/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.run.xml;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.IndentingWriter;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.run.xml.SimpleValue;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.run.xml.XmlSerializable;
import com.tangosol.run.xml.XmlValue;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.SimpleMapEntry;
import java.io.CharArrayWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SimpleElement
extends SimpleValue
implements XmlElement,
XmlSerializable {
    private String m_sName;
    private List m_listChildren;
    private Map m_mapAttributes;
    private String m_sComment;
    private transient boolean m_fDeserializing;

    public SimpleElement() {
    }

    public SimpleElement(String sName) {
        this(sName, null);
    }

    public SimpleElement(String sName, Object oValue) {
        super(oValue);
        this.setName(sName);
    }

    @Override
    public String getName() {
        return this.m_sName;
    }

    @Override
    public void setName(String sName) {
        if (!this.isNameMutable()) {
            throw new UnsupportedOperationException("the element cannot be renamed");
        }
        if (!XmlHelper.isNameValid(sName)) {
            throw new IllegalArgumentException("illegal name \"" + sName + "\"; see XML 1.0 2ed section 2.3 [5]");
        }
        this.m_sName = sName;
    }

    @Override
    public XmlElement getRoot() {
        XmlElement parent = this.getParent();
        return parent == null ? this : parent.getRoot();
    }

    @Override
    public String getAbsolutePath() {
        return XmlHelper.getAbsolutePath(this);
    }

    @Override
    public List getElementList() {
        List list = this.m_listChildren;
        if (list == null) {
            this.m_listChildren = list = this.instantiateElementList();
        }
        return list;
    }

    @Override
    public XmlElement getElement(String sName) {
        return XmlHelper.getElement(this, sName);
    }

    @Override
    public Iterator getElements(String sName) {
        return new ElementIterator(sName);
    }

    @Override
    public XmlElement addElement(String sName) {
        XmlElement element = this.instantiateElement(sName, null);
        this.getElementList().add(element);
        return element;
    }

    @Override
    public XmlElement findElement(String sPath) {
        return XmlHelper.findElement(this, sPath);
    }

    @Override
    public XmlElement getSafeElement(String sPath) {
        XmlElement element;
        String sRemain;
        String sName;
        SimpleElement.azzert(sPath != null);
        if (sPath.length() == 0) {
            return this;
        }
        if (sPath.charAt(0) == '/') {
            return this.getRoot().getSafeElement(sPath.substring(1));
        }
        int of = sPath.indexOf(47);
        if (of < 0) {
            sName = sPath;
            sRemain = null;
        } else {
            sName = sPath.substring(0, of);
            sRemain = sPath.substring(of + 1);
        }
        if (sName.equals("..")) {
            element = this.getParent();
            if (element == null) {
                throw new IllegalArgumentException("Invalid path " + sPath);
            }
        } else {
            element = this.getElement(sName);
            if (element == null) {
                element = this.instantiateElement(sName, null);
                element.setParent(this);
                if (element instanceof SimpleElement) {
                    ((SimpleElement)element).setMutable(false);
                }
            }
        }
        return sRemain == null ? element : element.getSafeElement(sRemain);
    }

    @Override
    public XmlElement ensureElement(String sPath) {
        return XmlHelper.ensureElement(this, sPath);
    }

    @Override
    public Map getAttributeMap() {
        Map map = this.m_mapAttributes;
        if (map == null) {
            this.m_mapAttributes = map = this.instantiateAttributeMap();
        }
        return map;
    }

    @Override
    public XmlValue getAttribute(String sName) {
        SimpleElement.azzert(sName != null && XmlHelper.isNameValid(sName));
        return (XmlValue)this.getAttributeMap().get(sName);
    }

    @Override
    public void setAttribute(String sName, XmlValue val) {
        Map map = this.getAttributeMap();
        if (val == null) {
            map.remove(sName);
        } else {
            map.put(sName, val);
        }
    }

    @Override
    public XmlValue addAttribute(String sName) {
        XmlValue attr = this.getAttribute(sName);
        if (attr == null) {
            attr = this.instantiateAttribute();
            this.setAttribute(sName, attr);
        }
        return attr;
    }

    @Override
    public XmlValue getSafeAttribute(String sName) {
        XmlValue value = this.getAttribute(sName);
        if (value == null) {
            value = this.instantiateAttribute();
            value.setParent(this);
            if (value instanceof SimpleValue) {
                ((SimpleValue)value).setMutable(false);
            }
        }
        return value;
    }

    @Override
    public String getComment() {
        return this.m_sComment;
    }

    @Override
    public void setComment(String sComment) {
        this.checkMutable();
        if (sComment.indexOf("--") >= 0) {
            throw new IllegalArgumentException("comment contains \"--\"; see XML 1.0 2ed section 2.5 [15]");
        }
        this.m_sComment = sComment;
    }

    @Override
    public void writeXml(PrintWriter out, boolean fPretty) {
        boolean fChildren;
        String sComment = this.getComment();
        boolean fComment = sComment != null && sComment.length() > 0;
        boolean fValue = !this.isEmpty();
        boolean bl = fChildren = !this.getElementList().isEmpty();
        if (!(fComment || fValue || fChildren)) {
            this.writeEmptyTag(out, fPretty);
        } else if (!fChildren) {
            this.writeStartTag(out, fPretty);
            this.writeComment(out, fPretty);
            this.writeValue(out, fPretty);
            this.writeEndTag(out, fPretty);
        } else {
            PrintWriter out2 = fPretty ? new IndentingWriter((Writer)out, 2) : out;
            this.writeStartTag(out, fPretty);
            if (fPretty) {
                out.println();
            }
            if (fComment) {
                this.writeComment(out2, fPretty);
                if (fPretty) {
                    out2.println();
                }
            }
            if (fValue) {
                this.writeValue(out2, fPretty);
                if (fPretty) {
                    out2.println();
                }
            }
            this.writeChildren(out2, fPretty);
            if (fPretty) {
                out2.println();
            }
            out2.flush();
            this.writeEndTag(out, fPretty);
        }
        if (this.getParent() == null) {
            out.flush();
        }
    }

    @Override
    public void writeValue(PrintWriter out, boolean fPretty) {
        if (fPretty && out instanceof IndentingWriter) {
            ((IndentingWriter)out).suspend();
            super.writeValue(out, fPretty);
            ((IndentingWriter)out).resume();
        } else {
            super.writeValue(out, fPretty);
        }
    }

    @Override
    public XmlElement toXml() {
        return this.isMutable() ? (XmlElement)this.clone() : this;
    }

    @Override
    public void fromXml(XmlElement xml) {
        this.checkMutable();
        xml = (XmlElement)xml.clone();
        this.setInternalValue(xml.getValue());
        this.m_sName = xml.getName();
        this.m_listChildren = xml.getElementList();
        this.m_mapAttributes = xml.getAttributeMap();
        this.m_sComment = xml.getComment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readExternal(DataInput in) throws IOException {
        if (this.m_sName != null) {
            throw new NotActiveException();
        }
        this.m_fDeserializing = true;
        try {
            super.readExternal(in);
            if (in.readBoolean()) {
                this.m_sName = SimpleElement.readUTF(in);
            }
            if (in.readBoolean()) {
                ((ExternalizableLite)((Object)this.getElementList())).readExternal(in);
            }
            if (in.readBoolean()) {
                ((ExternalizableLite)((Object)this.getAttributeMap())).readExternal(in);
            }
            if (in.readBoolean()) {
                this.m_sComment = SimpleElement.readUTF(in);
            }
        }
        finally {
            this.m_fDeserializing = false;
        }
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        String sComment;
        Map mapAttr;
        List listKids;
        super.writeExternal(out);
        String sName = this.m_sName;
        boolean fName = sName != null;
        out.writeBoolean(fName);
        if (fName) {
            SimpleElement.writeUTF(out, sName);
        }
        boolean fKids = (listKids = this.m_listChildren) != null && !listKids.isEmpty();
        out.writeBoolean(fKids);
        if (fKids) {
            ((ExternalizableLite)((Object)listKids)).writeExternal(out);
        }
        boolean fAttr = (mapAttr = this.m_mapAttributes) != null && !mapAttr.isEmpty();
        out.writeBoolean(fAttr);
        if (fAttr) {
            ((ExternalizableLite)((Object)mapAttr)).writeExternal(out);
        }
        boolean fComment = (sComment = this.m_sComment) != null;
        out.writeBoolean(fComment);
        if (fComment) {
            SimpleElement.writeUTF(out, sComment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readExternal(PofReader in) throws IOException {
        if (this.m_sName != null) {
            throw new NotActiveException();
        }
        this.m_fDeserializing = true;
        try {
            super.readExternal(in);
            if (in.readBoolean(4)) {
                this.m_sName = in.readString(5);
            }
            if (in.readBoolean(6)) {
                this.m_listChildren = this.instantiateElementList();
                in.readCollection(7, this.m_listChildren);
            }
            if (in.readBoolean(8)) {
                this.m_mapAttributes = this.instantiateAttributeMap();
                in.readMap(9, this.m_mapAttributes);
            }
            if (in.readBoolean(10)) {
                this.m_sComment = in.readString(11);
            }
        }
        finally {
            this.m_fDeserializing = false;
        }
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        String sComment;
        Map mapAttr;
        List listKids;
        super.writeExternal(out);
        String sName = this.m_sName;
        boolean fName = sName != null;
        out.writeBoolean(4, fName);
        if (fName) {
            out.writeString(5, sName);
        }
        boolean fKids = (listKids = this.m_listChildren) != null && !listKids.isEmpty();
        out.writeBoolean(6, fKids);
        if (fKids) {
            out.writeCollection(7, listKids);
        }
        boolean fAttr = (mapAttr = this.m_mapAttributes) != null && !mapAttr.isEmpty();
        out.writeBoolean(8, fAttr);
        if (fAttr) {
            out.writeMap(9, mapAttr);
        }
        boolean fComment = (sComment = this.m_sComment) != null;
        out.writeBoolean(10, fComment);
        if (fComment) {
            out.writeString(11, sComment);
        }
    }

    protected void checkMutable() {
        if (!this.isMutable()) {
            throw new UnsupportedOperationException("element \"" + this.getAbsolutePath() + "\" is not mutable");
        }
    }

    protected boolean isNameMutable() {
        return this.m_fDeserializing || this.isMutable();
    }

    protected List instantiateElementList() {
        return new ElementList();
    }

    protected XmlElement instantiateElement(String sName, Object oValue) {
        return new SimpleElement(sName, oValue);
    }

    protected Map instantiateAttributeMap() {
        return new AttributeMap();
    }

    protected XmlValue instantiateAttribute() {
        return new SimpleValue(null, true);
    }

    protected void writeEmptyTag(PrintWriter out, boolean fPretty) {
        out.print('<');
        out.print(this.getName());
        this.writeAttributes(out, fPretty);
        out.print("/>");
    }

    protected void writeStartTag(PrintWriter out, boolean fPretty) {
        out.print('<');
        out.print(this.getName());
        this.writeAttributes(out, fPretty);
        out.print('>');
    }

    protected void writeEndTag(PrintWriter out, boolean fPretty) {
        out.print("</");
        out.print(this.getName());
        out.print(">");
    }

    protected void writeAttributes(PrintWriter out, boolean fPretty) {
        for (Map.Entry entry : this.getAttributeMap().entrySet()) {
            String sName = (String)entry.getKey();
            XmlValue value = (XmlValue)entry.getValue();
            out.print(' ');
            out.print(sName);
            out.print('=');
            value.writeValue(out, fPretty);
        }
    }

    protected void writeComment(PrintWriter out, boolean fPretty) {
        String sComment = this.getComment();
        if (sComment != null && sComment.length() > 0) {
            out.print("<!--");
            if (fPretty) {
                out.println();
                out.println(SimpleElement.breakLines(sComment, 78, ""));
            } else {
                out.print(sComment);
            }
            out.print("-->");
        }
    }

    protected void writeChildren(PrintWriter out, boolean fPretty) {
        List list = this.getElementList();
        boolean fFirst = true;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            if (fFirst) {
                fFirst = false;
            } else if (fPretty) {
                out.println();
            }
            ((XmlElement)iter.next()).writeXml(out, fPretty);
        }
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean fPretty) {
        CharArrayWriter writer0 = new CharArrayWriter();
        PrintWriter writer1 = new PrintWriter(writer0);
        this.writeXml(writer1, fPretty);
        writer1.flush();
        return writer0.toString();
    }

    @Override
    public int hashCode() {
        return XmlHelper.hashElement(this);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof XmlElement)) {
            return false;
        }
        return XmlHelper.equalsElement(this, (XmlElement)o);
    }

    @Override
    public Object clone() {
        SimpleElement that = (SimpleElement)super.clone();
        Map mapThat = that.instantiateAttributeMap();
        for (Map.Entry entry : this.getAttributeMap().entrySet()) {
            String sName = (String)entry.getKey();
            XmlValue value = (XmlValue)entry.getValue();
            mapThat.put(sName, value.clone());
        }
        that.m_mapAttributes = mapThat;
        List listThat = that.instantiateElementList();
        for (XmlElement el : this.getElementList()) {
            listThat.add(el.clone());
        }
        that.m_listChildren = listThat;
        return that;
    }

    public class AttributeMap
    extends AbstractMap
    implements Cloneable,
    Serializable,
    ExternalizableLite {
        private Entry m_entryHead;
        private Entry m_entryTail;
        private int m_cEntries;
        private transient Set m_setEntries;

        @Override
        public int size() {
            return this.m_cEntries;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.findEntry(key) != null;
        }

        @Override
        public Object get(Object key) {
            Entry entry = this.findEntry(key);
            return entry == null ? null : entry.getValue();
        }

        @Override
        public Object put(Object key, Object value) {
            Entry entry = this.findEntry(key);
            if (entry != null) {
                return entry.setValue(value);
            }
            entry = this.instantiateEntry(key, value);
            if (this.m_entryTail == null) {
                this.m_entryHead = entry;
            } else {
                this.m_entryTail.setNextEntry(entry);
            }
            this.m_entryTail = entry;
            ++this.m_cEntries;
            return null;
        }

        @Override
        public Object remove(Object key) {
            Object oEntryKey;
            Entry entry;
            SimpleElement.this.checkMutable();
            Entry entryPrev = null;
            for (entry = this.m_entryHead; entry != null && !((oEntryKey = entry.getKey()) == null ? key == null : oEntryKey.equals(key)); entry = entry.getNextEntry()) {
                entryPrev = entry;
            }
            if (entry == null) {
                return null;
            }
            if (entry == this.m_entryHead) {
                this.m_entryHead = entry.getNextEntry();
            }
            if (entry == this.m_entryTail) {
                this.m_entryTail = entryPrev;
            }
            if (entryPrev != null) {
                entryPrev.setNextEntry(entry.getNextEntry());
            }
            --this.m_cEntries;
            return entry.getValue();
        }

        @Override
        public void clear() {
            SimpleElement.this.checkMutable();
            this.m_entryHead = null;
            this.m_entryTail = null;
            this.m_cEntries = 0;
        }

        @Override
        public Set entrySet() {
            Set set = this.m_setEntries;
            if (set == null) {
                this.m_setEntries = set = this.instantiateEntrySet();
            }
            return set;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Map) {
                Map that = (Map)o;
                if (this.size() != that.size()) {
                    return false;
                }
                Iterator iterThis = this.entrySet().iterator();
                Iterator iterThat = that.entrySet().iterator();
                try {
                    while (iterThis.hasNext()) {
                        if (iterThis.next().equals(iterThat.next())) continue;
                        return false;
                    }
                    return true;
                }
                catch (ConcurrentModificationException e) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public Object clone() {
            AttributeMap that = new AttributeMap();
            for (Entry entry : this.entrySet()) {
                that.put(entry.getKey(), entry.getValue());
            }
            return that;
        }

        private synchronized void writeObject(ObjectOutputStream out) throws IOException {
            Entry entry = this.m_entryHead;
            int cEntries = this.m_cEntries;
            int cCheck = 0;
            out.writeInt(cEntries);
            while (entry != null) {
                out.writeObject(entry.getKey());
                out.writeObject(entry.getValue());
                entry = entry.getNextEntry();
                ++cCheck;
            }
            if (cCheck != cEntries) {
                throw new IOException("expected to write " + cEntries + " entries but actually wrote " + cCheck);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int cEntries = in.readInt();
            Entry entryPrev = null;
            for (int i = 0; i < cEntries; ++i) {
                Entry entryNext = this.instantiateEntry(in.readObject(), in.readObject());
                if (entryPrev == null) {
                    this.m_entryHead = entryNext;
                } else {
                    entryPrev.setNextEntry(entryNext);
                }
                entryPrev = entryNext;
            }
            this.m_cEntries = cEntries;
            this.m_entryTail = entryPrev;
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            int c = ExternalizableHelper.readInt(in);
            for (int i = 0; i < c; ++i) {
                String sName = ExternalizableHelper.readUTF(in);
                SimpleValue value = new SimpleValue();
                value.readExternal(in);
                this.put(sName, value);
            }
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            int c = this.size();
            ExternalizableHelper.writeInt(out, c);
            if (c > 0) {
                int cActual = 0;
                for (Map.Entry entry : this.entrySet()) {
                    ExternalizableHelper.writeUTF(out, (String)entry.getKey());
                    ((SimpleValue)entry.getValue()).writeExternal(out);
                    ++cActual;
                }
                if (c != cActual) {
                    throw new IOException("expected to write " + c + " attributes; actually wrote " + cActual);
                }
            }
        }

        protected Entry instantiateEntry(Object oKey, Object oVal) {
            return new Entry(oKey, oVal);
        }

        protected Entry findEntry(Object oKey) {
            Object oEntryKey;
            Entry entry;
            for (entry = this.m_entryHead; entry != null && !((oEntryKey = entry.getKey()) == null ? oKey == null : oEntryKey.equals(oKey)); entry = entry.getNextEntry()) {
            }
            return entry;
        }

        protected Entry getFirstEntry() {
            return this.m_entryHead;
        }

        protected Set instantiateEntrySet() {
            return new EntrySet();
        }

        protected class EntrySet
        extends AbstractSet
        implements Serializable {
            protected EntrySet() {
            }

            @Override
            public Iterator iterator() {
                return new EntrySetIterator();
            }

            @Override
            public int size() {
                return AttributeMap.this.size();
            }

            protected class EntrySetIterator
            implements Iterator {
                private Entry m_entryPrev;
                private Entry m_entryNext;

                protected EntrySetIterator() {
                    this.m_entryNext = AttributeMap.this.getFirstEntry();
                }

                @Override
                public boolean hasNext() {
                    return this.m_entryNext != null;
                }

                public Object next() {
                    Entry entry = this.m_entryNext;
                    if (entry == null) {
                        throw new NoSuchElementException();
                    }
                    this.m_entryPrev = entry;
                    this.m_entryNext = entry.getNextEntry();
                    return entry;
                }

                @Override
                public void remove() {
                    Entry entry = this.m_entryPrev;
                    if (entry == null) {
                        throw new IllegalStateException();
                    }
                    AttributeMap.this.remove(entry.getKey());
                    this.m_entryPrev = null;
                }
            }
        }

        public class Entry
        extends SimpleMapEntry {
            private Entry m_entryNext;

            protected Entry(Object oKey, Object oVal) {
                super(oKey);
                if (!(oKey instanceof String)) {
                    throw new IllegalArgumentException("attribute name must be a String");
                }
                if (!XmlHelper.isNameValid((String)oKey)) {
                    throw new IllegalArgumentException("illegal name \"" + oKey + "\"; see XML 1.0 2ed section 2.3 [5]");
                }
                this.setValue(oVal);
            }

            @Override
            public Object setValue(Object value) {
                SimpleElement.this.checkMutable();
                if (!(value instanceof XmlValue)) {
                    throw new IllegalArgumentException("attribute value must be an XmlValue");
                }
                XmlValue xmlvalue = (XmlValue)value;
                if (xmlvalue.getParent() != null || !xmlvalue.isAttribute()) {
                    xmlvalue = new SimpleValue(xmlvalue.getValue(), true);
                }
                xmlvalue.setParent(SimpleElement.this);
                return super.setValue(xmlvalue);
            }

            protected Entry getNextEntry() {
                return this.m_entryNext;
            }

            protected void setNextEntry(Entry entry) {
                this.m_entryNext = entry;
            }
        }
    }

    protected class ElementIterator
    implements Iterator {
        protected String m_sName;
        protected Iterator m_iterator;
        protected XmlElement m_element;
        protected int m_nState;
        protected static final int FOUND = 0;
        protected static final int RETURNED = 1;
        protected static final int REMOVED = 2;

        public ElementIterator(String sName) {
            this.m_iterator = SimpleElement.this.getElementList().iterator();
            this.m_nState = 2;
            this.m_sName = sName;
        }

        @Override
        public boolean hasNext() {
            if (this.m_nState == 0) {
                return true;
            }
            Iterator iterator = this.m_iterator;
            while (iterator.hasNext()) {
                XmlElement element = (XmlElement)iterator.next();
                if (!element.getName().equals(this.m_sName)) continue;
                this.m_element = element;
                this.m_nState = 0;
                return true;
            }
            return false;
        }

        public Object next() {
            switch (this.m_nState) {
                case 1: 
                case 2: {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                }
                case 0: {
                    this.m_nState = 1;
                    return this.m_element;
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public void remove() {
            if (this.m_nState != 1) {
                throw new IllegalStateException();
            }
            this.m_nState = 2;
            this.m_iterator.remove();
        }
    }

    protected class ElementList
    extends ArrayList
    implements ExternalizableLite {
        protected ElementList() {
        }

        @Override
        public Object set(int index, Object element) {
            SimpleElement.this.checkMutable();
            return super.set(index, this.checkElement((XmlElement)element));
        }

        @Override
        public boolean add(Object o) {
            SimpleElement.this.checkMutable();
            return super.add(this.checkElement((XmlElement)o));
        }

        @Override
        public void add(int index, Object element) {
            SimpleElement.this.checkMutable();
            super.add(index, this.checkElement((XmlElement)element));
        }

        @Override
        public Object remove(int index) {
            SimpleElement.this.checkMutable();
            return super.remove(index);
        }

        @Override
        public void clear() {
            SimpleElement.this.checkMutable();
            super.clear();
        }

        @Override
        public boolean addAll(Collection c) {
            return this.addAll(this.size(), c);
        }

        @Override
        public boolean addAll(int index, Collection c) {
            boolean fModified = false;
            Iterator iterator = c.iterator();
            while (iterator.hasNext()) {
                this.add(index++, iterator.next());
                fModified = true;
            }
            return fModified;
        }

        protected XmlElement checkElement(XmlElement element) {
            if (element.getParent() != null) {
                List list;
                Map map;
                XmlElement elementNew = SimpleElement.this.instantiateElement(element.getName(), element.getValue());
                String sComment = element.getComment();
                if (sComment != null) {
                    elementNew.setComment(sComment);
                }
                if (!(map = element.getAttributeMap()).isEmpty()) {
                    elementNew.getAttributeMap().putAll(map);
                }
                if (!(list = element.getElementList()).isEmpty()) {
                    elementNew.getElementList().addAll(list);
                }
                element = elementNew;
            }
            element.setParent(SimpleElement.this);
            return element;
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            SimpleElement xmlThis = SimpleElement.this;
            int c = ExternalizableHelper.readInt(in);
            for (int i = 0; i < c; ++i) {
                SimpleElement xmlKid = new SimpleElement();
                xmlKid.readExternal(in);
                xmlKid.setParent(xmlThis);
                super.add(xmlKid);
            }
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            int c = this.size();
            ExternalizableHelper.writeInt(out, c);
            for (int i = 0; i < c; ++i) {
                ((ExternalizableLite)this.get(i)).writeExternal(out);
            }
        }
    }
}

