/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.internal.net;

import com.oracle.common.collections.UnmodifiableSetCollection;
import com.oracle.common.internal.net.WrapperSelector;
import com.oracle.common.internal.net.WrapperSocket;
import com.oracle.common.internal.net.WrapperSocketChannel;
import com.oracle.common.net.InetSocketAddress32;
import com.oracle.common.net.SafeSelectionHandler;
import com.oracle.common.net.SelectionService;
import com.oracle.common.net.SelectionServices;
import com.oracle.common.net.SocketProvider;
import com.oracle.common.net.TcpSocketProvider;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class MultiplexedSocketProvider
implements SocketProvider {
    protected static final int PROTOCOL_ID = 1522655232;
    protected static final int EPHEMERAL_SUB_PORT_START = 32768;
    private static Logger LOGGER = Logger.getLogger(MultiplexedSocketProvider.class.getName());
    protected final Dependencies m_dependencies;
    protected final ConcurrentMap<InetSocketAddress, Listener> m_mapListener = new ConcurrentHashMap<InetSocketAddress, Listener>();
    protected int m_nPortEphemeralLow = Integer.MAX_VALUE;
    protected int m_nPortEphemeralHi = Integer.MIN_VALUE;

    public MultiplexedSocketProvider(Dependencies deps) {
        this.m_dependencies = this.copyDependencies(deps).validate();
    }

    public Dependencies getDependencies() {
        return this.m_dependencies;
    }

    @Override
    public SocketAddress resolveAddress(String sAddr) {
        int ofPort;
        int ofAddrEnd;
        if (sAddr.startsWith("[")) {
            ofAddrEnd = sAddr.lastIndexOf("]:");
            if (ofAddrEnd == 2) {
                throw new IllegalArgumentException("address does not contain an hostname or ip");
            }
            if (ofAddrEnd == -1) {
                throw new IllegalArgumentException("address does not contain a port");
            }
            ofPort = ofAddrEnd + 2;
        } else {
            ofAddrEnd = sAddr.lastIndexOf(58);
            if (ofAddrEnd == 0) {
                throw new IllegalArgumentException("address does not contain an hostname of ip");
            }
            if (ofAddrEnd == -1) {
                throw new IllegalArgumentException("address does not contain a port");
            }
            ofPort = ofAddrEnd + 1;
        }
        String sHost = sAddr.substring(0, ofAddrEnd);
        int ofPortSub = sAddr.indexOf(46, ofPort);
        if (ofPortSub == -1) {
            int nPort = Integer.parseInt(sAddr.substring(ofPort));
            return new InetSocketAddress32(sHost, nPort);
        }
        int nPortBase = Integer.parseInt(sAddr.substring(ofPort, ofPortSub));
        int nPortSub = Integer.parseInt(sAddr.substring(ofPortSub + 1));
        return new InetSocketAddress32(sHost, MultiplexedSocketProvider.computePort(nPortBase, nPortSub));
    }

    @Override
    public String getAddressString(Socket socket) {
        String sAddr;
        InetAddress addr = socket.getInetAddress();
        boolean fAny = addr.isAnyLocalAddress();
        if (fAny) {
            try {
                addr = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            sAddr = addr.getCanonicalHostName();
        } else {
            sAddr = addr.getHostAddress();
        }
        if (sAddr.contains(":")) {
            sAddr = "[" + sAddr + "]";
        }
        int nPort = socket.getLocalPort();
        return sAddr + ":" + (MultiplexedSocketProvider.isMultiplexed(nPort) ? MultiplexedSocketProvider.getBasePort(nPort) + "." + MultiplexedSocketProvider.getSubPort(nPort) : Integer.valueOf(nPort));
    }

    @Override
    public String getAddressString(ServerSocket socket) {
        String sAddr;
        InetAddress addr = socket.getInetAddress();
        boolean fAny = addr.isAnyLocalAddress();
        if (fAny) {
            try {
                addr = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            sAddr = addr.getCanonicalHostName();
        } else {
            sAddr = addr.getHostAddress();
        }
        if (sAddr.contains(":")) {
            sAddr = "[" + sAddr + "]";
        }
        int nPort = socket.getLocalPort();
        return sAddr + ":" + (MultiplexedSocketProvider.isMultiplexed(nPort) ? MultiplexedSocketProvider.getBasePort(nPort) + "." + MultiplexedSocketProvider.getSubPort(nPort) : Integer.valueOf(nPort));
    }

    @Override
    public ServerSocketChannel openServerSocketChannel() throws IOException {
        return new MultiplexedServerSocketChannel();
    }

    @Override
    public ServerSocket openServerSocket() throws IOException {
        return this.openServerSocketChannel().socket();
    }

    @Override
    public SocketChannel openSocketChannel() throws IOException {
        return new MultiplexedSocketChannel(this.getDependencies().getDelegateProvider().openSocketChannel());
    }

    @Override
    public Socket openSocket() throws IOException {
        return new WrapperSocket(this.getDependencies().getDelegateProvider().openSocket()){
            protected InetSocketAddress32 m_addrPeer;
            protected InetSocketAddress32 m_addrLocal;

            @Override
            public void connect(SocketAddress addr) throws IOException {
                this.connect(addr, 0);
            }

            @Override
            public void connect(SocketAddress addr, int cMillis) throws IOException {
                if (!(addr instanceof InetSocketAddress32)) {
                    throw new IllegalArgumentException("unsupported SocketAddress type");
                }
                InetSocketAddress32 addr32 = (InetSocketAddress32)addr;
                super.connect(MultiplexedSocketProvider.getTransportAddress(addr32), cMillis);
                this.m_addrPeer = addr32;
                if (MultiplexedSocketProvider.isMultiplexed(addr32.getPort())) {
                    ByteBuffer buff = ByteBuffer.allocate(8);
                    buff.putInt(1522655232).putInt(MultiplexedSocketProvider.getSubPort(addr32.getPort())).flip();
                    this.getOutputStream().write(buff.array());
                    this.getOutputStream().flush();
                }
            }

            @Override
            public void bind(SocketAddress addr) throws IOException {
                InetSocketAddress32 addrBind;
                if (addr == null || addr instanceof InetSocketAddress32) {
                    addrBind = (InetSocketAddress32)addr;
                    if (addrBind != null && MultiplexedSocketProvider.getSubPort(addrBind.getPort()) != 0) {
                        throw new IOException("cannot bind client sockets to non-zero sub-ports");
                    }
                    if (addrBind == null) {
                        super.bind(null);
                        addrBind = new InetSocketAddress32(super.getLocalAddress(), super.getLocalPort());
                    } else {
                        super.bind(MultiplexedSocketProvider.getTransportAddress(addrBind));
                    }
                } else {
                    throw new IllegalArgumentException("unsupported SocketAddress type");
                }
                this.m_addrLocal = addrBind;
            }

            @Override
            public SocketAddress getLocalSocketAddress() {
                InetSocketAddress addrReal;
                InetSocketAddress32 addr = this.m_addrLocal;
                if (addr == null && (addrReal = (InetSocketAddress)super.getLocalSocketAddress()) != null) {
                    addr = this.m_addrLocal = new InetSocketAddress32(addrReal.getAddress(), addrReal.getPort());
                }
                return addr;
            }

            @Override
            public SocketAddress getRemoteSocketAddress() {
                return this.m_addrPeer;
            }

            @Override
            public int getPort() {
                InetSocketAddress32 addr = (InetSocketAddress32)this.getRemoteSocketAddress();
                return addr == null ? 0 : addr.getPort();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InetSocketAddress32 open(InetSocketAddress32 addr, MultiplexedServerSocketChannel server) throws IOException {
        InetSocketAddress addrListen = MultiplexedSocketProvider.getTransportAddress(addr);
        InetAddress addrIp = addr.getAddress();
        int nPort = addr.getPort();
        boolean fMultiplexed = MultiplexedSocketProvider.isMultiplexed(nPort);
        ServerSocket socket = server.socket();
        if (addrIp != null && MultiplexedSocketProvider.isMultiplexed(nPort) && addrIp.isAnyLocalAddress()) {
            boolean fEphemeral = MultiplexedSocketProvider.getSubPort(nPort) == 0 || nPort == -1;
            while (true) {
                HashSet<InetSocketAddress32> addrAcquired = new HashSet<InetSocketAddress32>();
                try {
                    Enumeration<NetworkInterface> iter = NetworkInterface.getNetworkInterfaces();
                    while (iter.hasMoreElements()) {
                        Enumeration<InetAddress> iterAddr = iter.nextElement().getInetAddresses();
                        while (iterAddr.hasMoreElements()) {
                            InetSocketAddress32 addrAdd = this.open(new InetSocketAddress32(iterAddr.nextElement(), nPort), server);
                            addrAcquired.add(addrAdd);
                            if (MultiplexedSocketProvider.getSubPort(nPort) != 0 && nPort != -1) continue;
                            nPort = addrAdd.getPort();
                        }
                    }
                    return fEphemeral ? new InetSocketAddress32(addr.getAddress(), nPort) : addr;
                }
                catch (IOException e) {
                    for (InetSocketAddress32 addrDrop : addrAcquired) {
                        this.close(addrDrop);
                    }
                    if (fEphemeral && MultiplexedSocketProvider.getSubPort(nPort) > 32768) {
                        nPort = addr.getPort();
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }
        int nPortEphemeralLow = this.m_nPortEphemeralLow;
        int nPortEphemeralHi = this.m_nPortEphemeralHi;
        ConcurrentMap<InetSocketAddress, Listener> mapListener = this.m_mapListener;
        if (nPort == -1 && !mapListener.isEmpty()) {
            for (Map.Entry entry : mapListener.entrySet()) {
                int nPortUsed = ((InetSocketAddress)entry.getKey()).getPort();
                if (nPortUsed < nPortEphemeralLow || nPortUsed > nPortEphemeralHi || ((Listener)entry.getValue()).m_server != null || !((InetSocketAddress)entry.getKey()).getAddress().equals(addrIp)) continue;
                try {
                    return this.open(new InetSocketAddress32(addrIp, nPortUsed << 16), server);
                }
                catch (IOException e) {
                }
            }
        }
        while (true) {
            Listener listener;
            if ((listener = (Listener)mapListener.get(addrListen)) == null) {
                ServerSocketChannel chanListen = this.getDependencies().getDelegateProvider().openServerSocketChannel();
                ServerSocket socketListen = chanListen.socket();
                socketListen.setReceiveBufferSize(socket.getReceiveBufferSize());
                socketListen.bind(addrListen);
                if (nPort == 0 || nPort == -1) {
                    addrListen = (InetSocketAddress)chanListen.socket().getLocalSocketAddress();
                    int nPortBind = addrListen.getPort();
                    if (nPortBind < nPortEphemeralLow) {
                        this.m_nPortEphemeralLow = nPortBind;
                    }
                    if (nPortBind > nPortEphemeralHi) {
                        this.m_nPortEphemeralHi = nPortBind;
                    }
                }
                chanListen.configureBlocking(false);
                listener = new Listener(chanListen, fMultiplexed ? null : server);
                this.getDependencies().getSelectionService().register(chanListen, listener);
                mapListener.put(addrListen, listener);
            }
            Listener listener2 = listener;
            synchronized (listener2) {
                ServerSocketChannel chanListen = (ServerSocketChannel)listener.getChannel();
                if (chanListen.isOpen()) {
                    return listener.register(nPort == -1 ? 0 : MultiplexedSocketProvider.getSubPort(nPort), server);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(InetSocketAddress32 addr) throws IOException {
        InetAddress addrIp = addr.getAddress();
        int nPort = addr.getPort();
        if (addrIp != null && MultiplexedSocketProvider.isMultiplexed(addr.getPort()) && addrIp.isAnyLocalAddress()) {
            Enumeration<NetworkInterface> iter = NetworkInterface.getNetworkInterfaces();
            while (iter.hasMoreElements()) {
                Enumeration<InetAddress> iterAddr = iter.nextElement().getInetAddresses();
                while (iterAddr.hasMoreElements()) {
                    try {
                        this.close(new InetSocketAddress32(iterAddr.nextElement(), addr.getPort()));
                    }
                    catch (IOException e) {}
                }
            }
            return;
        }
        ConcurrentMap<InetSocketAddress, Listener> mapListener = this.m_mapListener;
        InetSocketAddress addrListen = MultiplexedSocketProvider.getTransportAddress(addr);
        Listener listener = (Listener)mapListener.get(addrListen);
        if (listener == null) {
            throw new IOException("not bound");
        }
        Listener listener2 = listener;
        synchronized (listener2) {
            if (listener.deregister(MultiplexedSocketProvider.getSubPort(nPort))) {
                ((ServerSocketChannel)listener.getChannel()).close();
                mapListener.remove(addrListen);
            }
        }
    }

    public static InetSocketAddress getTransportAddress(InetSocketAddress32 addr) {
        int nPort = addr.getPort();
        return new InetSocketAddress(addr.getAddress(), nPort == -1 ? 0 : MultiplexedSocketProvider.getBasePort(nPort));
    }

    public static boolean isMultiplexed(int nPort) {
        return nPort > 65535 || nPort < 0;
    }

    public static int getBasePort(int nPort) {
        return MultiplexedSocketProvider.isMultiplexed(nPort) ? nPort >>> 16 : nPort;
    }

    public static int getSubPort(int nPort) {
        return nPort & 0xFFFF;
    }

    public static int computePort(int nPortBase, int nPortSub) {
        if (nPortBase < 0 || nPortBase > 65535) {
            throw new IllegalArgumentException("base port " + nPortBase + " is out of range");
        }
        if (nPortSub < 0 || nPortSub > 65535) {
            throw new IllegalArgumentException("sub port " + nPortSub + " is out of range");
        }
        return nPortBase << 16 | nPortSub;
    }

    protected DefaultDependencies copyDependencies(Dependencies deps) {
        return new DefaultDependencies(deps);
    }

    public static class DefaultDependencies
    implements Dependencies {
        protected static final int s_nBacklogDefault;
        protected SocketProvider m_provider;
        protected SelectionService m_service;
        protected int m_nBacklog = s_nBacklogDefault;
        protected Logger m_logger;

        public DefaultDependencies() {
            this(null);
        }

        public DefaultDependencies(Dependencies deps) {
            if (deps != null) {
                this.m_provider = deps.getDelegateProvider();
                this.m_service = deps.getSelectionService();
                this.m_nBacklog = deps.getBacklog();
                this.m_logger = deps.getLogger();
            }
        }

        protected DefaultDependencies validate() {
            return this;
        }

        @Override
        public SocketProvider getDelegateProvider() {
            SocketProvider provider = this.m_provider;
            if (provider == null) {
                this.m_provider = provider = TcpSocketProvider.INSTANCE;
            }
            return provider;
        }

        public DefaultDependencies setDelegateProvider(SocketProvider provider) {
            this.m_provider = provider;
            return this;
        }

        @Override
        public SelectionService getSelectionService() {
            SelectionService service = this.m_service;
            if (service == null) {
                this.m_service = service = SelectionServices.getDefaultService();
            }
            return service;
        }

        public DefaultDependencies setSelectionService(SelectionService service) {
            this.m_service = service;
            return this;
        }

        @Override
        public int getBacklog() {
            return this.m_nBacklog;
        }

        public DefaultDependencies setBacklog(int nBacklog) {
            this.m_nBacklog = nBacklog;
            return this;
        }

        @Override
        public Logger getLogger() {
            Logger logger = this.m_logger;
            return logger == null ? LOGGER : logger;
        }

        public DefaultDependencies setLogger(Logger logger) {
            this.m_logger = logger;
            return this;
        }

        static {
            int nBacklog = 0;
            try {
                nBacklog = Integer.parseInt(System.getProperty(MultiplexedServerSocketChannel.class.getName() + ".backlog", "0"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            s_nBacklogDefault = nBacklog;
        }
    }

    public static interface Dependencies {
        public SocketProvider getDelegateProvider();

        public SelectionService getSelectionService();

        public int getBacklog();

        public Logger getLogger();
    }

    protected class Listener
    extends SafeSelectionHandler<ServerSocketChannel> {
        protected final ConcurrentNavigableMap<Integer, MultiplexedServerSocketChannel> m_mapBindings;
        protected final SortedSet<Integer> m_setEphemeral;
        protected final MultiplexedServerSocketChannel m_server;

        public Listener(ServerSocketChannel chan, MultiplexedServerSocketChannel server) throws IOException {
            super(chan);
            this.m_server = server;
            if (server == null) {
                this.m_mapBindings = new ConcurrentSkipListMap<Integer, MultiplexedServerSocketChannel>();
                this.m_setEphemeral = this.m_mapBindings.descendingKeySet();
            } else {
                this.m_mapBindings = null;
                this.m_setEphemeral = null;
            }
        }

        @Override
        protected int onReadySafe(int nOps) throws IOException {
            SocketChannel chan;
            MultiplexedServerSocketChannel server = this.m_server;
            while ((chan = ((ServerSocketChannel)this.getChannel()).accept()) != null) {
                try {
                    if (server == null) {
                        chan.configureBlocking(false);
                        MultiplexedSocketProvider.this.getDependencies().getSelectionService().register(chan, new Switcher(chan));
                        continue;
                    }
                    if (server.add(chan)) continue;
                    chan.close();
                }
                catch (IOException e) {
                    try {
                        chan.close();
                    }
                    catch (IOException e2) {}
                }
            }
            return 16;
        }

        @Override
        protected int onException(Throwable t) {
            if (((ServerSocketChannel)this.getChannel()).isOpen()) {
                LogRecord rec = new LogRecord(Level.WARNING, "unhandled exception; continuing");
                rec.setThrown(t);
                MultiplexedSocketProvider.this.getDependencies().getLogger().log(rec);
                return 16;
            }
            return 0;
        }

        protected InetSocketAddress32 register(int nPortSub, MultiplexedServerSocketChannel server) throws IOException {
            ConcurrentNavigableMap<Integer, MultiplexedServerSocketChannel> map = this.m_mapBindings;
            ServerSocket socket = ((ServerSocketChannel)this.getChannel()).socket();
            if (server == this.m_server) {
                return new InetSocketAddress32(socket.getInetAddress(), socket.getLocalPort());
            }
            if (map == null) {
                throw new IOException("address already in use; sub-ports not supported");
            }
            if (nPortSub == 0) {
                nPortSub = 32768 + System.identityHashCode(server) % Short.MAX_VALUE;
                if (map.putIfAbsent(nPortSub, server) == null) {
                    return new InetSocketAddress32(socket.getInetAddress(), MultiplexedSocketProvider.computePort(socket.getLocalPort(), nPortSub));
                }
                nPortSub = 65535;
                Iterator iter = this.m_setEphemeral.iterator();
                while (nPortSub >= 32768) {
                    int nPortUsed = Math.max(Short.MAX_VALUE, iter.hasNext() ? (Integer)iter.next() : 0);
                    while (nPortSub > nPortUsed) {
                        if (map.putIfAbsent(nPortSub, server) == null) {
                            return new InetSocketAddress32(socket.getInetAddress(), MultiplexedSocketProvider.computePort(socket.getLocalPort(), nPortSub));
                        }
                        --nPortSub;
                    }
                    nPortSub = nPortUsed - 1;
                }
                throw new IOException("no available ephemeral sub-ports within base port " + socket.getLocalPort());
            }
            if (map.putIfAbsent(nPortSub, server) != null) {
                throw new IOException("address already in use");
            }
            return new InetSocketAddress32(socket.getInetAddress(), MultiplexedSocketProvider.computePort(socket.getLocalPort(), nPortSub));
        }

        protected boolean deregister(int nPortSub) throws IOException {
            ConcurrentNavigableMap<Integer, MultiplexedServerSocketChannel> map = this.m_mapBindings;
            if (map == null) {
                return true;
            }
            if (map.remove(nPortSub) == null) {
                throw new IOException("not bound");
            }
            return map.isEmpty();
        }

        public class Switcher
        extends SafeSelectionHandler<SocketChannel> {
            protected final ByteBuffer m_buf;

            public Switcher(SocketChannel chan) {
                super(chan);
                this.m_buf = ByteBuffer.allocate(8);
            }

            @Override
            protected int onReadySafe(int nOps) throws IOException {
                if ((nOps & 1) != 0) {
                    ByteBuffer buf;
                    SocketChannel chan = (SocketChannel)this.getChannel();
                    if (chan.read(buf = this.m_buf) < 0) {
                        chan.close();
                    } else if (!buf.hasRemaining()) {
                        MultiplexedSocketProvider.this.getDependencies().getSelectionService().register(chan, null);
                        buf.flip();
                        int nProt = buf.getInt();
                        if (nProt == 1522655232) {
                            int nSubPort = buf.getInt();
                            MultiplexedServerSocketChannel server = (MultiplexedServerSocketChannel)Listener.this.m_mapBindings.get(nSubPort);
                            chan.configureBlocking(true);
                            if (server != null && server.add(new WrapperSocketChannel(chan, new MultiplexedSelectorProvider(chan.provider())))) {
                                return 0;
                            }
                        }
                        chan.close();
                    }
                }
                return 1;
            }
        }
    }

    protected class MultiplexedSocketChannel
    extends WrapperSocketChannel {
        protected InetSocketAddress32 m_addrPeer;
        protected InetSocketAddress32 m_addrLocal;
        protected ByteBuffer m_bufHeader;

        public MultiplexedSocketChannel(SocketChannel delegate) {
            super(delegate, new MultiplexedSelectorProvider(delegate.provider()));
        }

        protected SocketChannel delegate() {
            return this.m_delegate;
        }

        @Override
        protected Socket wrapSocket(Socket socket) {
            return new WrapperSocket(socket){

                @Override
                public SocketChannel getChannel() {
                    return MultiplexedSocketChannel.this;
                }

                @Override
                public void bind(SocketAddress addr) throws IOException {
                    InetSocketAddress32 addrBind;
                    if (addr == null || addr instanceof InetSocketAddress32) {
                        addrBind = (InetSocketAddress32)addr;
                        if (addrBind != null && MultiplexedSocketProvider.getSubPort(addrBind.getPort()) != 0) {
                            throw new IOException("cannot bind client sockets to non-zero sub-ports");
                        }
                        if (addrBind == null) {
                            super.bind(null);
                            addrBind = new InetSocketAddress32(super.getLocalAddress(), super.getLocalPort());
                        } else {
                            super.bind(MultiplexedSocketProvider.getTransportAddress(addrBind));
                        }
                    } else {
                        throw new IllegalArgumentException("unsupported SocketAddress type");
                    }
                    MultiplexedSocketChannel.this.m_addrLocal = addrBind;
                }

                @Override
                public int getPort() {
                    InetSocketAddress32 addr = MultiplexedSocketChannel.this.m_addrPeer;
                    return addr == null ? super.getPort() : addr.getPort();
                }

                @Override
                public SocketAddress getRemoteSocketAddress() {
                    InetSocketAddress32 addr = MultiplexedSocketChannel.this.m_addrPeer;
                    return addr == null ? super.getRemoteSocketAddress() : addr;
                }

                @Override
                public SocketAddress getLocalSocketAddress() {
                    InetSocketAddress addrInet;
                    InetSocketAddress32 addr = MultiplexedSocketChannel.this.m_addrLocal;
                    if (addr == null && (addrInet = (InetSocketAddress)super.getLocalSocketAddress()) != null) {
                        addr = MultiplexedSocketChannel.this.m_addrLocal = new InetSocketAddress32(addrInet.getAddress(), addrInet.getPort());
                    }
                    return addr;
                }

                @Override
                public int getLocalPort() {
                    InetSocketAddress32 addr = (InetSocketAddress32)this.getLocalSocketAddress();
                    return addr == null ? -1 : addr.getPort();
                }
            };
        }

        @Override
        public boolean isConnected() {
            return super.isConnected() && this.m_bufHeader == null;
        }

        @Override
        public boolean isConnectionPending() {
            return super.isConnectionPending() || this.m_bufHeader != null;
        }

        @Override
        public boolean connect(SocketAddress remote) throws IOException {
            if (!(remote instanceof InetSocketAddress32)) {
                throw new IllegalArgumentException("unsupported SocketAddress type");
            }
            InetSocketAddress32 addrPeer = (InetSocketAddress32)remote;
            int nPort = addrPeer.getPort();
            boolean fConnected = super.connect(MultiplexedSocketProvider.getTransportAddress(addrPeer));
            this.m_addrPeer = addrPeer;
            if (MultiplexedSocketProvider.isMultiplexed(nPort)) {
                ByteBuffer buf = this.m_bufHeader = ByteBuffer.allocate(8);
                buf.putInt(1522655232).putInt(MultiplexedSocketProvider.getSubPort(nPort)).flip();
                return this.finishConnect();
            }
            return fConnected;
        }

        @Override
        public boolean finishConnect() throws IOException {
            ByteBuffer buf;
            boolean fResult = super.finishConnect();
            if (fResult && (buf = this.m_bufHeader) != null) {
                super.write(buf);
                if (buf.hasRemaining()) {
                    return false;
                }
                this.m_bufHeader = null;
            }
            return fResult;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return this.m_bufHeader == null || this.finishConnect() ? super.write(src) : 0;
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            return this.m_bufHeader == null || this.finishConnect() ? super.write(srcs, offset, length) : 0L;
        }
    }

    protected class MultiplexedServerSocketChannel
    extends ServerSocketChannel {
        protected BlockingQueue<SocketChannel> m_queue;
        protected ServerSocket m_socket;
        protected ServerSelectionKey m_keyHead;

        public MultiplexedServerSocketChannel() throws IOException {
            super(new MultiplexedSelectorProvider(MultiplexedSocketProvider.this.getDependencies().getDelegateProvider()));
            this.m_queue = new LinkedBlockingQueue<SocketChannel>();
            this.m_socket = new ServerSocket(){
                InetSocketAddress32 m_address;

                @Override
                public void bind(SocketAddress endpoint) throws IOException {
                    this.bind(endpoint, 0);
                }

                @Override
                public void bind(SocketAddress endpoint, int backlog) throws IOException {
                    if (this.isBound()) {
                        throw new IOException("already bound");
                    }
                    if (endpoint != null && !(endpoint instanceof InetSocketAddress32)) {
                        throw new IllegalArgumentException("unsupported SocketAddress type");
                    }
                    InetSocketAddress32 addr = (InetSocketAddress32)endpoint;
                    this.m_address = MultiplexedSocketProvider.this.open(addr, MultiplexedServerSocketChannel.this);
                }

                @Override
                public InetAddress getInetAddress() {
                    return this.m_address.getAddress();
                }

                @Override
                public int getLocalPort() {
                    return this.m_address.getPort();
                }

                @Override
                public SocketAddress getLocalSocketAddress() {
                    return this.m_address;
                }

                @Override
                public ServerSocketChannel getChannel() {
                    return MultiplexedServerSocketChannel.this;
                }

                @Override
                public boolean isBound() {
                    return this.m_address != null;
                }

                @Override
                public boolean isClosed() {
                    return MultiplexedServerSocketChannel.this.m_queue == null;
                }

                @Override
                public void close() throws IOException {
                    if (!this.isClosed()) {
                        MultiplexedServerSocketChannel.this.m_queue = null;
                        MultiplexedSocketProvider.this.close((InetSocketAddress32)this.getLocalSocketAddress());
                        ServerSelectionKey key = MultiplexedServerSocketChannel.this.m_keyHead;
                        while (key != null) {
                            key.cancel();
                            key = key.m_next;
                        }
                    }
                }

                @Override
                public Socket accept() throws IOException {
                    ServerSocketChannel chanServer = this.getChannel();
                    if (chanServer.isBlocking()) {
                        return chanServer.accept().socket();
                    }
                    throw new IllegalBlockingModeException();
                }
            };
        }

        @Override
        public ServerSocket socket() {
            return this.m_socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SocketChannel accept() throws IOException {
            try {
                long cMillis;
                BlockingQueue<SocketChannel> queue = this.m_queue;
                SocketChannel chan = this.isBlocking() ? ((cMillis = (long)this.socket().getSoTimeout()) == 0L ? queue.take() : queue.poll(cMillis, TimeUnit.MILLISECONDS)) : (SocketChannel)queue.poll();
                if (chan == null) {
                    MultiplexedServerSocketChannel multiplexedServerSocketChannel = this;
                    synchronized (multiplexedServerSocketChannel) {
                        if (queue.isEmpty()) {
                            ServerSelectionKey key = this.m_keyHead;
                            while (key != null) {
                                ((MultiplexedSelector)key.selector()).setKeyState(key, false);
                                key = key.m_next;
                            }
                        }
                    }
                } else {
                    chan.socket().setReceiveBufferSize(this.socket().getReceiveBufferSize());
                }
                return chan;
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.getMessage());
            }
            catch (NullPointerException e) {
                throw new IOException("socket closed");
            }
        }

        @Override
        protected void implCloseSelectableChannel() throws IOException {
            this.socket().close();
        }

        @Override
        protected void implConfigureBlocking(boolean block) throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean add(SocketChannel chan) {
            boolean fAdded = this.m_queue.offer(chan);
            if (fAdded) {
                MultiplexedServerSocketChannel multiplexedServerSocketChannel = this;
                synchronized (multiplexedServerSocketChannel) {
                    ServerSelectionKey key = this.m_keyHead;
                    while (key != null) {
                        ((MultiplexedSelector)key.selector()).setKeyState(key, true);
                        key = key.m_next;
                    }
                }
            }
            return fAdded;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SelectionKey makeKey(Selector selector) {
            ServerSelectionKey key = new ServerSelectionKey(selector);
            MultiplexedServerSocketChannel multiplexedServerSocketChannel = this;
            synchronized (multiplexedServerSocketChannel) {
                key.m_next = this.m_keyHead;
                this.m_keyHead = key;
            }
            return key;
        }

        protected boolean isReady() {
            return this.m_queue != null && !this.m_queue.isEmpty();
        }

        class ServerSelectionKey
        extends SelectionKey {
            protected Selector m_selector;
            protected boolean m_fCanceled;
            protected int m_nInterest;
            protected ServerSelectionKey m_next;

            ServerSelectionKey(Selector selector) {
                this.m_selector = selector;
            }

            @Override
            public SelectableChannel channel() {
                return MultiplexedServerSocketChannel.this;
            }

            @Override
            public Selector selector() {
                return this.m_selector;
            }

            @Override
            public boolean isValid() {
                return !this.m_fCanceled;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancel() {
                this.m_fCanceled = true;
                ((MultiplexedSelector)this.m_selector).m_setCancelled.add(this);
                MultiplexedServerSocketChannel multiplexedServerSocketChannel = MultiplexedServerSocketChannel.this;
                synchronized (multiplexedServerSocketChannel) {
                    ServerSelectionKey keyLast = null;
                    ServerSelectionKey key = MultiplexedServerSocketChannel.this.m_keyHead;
                    while (key != null) {
                        if (key == this) {
                            if (keyLast == null) {
                                MultiplexedServerSocketChannel.this.m_keyHead = this.m_next;
                                break;
                            }
                            keyLast.m_next = this.m_next;
                            break;
                        }
                        keyLast = key;
                        key = key.m_next;
                    }
                }
            }

            @Override
            public int interestOps() {
                this.ensureValid();
                return this.m_nInterest;
            }

            @Override
            public SelectionKey interestOps(int ops) {
                this.ensureValid();
                if (ops == 0 || ops == 16) {
                    this.m_nInterest = ops;
                    return this;
                }
                throw new IllegalArgumentException();
            }

            @Override
            public int readyOps() {
                this.ensureValid();
                return MultiplexedServerSocketChannel.this.m_queue.isEmpty() ? 0 : 0x10 & this.m_nInterest;
            }

            protected void ensureValid() {
                if (this.m_fCanceled) {
                    throw new CancelledKeyException();
                }
            }
        }
    }

    protected static class MultiplexedSelector
    extends WrapperSelector {
        protected Set<SelectionKey> m_setKeys = new HashSet<SelectionKey>();
        protected Set<SelectionKey> m_setKeysRO;
        protected Set<SelectionKey> m_setReady = new HashSet<SelectionKey>();
        protected Set<SelectionKey> m_setPending = new HashSet<SelectionKey>();
        protected Set<SelectionKey> m_setCancelled = Collections.newSetFromMap(new ConcurrentHashMap());

        protected MultiplexedSelector(Selector delegate, SelectorProvider provider) throws IOException {
            super(delegate, provider);
            this.m_setKeysRO = new UnmodifiableSetCollection<SelectionKey>(this.m_setKeys, super.keys());
        }

        @Override
        public Set<SelectionKey> keys() {
            Set<SelectionKey> setKeys = this.m_setKeysRO;
            this.ensureOpen();
            return setKeys;
        }

        @Override
        public Set<SelectionKey> selectedKeys() {
            Set<SelectionKey> setReady = this.m_setReady;
            this.ensureOpen();
            return setReady;
        }

        @Override
        public int selectNow() throws IOException {
            return this.select(-1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized int select(long cMillisTimeout) throws IOException {
            Set<SelectionKey> setKeys = this.m_setKeys;
            Set<SelectionKey> setKeysRO = this.m_setKeysRO;
            Set<SelectionKey> setReady = this.m_setReady;
            Set<SelectionKey> setPend = this.m_setPending;
            Selector delegate = this.m_delegate;
            this.ensureOpen();
            Set<SelectionKey> set = setKeysRO;
            synchronized (set) {
                Set<SelectionKey> set2 = setReady;
                synchronized (set2) {
                    boolean fEmpty;
                    int cNew = 0;
                    Set<SelectionKey> set3 = setPend;
                    synchronized (set3) {
                        Iterator<SelectionKey> iter = this.m_setCancelled.iterator();
                        while (iter.hasNext()) {
                            SelectionKey key = iter.next();
                            setKeys.remove(key);
                            setPend.remove(key);
                            iter.remove();
                        }
                        fEmpty = setPend.isEmpty();
                        if (!fEmpty) {
                            setReady.addAll(setPend);
                            cNew = setPend.size();
                        }
                    }
                    if (cMillisTimeout >= 0L && fEmpty) {
                        delegate.select(cMillisTimeout);
                        set3 = setPend;
                        synchronized (set3) {
                            setReady.addAll(setPend);
                            cNew = setPend.size();
                        }
                    } else {
                        delegate.selectNow();
                    }
                    Set<SelectionKey> setClient = delegate.selectedKeys();
                    for (SelectionKey key : setClient) {
                        setReady.add((SelectionKey)key.attachment());
                        ++cNew;
                    }
                    setClient.clear();
                    return cNew;
                }
            }
        }

        @Override
        public int select() throws IOException {
            return this.select(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void implCloseSelector() throws IOException {
            Set<SelectionKey> setKeys = this.m_setKeys;
            Set<SelectionKey> setKeysRO = this.m_setKeysRO;
            Set<SelectionKey> setReady = this.m_setReady;
            super.implCloseSelector();
            MultiplexedSelector multiplexedSelector = this;
            synchronized (multiplexedSelector) {
                Set<SelectionKey> set = setKeysRO;
                synchronized (set) {
                    Set<SelectionKey> set2 = setReady;
                    synchronized (set2) {
                        Set<SelectionKey> set3 = setKeys;
                        synchronized (set3) {
                            Iterator<SelectionKey> iter = setKeys.iterator();
                            while (iter.hasNext()) {
                                SelectionKey key = iter.next();
                                if (key.isValid()) {
                                    key.cancel();
                                }
                                iter.remove();
                            }
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected SelectionKey register(AbstractSelectableChannel ch, int ops, Object att) {
            Set<SelectionKey> setKeys;
            Set<SelectionKey> set = setKeys = this.m_setKeys;
            synchronized (set) {
                SelectionKey key;
                if (ch instanceof MultiplexedServerSocketChannel) {
                    MultiplexedServerSocketChannel chanMulti = (MultiplexedServerSocketChannel)ch;
                    key = chanMulti.makeKey(this);
                    key.interestOps(ops);
                    key.attach(att);
                    if (chanMulti.isReady()) {
                        this.setKeyState(key, true);
                    }
                    setKeys.add(key);
                } else {
                    key = super.register(ch, ops, att);
                }
                return key;
            }
        }

        public String toString() {
            return "MultiplexedSelector(" + this.m_delegate + ")";
        }

        protected void ensureOpen() {
            if (!this.isOpen()) {
                throw new ClosedSelectorException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setKeyState(SelectionKey key, boolean fReady) {
            Set<SelectionKey> set;
            Set<SelectionKey> set2 = set = this.m_setPending;
            synchronized (set2) {
                if (fReady) {
                    set.add(key);
                    this.wakeup();
                } else {
                    set.remove(key);
                }
            }
        }
    }

    protected class MultiplexedSelectorProvider
    extends SelectorProvider {
        protected SelectorProvider m_delegate;

        public MultiplexedSelectorProvider(SelectorProvider delegate) {
            this.m_delegate = delegate;
        }

        public MultiplexedSelectorProvider(SocketProvider providerSocket) throws IOException {
            ServerSocketChannel chan = providerSocket.openServerSocketChannel();
            this.m_delegate = chan.provider();
            chan.close();
        }

        @Override
        public DatagramChannel openDatagramChannel() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Pipe openPipe() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public AbstractSelector openSelector() throws IOException {
            return new MultiplexedSelector(this.m_delegate.openSelector(), this);
        }

        @Override
        public ServerSocketChannel openServerSocketChannel() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public SocketChannel openSocketChannel() throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof MultiplexedSelectorProvider) {
                return this.m_delegate.equals(((MultiplexedSelectorProvider)o).m_delegate);
            }
            return false;
        }

        public int hashCode() {
            return this.m_delegate.hashCode();
        }
    }
}

