/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.internal.net.socketbus;

import com.oracle.common.internal.net.socketbus.SharedBuffer;
import com.oracle.common.internal.net.socketbus.SocketMessageBus;
import com.oracle.common.io.BufferManager;
import com.oracle.common.io.MultiBufferSequence;
import com.oracle.common.net.exabus.EndPoint;
import com.oracle.common.net.exabus.Event;
import java.nio.ByteBuffer;

public class MultiBufferMessageEvent
extends MultiBufferSequence
implements Event {
    protected final SocketMessageBus.MessageConnection m_src;
    protected final SharedBuffer m_buffer0;
    protected final SharedBuffer m_bufferN;

    public MultiBufferMessageEvent(SocketMessageBus.MessageConnection src, BufferManager manager, ByteBuffer[] aBuffer, int of, int cBuffer, long cbBuffer, SharedBuffer buff0, SharedBuffer buffN) {
        super(manager, aBuffer, of, cBuffer, cbBuffer);
        this.m_src = src;
        this.m_buffer0 = buff0;
        this.m_bufferN = buffN;
    }

    @Override
    public Event.Type getType() {
        return Event.Type.MESSAGE;
    }

    @Override
    public EndPoint getEndPoint() {
        return this.m_src.getPeer();
    }

    @Override
    public Object getContent() {
        return this;
    }

    @Override
    public void dispose() {
        this.m_src.onMessageDispose(this);
        BufferManager manager = this.m_manager;
        ByteBuffer[] aBuffer = this.m_aBuffer;
        this.m_buffer0.dispose();
        int c = this.m_ofBuffer + this.m_cBuffer - 1;
        for (int i = this.m_ofBuffer + 1; i < c; ++i) {
            manager.release(aBuffer[i]);
        }
        this.m_bufferN.dispose();
        this.m_aBuffer = null;
    }

    public String toString() {
        return (Object)((Object)this.getType()) + " event for " + this.getEndPoint() + " containing " + this.getLength() + " bytes";
    }
}

