/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.queue.concurrentQueue;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.Queue$Iterator;
import com.tangosol.coherence.component.util.queue.ConcurrentQueue;
import com.tangosol.coherence.component.util.queue.concurrentQueue.BalancedQueue$TargetQueue;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class BalancedQueue
extends ConcurrentQueue {
    private volatile Map.Entry[] __m_Entries;
    private int __m_EntryIndex;
    private Map __m_TargetMap;
    private static ListMap __mapChildren;

    static {
        BalancedQueue.__initStatic();
    }

    public BalancedQueue(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Iterator", Queue$Iterator.get_CLASS());
        Class clazz2 = __mapChildren.put("TargetQueue", BalancedQueue$TargetQueue.get_CLASS());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object oElement) {
        Object object = this.getLock(this.getTarget(oElement));
        synchronized (object) {
            this.ensureTargetQueue(oElement).add(oElement);
        }
        this.onAddElement();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addHead(Object oElement) {
        Object object = this.getLock(this.getTarget(oElement));
        synchronized (object) {
            this.ensureTargetQueue(oElement).addHead(oElement);
        }
        this.onAddElement();
        return true;
    }

    protected Queue ensureTargetQueue(Object oElement) {
        Object oTarget = this.getTarget(oElement);
        Map map = this.getTargetMap();
        Queue queue = (Queue)map.get(oTarget);
        if (queue == null) {
            queue = this.instantiateTargetQueue();
            map.put(oTarget, queue);
            this.refreshEntries();
        }
        return queue;
    }

    public Map.Entry getCurrentEntry() {
        Map.Entry[] aEntry = this.getEntries();
        int cEntries = aEntry == null ? -1 : aEntry.length;
        if (cEntries > 0) {
            return aEntry[this.getEntryIndex() % cEntries];
        }
        return null;
    }

    public Map.Entry[] getEntries() {
        return this.__m_Entries;
    }

    public int getEntryIndex() {
        return this.__m_EntryIndex;
    }

    protected Object getLock(Object oTarget) {
        return oTarget;
    }

    public Object getTarget(Object oElement) {
        return null;
    }

    public int getTargetCount() {
        return this.getTargetMap().size();
    }

    protected Map getTargetMap() {
        return this.__m_TargetMap;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/queue/concurrentQueue/BalancedQueue".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    private final Component get_Module() {
        return this;
    }

    protected Queue instantiateTargetQueue() {
        return new BalancedQueue$TargetQueue();
    }

    protected Map.Entry nextEntry() {
        Map.Entry entryCurrent = this.getCurrentEntry();
        int iEntry = this.getEntryIndex();
        if (++iEntry < 0 ? true : entryCurrent == null) {
            iEntry = 0;
        }
        this.setEntryIndex(iEntry);
        return entryCurrent;
    }

    public void onEmptyTarget(Object oTarget, Queue queueTarget) {
        if (!(Base.getRandom().nextInt(1000) == 0) ? false : this.getTargetMap().size() > 1) {
            this.safeRemoveTargetQueue(oTarget);
        }
    }

    public Object peekNoWait() {
        Map.Entry entry = this.getCurrentEntry();
        while (this.isEmpty() ^ true) {
            Queue queue;
            Object oPeek;
            if (entry != null && (oPeek = (queue = (Queue)entry.getValue()).peekNoWait()) != null) {
                return oPeek;
            }
            entry = this.nextEntry();
        }
        return null;
    }

    protected synchronized Map.Entry[] refreshEntries() {
        Set setEntry = this.getTargetMap().entrySet();
        Map.Entry[] aEntry = this.getEntries();
        if (aEntry == null) {
            aEntry = new Map.Entry[setEntry.size()];
        }
        aEntry = setEntry.toArray(aEntry);
        this.setEntries(aEntry);
        return aEntry;
    }

    public Object removeNoWait() {
        Map map = this.getTargetMap();
        AtomicInteger counter = this.getElementCounter();
        while (counter.get() > 0) {
            Map.Entry entry = this.nextEntry();
            if (entry == null) continue;
            Queue queue = (Queue)entry.getValue();
            Object oRemoved = queue.removeNoWait();
            if (oRemoved == null) {
                this.onEmptyTarget(entry.getKey(), queue);
                continue;
            }
            if (counter.decrementAndGet() == 0) {
                this.onEmpty();
            }
            return oRemoved;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void safeRemoveTargetQueue(Object oTarget) {
        boolean fRemoved = false;
        Object object = this.getLock(oTarget);
        synchronized (object) {
            Map mapTarget = this.getTargetMap();
            Queue queueTarget = (Queue)mapTarget.get(oTarget);
            if (!(queueTarget != null) ? false : queueTarget.isEmpty()) {
                mapTarget.remove(oTarget);
                fRemoved = true;
            }
        }
        if (fRemoved) {
            this.refreshEntries();
        }
    }

    protected void setEntries(Map.Entry[] cEntries) {
        this.__m_Entries = cEntries;
    }

    protected void setEntryIndex(int i) {
        this.__m_EntryIndex = i;
    }

    protected void setTargetMap(Map mapTarget) {
        this.__m_TargetMap = mapTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map map;
        StringBuffer sb = new StringBuffer(super.toString());
        Map map2 = map = this.getTargetMap();
        synchronized (map2) {
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                sb.append(", target[").append(entry.getKey()).append("]={").append(entry.getValue()).append('}');
            }
        }
        return sb.toString();
    }
}

