/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal;

import com.tangosol.coherence.transaction.internal.IndexWrapper;
import com.tangosol.coherence.transaction.internal.ServiceContext;
import com.tangosol.coherence.transaction.internal.storage.KeyIndex;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.coherence.transaction.internal.storage.LocalPartitionState;
import com.tangosol.coherence.transaction.internal.storage.SyntheticKey;
import com.tangosol.coherence.transaction.internal.storage.XidSyntheticKey;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.BackingMapContext;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.MapIndex;
import com.tangosol.util.SimpleMapEntry;
import com.tangosol.util.SimpleMapIndex;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.AbstractExtractor;
import com.tangosol.util.extractor.IndexAwareExtractor;
import com.tangosol.util.extractor.KeyExtractor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

public class ExtractorWrapper
extends AbstractExtractor
implements IndexAwareExtractor,
ExternalizableLite,
PortableObject {
    private ValueExtractor m_valueExtractor;
    private String m_sTable;
    private transient ServiceContext m_context;

    public ExtractorWrapper() {
        this.m_nTarget = 0;
    }

    public ExtractorWrapper(ValueExtractor valueExtractor, ServiceContext context, String sTable) {
        this.m_valueExtractor = valueExtractor;
        this.m_context = context;
        this.m_sTable = sTable;
        this.m_nTarget = this.m_valueExtractor instanceof KeyExtractor ? 1 : 0;
    }

    @Override
    public Object extract(Object o) {
        return this.m_valueExtractor.extract(o);
    }

    @Override
    public Object extractFromEntry(Map.Entry entry) {
        Object oValue = entry.getValue();
        if (this.m_nTarget == 1) {
            XidSyntheticKey xidSynKey = (XidSyntheticKey)entry.getKey();
            return ((KeyExtractor)this.m_valueExtractor).extractFromEntry(new SimpleMapEntry(this.getNaturalKey(xidSynKey), oValue));
        }
        return this.m_valueExtractor.extract(oValue);
    }

    @Override
    public MapIndex createIndex(boolean fOrdered, Comparator comparator, Map mapIndex, BackingMapContext ctx) {
        IndexWrapper index;
        if (this.m_valueExtractor instanceof IndexAwareExtractor) {
            index = new IndexWrapper(((IndexAwareExtractor)this.m_valueExtractor).createIndex(fOrdered, comparator, new IndexMapWrapper(mapIndex), ctx));
        } else {
            index = new IndexWrapper(new SimpleMapIndex(this, fOrdered, comparator, ctx));
            mapIndex.put(this.m_valueExtractor, index);
        }
        return index;
    }

    @Override
    public MapIndex destroyIndex(Map mapIndex) {
        if (this.m_valueExtractor instanceof IndexAwareExtractor) {
            return ((IndexAwareExtractor)this.m_valueExtractor).destroyIndex(new IndexMapWrapper(mapIndex));
        }
        return (MapIndex)mapIndex.remove(this.m_valueExtractor);
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof ExtractorWrapper && ((Object)this.m_valueExtractor).equals(((ExtractorWrapper)o).m_valueExtractor);
    }

    @Override
    public int hashCode() {
        return ((Object)this.m_valueExtractor).hashCode();
    }

    @Override
    public String toString() {
        return "ExtractorWrapper(" + ((Object)this.m_valueExtractor).toString() + ")";
    }

    private Object getNaturalKey(XidSyntheticKey xidSynKey) {
        long lKey = xidSynKey.getKey();
        LocalPartitionState lps = LocalMemberState.getMemberState(this.m_context.getServiceName()).getLocalPartitionState(SyntheticKey.getPartition(lKey));
        KeyIndex keyIndex = lps.getKeyIndex(this.m_sTable);
        return keyIndex.getNaturalKey(SyntheticKey.getIndex(lKey));
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_nTarget = ExternalizableHelper.readInt(in);
        this.m_valueExtractor = (ValueExtractor)ExternalizableHelper.readObject(in);
        this.m_context = (ServiceContext)ExternalizableHelper.readExternalizableLite(in);
        this.m_sTable = (String)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeInt(out, this.m_nTarget);
        ExternalizableHelper.writeObject(out, this.m_valueExtractor);
        ExternalizableHelper.writeExternalizableLite(out, this.m_context);
        ExternalizableHelper.writeObject(out, this.m_sTable);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_nTarget = in.readInt(1);
        this.m_valueExtractor = (ValueExtractor)in.readObject(2);
        this.m_context = (ServiceContext)in.readObject(3);
        this.m_sTable = in.readString(4);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeInt(1, this.m_nTarget);
        out.writeObject(2, this.m_valueExtractor);
        out.writeObject(3, this.m_context);
        out.writeString(4, this.m_sTable);
    }

    private class IndexMapWrapper
    implements Map {
        private Map m_map;

        public IndexMapWrapper(Map map) {
            this.m_map = map;
        }

        @Override
        public int size() {
            return this.m_map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m_map.isEmpty();
        }

        @Override
        public boolean containsKey(Object oKey) {
            return this.m_map.containsKey(oKey);
        }

        @Override
        public boolean containsValue(Object oValue) {
            if (oValue instanceof MapIndex) {
                oValue = new IndexWrapper((MapIndex)oValue);
            }
            return this.m_map.containsValue(oValue);
        }

        public Object get(Object oKey) {
            Object oValue = this.m_map.get(oKey);
            if (oKey instanceof IndexWrapper) {
                return ((IndexWrapper)oKey).getIndex();
            }
            return oValue;
        }

        public Object put(Object oKey, Object oValue) {
            if (oValue instanceof MapIndex) {
                oValue = new IndexWrapper((MapIndex)oValue);
            }
            return this.m_map.put(oKey, oValue);
        }

        public Object remove(Object oKey) {
            Object oValue = this.m_map.remove(oKey);
            if (oKey instanceof IndexWrapper) {
                return ((IndexWrapper)oKey).getIndex();
            }
            return oValue;
        }

        public void putAll(Map map) {
            for (Map.Entry entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public void clear() {
            this.m_map.clear();
        }

        public Set keySet() {
            return this.m_map.keySet();
        }

        public Collection values() {
            throw new UnsupportedOperationException("values is not supported.");
        }

        public Set entrySet() {
            throw new UnsupportedOperationException("entrySet is not supported.");
        }
    }
}

