/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal;

import com.tangosol.coherence.transaction.Connection;
import com.tangosol.coherence.transaction.Isolation;
import com.tangosol.coherence.transaction.OptimisticNamedCache;
import com.tangosol.coherence.transaction.Status;
import com.tangosol.coherence.transaction.TransactionId;
import com.tangosol.coherence.transaction.TransactionState;
import com.tangosol.coherence.transaction.exception.ConnectionClosedException;
import com.tangosol.coherence.transaction.internal.OptimisticNamedCacheImpl;
import com.tangosol.coherence.transaction.internal.ServiceContext;
import com.tangosol.coherence.transaction.internal.Transaction;
import com.tangosol.coherence.transaction.internal.TransactionImpl;
import com.tangosol.coherence.transaction.internal.storage.Schema;
import com.tangosol.coherence.transaction.internal.storage.Session;
import com.tangosol.net.CacheService;
import com.tangosol.net.Member;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.Service;
import java.util.HashSet;
import java.util.Set;

public class ServiceConnection
implements Connection,
MemberListener {
    protected Transaction m_tx;
    protected volatile boolean m_fAutoCommit = true;
    private volatile boolean m_fClosed = false;
    private boolean m_fEager = true;
    private Isolation m_isolation = Isolation.READ_COMMITTED;
    private int m_nSeconds = 300;
    private volatile CacheService m_service;
    private ServiceContext m_context;
    private Member m_localMember;
    private final Set<OptimisticNamedCache> m_setTables = new HashSet<OptimisticNamedCache>();
    private long m_lLastCommitVersion;
    private ClassLoader m_loader;

    public ServiceConnection(CacheService service) {
        this(service, null);
    }

    public ServiceConnection(CacheService service, ClassLoader loader) {
        this.m_loader = loader;
        this.init(service);
    }

    @Override
    public OptimisticNamedCache getNamedCache(String sTable) {
        this.checkNotClosed();
        return this.instantiateCache(sTable);
    }

    @Override
    public void commit() {
        this.checkNotClosed();
        this.checkNotAutoCommit();
        this.m_tx.commit();
    }

    @Override
    public void rollback() {
        this.checkNotClosed();
        this.checkNotAutoCommit();
        this.internalRollback();
    }

    @Override
    public void close() {
        this.close(true);
    }

    @Override
    public boolean isClosed() {
        return this.m_fClosed;
    }

    @Override
    public TransactionState getTransactionState() {
        return this.m_tx;
    }

    @Override
    public void setAutoCommit(boolean fAuto) {
        if (this.m_fAutoCommit == fAuto) {
            return;
        }
        this.m_fAutoCommit = fAuto;
        if (fAuto) {
            this.internalRollback();
        } else {
            this.startNewTransaction();
        }
    }

    @Override
    public boolean isAutoCommit() {
        return this.m_fAutoCommit;
    }

    @Override
    public void setEager(boolean fEager) {
        this.m_fEager = fEager;
        this.m_tx.setEager(fEager);
    }

    @Override
    public boolean isEager() {
        return this.m_fEager;
    }

    @Override
    public void setIsolationLevel(Isolation isolation) {
        Transaction tx = this.m_tx;
        if (!tx.isAutoCommit() && tx.getSession().hasWorkBeenDone()) {
            throw new IllegalStateException("Can't change isolation level with active transaction");
        }
        this.m_isolation = isolation;
        this.startNewTransaction();
    }

    @Override
    public Isolation getIsolationLevel() {
        return this.m_isolation;
    }

    @Override
    public void setTransactionTimeout(int nSeconds) {
        this.m_nSeconds = nSeconds;
        this.getTransaction().setTimeout(this.m_nSeconds);
    }

    @Override
    public int getTransactionTimeout() {
        return this.getTransaction().getTimeout();
    }

    @Override
    public void memberJoined(MemberEvent event) {
    }

    @Override
    public void memberLeaving(MemberEvent event) {
        this.memberLeft(event);
    }

    @Override
    public void memberLeft(MemberEvent event) {
        if (event.getMember().equals(this.m_localMember)) {
            this.m_fClosed = true;
            this.closeChildren();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close(false);
        }
        finally {
            super.finalize();
        }
    }

    protected Transaction newTransaction() {
        TransactionId xid = this.m_context.getXidManager().nextXid();
        Session session = new Session();
        TransactionImpl transaction = new TransactionImpl(xid, session, this.isEager(), this.isAutoCommit(), this.getContext());
        transaction.setTimeout(this.m_nSeconds);
        return transaction;
    }

    private void internalRollback() {
        this.m_tx.rollback();
    }

    private synchronized void close(boolean fCheckState) {
        Status txStatus;
        if (this.isClosed()) {
            return;
        }
        Transaction tx = this.m_tx;
        if (fCheckState && (txStatus = tx.getStatus()).isCompleting()) {
            throw new IllegalStateException("close called on transaction in state: " + (Object)((Object)txStatus));
        }
        this.m_fClosed = true;
        if (tx.getSession().hasMutations()) {
            this.internalRollback();
        }
        this.closeChildren();
        this.m_service.removeMemberListener(this);
    }

    private void closeChildren() {
        for (OptimisticNamedCache table : this.m_setTables) {
            table.release();
        }
        this.m_setTables.clear();
    }

    private void startNewTransaction() {
        this.m_tx = this.newTransaction();
        this.m_tx.setIsolation(this.getIsolationLevel());
        this.m_tx.getSession().setMinimumMonotonicReadVersion(this.m_lLastCommitVersion);
        this.registerTxListener();
    }

    protected Transaction getTransaction() {
        return this.m_tx;
    }

    private void checkNotClosed() {
        if (this.isClosed()) {
            throw new ConnectionClosedException("Connection has been closed");
        }
    }

    private void checkNotAutoCommit() {
        if (this.m_fAutoCommit) {
            throw new IllegalStateException("Illegal call made in auto-commit mode");
        }
    }

    protected void registerTxListener() {
        this.m_tx.registerStateChangeListener(new Transaction.TransactionStateListener(){

            @Override
            public void stateChanged(Status state) {
                if (state.isTerminal()) {
                    ServiceConnection.this.m_context.getSessionManager().unregister(ServiceConnection.this.m_tx.getXid());
                    if (state == Status.COMMITTED) {
                        ServiceConnection.this.m_lLastCommitVersion = ServiceConnection.this.m_tx.getSession().getCommitVersion();
                    }
                    ServiceConnection.this.startNewTransaction();
                }
            }
        });
    }

    public OptimisticNamedCache instantiateCache(String sTable) {
        OptimisticNamedCacheImpl cache = new OptimisticNamedCacheImpl(this, sTable);
        this.m_setTables.add(cache);
        return cache;
    }

    private void init(CacheService service) {
        this.m_context = ServiceContext.getContext(service.getInfo().getServiceName());
        this.m_service = service;
        this.m_localMember = this.m_context.getSchema().getLocalMember();
        this.m_service.ensureCache("V$TXN-XIDBLOCK", this.m_loader);
        this.m_service.ensureCache("V$TXN-XIDMEMBERS", this.m_loader);
        this.m_service.ensureCache("V$TXN-RECOVERY", this.m_loader);
        this.m_service.ensureCache("V$TXN-XAPREPARED", this.m_loader);
        this.m_service.ensureCache("V$TXN-VERSIONS", this.m_loader);
        service.addMemberListener(this);
        this.startNewTransaction();
    }

    public Service getService() {
        return this.m_service;
    }

    protected ServiceContext getContext() {
        return this.m_context;
    }

    public ClassLoader getClassLoader() {
        return this.m_loader;
    }

    public Schema getSchema() {
        return this.m_context.getSchema();
    }
}

