/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.component;

import com.tangosol.coherence.transaction.TransactionId;
import com.tangosol.coherence.transaction.exception.PredicateFailedException;
import com.tangosol.coherence.transaction.internal.Message;
import com.tangosol.coherence.transaction.internal.Results;
import com.tangosol.coherence.transaction.internal.component.Component;
import com.tangosol.coherence.transaction.internal.operation.MutatingOperation;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.coherence.transaction.internal.storage.LocalPartitionState;
import com.tangosol.coherence.transaction.internal.storage.Storage;
import com.tangosol.coherence.transaction.internal.storage.StorageImpl;
import com.tangosol.coherence.transaction.internal.storage.SyntheticKey;
import com.tangosol.coherence.transaction.internal.storage.TableInfo;
import com.tangosol.coherence.transaction.internal.storage.TableInfoImpl;
import com.tangosol.coherence.transaction.internal.storage.VersionDependencyManager;
import com.tangosol.coherence.transaction.internal.storage.XidSyntheticKey;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import java.util.Map;
import java.util.Set;

public class StorageWrite
implements Component {
    private Storage m_storage = new StorageImpl();

    @Override
    public Message invoke(Message msg) {
        MutatingOperation op = (MutatingOperation)msg.getOperation();
        Set entries = (Set)msg.getContext();
        Results results = msg.getResults();
        Long version = (Long)msg.getBinding("write-version");
        LocalMemberState.getMemberState(op.getServiceName()).setCurrentWriteVersion(version);
        for (Object oEntry : entries) {
            InvocableMap.Entry entry = (InvocableMap.Entry)oEntry;
            this.write(op, entry, results);
        }
        return msg;
    }

    private Results write(MutatingOperation op, Map.Entry entry, Results results) {
        String sService = op.getServiceName();
        String sTable = op.getTableName();
        TransactionId xid = op.getXid();
        TableInfoImpl tableInfo = new TableInfoImpl(sTable, sService);
        Object key = entry.getKey();
        SyntheticKey synKey = (SyntheticKey)entry.getValue();
        Filter validator = op.getPredicate();
        XidSyntheticKey xidKey = new XidSyntheticKey(synKey, xid);
        LocalPartitionState lps = LocalMemberState.getMemberState(sService).getLocalPartitionState(synKey.getPartition());
        if (!this.validatePreviousValue(tableInfo, synKey, xid, validator)) {
            this.setPredicateFailedException(results, key, validator);
            return results;
        }
        try {
            long lVersion = this.addWriteDependency(lps.getDependencyManager(), xid, results);
            this.m_storage.write(tableInfo, xidKey, op.getValue(key), lVersion);
            results.addSyntheticKey(sTable, key, synKey);
        }
        catch (RuntimeException e) {
            results.setException(e);
            return results;
        }
        return results;
    }

    private boolean validatePreviousValue(TableInfo tableInfo, SyntheticKey syntheticKey, TransactionId xid, Filter validator) {
        if (validator == null) {
            return true;
        }
        Object o = this.getCurrentValue(tableInfo, xid, syntheticKey);
        return validator.evaluate(Storage.NIL.equals(o) ? null : o);
    }

    private Object getCurrentValue(TableInfo tableInfo, TransactionId xid, SyntheticKey syntheticKey) {
        XidSyntheticKey versionedKey = new XidSyntheticKey(syntheticKey, xid);
        Object value = this.m_storage.read(tableInfo, versionedKey);
        if (value == null && !this.m_storage.contains(tableInfo, versionedKey)) {
            value = Storage.NIL;
            XidSyntheticKey currentKey = this.getCurrentVersionKey(tableInfo, syntheticKey);
            if (currentKey != null) {
                value = this.m_storage.read(tableInfo, currentKey);
            }
        }
        return value;
    }

    private long addWriteDependency(VersionDependencyManager dependencyManager, TransactionId xid, Results results) {
        long lVersion = dependencyManager.addDependency(xid);
        results.setPartitionVersion(lVersion);
        return lVersion;
    }

    private XidSyntheticKey getCurrentVersionKey(TableInfo tableInfo, SyntheticKey syntheticKey) {
        int iPartition = syntheticKey.getPartition();
        LocalPartitionState lps = LocalMemberState.getMemberState(tableInfo.getServiceName()).getLocalPartitionState(iPartition);
        TransactionId xid = lps.ensureVersionIndex(tableInfo.getTableName()).getXid(syntheticKey, Long.MAX_VALUE);
        return xid == null ? null : new XidSyntheticKey(syntheticKey, xid);
    }

    private void setPredicateFailedException(Results r, Object oKey, Filter validator) {
        StringBuilder sb = new StringBuilder();
        sb.append("Predicate Failed. Key: ");
        sb.append(oKey);
        sb.append(" Predicate: ");
        sb.append(validator);
        r.setException(new PredicateFailedException(sb.toString()));
    }
}

