/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.router;

import com.tangosol.coherence.transaction.internal.Endpoint;
import com.tangosol.coherence.transaction.internal.Message;
import com.tangosol.coherence.transaction.internal.Results;
import com.tangosol.coherence.transaction.internal.operation.AggregateOperation;
import com.tangosol.coherence.transaction.internal.operation.Operation;
import com.tangosol.coherence.transaction.internal.router.AbstractProcessor;
import com.tangosol.coherence.transaction.internal.router.CoherenceAggregateProcessor;
import com.tangosol.coherence.transaction.internal.router.CoherenceParallelAggregateProcessor;
import com.tangosol.coherence.transaction.internal.router.CoherenceProcessor;
import com.tangosol.coherence.transaction.internal.router.RouterConcern;
import com.tangosol.net.NamedCache;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.filter.PartitionedFilter;
import java.util.Map;
import java.util.Set;

public class CoherenceDispatch
implements RouterConcern {
    private String m_sAddr;

    public CoherenceDispatch(Endpoint ep) {
        this.m_sAddr = ep.getAddress();
    }

    @Override
    public Message apply(Message msg) {
        Operation op = msg.getOperation();
        Set setKeys = op.getKeys();
        int nKeys = setKeys.size();
        Object oCtx = msg.getContext();
        Filter predicate = op.getPredicate();
        PartitionSet partitions = op.getPartitionSet();
        if (partitions != null) {
            predicate = new PartitionedFilter(predicate, partitions);
        }
        if (nKeys == 0 && predicate == null) {
            return msg;
        }
        AbstractProcessor processor = this.getProcessor(op, msg, this.m_sAddr);
        NamedCache cache = op.getTable();
        if (!op.isMutating() && !op.isTerminal()) {
            InvocableMap.EntryAggregator aggregator = (InvocableMap.EntryAggregator)((Object)processor);
            msg = setKeys.size() != 0 ? (Message)cache.aggregate(setKeys, aggregator) : (Message)cache.aggregate(predicate, aggregator);
        } else {
            InvocableMap.EntryProcessor entryProcessor = (InvocableMap.EntryProcessor)((Object)processor);
            Map map = setKeys.size() != 0 ? cache.invokeAll(setKeys, entryProcessor) : cache.invokeAll(predicate, entryProcessor);
            Results merged = new Results();
            for (Message msgResult : map.values()) {
                if (msgResult == null) continue;
                merged.combine(msgResult.getResults());
            }
            msg.getResults().combine(merged);
        }
        msg.setContext(oCtx);
        msg.setOperation(op);
        return msg;
    }

    public void setDestinationAddress(String sAddr) {
        this.m_sAddr = sAddr;
    }

    private AbstractProcessor getProcessor(Operation op, Message msg, String sAddr) {
        if (op.getId() == Operation.Id.Aggregate) {
            InvocableMap.EntryAggregator aggregator = ((AggregateOperation)op).getEntryAggregator();
            return aggregator instanceof InvocableMap.ParallelAwareAggregator ? new CoherenceParallelAggregateProcessor(msg, sAddr) : new CoherenceAggregateProcessor(msg, sAddr);
        }
        if (op.getId() == Operation.Id.Size) {
            return new CoherenceParallelAggregateProcessor(msg, sAddr);
        }
        return new CoherenceProcessor(msg, this.m_sAddr);
    }
}

