/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.storage;

import com.tangosol.coherence.transaction.internal.ValuesKeyExtractor;
import com.tangosol.coherence.transaction.internal.storage.FixedPartitionKey;
import com.tangosol.coherence.transaction.internal.storage.TableInfoImpl;
import com.tangosol.io.Serializer;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.Member;
import com.tangosol.net.NamedCache;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.Service;
import com.tangosol.util.Base;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class Schema {
    public static final String VTABLE_PREFIX = "V$TXN-";
    public static final String VTABLE_NATURAL_PREFIX = "V$TXN-NATURAL-";
    public static final String VTABLE_VALUE_PREFIX = "V$TXN-VALUE-";
    public static final String VTABLE_VERSION_PREFIX = "V$TXN-VERSION-";
    public static final String VTABLE_XIDBLOCK = "V$TXN-XIDBLOCK";
    public static final String VTABLE_XIDMEMBERS = "V$TXN-XIDMEMBERS";
    public static final String VTABLE_RECOVERY = "V$TXN-RECOVERY";
    public static final String VTABLE_XAPREPARED = "V$TXN-XAPREPARED";
    public static final String VTABLE_VERSIONS = "V$TXN-VERSIONS";
    public static final int VTABLE_PREFIX_LEN = "V$TXN-".length();
    public static final String[] STORAGE_VTABLE_PREFIXES = new String[]{"V$TXN-NATURAL-", "V$TXN-VALUE-", "V$TXN-VERSION-"};
    public static final String BASE_SCHEME_NATURAL = "V$txn-natural-scheme";
    public static final String BASE_SCHEME_VALUE = "V$txn-value-scheme";
    public static final String BASE_SCHEME_VERSION = "V$txn-version-scheme";
    public static final String[] BASE_SCHEMES = new String[]{"V$txn-natural-scheme", "V$txn-value-scheme", "V$txn-version-scheme"};
    public static final String CR_VERSION_KEY = "KEY";
    private volatile Service m_service;
    private String m_sServiceName;

    public Schema(String sService) {
        this.m_sServiceName = sService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service getService() {
        if (this.m_service == null) {
            Schema schema = this;
            synchronized (schema) {
                if (this.m_service == null) {
                    this.m_service = CacheFactory.getCluster().getService(this.m_sServiceName);
                }
            }
        }
        return this.m_service;
    }

    public Member getLocalMember() {
        return this.getService().getCluster().getLocalMember();
    }

    public Service getClusterService() {
        return this.getService().getCluster().getService("Cluster");
    }

    public Serializer getStorageSerializer() {
        return this.getService().getSerializer();
    }

    public NamedCache getValuesTableByName(String sLogical) {
        Base.azzert(sLogical.indexOf("$") < 0);
        return ((CacheService)this.getService()).ensureCache(Schema.getPhysicalValuesTableName(sLogical), null);
    }

    public NamedCache getVersionsTableByName(String sLogical) {
        Base.azzert(sLogical.indexOf("$") < 0);
        return ((CacheService)this.getService()).ensureCache(Schema.getPhysicalVersionsTableName(sLogical), null);
    }

    public NamedCache getNaturalKeysTableByName(String sLogical) {
        Base.azzert(sLogical.indexOf("$") < 0);
        return ((CacheService)this.getService()).ensureCache(Schema.getPhysicalNaturalKeysTableName(sLogical), null);
    }

    public NamedCache getXidBlockTable() {
        return ((CacheService)this.getService()).ensureCache(VTABLE_XIDBLOCK, null);
    }

    public NamedCache getXidMemberTable() {
        return ((CacheService)this.getService()).ensureCache(VTABLE_XIDMEMBERS, null);
    }

    public NamedCache getRecoveryTable() {
        return ((CacheService)this.getService()).ensureCache(VTABLE_RECOVERY, null);
    }

    public NamedCache getXAPreparedTable() {
        return ((CacheService)this.getService()).ensureCache(VTABLE_XAPREPARED, null);
    }

    public NamedCache getVersionManagerTable() {
        return ((CacheService)this.getService()).ensureCache(VTABLE_VERSIONS, null);
    }

    public Set<String> getLogicalTableNames() {
        HashSet<String> setNames = new HashSet<String>();
        Enumeration caches = ((CacheService)this.getService()).getCacheNames();
        while (caches.hasMoreElements()) {
            String sTable = (String)caches.nextElement();
            if (!sTable.startsWith(VTABLE_NATURAL_PREFIX)) continue;
            setNames.add(Schema.getLogicalTableName(sTable));
        }
        return setNames;
    }

    public int getPartition(Object oKey) {
        return ((PartitionedService)this.getService()).getKeyPartitioningStrategy().getKeyPartition(oKey);
    }

    public void ensureStorage(String sTable, ClassLoader loader) {
        CacheService service = (CacheService)this.getService();
        TableInfoImpl table = new TableInfoImpl(sTable, service.getInfo().getServiceName());
        NamedCache valuesTable = service.ensureCache(Schema.getPhysicalValuesTableName(sTable), loader);
        service.ensureCache(Schema.getPhysicalVersionsTableName(sTable), loader);
        service.ensureCache(Schema.getPhysicalNaturalKeysTableName(sTable), loader);
        valuesTable.addIndex(new ValuesKeyExtractor(table), false, null);
    }

    public Set<FixedPartitionKey> getPartitionSetKeys() {
        HashSet<FixedPartitionKey> m_setPartitions = new HashSet<FixedPartitionKey>();
        int cPartitions = ((PartitionedService)this.m_service).getPartitionCount();
        for (int i = 0; i < cPartitions; ++i) {
            m_setPartitions.add(new FixedPartitionKey(i, ""));
        }
        return m_setPartitions;
    }

    public static String getLogicalTableName(String sPhysicalName) {
        String sLogicalName = Schema.extractLogicalTableName(sPhysicalName);
        if (sLogicalName == null) {
            throw new IllegalArgumentException("Can't get a logical table name from " + sPhysicalName);
        }
        return sLogicalName;
    }

    public static String extractLogicalTableName(String sPhysicalName) {
        int index = sPhysicalName.indexOf(45, VTABLE_PREFIX_LEN);
        return index == -1 ? null : sPhysicalName.substring(index + 1);
    }

    public static String getPhysicalVersionsTableName(String sLogical) {
        return VTABLE_VERSION_PREFIX + sLogical;
    }

    public static String getPhysicalValuesTableName(String sLogical) {
        return VTABLE_VALUE_PREFIX + sLogical;
    }

    public static String getPhysicalNaturalKeysTableName(String sLogical) {
        return VTABLE_NATURAL_PREFIX + sLogical;
    }
}

