/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.storage;

import com.tangosol.coherence.transaction.internal.Transcript;
import com.tangosol.coherence.transaction.internal.TranscriptImpl;
import com.tangosol.coherence.transaction.internal.operation.Operation;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.coherence.transaction.internal.storage.XidSyntheticKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Session {
    private Transcript m_transcriptFlushed = new TranscriptImpl();
    private Transcript m_transcriptPending = new TranscriptImpl();
    private long m_lReadVersion = -1L;
    private long m_lMinMonotonicReadVersion;
    private long m_lCommitVersion = -1L;
    private long m_lTimestamp;
    protected Map<String, Set<XidSyntheticKey>> m_mapSyntheticKeys = new ConcurrentHashMap<String, Set<XidSyntheticKey>>();
    private Map<String, Map<?, ?>> m_mapClientData = new HashMap();

    public void queueOperation(Operation op) {
        if (op.isMutating() && this.getModifiedTables().isEmpty()) {
            LocalMemberState.getMemberState(op.getServiceName()).getJmxStats().incrementActiveCount();
            this.setTimestamp(System.currentTimeMillis());
        }
        this.m_transcriptPending.addOperation(op);
    }

    public void recordSyntheticKeys(String sTable, Set<XidSyntheticKey> setSynKeys) {
        if (setSynKeys != null) {
            Set<XidSyntheticKey> keys = this.m_mapSyntheticKeys.get(sTable);
            if (keys == null) {
                keys = new HashSet<XidSyntheticKey>();
                this.m_mapSyntheticKeys.put(sTable, keys);
            }
            keys.addAll(setSynKeys);
        }
    }

    public Set<String> getModifiedTables() {
        HashSet<String> setTables = new HashSet<String>(this.getSyntheticKeyMap().keySet());
        setTables.addAll(this.m_transcriptPending.getModifiedTables());
        return setTables;
    }

    public boolean hasMutations() {
        return this.getSyntheticKeyMap().size() > 0;
    }

    public boolean hasWorkBeenDone() {
        return this.m_transcriptPending.getOperations().size() > 0 || this.getFlushedTranscript().getOperations().size() > 0;
    }

    public Map<String, Set<XidSyntheticKey>> getSyntheticKeyMap() {
        return this.m_mapSyntheticKeys;
    }

    public Transcript getFlushedTranscript() {
        return this.m_transcriptFlushed;
    }

    public Transcript flushPendingTranscript() {
        Transcript t = this.m_transcriptPending;
        this.m_transcriptPending = new TranscriptImpl();
        this.m_transcriptFlushed.addOperations(t.getOperations());
        return t;
    }

    public void setReadVersion(long lVersion) {
        this.m_lReadVersion = lVersion;
    }

    public long getReadVersion() {
        return this.m_lReadVersion;
    }

    public void setCommitVersion(long lVersion) {
        this.m_lCommitVersion = Math.max(this.m_lCommitVersion, lVersion);
    }

    public long getCommitVersion() {
        return this.m_lCommitVersion;
    }

    public void setTimestamp(long lTimestamp) {
        this.m_lTimestamp = lTimestamp;
    }

    public long getTimestamp() {
        return this.m_lTimestamp;
    }

    public long getActiveMillis() {
        long lTimeStamp = this.getTimestamp();
        return lTimeStamp == 0L ? 0L : System.currentTimeMillis() - this.getTimestamp();
    }

    public Map<String, Map<?, ?>> getClientData() {
        return this.m_mapClientData;
    }

    public void setMinimumMonotonicReadVersion(long lVersion) {
        this.m_lMinMonotonicReadVersion = lVersion;
    }

    public long getMinimumMonotonicReadVersion() {
        return this.m_lMinMonotonicReadVersion;
    }
}

