/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.util;

import com.tangosol.coherence.transaction.internal.FilterWrapper;
import com.tangosol.coherence.transaction.internal.OptimisticNamedCacheImpl;
import com.tangosol.coherence.transaction.internal.Results;
import com.tangosol.coherence.transaction.internal.operation.EntrySetOperation;
import com.tangosol.coherence.transaction.internal.operation.QueryOperation;
import com.tangosol.coherence.transaction.internal.storage.Storage;
import com.tangosol.coherence.transaction.internal.util.PartitionedSetWrapper;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.IdentityExtractor;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.filter.EqualsFilter;
import com.tangosol.util.filter.InFilter;
import com.tangosol.util.filter.NotFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ValuesWrapper
extends PartitionedSetWrapper {
    public ValuesWrapper(QueryOperation operation, OptimisticNamedCacheImpl cache) {
        super(operation, cache);
    }

    @Override
    protected Set getSet(Map map) {
        HashSet set = new HashSet();
        for (Map.Entry entry : map.entrySet()) {
            set.add(entry.getValue());
        }
        return set;
    }

    @Override
    public boolean contains(Object o) {
        return this.getCache().containsValue(o);
    }

    @Override
    public boolean containsAll(Collection collection) {
        EntrySetOperation op = new EntrySetOperation(this.m_operation.getServiceName());
        OptimisticNamedCacheImpl cache = this.getCache();
        op.setPredicate(new FilterWrapper(new InFilter((ValueExtractor)IdentityExtractor.INSTANCE, new HashSet(collection)), cache.getServiceContext(), cache.getCacheName()));
        Results map = cache.invoke(op).getResults();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (map.containsValue(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        Set<Object> c = Collections.singleton(o);
        return c != null && c.size() != 0 && this.updateAll(new EqualsFilter(IdentityExtractor.INSTANCE, o), Storage.NIL);
    }

    @Override
    public boolean retainAll(Collection c) {
        AlwaysFilter filter = c == null || c.size() == 0 ? AlwaysFilter.INSTANCE : new NotFilter(new InFilter((ValueExtractor)IdentityExtractor.INSTANCE, new HashSet(c)));
        return this.updateAll(filter, Storage.NIL);
    }

    @Override
    public boolean removeAll(Collection c) {
        return c != null && c.size() != 0 && this.updateAll(new InFilter((ValueExtractor)IdentityExtractor.INSTANCE, new HashSet(c)), Storage.NIL);
    }
}

