/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Dcmpl;
import com.tangosol.dev.assembler.Fcmpl;
import com.tangosol.dev.assembler.Goto;
import com.tangosol.dev.assembler.Iconst;
import com.tangosol.dev.assembler.If_acmpeq;
import com.tangosol.dev.assembler.If_icmpeq;
import com.tangosol.dev.assembler.Ifeq;
import com.tangosol.dev.assembler.Ifnull;
import com.tangosol.dev.assembler.Ixor;
import com.tangosol.dev.assembler.Label;
import com.tangosol.dev.assembler.Lcmp;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.BooleanExpression;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.EqualityExpression;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.NullExpression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ErrorList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EqualExpression
extends EqualityExpression {
    private static final String CLASS = "EqualExpression";

    public EqualExpression(Expression left, Token operator, Expression right) {
        super(left, operator, right);
    }

    @Override
    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        DualSet setULeft = new DualSet(setUVars);
        left = (Expression)left.precompile(ctx, setULeft, setFVars, mapThrown, errlist);
        DualSet setURight = new DualSet(setULeft);
        right = (Expression)right.precompile(ctx, setURight, setFVars, mapThrown, errlist);
        if (left.getType() == BOOLEAN) {
            if (setULeft.isModified() || setURight.isModified()) {
                Set setLeftTrue = setULeft.getTrueSet().getRemoved();
                Set setLeftFalse = setULeft.getFalseSet().getRemoved();
                Set setRightTrue = setURight.getTrueSet().getRemoved();
                Set setRightFalse = setURight.getFalseSet().getRemoved();
                HashSet setAssigned = new HashSet(setLeftTrue);
                setAssigned.retainAll(setRightFalse);
                setUVars.getTrueSet().removeAll(setAssigned);
                setAssigned = new HashSet(setLeftFalse);
                setAssigned.retainAll(setRightTrue);
                setUVars.getTrueSet().removeAll(setAssigned);
                setAssigned = new HashSet(setLeftTrue);
                setAssigned.retainAll(setRightTrue);
                setUVars.getFalseSet().removeAll(setAssigned);
                setAssigned = new HashSet(setLeftFalse);
                setAssigned.retainAll(setRightFalse);
                setUVars.getFalseSet().removeAll(setAssigned);
            }
            right.checkBoolean(errlist);
        } else {
            setURight.resolve();
            setULeft.resolve();
            if (left.getType().isReference()) {
                if (right.checkReference(errlist)) {
                    left.checkComparable(ctx, right, errlist);
                }
            } else if (left.checkNumeric(errlist) & right.checkNumeric(errlist)) {
                left = left.promoteNumeric(right);
                right = right.promoteNumeric(left);
            }
        }
        this.setLeftExpression(left);
        this.setRightExpression(right);
        this.setType(BOOLEAN);
        return this;
    }

    @Override
    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        if (!ctx.isDebug() && this.isConstant()) {
            return super.compile(ctx, code, fReached, errlist);
        }
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        DataType dt = left.getType();
        if (dt.isNumeric()) {
            Label lblTrue = new Label();
            Label lblExit = new Label();
            left.compile(ctx, code, fReached, errlist);
            right.compile(ctx, code, fReached, errlist);
            switch (dt.getTypeString().charAt(0)) {
                case 'I': {
                    code.add(new If_icmpeq(lblTrue));
                    break;
                }
                case 'J': {
                    code.add(new Lcmp());
                    code.add(new Ifeq(lblTrue));
                    break;
                }
                case 'F': {
                    code.add(new Fcmpl());
                    code.add(new Ifeq(lblTrue));
                    break;
                }
                case 'D': {
                    code.add(new Dcmpl());
                    code.add(new Ifeq(lblTrue));
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            code.add(new Iconst(FALSE));
            code.add(new Goto(lblExit));
            code.add(lblTrue);
            code.add(new Iconst(TRUE));
            code.add(lblExit);
        } else if (dt == BOOLEAN) {
            boolean fUnary = false;
            Expression expr = null;
            boolean fValue = false;
            if (left instanceof BooleanExpression || !ctx.isDebug() && left.isConstant()) {
                fUnary = true;
                expr = right;
                fValue = (Boolean)left.getValue();
            } else if (right instanceof BooleanExpression || !ctx.isDebug() && right.isConstant()) {
                fUnary = true;
                expr = left;
                fValue = (Boolean)right.getValue();
            }
            if (fUnary) {
                expr.compile(ctx, code, fReached, errlist);
                if (!fValue) {
                    code.add(new Iconst(TRUE));
                    code.add(new Ixor());
                }
            } else {
                left.compile(ctx, code, fReached, errlist);
                right.compile(ctx, code, fReached, errlist);
                code.add(new Ixor());
                code.add(new Iconst(TRUE));
                code.add(new Ixor());
            }
        } else {
            Label lblTrue = new Label();
            Label lblExit = new Label();
            if (left instanceof NullExpression || !ctx.isDebug() && left.isConstant() && left.getValue() == null) {
                right.compile(ctx, code, fReached, errlist);
                code.add(new Ifnull(lblTrue));
            } else if (right instanceof NullExpression || !ctx.isDebug() && right.isConstant() && right.getValue() == null) {
                left.compile(ctx, code, fReached, errlist);
                code.add(new Ifnull(lblTrue));
            } else {
                left.compile(ctx, code, fReached, errlist);
                right.compile(ctx, code, fReached, errlist);
                code.add(new If_acmpeq(lblTrue));
            }
            code.add(new Iconst(FALSE));
            code.add(new Goto(lblExit));
            code.add(lblTrue);
            code.add(new Iconst(TRUE));
            code.add(lblExit);
        }
        return fReached;
    }
}

