/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.tools;

import com.tangosol.dev.tools.CommandLineTool;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;

public class LineCount
extends CommandLineTool {
    public static void main(String[] asArgs) {
        try {
            int MINSIZE;
            Enumeration enmrFiles;
            int cArgs = asArgs.length;
            if (cArgs < 1) {
                LineCount.showInstructions();
                return;
            }
            String sFileSpec = asArgs[0];
            if (sFileSpec.length() < 1) {
                LineCount.showInstructions();
                return;
            }
            boolean fPrompt = false;
            boolean fRecurse = false;
            boolean fVerbose = false;
            for (int i = 1; i < cArgs; ++i) {
                String sOpt = asArgs[i];
                if (sOpt.length() < 2 || sOpt.charAt(0) != '-') {
                    LineCount.showInstructions();
                    return;
                }
                block8: for (int of = 1; of < sOpt.length(); ++of) {
                    switch (sOpt.charAt(of)) {
                        case 'P': 
                        case 'p': {
                            fPrompt = true;
                            continue block8;
                        }
                        case 'D': 
                        case 'd': {
                            fRecurse = true;
                            continue block8;
                        }
                        case 'V': 
                        case 'v': {
                            fVerbose = true;
                            continue block8;
                        }
                        default: {
                            LineCount.showInstructions();
                            return;
                        }
                    }
                }
            }
            if (fVerbose) {
                LineCount.out();
                LineCount.out("File Spec   :  \"" + sFileSpec + "\"");
                LineCount.out("Selected Options:");
                if (fRecurse) {
                    LineCount.out("  -d  Recurse sub-directories");
                }
                if (fPrompt) {
                    LineCount.out("  -p  Prompt before making each change");
                }
                LineCount.out("  -v  Verbose mode");
            }
            if (fVerbose) {
                LineCount.out();
                LineCount.out("Selecting files ...");
            }
            if ((enmrFiles = LineCount.applyFilter(sFileSpec, fRecurse)) == null) {
                LineCount.out();
                LineCount.out("Invalid directory or file specification:  " + sFileSpec);
                LineCount.showInstructions();
                return;
            }
            if (fVerbose) {
                LineCount.out();
                LineCount.out("Processing files ...");
            }
            int MAXSIZE = 0x1000000;
            int cbBuf = MINSIZE = 65536;
            byte[] abBuf = new byte[cbBuf];
            int cTotal = 0;
            int cFiles = 0;
            while (enmrFiles.hasMoreElements()) {
                char chAns;
                File file = (File)enmrFiles.nextElement();
                boolean fReadable = file.canRead();
                boolean fWriteable = file.canWrite();
                boolean fHidden = file.isHidden();
                int cbFile = (int)file.length();
                if (fPrompt || fVerbose) {
                    StringBuffer sb = new StringBuffer();
                    if (fReadable) {
                        sb.append("r");
                    }
                    if (fWriteable) {
                        sb.append("w");
                    }
                    if (fHidden) {
                        sb.append("h");
                    }
                    LineCount.out(file.getPath() + ", (" + sb.toString() + "), " + cbFile + " bytes");
                }
                if (!fReadable || cbFile > MAXSIZE) {
                    String sText = "";
                    if (!fReadable) {
                        sText = "(not readable)";
                    } else if (cbFile > MAXSIZE) {
                        sText = "(too large)";
                    }
                    LineCount.out("Skipping " + file.getPath() + " " + sText);
                    continue;
                }
                if (fPrompt && (chAns = LineCount.in("Evaluate? (Y/N): ")) != 'Y' && chAns != 'y') continue;
                if (cbFile > cbBuf) {
                    cbBuf = cbFile + MINSIZE;
                    abBuf = new byte[cbBuf];
                }
                FileInputStream in = new FileInputStream(file);
                for (int cbTotal = 0; cbTotal < cbFile; cbTotal += in.read(abBuf, cbTotal, cbFile - cbTotal)) {
                }
                in.close();
                int cLines = 0;
                for (int of = 0; of < cbFile; ++of) {
                    if (abBuf[of] != 10) continue;
                    ++cLines;
                }
                if (fVerbose) {
                    LineCount.out(cLines + " line(s)");
                }
                ++cFiles;
                cTotal += cLines;
            }
            LineCount.out();
            LineCount.out("Total files:  " + cFiles);
            LineCount.out("Total lines:  " + cTotal);
            LineCount.out();
        }
        catch (Throwable t) {
            LineCount.out();
            LineCount.out("Caught \"" + t + "\"");
            LineCount.out("(begin stack trace)");
            LineCount.out(t);
            LineCount.out("(end stack trace)");
            LineCount.out();
        }
    }

    static void showInstructions() {
        LineCount.out();
        LineCount.out("Line-counting utility");
        LineCount.out();
        LineCount.out("Usage:");
        LineCount.out("  LineCount <filespec> [-p] [-d] [-v]");
        LineCount.out();
        LineCount.out("Options:");
        LineCount.out("  -d  Recurse sub-directories");
        LineCount.out("  -p  Prompt before making each change");
        LineCount.out("  -v  Verbose mode");
        LineCount.out();
        LineCount.out("Example:");
        LineCount.out("  java com.tangosol.dev.tools.LineCount \"*.java\" -d");
        LineCount.out();
    }
}

