/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.ReadBuffer;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofHelper;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.RawDate;
import com.tangosol.io.pof.RawDateTime;
import com.tangosol.io.pof.RawDayTimeInterval;
import com.tangosol.io.pof.RawQuad;
import com.tangosol.io.pof.RawTime;
import com.tangosol.io.pof.RawTimeInterval;
import com.tangosol.io.pof.RawYearMonthInterval;
import com.tangosol.util.Binary;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.LongArray;
import com.tangosol.util.SparseArray;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PofBufferReader
extends PofHelper
implements PofReader {
    protected ReadBuffer.BufferInput m_in;
    protected PofContext m_ctx;
    protected SparseArray m_arrayRefs;

    public PofBufferReader(ReadBuffer.BufferInput in, PofContext ctx) {
        this.m_in = in;
        this.m_ctx = ctx;
    }

    protected PofBufferReader() {
    }

    @Override
    public boolean readBoolean(int iProp) throws IOException {
        return this.readInt(iProp) != 0;
    }

    @Override
    public byte readByte(int iProp) throws IOException {
        return (byte)this.readInt(iProp);
    }

    @Override
    public char readChar(int iProp) throws IOException {
        return (char)this.readInt(iProp);
    }

    @Override
    public short readShort(int iProp) throws IOException {
        return (short)this.readInt(iProp);
    }

    @Override
    public int readInt(int iProp) throws IOException {
        int n = 0;
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    n = this.readInt(iProp);
                    this.registerIdentity(nId, n);
                    break;
                }
                case -32: {
                    Number number = (Number)this.lookupIdentity(in.readPackedInt());
                    if (number == null) break;
                    n = number.intValue();
                    break;
                }
                case -42: 
                case -37: {
                    break;
                }
                default: {
                    n = PofBufferReader.readAsInt(in, nType);
                }
            }
        }
        this.complete(iProp);
        return n;
    }

    @Override
    public long readLong(int iProp) throws IOException {
        long n = 0L;
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    n = this.readLong(iProp);
                    this.registerIdentity(nId, n);
                    break;
                }
                case -32: {
                    Number number = (Number)this.lookupIdentity(in.readPackedInt());
                    if (number == null) break;
                    n = number.longValue();
                    break;
                }
                case -42: 
                case -37: {
                    break;
                }
                default: {
                    n = PofBufferReader.readAsLong(in, nType);
                }
            }
        }
        this.complete(iProp);
        return n;
    }

    @Override
    public float readFloat(int iProp) throws IOException {
        float fl = 0.0f;
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    fl = this.readFloat(iProp);
                    this.registerIdentity(nId, Float.valueOf(fl));
                    break;
                }
                case -32: {
                    Number number = (Number)this.lookupIdentity(in.readPackedInt());
                    if (number == null) break;
                    fl = number.floatValue();
                    break;
                }
                case -42: 
                case -37: {
                    break;
                }
                default: {
                    fl = PofBufferReader.readAsFloat(in, nType);
                }
            }
        }
        this.complete(iProp);
        return fl;
    }

    @Override
    public double readDouble(int iProp) throws IOException {
        double dfl = 0.0;
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    dfl = this.readDouble(iProp);
                    this.registerIdentity(nId, dfl);
                    break;
                }
                case -32: {
                    Number number = (Number)this.lookupIdentity(in.readPackedInt());
                    if (number == null) break;
                    dfl = number.doubleValue();
                    break;
                }
                case -42: 
                case -37: {
                    break;
                }
                default: {
                    dfl = PofBufferReader.readAsDouble(in, nType);
                }
            }
        }
        this.complete(iProp);
        return dfl;
    }

    @Override
    public boolean[] readBooleanArray(int iProp) throws IOException {
        boolean[] af = null;
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            block0 : switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    af = this.readBooleanArray(iProp);
                    this.registerIdentity(nId, af);
                    break;
                }
                case -32: {
                    af = (boolean[])this.lookupIdentity(in.readPackedInt());
                    break;
                }
                case -37: {
                    break;
                }
                case -36: 
                case -35: {
                    af = BOOLEAN_ARRAY_EMPTY;
                    break;
                }
                case -24: 
                case -22: {
                    int cElements = in.readPackedInt();
                    af = new boolean[cElements];
                    for (int i = 0; i < cElements; ++i) {
                        af[i] = PofBufferReader.readAsInt(in, in.readPackedInt()) != 0;
                    }
                    break;
                }
                case -25: 
                case -23: {
                    int nElementType = in.readPackedInt();
                    int cElements = in.readPackedInt();
                    af = new boolean[cElements];
                    switch (nElementType) {
                        case -11: 
                        case -4: 
                        case -3: 
                        case -2: 
                        case -1: {
                            for (int i = 0; i < cElements; ++i) {
                                af[i] = in.readPackedInt() != 0;
                            }
                            break block0;
                        }
                        default: {
                            for (int i = 0; i < cElements; ++i) {
                                af[i] = PofBufferReader.readAsInt(in, nElementType) != 0;
                            }
                            break block0;
                        }
                    }
                }
                case -26: {
                    int iElement;
                    int cElements = in.readPackedInt();
                    af = new boolean[cElements];
                    while ((iElement = in.readPackedInt()) >= 0) {
                        boolean bl = af[iElement] = PofBufferReader.readAsInt(in, in.readPackedInt()) != 0;
                        if (--cElements >= 0) continue;
                        break block0;
                    }
                    break;
                }
                case -27: {
                    int iElement;
                    int nElementType = in.readPackedInt();
                    int cElements = in.readPackedInt();
                    af = new boolean[cElements];
                    while ((iElement = in.readPackedInt()) >= 0) {
                        boolean bl = af[iElement] = PofBufferReader.readAsInt(in, nElementType) != 0;
                        if (--cElements >= 0) continue;
                        break block0;
                    }
                    break;
                }
                default: {
                    throw new IOException("unable to convert type " + nType + " to an array type");
                }
            }
        }
        this.complete(iProp);
        return af;
    }

    @Override
    public byte[] readByteArray(int iProp) throws IOException {
        byte[] ab = null;
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            block0 : switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    ab = this.readByteArray(iProp);
                    this.registerIdentity(nId, ab);
                    break;
                }
                case -32: {
                    Object o = this.lookupIdentity(in.readPackedInt());
                    ab = o instanceof Binary ? ((Binary)o).toByteArray() : (byte[])o;
                    break;
                }
                case -37: {
                    break;
                }
                case -36: 
                case -35: {
                    ab = BYTE_ARRAY_EMPTY;
                    break;
                }
                case -13: {
                    ab = new byte[in.readPackedInt()];
                    in.readFully(ab);
                    break;
                }
                case -24: 
                case -22: {
                    int cElements = in.readPackedInt();
                    ab = new byte[cElements];
                    for (int i = 0; i < cElements; ++i) {
                        ab[i] = (byte)PofBufferReader.readAsInt(in, in.readPackedInt());
                    }
                    break;
                }
                case -25: 
                case -23: {
                    int nElementType = in.readPackedInt();
                    int cElements = in.readPackedInt();
                    ab = new byte[cElements];
                    if (nElementType == -12) {
                        in.readFully(ab);
                        break;
                    }
                    for (int i = 0; i < cElements; ++i) {
                        ab[i] = (byte)PofBufferReader.readAsInt(in, nElementType);
                    }
                    break;
                }
                case -26: {
                    int iElement;
                    int cElements = in.readPackedInt();
                    ab = new byte[cElements];
                    while ((iElement = in.readPackedInt()) >= 0) {
                        ab[iElement] = (byte)PofBufferReader.readAsInt(in, in.readPackedInt());
                        if (--cElements >= 0) continue;
                        break block0;
                    }
                    break;
                }
                case -27: {
                    int iElement;
                    int nElementType = in.readPackedInt();
                    int cElements = in.readPackedInt();
                    ab = new byte[cElements];
                    while ((iElement = in.readPackedInt()) >= 0) {
                        byte by = ab[iElement] = nElementType == -12 ? in.readByte() : (byte)PofBufferReader.readAsInt(in, nElementType);
                        if (--cElements >= 0) continue;
                        break block0;
                    }
                    break;
                }
                default: {
                    throw new IOException("unable to convert type " + nType + " to an array type");
                }
            }
        }
        this.complete(iProp);
        return ab;
    }

    @Override
    public char[] readCharArray(int iProp) throws IOException {
        char[] ach = null;
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            block0 : switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    ach = this.readCharArray(iProp);
                    this.registerIdentity(nId, ach);
                    break;
                }
                case -32: {
                    Object o = this.lookupIdentity(in.readPackedInt());
                    ach = o instanceof String ? ((String)o).toCharArray() : (char[])o;
                    break;
                }
                case -37: {
                    break;
                }
                case -36: 
                case -35: {
                    ach = CHAR_ARRAY_EMPTY;
                    break;
                }
                case -13: {
                    int cb;
                    byte[] ab = new byte[cb];
                    in.readFully(ab);
                    ach = new char[cb];
                    int of = 0;
                    for (cb = in.readPackedInt(); of < cb; ++cb) {
                        ach[of] = (char)(ab[of] & 0xFF);
                    }
                    break;
                }
                case -15: {
                    ach = in.readSafeUTF().toCharArray();
                    break;
                }
                case -24: 
                case -22: {
                    int cElements = in.readPackedInt();
                    ach = new char[cElements];
                    for (int i = 0; i < cElements; ++i) {
                        ach[i] = (char)PofBufferReader.readAsInt(in, in.readPackedInt());
                    }
                    break;
                }
                case -25: 
                case -23: {
                    int nElementType = in.readPackedInt();
                    int cElements = in.readPackedInt();
                    ach = new char[cElements];
                    for (int i = 0; i < cElements; ++i) {
                        ach[i] = nElementType == -14 ? PofBufferReader.readChar(in) : (char)PofBufferReader.readAsInt(in, nElementType);
                    }
                    break;
                }
                case -26: {
                    int iElement;
                    int cElements = in.readPackedInt();
                    ach = new char[cElements];
                    while ((iElement = in.readPackedInt()) >= 0) {
                        ach[iElement] = (char)PofBufferReader.readAsInt(in, in.readPackedInt());
                        if (--cElements >= 0) continue;
                        break block0;
                    }
                    break;
                }
                case -27: {
                    int iElement;
                    int nElementType = in.readPackedInt();
                    int cElements = in.readPackedInt();
                    ach = new char[cElements];
                    while ((iElement = in.readPackedInt()) >= 0) {
                        char c = ach[iElement] = nElementType == -14 ? PofBufferReader.readChar(in) : (char)PofBufferReader.readAsInt(in, nElementType);
                        if (--cElements >= 0) continue;
                        break block0;
                    }
                    break;
                }
                default: {
                    throw new IOException("unable to convert type " + nType + " to an array type");
                }
            }
        }
        this.complete(iProp);
        return ach;
    }

    @Override
    public short[] readShortArray(int iProp) throws IOException {
        short[] an = null;
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            block0 : switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    an = this.readShortArray(iProp);
                    this.registerIdentity(nId, an);
                    break;
                }
                case -32: {
                    an = (short[])this.lookupIdentity(in.readPackedInt());
                    break;
                }
                case -37: {
                    break;
                }
                case -36: {
                    an = SHORT_ARRAY_EMPTY;
                    break;
                }
                case -24: 
                case -22: {
                    int cElements = in.readPackedInt();
                    an = new short[cElements];
                    for (int i = 0; i < cElements; ++i) {
                        an[i] = (short)PofBufferReader.readAsInt(in, in.readPackedInt());
                    }
                    break;
                }
                case -25: 
                case -23: {
                    int nElementType = in.readPackedInt();
                    int cElements = in.readPackedInt();
                    an = new short[cElements];
                    switch (nElementType) {
                        case -4: 
                        case -3: 
                        case -2: 
                        case -1: {
                            for (int i = 0; i < cElements; ++i) {
                                an[i] = (short)in.readPackedInt();
                            }
                            break block0;
                        }
                        default: {
                            for (int i = 0; i < cElements; ++i) {
                                an[i] = (short)PofBufferReader.readAsInt(in, nElementType);
                            }
                            break block0;
                        }
                    }
                }
                case -26: {
                    int iElement;
                    int cElements = in.readPackedInt();
                    an = new short[cElements];
                    while ((iElement = in.readPackedInt()) >= 0) {
                        an[iElement] = (short)PofBufferReader.readAsInt(in, in.readPackedInt());
                        if (--cElements >= 0) continue;
                        break block0;
                    }
                    break;
                }
                case -27: {
                    int nElementType = in.readPackedInt();
                    int cElements = in.readPackedInt();
                    an = new short[cElements];
                    block13 : switch (nElementType) {
                        case -4: 
                        case -3: 
                        case -2: 
                        case -1: {
                            int iElement;
                            while ((iElement = in.readPackedInt()) >= 0) {
                                an[iElement] = (short)in.readPackedInt();
                                if (--cElements >= 0) continue;
                                break block13;
                            }
                            break;
                        }
                        default: {
                            int iElement;
                            while ((iElement = in.readPackedInt()) >= 0) {
                                an[iElement] = (short)PofBufferReader.readAsInt(in, nElementType);
                                if (--cElements >= 0) continue;
                                break block13;
                            }
                            break block13;
                        }
                    }
                    break;
                }
                default: {
                    throw new IOException("unable to convert type " + nType + " to an array type");
                }
            }
        }
        this.complete(iProp);
        return an;
    }

    @Override
    public int[] readIntArray(int iProp) throws IOException {
        int[] an = null;
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            block0 : switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    an = this.readIntArray(iProp);
                    this.registerIdentity(nId, an);
                    break;
                }
                case -32: {
                    an = (int[])this.lookupIdentity(in.readPackedInt());
                    break;
                }
                case -37: {
                    break;
                }
                case -36: {
                    an = INT_ARRAY_EMPTY;
                    break;
                }
                case -24: 
                case -22: {
                    int cElements = in.readPackedInt();
                    an = new int[cElements];
                    for (int i = 0; i < cElements; ++i) {
                        an[i] = PofBufferReader.readAsInt(in, in.readPackedInt());
                    }
                    break;
                }
                case -25: 
                case -23: {
                    int nElementType = in.readPackedInt();
                    int cElements = in.readPackedInt();
                    an = new int[cElements];
                    switch (nElementType) {
                        case -4: 
                        case -3: 
                        case -2: 
                        case -1: {
                            for (int i = 0; i < cElements; ++i) {
                                an[i] = in.readPackedInt();
                            }
                            break block0;
                        }
                        default: {
                            for (int i = 0; i < cElements; ++i) {
                                an[i] = PofBufferReader.readAsInt(in, nElementType);
                            }
                            break block0;
                        }
                    }
                }
                case -26: {
                    int iElement;
                    int cElements = in.readPackedInt();
                    an = new int[cElements];
                    while ((iElement = in.readPackedInt()) >= 0) {
                        an[iElement] = PofBufferReader.readAsInt(in, in.readPackedInt());
                        if (--cElements >= 0) continue;
                        break block0;
                    }
                    break;
                }
                case -27: {
                    int nElementType = in.readPackedInt();
                    int cElements = in.readPackedInt();
                    an = new int[cElements];
                    block13 : switch (nElementType) {
                        case -4: 
                        case -3: 
                        case -2: 
                        case -1: {
                            int iElement;
                            while ((iElement = in.readPackedInt()) >= 0) {
                                an[iElement] = in.readPackedInt();
                                if (--cElements >= 0) continue;
                                break block13;
                            }
                            break;
                        }
                        default: {
                            int iElement;
                            while ((iElement = in.readPackedInt()) >= 0) {
                                an[iElement] = PofBufferReader.readAsInt(in, nElementType);
                                if (--cElements >= 0) continue;
                                break block13;
                            }
                            break block13;
                        }
                    }
                    break;
                }
                default: {
                    throw new IOException("unable to convert type " + nType + " to an array type");
                }
            }
        }
        this.complete(iProp);
        return an;
    }

    @Override
    public long[] readLongArray(int iProp) throws IOException {
        long[] an = null;
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            block0 : switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    an = this.readLongArray(iProp);
                    this.registerIdentity(nId, an);
                    break;
                }
                case -32: {
                    an = (long[])this.lookupIdentity(in.readPackedInt());
                    break;
                }
                case -37: {
                    break;
                }
                case -36: {
                    an = LONG_ARRAY_EMPTY;
                    break;
                }
                case -24: 
                case -22: {
                    int cElements = in.readPackedInt();
                    an = new long[cElements];
                    for (int i = 0; i < cElements; ++i) {
                        an[i] = PofBufferReader.readAsLong(in, in.readPackedInt());
                    }
                    break;
                }
                case -25: 
                case -23: {
                    int nElementType = in.readPackedInt();
                    int cElements = in.readPackedInt();
                    an = new long[cElements];
                    switch (nElementType) {
                        case -4: 
                        case -3: 
                        case -2: 
                        case -1: {
                            for (int i = 0; i < cElements; ++i) {
                                an[i] = in.readPackedLong();
                            }
                            break block0;
                        }
                        default: {
                            for (int i = 0; i < cElements; ++i) {
                                an[i] = PofBufferReader.readAsLong(in, nElementType);
                            }
                            break block0;
                        }
                    }
                }
                case -26: {
                    int iElement;
                    int cElements = in.readPackedInt();
                    an = new long[cElements];
                    while ((iElement = in.readPackedInt()) >= 0) {
                        an[iElement] = PofBufferReader.readAsLong(in, in.readPackedInt());
                        if (--cElements >= 0) continue;
                        break block0;
                    }
                    break;
                }
                case -27: {
                    int nElementType = in.readPackedInt();
                    int cElements = in.readPackedInt();
                    an = new long[cElements];
                    block13 : switch (nElementType) {
                        case -4: 
                        case -3: 
                        case -2: 
                        case -1: {
                            int iElement;
                            while ((iElement = in.readPackedInt()) >= 0) {
                                an[iElement] = in.readPackedLong();
                                if (--cElements >= 0) continue;
                                break block13;
                            }
                            break;
                        }
                        default: {
                            int iElement;
                            while ((iElement = in.readPackedInt()) >= 0) {
                                an[iElement] = PofBufferReader.readAsLong(in, nElementType);
                                if (--cElements >= 0) continue;
                                break block13;
                            }
                            break block13;
                        }
                    }
                    break;
                }
                default: {
                    throw new IOException("unable to convert type " + nType + " to an array type");
                }
            }
        }
        this.complete(iProp);
        return an;
    }

    @Override
    public float[] readFloatArray(int iProp) throws IOException {
        float[] afl = null;
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            block0 : switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    afl = this.readFloatArray(iProp);
                    this.registerIdentity(nId, afl);
                    break;
                }
                case -32: {
                    afl = (float[])this.lookupIdentity(in.readPackedInt());
                    break;
                }
                case -37: {
                    break;
                }
                case -36: {
                    afl = FLOAT_ARRAY_EMPTY;
                    break;
                }
                case -24: 
                case -22: {
                    int cElements = in.readPackedInt();
                    afl = new float[cElements];
                    for (int i = 0; i < cElements; ++i) {
                        afl[i] = PofBufferReader.readAsFloat(in, in.readPackedInt());
                    }
                    break;
                }
                case -25: 
                case -23: {
                    int nElementType = in.readPackedInt();
                    int cElements = in.readPackedInt();
                    afl = new float[cElements];
                    for (int i = 0; i < cElements; ++i) {
                        afl[i] = nElementType == -5 ? in.readFloat() : PofBufferReader.readAsFloat(in, nElementType);
                    }
                    break;
                }
                case -26: {
                    int iElement;
                    int cElements = in.readPackedInt();
                    afl = new float[cElements];
                    while ((iElement = in.readPackedInt()) >= 0) {
                        afl[iElement] = PofBufferReader.readAsFloat(in, in.readPackedInt());
                        if (--cElements >= 0) continue;
                        break block0;
                    }
                    break;
                }
                case -27: {
                    int iElement;
                    int nElementType = in.readPackedInt();
                    int cElements = in.readPackedInt();
                    afl = new float[cElements];
                    while ((iElement = in.readPackedInt()) >= 0) {
                        float f = afl[iElement] = nElementType == -5 ? in.readFloat() : PofBufferReader.readAsFloat(in, nElementType);
                        if (--cElements >= 0) continue;
                        break block0;
                    }
                    break;
                }
                default: {
                    throw new IOException("unable to convert type " + nType + " to an array type");
                }
            }
        }
        this.complete(iProp);
        return afl;
    }

    @Override
    public double[] readDoubleArray(int iProp) throws IOException {
        double[] adfl = null;
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            block0 : switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    adfl = this.readDoubleArray(iProp);
                    this.registerIdentity(nId, adfl);
                    break;
                }
                case -32: {
                    adfl = (double[])this.lookupIdentity(in.readPackedInt());
                    break;
                }
                case -37: {
                    break;
                }
                case -36: {
                    adfl = DOUBLE_ARRAY_EMPTY;
                    break;
                }
                case -24: 
                case -22: {
                    int cElements = in.readPackedInt();
                    adfl = new double[cElements];
                    for (int i = 0; i < cElements; ++i) {
                        adfl[i] = PofBufferReader.readAsDouble(in, in.readPackedInt());
                    }
                    break;
                }
                case -25: 
                case -23: {
                    int nElementType = in.readPackedInt();
                    int cElements = in.readPackedInt();
                    adfl = new double[cElements];
                    for (int i = 0; i < cElements; ++i) {
                        adfl[i] = nElementType == -6 ? in.readDouble() : PofBufferReader.readAsDouble(in, nElementType);
                    }
                    break;
                }
                case -26: {
                    int iElement;
                    int cElements = in.readPackedInt();
                    adfl = new double[cElements];
                    while ((iElement = in.readPackedInt()) >= 0) {
                        adfl[iElement] = PofBufferReader.readAsDouble(in, in.readPackedInt());
                        if (--cElements >= 0) continue;
                        break block0;
                    }
                    break;
                }
                case -27: {
                    int iElement;
                    int nElementType = in.readPackedInt();
                    int cElements = in.readPackedInt();
                    adfl = new double[cElements];
                    while ((iElement = in.readPackedInt()) >= 0) {
                        double d = adfl[iElement] = nElementType == -6 ? in.readDouble() : PofBufferReader.readAsDouble(in, nElementType);
                        if (--cElements >= 0) continue;
                        break block0;
                    }
                    break;
                }
                default: {
                    throw new IOException("unable to convert type " + nType + " to an array type");
                }
            }
        }
        this.complete(iProp);
        return adfl;
    }

    @Override
    public BigInteger readBigInteger(int iProp) throws IOException {
        BigInteger n = null;
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    n = this.readBigInteger(iProp);
                    this.registerIdentity(nId, n);
                    break;
                }
                case -32: {
                    Number number = (Number)this.lookupIdentity(in.readPackedInt());
                    n = (BigInteger)PofBufferReader.convertNumber(number, 7);
                    break;
                }
                case -37: {
                    break;
                }
                case -42: {
                    n = BigInteger.ZERO;
                    break;
                }
                default: {
                    n = PofBufferReader.readAsBigInteger(in, nType);
                }
            }
        }
        this.complete(iProp);
        return n;
    }

    @Override
    public RawQuad readRawQuad(int iProp) throws IOException {
        RawQuad qfl = RawQuad.ZERO;
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    qfl = this.readRawQuad(iProp);
                    this.registerIdentity(nId, qfl);
                    break;
                }
                case -32: {
                    Number number = (Number)this.lookupIdentity(in.readPackedInt());
                    qfl = (RawQuad)PofBufferReader.convertNumber(number, 10);
                    break;
                }
                case -37: {
                    qfl = null;
                    break;
                }
                case -42: {
                    break;
                }
                default: {
                    qfl = PofBufferReader.readAsQuad(in, nType);
                }
            }
        }
        this.complete(iProp);
        return qfl;
    }

    @Override
    public BigDecimal readBigDecimal(int iProp) throws IOException {
        BigDecimal dec = null;
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    dec = this.readBigDecimal(iProp);
                    this.registerIdentity(nId, dec);
                    break;
                }
                case -32: {
                    Number number = (Number)this.lookupIdentity(in.readPackedInt());
                    dec = (BigDecimal)PofBufferReader.convertNumber(number, 11);
                    break;
                }
                case -37: {
                    break;
                }
                case -42: {
                    dec = BigDecimal.ZERO;
                    break;
                }
                default: {
                    dec = PofBufferReader.readAsBigDecimal(in, nType);
                }
            }
        }
        this.complete(iProp);
        return dec;
    }

    @Override
    public Binary readBinary(int iProp) throws IOException {
        Binary bin = null;
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    bin = this.readBinary(iProp);
                    this.registerIdentity(nId, bin);
                    break;
                }
                case -32: {
                    Object o = this.lookupIdentity(in.readPackedInt());
                    bin = o instanceof byte[] ? new Binary((byte[])o) : (Binary)o;
                    break;
                }
                case -37: {
                    break;
                }
                case -36: 
                case -35: {
                    bin = BINARY_EMPTY;
                    break;
                }
                case -13: {
                    bin = PofBufferReader.readBinary(in);
                    break;
                }
                case -24: 
                case -22: {
                    int cb = in.readPackedInt();
                    byte[] ab = new byte[cb];
                    for (int i = 0; i < cb; ++i) {
                        ab[i] = (byte)PofBufferReader.readAsInt(in, in.readPackedInt());
                    }
                    bin = new Binary(ab);
                    break;
                }
                case -25: 
                case -23: {
                    int nElementType = in.readPackedInt();
                    int cb = in.readPackedInt();
                    byte[] ab = new byte[cb];
                    if (nElementType == -12) {
                        in.readFully(ab);
                    } else {
                        for (int i = 0; i < cb; ++i) {
                            ab[i] = (byte)PofBufferReader.readAsInt(in, nElementType);
                        }
                    }
                    bin = new Binary(ab);
                    break;
                }
                case -26: {
                    int iElement;
                    int cb = in.readPackedInt();
                    byte[] ab = new byte[cb];
                    while ((iElement = in.readPackedInt()) >= 0) {
                        ab[iElement] = (byte)PofBufferReader.readAsInt(in, in.readPackedInt());
                        if (--cb >= 0) continue;
                    }
                    bin = new Binary(ab);
                    break;
                }
                case -27: {
                    int iElement;
                    int nElementType = in.readPackedInt();
                    int cb = in.readPackedInt();
                    byte[] ab = new byte[cb];
                    while ((iElement = in.readPackedInt()) >= 0) {
                        byte by = ab[iElement] = nElementType == -12 ? in.readByte() : (byte)PofBufferReader.readAsInt(in, nElementType);
                        if (--cb >= 0) continue;
                    }
                    bin = new Binary(ab);
                    break;
                }
                default: {
                    throw new IOException("unable to convert type " + nType + " to a Binary type");
                }
            }
        }
        this.complete(iProp);
        return bin;
    }

    @Override
    public String readString(int iProp) throws IOException {
        String s = null;
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    s = this.readString(iProp);
                    this.registerIdentity(nId, s);
                    break;
                }
                case -32: {
                    Object o = this.lookupIdentity(in.readPackedInt());
                    if (o instanceof byte[]) {
                        s = new String((byte[])o, 0);
                        break;
                    }
                    if (o instanceof Binary) {
                        s = new String(((Binary)o).toByteArray(), 0);
                        break;
                    }
                    s = (String)o;
                    break;
                }
                case -37: {
                    break;
                }
                case -36: 
                case -35: {
                    s = "";
                    break;
                }
                case -13: {
                    int cb = in.readPackedInt();
                    int of = in.getOffset();
                    ReadBuffer buf = in.getBuffer();
                    if (buf == null) {
                        s = new String(in.readBuffer(cb).toByteArray(), 0);
                        break;
                    }
                    in.skipBytes(cb);
                    Binary bin = in.getBuffer().toBinary(of, cb);
                    s = new String(bin.toByteArray(), 0);
                    break;
                }
                case -15: {
                    s = in.readSafeUTF();
                    break;
                }
                case -24: 
                case -22: {
                    int cch = in.readPackedInt();
                    char[] ach = new char[cch];
                    for (int i = 0; i < cch; ++i) {
                        ach[i] = PofBufferReader.readAsChar(in, in.readPackedInt());
                    }
                    s = new String(ach);
                    break;
                }
                case -25: 
                case -23: {
                    int nElementType = in.readPackedInt();
                    int cch = in.readPackedInt();
                    char[] ach = new char[cch];
                    for (int i = 0; i < cch; ++i) {
                        ach[i] = PofBufferReader.readAsChar(in, nElementType);
                    }
                    s = new String(ach);
                    break;
                }
                case -26: {
                    int iElement;
                    int cch = in.readPackedInt();
                    char[] ach = new char[cch];
                    while ((iElement = in.readPackedInt()) >= 0) {
                        ach[iElement] = PofBufferReader.readAsChar(in, in.readPackedInt());
                        if (--cch >= 0) continue;
                    }
                    s = new String(ach);
                    break;
                }
                case -27: {
                    int iElement;
                    int nElementType = in.readPackedInt();
                    int cch = in.readPackedInt();
                    char[] ach = new char[cch];
                    while ((iElement = in.readPackedInt()) >= 0) {
                        ach[iElement] = PofBufferReader.readAsChar(in, nElementType);
                        if (--cch >= 0) continue;
                    }
                    s = new String(ach);
                    break;
                }
                default: {
                    throw new IOException("unable to convert type " + nType + " to a String type");
                }
            }
        }
        this.complete(iProp);
        return s;
    }

    @Override
    public Date readDate(int iProp) throws IOException {
        Date date = null;
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    date = this.readDate(iProp);
                    this.registerIdentity(nId, date);
                    break;
                }
                case -32: {
                    date = PofBufferReader.convertToDate(this.lookupIdentity(in.readPackedInt()));
                    break;
                }
                case -37: {
                    break;
                }
                case -16: {
                    date = PofBufferReader.convertToDate(PofBufferReader.readRawDate(in));
                    break;
                }
                case -18: {
                    date = PofBufferReader.convertToDate(PofBufferReader.readRawTime(in));
                    break;
                }
                case -20: {
                    date = PofBufferReader.convertToDate(new RawDateTime(PofBufferReader.readRawDate(in), PofBufferReader.readRawTime(in)));
                    break;
                }
                default: {
                    throw new IOException("unable to convert type " + nType + " to a Java Date type");
                }
            }
        }
        this.complete(iProp);
        return date;
    }

    @Override
    public RawDate readRawDate(int iProp) throws IOException {
        RawDate date = null;
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    date = this.readRawDate(iProp);
                    this.registerIdentity(nId, date);
                    break;
                }
                case -32: {
                    Object o = this.lookupIdentity(in.readPackedInt());
                    if (o instanceof Date) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime((Date)o);
                        date = new RawDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
                        break;
                    }
                    if (o instanceof RawDateTime) {
                        date = ((RawDateTime)o).getRawDate();
                        break;
                    }
                    date = (RawDate)o;
                    break;
                }
                case -37: {
                    break;
                }
                case -16: {
                    date = PofBufferReader.readRawDate(in);
                    break;
                }
                case -20: {
                    date = PofBufferReader.readRawDate(in);
                    PofBufferReader.skipPackedInts(in, 4);
                    int nZoneType = in.readPackedInt();
                    if (nZoneType != 2) break;
                    PofBufferReader.skipPackedInts(in, 2);
                    break;
                }
                default: {
                    throw new IOException("unable to convert type " + nType + " to a RawDate type");
                }
            }
        }
        this.complete(iProp);
        return date;
    }

    @Override
    public RawTime readRawTime(int iProp) throws IOException {
        RawTime time = null;
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    time = this.readRawTime(iProp);
                    this.registerIdentity(nId, time);
                    break;
                }
                case -32: {
                    Object o = this.lookupIdentity(in.readPackedInt());
                    if (o instanceof Date) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime((Date)o);
                        time = new RawTime(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14) * 1000000, false);
                        break;
                    }
                    if (o instanceof RawDateTime) {
                        time = ((RawDateTime)o).getRawTime();
                        break;
                    }
                    time = (RawTime)o;
                    break;
                }
                case -37: {
                    break;
                }
                case -20: {
                    PofBufferReader.skipPackedInts(in, 3);
                }
                case -18: {
                    time = PofBufferReader.readRawTime(in);
                    break;
                }
                default: {
                    throw new IOException("unable to convert type " + nType + " to a RawTime type");
                }
            }
        }
        this.complete(iProp);
        return time;
    }

    @Override
    public RawDateTime readRawDateTime(int iProp) throws IOException {
        RawDateTime dt = null;
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    dt = this.readRawDateTime(iProp);
                    this.registerIdentity(nId, dt);
                    break;
                }
                case -32: {
                    Object o = this.lookupIdentity(in.readPackedInt());
                    if (o instanceof Date) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime((Date)o);
                        dt = new RawDateTime(new RawDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5)), new RawTime(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14) * 1000000, false));
                        break;
                    }
                    if (o instanceof RawDate) {
                        dt = new RawDateTime((RawDate)o, new RawTime(0, 0, 0, 0, false));
                        break;
                    }
                    dt = (RawDateTime)o;
                    break;
                }
                case -37: {
                    break;
                }
                case -16: {
                    dt = new RawDateTime(PofBufferReader.readRawDate(in), new RawTime(0, 0, 0, 0, false));
                    break;
                }
                case -20: {
                    dt = new RawDateTime(PofBufferReader.readRawDate(in), PofBufferReader.readRawTime(in));
                    break;
                }
                default: {
                    throw new IOException("unable to convert type " + nType + " to a RawDateTime type");
                }
            }
        }
        this.complete(iProp);
        return dt;
    }

    @Override
    public RawYearMonthInterval readRawYearMonthInterval(int iProp) throws IOException {
        RawYearMonthInterval interval = null;
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    interval = this.readRawYearMonthInterval(iProp);
                    this.registerIdentity(nId, interval);
                    break;
                }
                case -32: {
                    interval = (RawYearMonthInterval)this.lookupIdentity(in.readPackedInt());
                    break;
                }
                case -37: {
                    break;
                }
                case -17: {
                    int cYears = in.readPackedInt();
                    int cMonths = in.readPackedInt();
                    interval = new RawYearMonthInterval(cYears, cMonths);
                    break;
                }
                default: {
                    throw new IOException("unable to convert type " + nType + " to a RawYearMonthInterval type");
                }
            }
        }
        this.complete(iProp);
        return interval;
    }

    @Override
    public RawTimeInterval readRawTimeInterval(int iProp) throws IOException {
        RawTimeInterval interval = null;
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    interval = this.readRawTimeInterval(iProp);
                    this.registerIdentity(nId, interval);
                    break;
                }
                case -32: {
                    interval = (RawTimeInterval)this.lookupIdentity(in.readPackedInt());
                    break;
                }
                case -37: {
                    break;
                }
                case -19: {
                    int cHours = in.readPackedInt();
                    int cMinutes = in.readPackedInt();
                    int cSeconds = in.readPackedInt();
                    int cNanos = in.readPackedInt();
                    interval = new RawTimeInterval(cHours, cMinutes, cSeconds, cNanos);
                    break;
                }
                default: {
                    throw new IOException("unable to convert type " + nType + " to a RawTimeInterval type");
                }
            }
        }
        this.complete(iProp);
        return interval;
    }

    @Override
    public RawDayTimeInterval readRawDayTimeInterval(int iProp) throws IOException {
        RawDayTimeInterval interval = null;
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    interval = this.readRawDayTimeInterval(iProp);
                    this.registerIdentity(nId, interval);
                    break;
                }
                case -32: {
                    interval = (RawDayTimeInterval)this.lookupIdentity(in.readPackedInt());
                    break;
                }
                case -37: {
                    break;
                }
                case -21: {
                    int cDays = in.readPackedInt();
                    int cHours = in.readPackedInt();
                    int cMinutes = in.readPackedInt();
                    int cSeconds = in.readPackedInt();
                    int cNanos = in.readPackedInt();
                    interval = new RawDayTimeInterval(cDays, cHours, cMinutes, cSeconds, cNanos);
                    break;
                }
                default: {
                    throw new IOException("unable to convert type " + nType + " to a RawDayTimeInterval type");
                }
            }
        }
        this.complete(iProp);
        return interval;
    }

    @Override
    public Object[] readObjectArray(int iProp, Object[] ao) throws IOException {
        Object[] aoResult = null;
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    aoResult = this.readObjectArray(iProp, ao);
                    this.registerIdentity(nId, aoResult);
                    break;
                }
                case -32: {
                    Object o = this.lookupIdentity(in.readPackedInt());
                    if (o instanceof Collection) {
                        aoResult = ((Collection)o).toArray(ao);
                        break;
                    }
                    if (o instanceof LongArray) {
                        LongArray array = (LongArray)o;
                        long cElements = array.getLastIndex() + 1L;
                        if (array.getFirstIndex() < 0L) {
                            throw new ArrayIndexOutOfBoundsException("index=" + array.getFirstIndex());
                        }
                        if (cElements > Integer.MAX_VALUE) {
                            throw new ArrayIndexOutOfBoundsException("index=" + array.getLastIndex());
                        }
                        aoResult = PofBufferReader.resizeArray(ao, (int)cElements);
                        LongArray.Iterator iter = array.iterator();
                        while (iter.hasNext()) {
                            Object oValue;
                            aoResult[(int)iter.getIndex()] = oValue = iter.next();
                        }
                        break;
                    }
                    aoResult = (Object[])o;
                    break;
                }
                case -37: {
                    break;
                }
                case -36: 
                case -35: {
                    aoResult = OBJECT_ARRAY_EMPTY;
                    break;
                }
                default: {
                    aoResult = this.readAsObjectArray(nType, ao);
                }
            }
        }
        this.complete(iProp);
        return aoResult;
    }

    @Override
    public LongArray readLongArray(int iProp, LongArray array) throws IOException {
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            block0 : switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    array = this.readLongArray(iProp, array);
                    this.registerIdentity(nId, array);
                    break;
                }
                case -32: {
                    Object o = this.lookupIdentity(in.readPackedInt());
                    if (o instanceof Collection) {
                        if (array == null) {
                            array = new SparseArray();
                        }
                        int i = 0;
                        Iterator iter = ((Collection)o).iterator();
                        while (iter.hasNext()) {
                            array.set(++i, iter.next());
                        }
                        break;
                    }
                    array = (LongArray)o;
                    break;
                }
                case -37: 
                case -36: 
                case -35: {
                    break;
                }
                case -24: 
                case -22: {
                    if (array == null) {
                        array = new SparseArray();
                    }
                    int co = in.readPackedInt();
                    for (int i = 0; i < co; ++i) {
                        array.set(i, this.readAsObject(in.readPackedInt()));
                    }
                    break;
                }
                case -25: 
                case -23: {
                    if (array == null) {
                        array = new SparseArray();
                    }
                    int nElementType = in.readPackedInt();
                    int co = in.readPackedInt();
                    for (int i = 0; i < co; ++i) {
                        array.set(i, this.readAsUniformObject(nElementType));
                    }
                    break;
                }
                case -26: {
                    int iElement;
                    if (array == null) {
                        array = new SparseArray();
                    }
                    int co = in.readPackedInt();
                    while ((iElement = in.readPackedInt()) >= 0) {
                        array.set(iElement, this.readAsObject(in.readPackedInt()));
                        if (--co >= 0) continue;
                        break block0;
                    }
                    break;
                }
                case -27: {
                    int iElement;
                    if (array == null) {
                        array = new SparseArray();
                    }
                    int nElementType = in.readPackedInt();
                    int co = in.readPackedInt();
                    while ((iElement = in.readPackedInt()) >= 0) {
                        array.set(iElement, this.readAsUniformObject(nElementType));
                        if (--co >= 0) continue;
                        break block0;
                    }
                    break;
                }
                default: {
                    throw new IOException("unable to convert type " + nType + " to an array type");
                }
            }
        }
        this.complete(iProp);
        return array;
    }

    @Override
    public Collection readCollection(int iProp, Collection coll) throws IOException {
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            block0 : switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    coll = this.readCollection(iProp, coll);
                    this.registerIdentity(nId, coll);
                    break;
                }
                case -32: {
                    Object o = this.lookupIdentity(in.readPackedInt());
                    if (o instanceof Object[]) {
                        List collData = new ImmutableArrayList((Object[])o).getList();
                        if (coll == null) {
                            coll = collData;
                            break;
                        }
                        coll.addAll(collData);
                        break;
                    }
                    coll = (Collection)o;
                    break;
                }
                case -37: 
                case -36: 
                case -35: {
                    break;
                }
                case -24: 
                case -22: {
                    if (coll == null) {
                        Object[] ao = this.readAsObjectArray(nType, null);
                        coll = new ImmutableArrayList(ao).getList();
                        break;
                    }
                    int co = in.readPackedInt();
                    for (int i = 0; i < co; ++i) {
                        coll.add(this.readAsObject(in.readPackedInt()));
                    }
                    break;
                }
                case -25: 
                case -23: {
                    if (coll == null) {
                        Object[] ao = this.readAsObjectArray(nType, null);
                        coll = new ImmutableArrayList(ao).getList();
                        break;
                    }
                    int nElementType = in.readPackedInt();
                    int co = in.readPackedInt();
                    for (int i = 0; i < co; ++i) {
                        coll.add(this.readAsUniformObject(nElementType));
                    }
                    break;
                }
                case -26: {
                    int iElement;
                    int co = in.readPackedInt();
                    if (coll == null) {
                        coll = new ArrayList(co);
                    }
                    while ((iElement = in.readPackedInt()) >= 0) {
                        coll.add(this.readAsObject(in.readPackedInt()));
                        if (--co >= 0) continue;
                        break block0;
                    }
                    break;
                }
                case -27: {
                    int iElement;
                    int nElementType = in.readPackedInt();
                    int co = in.readPackedInt();
                    if (coll == null) {
                        coll = new ArrayList(co);
                    }
                    while ((iElement = in.readPackedInt()) >= 0) {
                        coll.add(this.readAsUniformObject(nElementType));
                        if (--co >= 0) continue;
                        break block0;
                    }
                    break;
                }
                default: {
                    throw new IOException("unable to convert type " + nType + " to a Collection type");
                }
            }
        }
        this.complete(iProp);
        return coll;
    }

    @Override
    public Map readMap(int iProp, Map map) throws IOException {
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    map = this.readMap(iProp, map);
                    this.registerIdentity(nId, map);
                    break;
                }
                case -32: {
                    map = (Map)this.lookupIdentity(in.readPackedInt());
                    break;
                }
                case -37: 
                case -36: 
                case -35: {
                    break;
                }
                case -28: {
                    int cEntries = in.readPackedInt();
                    if (map == null) {
                        map = new HashMap<Object, Object>(cEntries);
                    }
                    for (int i = 0; i < cEntries; ++i) {
                        Object oKey = this.readAsObject(in.readPackedInt());
                        Object oVal = this.readAsObject(in.readPackedInt());
                        map.put(oKey, oVal);
                    }
                    break;
                }
                case -29: {
                    int nKeyType = in.readPackedInt();
                    int cEntries = in.readPackedInt();
                    if (map == null) {
                        map = new HashMap(cEntries);
                    }
                    for (int i = 0; i < cEntries; ++i) {
                        Object oKey = this.readAsUniformObject(nKeyType);
                        Object oVal = this.readAsObject(in.readPackedInt());
                        map.put(oKey, oVal);
                    }
                    break;
                }
                case -30: {
                    int nKeyType = in.readPackedInt();
                    int nValType = in.readPackedInt();
                    int cEntries = in.readPackedInt();
                    if (map == null) {
                        map = new HashMap(cEntries);
                    }
                    for (int i = 0; i < cEntries; ++i) {
                        Object oKey = this.readAsUniformObject(nKeyType);
                        Object oVal = this.readAsUniformObject(nValType);
                        map.put(oKey, oVal);
                    }
                    break;
                }
                default: {
                    throw new IOException("unable to convert type " + nType + " to a Map type");
                }
            }
        }
        this.complete(iProp);
        return map;
    }

    @Override
    public PofContext getPofContext() {
        return this.m_ctx;
    }

    @Override
    public void setPofContext(PofContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("PofContext cannot be null");
        }
        this.m_ctx = ctx;
    }

    @Override
    public Object readObject(int iProp) throws IOException {
        Object o = null;
        if (this.advanceTo(iProp)) {
            ReadBuffer.BufferInput in = this.m_in;
            int nType = in.readPackedInt();
            switch (nType) {
                case -31: {
                    int nId = in.readPackedInt();
                    IdentityHolder.set(this, nId);
                    o = this.readObject(iProp);
                    IdentityHolder.reset(this, nId, o);
                    break;
                }
                case -32: {
                    o = this.lookupIdentity(in.readPackedInt());
                    break;
                }
                case -37: {
                    break;
                }
                default: {
                    o = this.readAsObject(nType);
                }
            }
        }
        this.complete(iProp);
        return o;
    }

    @Override
    public int getUserTypeId() {
        return -1;
    }

    @Override
    public int getVersionId() {
        throw new IllegalStateException("not in a user type");
    }

    @Override
    public void registerIdentity(Object o) {
        throw new IllegalStateException("not in a user type");
    }

    @Override
    public PofReader createNestedPofReader(int iProp) throws IOException {
        throw new IllegalStateException("not in a user type");
    }

    @Override
    public Binary readRemainder() throws IOException {
        throw new IllegalStateException("not in a user type");
    }

    protected boolean advanceTo(int iProp) throws IOException {
        if (iProp > 0) {
            throw new IllegalStateException();
        }
        return true;
    }

    protected void complete(int iProp) throws IOException {
    }

    protected PofBufferReader getParentParser() {
        return null;
    }

    protected SparseArray ensureReferenceRegistry() {
        SparseArray array = this.m_arrayRefs;
        if (array == null) {
            PofBufferReader parent = this.getParentParser();
            array = parent == null ? new SparseArray() : parent.ensureReferenceRegistry();
            this.m_arrayRefs = array;
        }
        return array;
    }

    protected void registerIdentity(int nId, Object oValue) {
        if (nId >= 0) {
            SparseArray array = this.ensureReferenceRegistry();
            Object o = array.get(nId);
            if (o != null && o != oValue) {
                throw new IllegalArgumentException("duplicate identity: " + nId);
            }
            array.set(nId, oValue);
        }
    }

    protected Object lookupIdentity(int nId) throws IOException {
        SparseArray array = this.ensureReferenceRegistry();
        if (!array.exists(nId)) {
            throw new IOException("missing identity: " + nId);
        }
        return array.get(nId);
    }

    protected Object readAsObject(int nType) throws IOException {
        Object o = null;
        ReadBuffer.BufferInput in = this.m_in;
        block1 : switch (nType) {
            case -1: {
                o = (short)in.readPackedInt();
                break;
            }
            case -64: 
            case -63: 
            case -62: 
            case -61: 
            case -60: 
            case -59: 
            case -58: 
            case -57: 
            case -56: 
            case -55: 
            case -54: 
            case -53: 
            case -52: 
            case -51: 
            case -50: 
            case -49: 
            case -48: 
            case -47: 
            case -46: 
            case -45: 
            case -44: 
            case -43: 
            case -42: 
            case -41: 
            case -2: {
                o = PofBufferReader.readAsInt(in, nType);
                break;
            }
            case -3: {
                o = in.readPackedLong();
                break;
            }
            case -4: {
                o = PofBufferReader.readBigInteger(in);
                break;
            }
            case -5: {
                o = Float.valueOf(in.readFloat());
                break;
            }
            case -6: {
                o = in.readDouble();
                break;
            }
            case -7: {
                o = PofBufferReader.readQuad(in);
                break;
            }
            case -38: {
                o = Double.POSITIVE_INFINITY;
                break;
            }
            case -39: {
                o = Double.NEGATIVE_INFINITY;
                break;
            }
            case -40: {
                o = Double.NaN;
                break;
            }
            case -8: {
                o = PofBufferReader.readBigDecimal(in, 4);
                break;
            }
            case -9: {
                o = PofBufferReader.readBigDecimal(in, 8);
                break;
            }
            case -10: {
                o = PofBufferReader.readBigDecimal(in, 16);
                break;
            }
            case -11: {
                o = in.readPackedInt() == 0 ? Boolean.FALSE : Boolean.TRUE;
                break;
            }
            case -12: {
                o = in.readByte();
                break;
            }
            case -13: {
                o = PofBufferReader.readBinary(in);
                break;
            }
            case -14: {
                o = Character.valueOf(PofBufferReader.readChar(in));
                break;
            }
            case -15: {
                o = in.readSafeUTF();
                break;
            }
            case -16: {
                o = PofBufferReader.readRawDate(in).toSqlDate();
                break;
            }
            case -18: {
                o = PofBufferReader.readRawTime(in).toSqlTime();
                break;
            }
            case -20: {
                o = new RawDateTime(PofBufferReader.readRawDate(in), PofBufferReader.readRawTime(in)).toSqlTimestamp();
                break;
            }
            case -17: {
                int cYears = in.readPackedInt();
                int dMonths = in.readPackedInt();
                o = new RawYearMonthInterval(cYears, dMonths);
                break;
            }
            case -19: {
                int cHours = in.readPackedInt();
                int cMinutes = in.readPackedInt();
                int cSeconds = in.readPackedInt();
                int cNanos = in.readPackedInt();
                o = new RawTimeInterval(cHours, cMinutes, cSeconds, cNanos);
                break;
            }
            case -21: {
                int cDays = in.readPackedInt();
                int cHours = in.readPackedInt();
                int cMinutes = in.readPackedInt();
                int cSeconds = in.readPackedInt();
                int cNanos = in.readPackedInt();
                o = new RawDayTimeInterval(cDays, cHours, cMinutes, cSeconds, cNanos);
                break;
            }
            case -23: 
            case -22: {
                o = new ImmutableArrayList(this.readAsObjectArray(nType, null)).getList();
                break;
            }
            case -24: {
                o = this.readAsObjectArray(nType, null);
                break;
            }
            case -25: {
                int nElementType = in.readPackedInt();
                int cElements = in.readPackedInt();
                switch (nElementType) {
                    case -11: {
                        boolean[] af = new boolean[cElements];
                        for (int i = 0; i < cElements; ++i) {
                            af[i] = in.readPackedInt() != 0;
                        }
                        o = af;
                        break block1;
                    }
                    case -12: {
                        byte[] ab = new byte[cElements];
                        in.readFully(ab);
                        o = ab;
                        break block1;
                    }
                    case -14: {
                        char[] ach = new char[cElements];
                        for (int i = 0; i < cElements; ++i) {
                            ach[i] = PofBufferReader.readChar(in);
                        }
                        o = ach;
                        break block1;
                    }
                    case -1: {
                        short[] an = new short[cElements];
                        for (int i = 0; i < cElements; ++i) {
                            an[i] = (short)in.readPackedInt();
                        }
                        o = an;
                        break block1;
                    }
                    case -2: {
                        int[] an = new int[cElements];
                        for (int i = 0; i < cElements; ++i) {
                            an[i] = in.readPackedInt();
                        }
                        o = an;
                        break block1;
                    }
                    case -3: {
                        long[] an = new long[cElements];
                        for (int i = 0; i < cElements; ++i) {
                            an[i] = in.readPackedLong();
                        }
                        o = an;
                        break block1;
                    }
                    case -5: {
                        float[] afl = new float[cElements];
                        for (int i = 0; i < cElements; ++i) {
                            afl[i] = in.readFloat();
                        }
                        o = afl;
                        break block1;
                    }
                    case -6: {
                        double[] adfl = new double[cElements];
                        for (int i = 0; i < cElements; ++i) {
                            adfl[i] = in.readDouble();
                        }
                        o = adfl;
                        break block1;
                    }
                }
                Object[] ao = new Object[cElements];
                for (int i = 0; i < cElements; ++i) {
                    ao[i] = this.readAsUniformObject(nElementType);
                }
                o = ao;
                break;
            }
            case -26: {
                int iElement;
                SparseArray array = new SparseArray();
                int cElements = in.readPackedInt();
                while ((iElement = in.readPackedInt()) >= 0) {
                    array.set(iElement, this.readAsObject(in.readPackedInt()));
                    if (--cElements >= 0) continue;
                }
                o = array;
                break;
            }
            case -27: {
                int iElement;
                int nElementType = in.readPackedInt();
                int cElements = in.readPackedInt();
                switch (nElementType) {
                    case -11: {
                        int iElement2;
                        boolean[] af = new boolean[cElements];
                        while ((iElement2 = in.readPackedInt()) >= 0) {
                            boolean bl = af[iElement2] = in.readPackedInt() != 0;
                            if (--cElements >= 0) continue;
                        }
                        o = af;
                        break block1;
                    }
                    case -12: {
                        int iElement3;
                        byte[] ab = new byte[cElements];
                        while ((iElement3 = in.readPackedInt()) >= 0) {
                            ab[iElement3] = in.readByte();
                            if (--cElements >= 0) continue;
                        }
                        o = ab;
                        break block1;
                    }
                    case -14: {
                        int iElement4;
                        char[] ach = new char[cElements];
                        while ((iElement4 = in.readPackedInt()) >= 0) {
                            ach[iElement4] = PofBufferReader.readChar(in);
                            if (--cElements >= 0) continue;
                        }
                        o = ach;
                        break block1;
                    }
                    case -1: {
                        int iElement5;
                        short[] an = new short[cElements];
                        while ((iElement5 = in.readPackedInt()) >= 0) {
                            an[iElement5] = (short)in.readPackedInt();
                            if (--cElements >= 0) continue;
                        }
                        o = an;
                        break block1;
                    }
                    case -2: {
                        int iElement6;
                        int[] an = new int[cElements];
                        while ((iElement6 = in.readPackedInt()) >= 0) {
                            an[iElement6] = in.readPackedInt();
                            if (--cElements >= 0) continue;
                        }
                        o = an;
                        break block1;
                    }
                    case -3: {
                        int iElement7;
                        long[] an = new long[cElements];
                        while ((iElement7 = in.readPackedInt()) >= 0) {
                            an[iElement7] = in.readPackedLong();
                            if (--cElements >= 0) continue;
                        }
                        o = an;
                        break block1;
                    }
                    case -5: {
                        int iElement8;
                        float[] afl = new float[cElements];
                        while ((iElement8 = in.readPackedInt()) >= 0) {
                            afl[iElement8] = in.readFloat();
                            if (--cElements >= 0) continue;
                        }
                        o = afl;
                        break block1;
                    }
                    case -6: {
                        int iElement9;
                        double[] adfl = new double[cElements];
                        while ((iElement9 = in.readPackedInt()) >= 0) {
                            adfl[iElement9] = in.readDouble();
                            if (--cElements >= 0) continue;
                        }
                        o = adfl;
                        break block1;
                    }
                }
                SparseArray array = new SparseArray();
                while ((iElement = in.readPackedInt()) >= 0) {
                    array.set(iElement, this.readAsUniformObject(nElementType));
                    if (--cElements >= 0) continue;
                }
                o = array;
                break;
            }
            case -28: {
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                int cEntries = in.readPackedInt();
                for (int i = 0; i < cEntries; ++i) {
                    Object oKey = this.readAsObject(in.readPackedInt());
                    Object oVal = this.readAsObject(in.readPackedInt());
                    map.put(oKey, oVal);
                }
                o = map;
                break;
            }
            case -29: {
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                int nKeyType = in.readPackedInt();
                int cEntries = in.readPackedInt();
                for (int i = 0; i < cEntries; ++i) {
                    Object oKey = this.readAsUniformObject(nKeyType);
                    Object oVal = this.readAsObject(in.readPackedInt());
                    map.put(oKey, oVal);
                }
                o = map;
                break;
            }
            case -30: {
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                int nKeyType = in.readPackedInt();
                int nValType = in.readPackedInt();
                int cEntries = in.readPackedInt();
                for (int i = 0; i < cEntries; ++i) {
                    Object oKey = this.readAsUniformObject(nKeyType);
                    Object oVal = this.readAsUniformObject(nValType);
                    map.put(oKey, oVal);
                }
                o = map;
                break;
            }
            case -31: {
                int nId = in.readPackedInt();
                nType = in.readPackedInt();
                IdentityHolder.set(this, nId);
                o = this.readAsObject(nType);
                IdentityHolder.reset(this, nId, o);
                break;
            }
            case -32: {
                o = this.lookupIdentity(in.readPackedInt());
                break;
            }
            case -33: {
                o = Boolean.FALSE;
                break;
            }
            case -34: {
                o = Boolean.TRUE;
                break;
            }
            case -35: {
                o = "";
                break;
            }
            case -36: {
                o = COLLECTION_EMPTY;
                break;
            }
            case -37: {
                break;
            }
            default: {
                PofSerializer ser;
                if (nType < 0) {
                    throw new StreamCorruptedException("illegal type " + nType);
                }
                PofContext ctx = this.getPofContext();
                try {
                    ser = ctx.getPofSerializer(nType);
                }
                catch (IllegalArgumentException e) {
                    throw new StreamCorruptedException(e.getMessage());
                }
                UserTypeReader reader = new UserTypeReader(this, in, ctx, nType, in.readPackedInt());
                o = ser.deserialize(reader);
            }
        }
        return o;
    }

    protected Object readAsUniformObject(int nType) throws IOException {
        Object o;
        ReadBuffer.BufferInput in = this.m_in;
        int of = in.getOffset();
        int nId = -1;
        if (of == 0) {
            return this.readAsObject(nType);
        }
        int nValue = in.readPackedInt();
        if (nValue == -31) {
            nId = in.readPackedInt();
            IdentityHolder.set(this, nId);
        } else {
            int nTypeId;
            if (nValue > 0 && nType > 0 && (o = this.ensureReferenceRegistry().get(nValue)) != null && (nTypeId = PofHelper.getPofTypeId(o.getClass(), this.getPofContext())) == nType) {
                return o;
            }
            in.setOffset(of);
        }
        o = this.readAsObject(nType);
        if (nValue == -31) {
            IdentityHolder.reset(this, nId, o);
        }
        return o;
    }

    protected Object[] readAsObjectArray(int nType, Object[] ao) throws IOException {
        Object[] aoResult = null;
        ReadBuffer.BufferInput in = this.m_in;
        block0 : switch (nType) {
            case -37: {
                break;
            }
            case -36: 
            case -35: {
                aoResult = OBJECT_ARRAY_EMPTY;
                break;
            }
            case -24: 
            case -22: {
                int co = in.readPackedInt();
                aoResult = PofBufferReader.resizeArray(ao, co);
                for (int i = 0; i < co; ++i) {
                    aoResult[i] = this.readAsObject(in.readPackedInt());
                }
                break;
            }
            case -25: 
            case -23: {
                int nElementType = in.readPackedInt();
                int co = in.readPackedInt();
                aoResult = PofBufferReader.resizeArray(ao, co);
                for (int i = 0; i < co; ++i) {
                    aoResult[i] = this.readAsUniformObject(nElementType);
                }
                break;
            }
            case -26: {
                int iElement;
                int co = in.readPackedInt();
                aoResult = PofBufferReader.resizeArray(ao, co);
                while ((iElement = in.readPackedInt()) >= 0) {
                    aoResult[iElement] = this.readAsObject(in.readPackedInt());
                    if (--co >= 0) continue;
                    break block0;
                }
                break;
            }
            case -27: {
                int iElement;
                int nElementType = in.readPackedInt();
                int co = in.readPackedInt();
                aoResult = PofBufferReader.resizeArray(ao, co);
                while ((iElement = in.readPackedInt()) >= 0) {
                    aoResult[iElement] = this.readAsUniformObject(nElementType);
                    if (--co >= 0) continue;
                    break block0;
                }
                break;
            }
            default: {
                throw new IOException("unable to convert type " + nType + " to an array type");
            }
        }
        return aoResult;
    }

    protected static Binary readBinary(ReadBuffer.BufferInput in) throws IOException {
        int cb = in.readPackedInt();
        ReadBuffer buf = in.getBuffer();
        if (buf == null) {
            return in.readBuffer(cb).toBinary();
        }
        int of = in.getOffset();
        Binary bin = buf.toBinary(of, cb);
        in.skipBytes(cb);
        return bin;
    }

    public static class IdentityHolder {
        private static ThreadLocal s_mapId = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new HashMap();
            }
        };

        public static void set(PofBufferReader reader, int nId) {
            Map mapId = (Map)s_mapId.get();
            mapId.put(reader, nId);
        }

        public static void reset(PofBufferReader reader, int nId, Object o) {
            Map mapId = (Map)s_mapId.get();
            if (!mapId.isEmpty()) {
                while (reader != null) {
                    Object oValue = mapId.get(reader);
                    if (oValue != null) {
                        int nValue = (Integer)oValue;
                        if (nId != -1 && nValue != nId) break;
                        reader.registerIdentity(nValue, o);
                        mapId.remove(reader);
                        break;
                    }
                    reader = reader.getParentParser();
                }
            }
        }
    }

    public static class UserTypeReader
    extends PofBufferReader {
        private static final int EOPS = Integer.MAX_VALUE;
        private PofBufferReader m_parent;
        private int m_nTypeId;
        private int m_nVersionId;
        private int m_iPrevProp = -1;
        private int m_iNextProp;
        private int m_ofNextProp;
        private UserTypeReader m_readerNested;
        private int m_iNestedProp;

        public UserTypeReader(ReadBuffer.BufferInput in, PofContext ctx, int nTypeId, int nVersionId) throws IOException {
            this(null, in, ctx, nTypeId, nVersionId);
        }

        public UserTypeReader(PofBufferReader parent, ReadBuffer.BufferInput in, PofContext ctx, int nTypeId, int nVersionId) throws IOException {
            super(in, ctx);
            assert (nTypeId >= 0);
            assert (nVersionId >= 0);
            this.m_parent = parent;
            this.m_nTypeId = nTypeId;
            this.m_nVersionId = nVersionId;
            this.m_ofNextProp = in.getOffset();
            int iProp = in.readPackedInt();
            this.m_iNextProp = iProp < 0 ? Integer.MAX_VALUE : iProp;
        }

        private UserTypeReader(PofBufferReader parent, ReadBuffer.BufferInput in, PofContext ctx) throws IOException {
            super(in, ctx);
            this.m_parent = parent;
            this.m_ofNextProp = in.getOffset();
            this.m_nTypeId = in.readPackedInt();
            this.m_nVersionId = in.readPackedInt();
            int iProp = in.readPackedInt();
            this.m_iNextProp = iProp < 0 ? Integer.MAX_VALUE : iProp;
        }

        private UserTypeReader(PofBufferReader parent, ReadBuffer.BufferInput in, PofContext ctx, int nTypeId) throws IOException {
            super(in, ctx);
            assert (nTypeId >= 0);
            this.m_parent = parent;
            this.m_nTypeId = nTypeId;
            this.m_nVersionId = 0;
            this.m_ofNextProp = in.getOffset();
            this.m_iNextProp = Integer.MAX_VALUE;
        }

        @Override
        public int getUserTypeId() {
            return this.m_nTypeId;
        }

        @Override
        public int getVersionId() {
            return this.m_nVersionId;
        }

        @Override
        public void registerIdentity(Object o) {
            IdentityHolder.reset(this, -1, o);
        }

        @Override
        public PofReader createNestedPofReader(int iProp) throws IOException {
            UserTypeReader reader;
            if (this.advanceTo(iProp)) {
                reader = new UserTypeReader(this, this.m_in, this.getPofContext());
            } else {
                this.complete(iProp);
                reader = new UserTypeReader(this, this.m_in, this.getPofContext(), this.getUserTypeId());
            }
            this.m_readerNested = reader;
            this.m_iNestedProp = iProp;
            return reader;
        }

        @Override
        public Binary readRemainder() throws IOException {
            int ofEnd;
            this.closeNested();
            int iNextProp = this.m_iNextProp;
            if (iNextProp == Integer.MAX_VALUE) {
                return null;
            }
            ReadBuffer.BufferInput in = this.m_in;
            ReadBuffer buf = in.getBuffer();
            if (buf == null) {
                in.mark(Integer.MAX_VALUE);
            }
            int ofBegin = this.m_ofNextProp;
            do {
                UserTypeReader.skipValue(in);
                ofEnd = in.getOffset();
            } while ((iNextProp = in.readPackedInt()) != -1);
            this.m_iNextProp = Integer.MAX_VALUE;
            this.m_ofNextProp = ofEnd;
            int cb = ofEnd - ofBegin;
            if (buf == null) {
                in.reset();
                return in.readBuffer(cb).toBinary();
            }
            return buf.toBinary(ofBegin, cb);
        }

        @Override
        protected boolean advanceTo(int iProp) throws IOException {
            this.closeNested();
            if (iProp == -1) {
                iProp = Integer.MAX_VALUE;
            }
            if (iProp <= this.m_iPrevProp) {
                throw new IllegalStateException("previous property index=" + this.m_iPrevProp + ", requested property index=" + iProp + " while reading user type " + this.getUserTypeId());
            }
            int iNextProp = this.m_iNextProp;
            if (iProp == iNextProp) {
                return true;
            }
            ReadBuffer.BufferInput in = this.m_in;
            int ofNextProp = this.m_ofNextProp;
            while (iNextProp != Integer.MAX_VALUE && iNextProp < iProp) {
                UserTypeReader.skipValue(in);
                ofNextProp = in.getOffset();
                iNextProp = in.readPackedInt();
                if (iNextProp >= 0) continue;
                iNextProp = Integer.MAX_VALUE;
            }
            this.m_ofNextProp = ofNextProp;
            this.m_iNextProp = iNextProp;
            return iProp == iNextProp;
        }

        @Override
        protected void complete(int iProp) throws IOException {
            if (this.m_iNextProp == iProp) {
                ReadBuffer.BufferInput in = this.m_in;
                this.m_ofNextProp = in.getOffset();
                int iNextProp = in.readPackedInt();
                this.m_iNextProp = iNextProp < 0 ? Integer.MAX_VALUE : iNextProp;
            }
            this.m_iPrevProp = iProp;
        }

        protected void closeNested() throws IOException {
            UserTypeReader readerNested = this.m_readerNested;
            if (readerNested != null) {
                if (readerNested.m_iNextProp != Integer.MAX_VALUE) {
                    readerNested.readRemainder();
                }
                readerNested.closeNested();
                this.complete(this.m_iNestedProp);
                this.m_readerNested = null;
                this.m_iNestedProp = -1;
            }
        }

        @Override
        protected PofBufferReader getParentParser() {
            return this.m_parent;
        }
    }
}

