/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.util.Base;
import com.tangosol.util.LiteMap;
import java.io.Serializable;
import java.security.Permission;
import java.util.Map;
import java.util.StringTokenizer;

public final class ClusterPermission
extends Permission
implements Serializable {
    public static final int CREATE = 1;
    public static final int DESTROY = 2;
    public static final int JOIN = 4;
    public static final int ALL = 7;
    public static final int NONE = 0;
    private int m_nActionMask;
    private boolean m_fAllTargets;
    private Map m_mapService;
    private Map m_mapCache;

    public ClusterPermission(String sTarget, String sAction) {
        super(sTarget);
        this.parseTarget(sTarget);
        this.parseAction(sAction);
    }

    @Override
    public String getActions() {
        return ClusterPermission.formatAction(this.m_nActionMask);
    }

    @Override
    public boolean implies(Permission permission) {
        block14: {
            Map mapCacheThat;
            Map mapCacheThis;
            block13: {
                if (!(permission instanceof ClusterPermission)) {
                    return false;
                }
                ClusterPermission that = (ClusterPermission)permission;
                int nActionThis = this.m_nActionMask;
                int nActionThat = that.m_nActionMask;
                if ((nActionThis & nActionThat) != nActionThat) {
                    return false;
                }
                if (this.m_fAllTargets) {
                    return true;
                }
                if (that.m_fAllTargets) {
                    return false;
                }
                Map mapServiceThis = this.m_mapService;
                mapCacheThis = this.m_mapCache;
                Map mapServiceThat = that.m_mapService;
                mapCacheThat = that.m_mapCache;
                if (that.m_fAllTargets || mapServiceThat.size() > 1 || mapCacheThat.size() > 1) {
                    throw new IllegalArgumentException("Composite permission cannot be implied");
                }
                if (!mapServiceThis.isEmpty()) {
                    for (Map.Entry entryThis : mapServiceThis.entrySet()) {
                        for (String sNameThat : mapServiceThat.keySet()) {
                            if (!ClusterPermission.implies(entryThis, sNameThat)) continue;
                            break block13;
                        }
                    }
                    return false;
                }
            }
            if (mapCacheThat.isEmpty()) {
                return mapCacheThis.isEmpty();
            }
            if (mapCacheThat.size() == 1 && mapCacheThat.containsKey("*")) {
                return true;
            }
            if (!mapCacheThis.isEmpty()) {
                for (Map.Entry entryThis : mapCacheThis.entrySet()) {
                    for (String sNameThat : mapCacheThat.keySet()) {
                        if (!ClusterPermission.implies(entryThis, sNameThat)) continue;
                        break block14;
                    }
                }
                return false;
            }
        }
        return true;
    }

    private static boolean implies(Map.Entry entryThis, String sNameThat) {
        String sNameThis = (String)entryThis.getKey();
        if (sNameThis.equals("*")) {
            return true;
        }
        Boolean FExact = (Boolean)entryThis.getValue();
        return FExact != false ? sNameThat.equals(sNameThis) : sNameThat.startsWith(sNameThis);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ClusterPermission) {
            ClusterPermission that = (ClusterPermission)obj;
            return Base.equals(this.getName(), that.getName()) && this.m_nActionMask == that.m_nActionMask;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode() + this.m_nActionMask;
    }

    public String getServiceName() {
        String sName;
        Map mapService = this.m_mapService;
        if (mapService.size() == 1 && !(sName = (String)mapService.keySet().iterator().next()).equals("*")) {
            return sName;
        }
        return null;
    }

    protected void parseTarget(String sTarget) {
        if (sTarget == null || sTarget.length() == 0) {
            throw new IllegalArgumentException("Target is not specified");
        }
        if (sTarget.equals("*")) {
            this.m_fAllTargets = true;
            return;
        }
        this.m_mapService = new LiteMap();
        LiteMap mapService = this.m_mapService;
        this.m_mapCache = new LiteMap();
        LiteMap mapCache = this.m_mapCache;
        StringTokenizer tokens = new StringTokenizer(sTarget, ", ");
        while (tokens.hasMoreTokens()) {
            String sName;
            LiteMap map;
            String sToken = tokens.nextToken();
            if (sToken.startsWith("service=")) {
                map = mapService;
                sName = sToken.substring("service=".length());
            } else if (sToken.startsWith("cache=")) {
                map = mapCache;
                sName = sToken.substring("cache=".length());
            } else {
                throw new IllegalArgumentException("Unknown target attribute: " + sToken);
            }
            if (sName.endsWith("*")) {
                if (sName.length() > 1) {
                    sName = sName.substring(0, sName.length() - 1);
                }
                map.put(sName, Boolean.FALSE);
                continue;
            }
            map.put(sName, Boolean.TRUE);
        }
    }

    protected void parseAction(String sAction) {
        if (sAction == null || sAction.length() == 0) {
            throw new IllegalArgumentException("Action is not specified");
        }
        int nAction = 0;
        if (sAction.equals("all")) {
            nAction = 7;
        } else {
            StringTokenizer tokens = new StringTokenizer(sAction.toLowerCase(), ", ");
            while (tokens.hasMoreTokens()) {
                String sToken = tokens.nextToken();
                if (sToken.equals("all")) {
                    nAction |= 7;
                    continue;
                }
                if (sToken.equals("create")) {
                    nAction |= 1;
                    continue;
                }
                if (sToken.equals("destroy")) {
                    nAction |= 2;
                    continue;
                }
                if (sToken.equals("join")) {
                    nAction |= 4;
                    continue;
                }
                throw new IllegalArgumentException("Unknown action name: " + sToken);
            }
        }
        this.m_nActionMask = nAction;
    }

    public static String formatAction(int nAction) {
        if ((nAction &= 7) == 7) {
            return "all";
        }
        if (nAction == 0) {
            return "none";
        }
        StringBuffer sb = new StringBuffer();
        if ((nAction & 1) != 0) {
            sb.append(",create");
        }
        if ((nAction & 2) != 0) {
            sb.append(",destroy");
        }
        if ((nAction & 4) != 0) {
            sb.append(",join");
        }
        return sb.substring(1);
    }

    public static void main(String[] asArg) {
        if (asArg.length != 4) {
            Base.out("java com.tangosol.net.ClusterPermission <target1> <action1> <target2> <action2>");
        } else {
            ClusterPermission perm1 = new ClusterPermission(asArg[0], asArg[1]);
            ClusterPermission perm2 = new ClusterPermission(asArg[2], asArg[3]);
            Base.out("<P1>=" + perm1);
            Base.out("<P2>=" + perm2);
            if (perm1.implies(perm2)) {
                Base.out("<P1> implies <P2>");
            } else {
                Base.out("<P1> does not imply <P2>");
            }
        }
    }
}

