/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.Filter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.ComparisonFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class InFilter
extends ComparisonFilter
implements IndexAwareFilter {
    public InFilter() {
    }

    public InFilter(ValueExtractor extractor, Set setValues) {
        super(extractor, new HashSet(setValues));
        InFilter.azzert(setValues != null);
    }

    public InFilter(String sMethod, Set setValues) {
        super(sMethod, new HashSet(setValues));
        InFilter.azzert(setValues != null, "Null set");
    }

    @Override
    protected boolean evaluateExtracted(Object oExtracted) {
        return ((Collection)this.getValue()).contains(oExtracted);
    }

    @Override
    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        return index == null ? InFilter.calculateIteratorEffectiveness(setKeys.size()) : ((Collection)this.getValue()).size();
    }

    @Override
    public Filter applyIndex(Map mapIndexes, Set setKeys) {
        MapIndex index = (MapIndex)mapIndexes.get(this.getValueExtractor());
        if (index == null) {
            return this;
        }
        Collection colValues = (Collection)this.getValue();
        HashSet setIn = new HashSet();
        for (Object oValue : colValues) {
            Set setEQ = (Set)index.getIndexContents().get(oValue);
            if (setEQ == null) continue;
            setIn.addAll(setEQ);
        }
        if (setIn.isEmpty()) {
            setKeys.clear();
        } else {
            setKeys.retainAll(setIn);
        }
        return null;
    }
}

