/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.oracle.common.base.Disposable;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.PacketBufferPool;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.memberSet.ActualMemberSet;
import com.tangosol.coherence.component.net.memberSet.DependentMemberSet;
import com.tangosol.coherence.component.net.memberSet.SingleMemberSet;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.coherence.component.net.packet.messagePacket.Directed;
import com.tangosol.coherence.component.net.packet.messagePacket.Sequel;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.io.MultiBufferReadBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.util.Collection;

public class Message
extends Net {
    private transient Disposable __m_BufferController;
    private transient int __m_BufferUsageCounter;
    private transient boolean __m_DeserializationRequired;
    private Member __m_FromMember;
    private long __m_FromMessageId;
    private int __m_MessagePartCount;
    private int __m_MessageType;
    private transient boolean __m_NotifySent;
    private int __m_NullPacketCount;
    private MessagePacket[] __m_Packet;
    private transient ReadBuffer __m_ReadBuffer;
    private Grid __m_Service;
    private MemberSet __m_ToMemberSet;
    private transient long __m_ToMessageId;
    private long __m_ToPollId;

    public Message() {
        this(null, null, true);
    }

    public Message(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setBufferUsageCounter(1);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void addToMember(Member member) {
        this.ensureToMemberSet().add(member);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkNotifySent() {
        if (this.isNotifySent()) {
            Message message = this;
            synchronized (message) {
                if (!this.isNotifySent() ? false : this.isDelivered()) {
                    this.setNotifySent(false);
                    this.getService().onMessageReceipt(this);
                }
            }
        }
    }

    public Message cloneMessage() {
        Grid service = this.getService();
        if (service == null) {
            throw new IllegalStateException(String.valueOf("Unable to clone message: ") + this);
        }
        return service.instantiateMessage(this.getMessageType());
    }

    public MemberSet ensureToMemberSet() {
        MemberSet setMember = this.getToMemberSet();
        if (setMember == null) {
            setMember = new MemberSet();
            this.setToMemberSet(setMember);
        }
        return setMember;
    }

    public Disposable getBufferController() {
        return this.__m_BufferController;
    }

    public int getBufferUsageCounter() {
        return this.__m_BufferUsageCounter;
    }

    public long getDeferrableMillis() {
        return 0L;
    }

    public String getDescription() {
        return null;
    }

    public Member getFromMember() {
        return this.__m_FromMember;
    }

    public long getFromMessageId() {
        return this.__m_FromMessageId;
    }

    public int getMessagePartCount() {
        MessagePacket[] aPacket = this.getPacket();
        return aPacket == null ? 0 : aPacket.length;
    }

    public int getMessageType() {
        return this.__m_MessageType;
    }

    public int getNullPacketCount() {
        return this.__m_NullPacketCount;
    }

    public MessagePacket[] getPacket() {
        return this.__m_Packet;
    }

    public MessagePacket getPacket(int i) {
        return this.getPacket()[i];
    }

    public Poll getPoll() {
        long lPollId = this.getToPollId();
        if (lPollId == 0L) {
            return null;
        }
        Grid service = this.getService();
        return service == null ? null : (Poll)service.getPollArray().get(lPollId);
    }

    public ReadBuffer getReadBuffer() {
        ReadBuffer buffer = this.__m_ReadBuffer;
        if (buffer != null ? true : this.isDeserializationRequired() ^ true) {
            return buffer;
        }
        int cPackets = this.getMessagePartCount();
        switch (cPackets) {
            case 0: {
                throw new IllegalStateException(String.valueOf("empty message: ") + this);
            }
            case 1: {
                return this.getPacket(0).getReadBuffer();
            }
        }
        ReadBuffer[] arb = new ReadBuffer[cPackets];
        int i = 0;
        while (i < cPackets) {
            arb[i] = this.getPacket(i).getReadBuffer();
            ++i;
        }
        return new MultiBufferReadBuffer(arb);
    }

    public Grid getService() {
        return this.__m_Service;
    }

    public MemberSet getToMemberSet() {
        return this.__m_ToMemberSet;
    }

    public long getToMessageId() {
        return this.__m_ToMessageId;
    }

    public long getToPollId() {
        return this.__m_ToPollId;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/Message".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Message();
    }

    private final Component get_Module() {
        return this;
    }

    public Component get_Parent() {
        Component parent = super.get_Parent();
        return parent == null ? this.getService() : parent;
    }

    public boolean isDelivered() {
        return this.getBufferController() == null;
    }

    public boolean isDeserializationRequired() {
        return this.__m_DeserializationRequired;
    }

    public boolean isInternal() {
        return this.getMessageType() < 0;
    }

    public boolean isNotifySent() {
        return this.__m_NotifySent;
    }

    public void onInit() {
        super.onInit();
        Component._assert(this.get_Parent() == null, "Message must be instantiated using instantiateMessage() method.");
    }

    public void onReceived() {
    }

    public void onSent() {
    }

    public boolean packetize(ReadBuffer buffer, int cbPreferred, int cbMax) {
        int cbSequelBody;
        int cPackets;
        DependentMemberSet setTo = null;
        int nMemberTo = 0;
        MemberSet setMemberTo = this.getToMemberSet();
        switch (setMemberTo.size()) {
            case 0: {
                return false;
            }
            case 1: {
                nMemberTo = setMemberTo.getFirstId();
                if (!(nMemberTo == 0)) break;
                return false;
            }
            default: {
                setTo = (DependentMemberSet)setMemberTo;
                break;
            }
        }
        int cbBuffer = buffer.length();
        int cbDirectedBody = Math.min(cbBuffer, MessagePacket.calcBodyLength(Directed.calcHeaderLength(setMemberTo), cbPreferred, cbMax));
        if (cbDirectedBody >= cbBuffer) {
            cPackets = 1;
            cbSequelBody = 0;
        } else {
            cbSequelBody = MessagePacket.calcBodyLength(Sequel.calcHeaderLength(setMemberTo), cbPreferred, cbMax);
            int cbSequel = cbBuffer - cbDirectedBody;
            cPackets = 1 + (cbSequel + cbSequelBody - 1) / cbSequelBody;
        }
        this.setMessagePartCount(cPackets);
        int nMemberFrom = this.getFromMember().getId();
        int nServiceId = this.getService().getServiceId();
        Directed packetHead = new Directed();
        if (setTo == null) {
            packetHead.setToId(nMemberTo);
        } else {
            packetHead.setToMemberSet(setTo);
        }
        packetHead.setFromId(nMemberFrom);
        packetHead.setServiceId(nServiceId);
        packetHead.setMessageType(this.getMessageType());
        packetHead.setMessagePartCount(cPackets);
        packetHead.defineBufferView(buffer, 0, cbDirectedBody);
        this.setPacket(0, packetHead);
        int i = 1;
        int cbWritten = cbDirectedBody;
        while (i < cPackets) {
            Sequel packet = new Sequel();
            if (setTo == null) {
                packet.setToId(nMemberTo);
            } else {
                packet.setToMemberSet((DependentMemberSet)setTo.clone());
            }
            packet.setFromId(nMemberFrom);
            packet.setServiceId(nServiceId);
            packet.setMessageType(this.getMessageType());
            packet.setMessagePartCount(cPackets);
            int cb = Math.min(cbSequelBody, cbBuffer - cbWritten);
            packet.defineBufferView(buffer, cbWritten, cb);
            cbWritten += cb;
            packet.setMessagePartIndex(i);
            this.setPacket(i, packet);
            ++i;
        }
        return true;
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
    }

    public void readInternal(ReadBuffer.BufferInput input) throws IOException {
        if (input.readBoolean()) {
            int nId = Packet.readUnsignedTrint(input);
            this.setToPollId(Packet.translateTrint(nId, this.getService().getPollArray().getFirstIndex()));
        }
    }

    public Object readObject(ReadBuffer.BufferInput input) throws IOException {
        return this.getService().readObject(input);
    }

    public void releaseIncoming() {
        Component._assert(this.getBufferUsageCounter() == 1);
        this.setBufferUsageCounter(0);
        Disposable controller = this.getBufferController();
        MessagePacket[] aPacket = this.getPacket();
        if (controller == null) {
            PacketBufferPool pool = this.getService().getPacketAllocator();
            int i = 0;
            int c = this.getMessagePartCount();
            while (i < c) {
                pool.release(aPacket[i].getWriteBuffer());
                ++i;
            }
            this.setPacket(null);
        } else {
            Component._assert(aPacket == null);
            controller.dispose();
            this.setBufferController(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseOutgoing() {
        int cUsage;
        Disposable controller = this.getBufferController();
        if (controller == null) {
            throw new IllegalStateException();
        }
        Message message = this;
        synchronized (message) {
            cUsage = this.getBufferUsageCounter() - 1;
            this.setBufferUsageCounter(cUsage);
        }
        if (cUsage == 0) {
            controller.dispose();
            this.setBufferController(null);
        } else if (cUsage < 0) {
            throw new IllegalStateException();
        }
    }

    public void respondTo(RequestMessage msg) {
        this.setToMemberSet(SingleMemberSet.instantiate(msg.getFromMember()));
        this.setToPollId(msg.getFromPollId());
    }

    public void setBufferController(Disposable controller) {
        this.__m_BufferController = controller;
    }

    public void setBufferUsageCounter(int c) {
        this.__m_BufferUsageCounter = c;
    }

    public void setDeserializationRequired(boolean fRequired) {
        this.__m_DeserializationRequired = fRequired;
    }

    public void setFromMember(Member member) {
        this.__m_FromMember = member;
    }

    public void setFromMessageId(long lMsgId) {
        this.__m_FromMessageId = lMsgId;
    }

    public void setMessagePartCount(int cPackets) {
        if (cPackets < 1 ? true : this.getPacket() != null) {
            throw new IllegalStateException(String.valueOf("cPackets: ") + cPackets);
        }
        this.setPacket(new MessagePacket[cPackets]);
        this.setNullPacketCount(cPackets);
    }

    public void setMessageType(int nType) {
        this.__m_MessageType = nType;
    }

    protected void setNotifySent(boolean fNotify) {
        this.__m_NotifySent = fNotify;
    }

    protected void setNullPacketCount(int cPackets) {
        this.__m_NullPacketCount = cPackets;
    }

    public void setPacket(int i, MessagePacket packet) {
        MessagePacket[] aPacket = this.getPacket();
        if (packet == null) {
            if (aPacket[i] != null) {
                this.setNullPacketCount(this.getNullPacketCount() + 1);
            }
        } else if (aPacket[i] == null) {
            this.setNullPacketCount(this.getNullPacketCount() - 1);
        }
        aPacket[i] = packet;
    }

    public void setPacket(MessagePacket[] aPacket) {
        this.__m_Packet = aPacket;
    }

    public void setReadBuffer(ReadBuffer buffer) {
        this.__m_ReadBuffer = buffer;
    }

    public void setService(Grid service) {
        this.__m_Service = service;
    }

    public void setToMemberSet(MemberSet setMember) {
        this.__m_ToMemberSet = setMember;
    }

    public void setToMessageId(long lMsgId) {
        this.__m_ToMessageId = lMsgId;
    }

    public void setToPollId(long lPollId) {
        this.__m_ToPollId = lPollId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean fVerbose) {
        int cParts = this.getMessagePartCount();
        int cPending = this.isDeserializationRequired() ? this.getNullPacketCount() : cParts - this.getNullPacketCount();
        StringBuffer sb = new StringBuffer();
        sb.append("Message \"").append(this.get_Name()).append("\"\n  {").append("\n  FromMember=").append(this.getFromMember()).append("\n  FromMessageId=").append(this.getFromMessageId()).append("\n  Internal=").append(this.isInternal()).append("\n  MessagePartCount=").append(cParts).append("\n  PendingCount=").append(cPending).append("\n  MessageType=").append(this.getMessageType()).append("\n  ToPollId=").append(this.getToPollId()).append("\n  Poll=").append(this.getPoll());
        if (fVerbose) {
            sb.append("\n  Packets").append("\n    {");
            int cDigts = cParts > 1000 ? 4 : 3;
            int i = 0;
            while (i < cParts) {
                MessagePacket packet = this.getPacket(i);
                if (packet != null) {
                    sb.append("\n    [").append(Base.toDecString(i, cDigts)).append("]=").append(Base.indentString(packet.toString(), "          ", false));
                }
                ++i;
            }
            sb.append("\n    }");
        }
        sb.append("\n  Service=");
        Grid service = this.getService();
        if (service == null) {
            sb.append("null");
        } else {
            sb.append(Base.indentString(service.toString(), "    ", false));
        }
        sb.append("\n  ToMemberSet=");
        MemberSet setMember = this.getToMemberSet();
        if (setMember == null) {
            sb.append("null");
        } else {
            sb.append(Base.indentString(setMember.toString(), "    ", false));
        }
        sb.append("\n  NotifySent=").append(this.isNotifySent());
        String sDesc = this.getDescription();
        if (!(sDesc != null) ? false : sDesc.length() > 0) {
            sb.append('\n').append(Base.indentString(sDesc, "  "));
        }
        sb.append("\n  }");
        return sb.toString();
    }

    public void validateAddressing(ActualMemberSet setMembers) {
        Grid service = this.getService();
        if (service == null) {
            throw new IllegalStateException(String.valueOf("Orphaned message: ") + this);
        }
        MemberSet setMemberTo = this.getToMemberSet();
        if (setMemberTo == null) {
            if (service.getServiceId() == 0) {
                return;
            }
            throw new IllegalStateException(String.valueOf("Broadcast Message sent from unexpected") + " service " + service + " (Message=" + this + ")");
        }
        Member memberFrom = this.getFromMember();
        if (memberFrom.getId() == 0) {
            throw new IllegalStateException(String.valueOf("Directed message sent before Member ID obtained: ") + this);
        }
        if (setMemberTo.size() > 1) {
            DependentMemberSet setTo = new DependentMemberSet();
            setTo.setBaseSet(setMembers);
            setTo.addAll((Collection)setMemberTo);
            setTo.remove(memberFrom);
            this.setToMemberSet(setTo);
        }
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
    }

    public void writeInternal(WriteBuffer.BufferOutput output) throws IOException {
        long lPollId = this.getToPollId();
        boolean fResponse = lPollId != 0L;
        output.writeBoolean(fResponse);
        if (fResponse) {
            Packet.writeTrint(output, lPollId);
        }
    }

    public void writeObject(WriteBuffer.BufferOutput output, Object o) throws IOException {
        this.getService().writeObject(output, o);
    }
}

