/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.daemon.QueueProcessor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$EventDispatcher$Guard;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$EventDispatcher$Queue;
import com.tangosol.net.GuardSupport;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.util.Map;

public class Service$EventDispatcher
extends QueueProcessor {
    private int __m_CloggedCount;
    private int __m_CloggedDelay;
    private volatile boolean __m_Dispatching;
    private transient long __m_LastLogTime;
    private static ListMap __mapChildren;

    static {
        Service$EventDispatcher.__initStatic();
    }

    public Service$EventDispatcher() {
        this(null, null, true);
    }

    public Service$EventDispatcher(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setCloggedCount(1024);
            this.setCloggedDelay(32);
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Service$EventDispatcher$Guard("Guard", this, true), "Guard");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Queue", Service$EventDispatcher$Queue.get_CLASS());
    }

    public void drainOverflow() {
        Service service = (Service)this.get_Module();
        if (service.isServiceThread(false) ^ true) {
            int cMaxEvents = this.getCloggedCount();
            int cPauseMillis = this.getCloggedDelay();
            Queue queue = this.getQueue();
            Object oHead = null;
            int cEventsPrev = 0;
            int nIter = 0;
            long lGrowthInterval = 5000L;
            long ldtGrowthCheck = 0L;
            while (this.isStarted()) {
                int cEvents = queue.size();
                if ((cEvents < cMaxEvents ? true : cMaxEvents <= 0) ? true : Daemon.sleep(cPauseMillis) ^ true) break;
                if (nIter == 0) {
                    oHead = queue.peekNoWait();
                    ldtGrowthCheck = System.currentTimeMillis() + lGrowthInterval;
                    cEventsPrev = cEvents;
                }
                if (!(++nIter % 10 == 0)) continue;
                long ldtNow = System.currentTimeMillis();
                Object oHeadCurrent = queue.peekNoWait();
                if (oHead == oHeadCurrent) {
                    if (!(ldtNow > this.getLastLogTime() + 60000L)) break;
                    Component._trace("The event queue appears to be stuck.", 2);
                    GuardSupport.logStackTraces();
                    this.setLastLogTime(ldtNow);
                    break;
                }
                if (ldtNow > ldtGrowthCheck) {
                    if (cEvents >= cEventsPrev) {
                        Component._trace(String.valueOf("The events are processed at a slower rate than they arrive.") + " During the last " + lGrowthInterval + "ms, the event " + " backlog went from " + cEventsPrev + " to " + cEvents, 2);
                    }
                    ldtGrowthCheck = ldtNow + lGrowthInterval;
                    cEventsPrev = cEvents;
                }
                oHead = oHeadCurrent;
            }
        }
    }

    public void drainQueue() {
        if (((Service)this.get_Module()).isServiceThread(false) ^ true) {
            Queue queue = this.getQueue();
            while (queue.size() > 0 ? true : this.isDispatching()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Base.ensureRuntimeException(e);
                }
            }
        }
    }

    public int getCloggedCount() {
        return this.__m_CloggedCount;
    }

    public int getCloggedDelay() {
        return this.__m_CloggedDelay;
    }

    public long getLastLogTime() {
        return this.__m_LastLogTime;
    }

    public String getThreadName() {
        return String.valueOf(((Service)this.get_Module()).getThreadName()) + ':' + super.getThreadName();
    }

    public long getWaitMillis() {
        long cWait = super.getWaitMillis();
        if (this.isGuarded() ? true : this.isGuardian()) {
            long cMaxWait = 1000L;
            cWait = cWait == (long)0 ? cMaxWait : Math.min(cWait, cMaxWait);
        }
        return cWait;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/Service$EventDispatcher".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new Service$EventDispatcher();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public boolean isDispatching() {
        return this.__m_Dispatching;
    }

    protected void onException(Throwable e) {
        if (this.isExiting() ^ true) {
            Component._trace("The following exception was caught by the event dispatcher:", 1);
            Component._trace(e);
            Component._trace("(The service event thread has logged the exception and is continuing.)", 1);
        }
    }

    protected void onExit() {
        this.onNotify();
        super.onExit();
    }

    public void onInit() {
        try {
            String sMaxEvents = System.getProperty("tangosol.coherence.events.limit");
            String sDelay = System.getProperty("tangosol.coherence.events.delay");
            if (sMaxEvents != null) {
                this.setCloggedCount(Integer.parseInt(sMaxEvents));
            }
            if (sDelay != null) {
                this.setCloggedDelay(Integer.parseInt(sDelay));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.onInit();
    }

    protected void onNotify() {
        super.onNotify();
        Queue queue = this.getQueue();
        Runnable task = null;
        this.setDispatching(true);
        try {
            block6: {
                try {
                    int cEvents = 0;
                    while (!((task = (Runnable)queue.removeNoWait()) == null)) {
                        if ((cEvents++ & 7) == 7) {
                            this.heartbeat();
                        }
                        task.run();
                    }
                }
                catch (Throwable e) {
                    if (!((Service)this.get_Module()).isRunning()) break block6;
                    Component._trace(String.valueOf("An exception occurred while dispatching the following event:\n") + String.valueOf(task), 1);
                    this.onException(e);
                }
            }
            Object var4_6 = null;
            this.setDispatching(false);
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.setDispatching(false);
            throw throwable;
        }
    }

    protected void onWait() throws InterruptedException {
        if (this.isGuarded()) {
            this.heartbeat();
        }
        super.onWait();
    }

    public void setCloggedCount(int cMaxEvents) {
        this.__m_CloggedCount = cMaxEvents;
    }

    public void setCloggedDelay(int cMillis) {
        this.__m_CloggedDelay = Math.max(1, cMillis);
    }

    protected void setDispatching(boolean fDispatching) {
        this.__m_Dispatching = fDispatching;
    }

    protected void setLastLogTime(long ldtLog) {
        this.__m_LastLogTime = ldtLog;
    }
}

