/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal;

import com.tangosol.coherence.transaction.internal.SessionManager;
import com.tangosol.coherence.transaction.internal.XidManager;
import com.tangosol.coherence.transaction.internal.composition.CompositionManager;
import com.tangosol.coherence.transaction.internal.storage.JmxStats;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.coherence.transaction.internal.storage.LockManager;
import com.tangosol.coherence.transaction.internal.storage.Schema;
import com.tangosol.coherence.transaction.internal.storage.Storage;
import com.tangosol.coherence.transaction.internal.storage.StorageImpl;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.Service;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class ServiceContext
implements ExternalizableLite,
PortableObject {
    private static Map<String, ServiceContext> s_mapConfig = new HashMap<String, ServiceContext>();
    private String m_sService;
    private Schema m_schema;
    private XidManager m_xidManager;
    private CompositionManager m_compositionManager;
    private SessionManager m_sessionManager;
    private Storage m_storage;
    private LockManager m_lockManager;
    private ExecutorService m_threadPool;
    private volatile LocalMemberState m_localMemberState;

    public static void initialize(Service service) {
        String sService = service.getInfo().getServiceName();
        ServiceContext serviceContext = new ServiceContext(sService);
        LocalMemberState.register(sService, JmxStats.initialize(service));
        s_mapConfig.put(sService, serviceContext);
    }

    public static ServiceContext getContext(String sService) {
        return s_mapConfig.get(sService);
    }

    public ServiceContext() {
    }

    private ServiceContext(String sService) {
        this.m_sService = sService;
        this.initializeXidManager(sService);
        this.initializeCompositionManager();
        this.initializeSchema(sService);
        this.initializeSessionManager();
        this.initializeThreadPool();
        this.initializeStorage();
        this.initializeLockManager();
    }

    public Service getService() {
        return this.getSchema().getService();
    }

    public String getServiceName() {
        return this.m_sService;
    }

    public Schema getSchema() {
        return this.m_schema;
    }

    public XidManager getXidManager() {
        return this.m_xidManager;
    }

    public CompositionManager getCompositionManager() {
        return this.m_compositionManager;
    }

    public SessionManager getSessionManager() {
        return this.m_sessionManager;
    }

    public Storage getStorage() {
        return this.m_storage;
    }

    public LockManager getLockManager() {
        return this.m_lockManager;
    }

    public ExecutorService getThreadPool() {
        return this.m_threadPool;
    }

    public LocalMemberState getMemberState() {
        if (this.m_localMemberState == null) {
            this.m_localMemberState = LocalMemberState.getMemberState(this.m_sService);
        }
        return this.m_localMemberState;
    }

    public boolean hasOwnershipEnabledMembers() {
        block3: {
            PartitionedService service = (PartitionedService)this.getService();
            try {
                if (service.isRunning()) {
                    Set setOwners = service.getOwnershipEnabledMembers();
                    return setOwners != null && !setOwners.isEmpty();
                }
            }
            catch (RuntimeException e) {
                if (!service.isRunning()) break block3;
                throw e;
            }
        }
        return false;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_sService = (String)ExternalizableHelper.readObject(in);
        this.initializeFromContext(ServiceContext.getContext(this.m_sService));
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_sService);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_sService = in.readString(0);
        this.initializeFromContext(ServiceContext.getContext(this.m_sService));
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeString(0, this.m_sService);
    }

    private void initializeCompositionManager() {
        this.m_compositionManager = new CompositionManager();
        this.m_compositionManager.initialize();
    }

    private void initializeSchema(String sService) {
        this.m_schema = new Schema(sService);
    }

    private void initializeXidManager(String sService) {
        this.m_xidManager = new XidManager(sService);
    }

    private void initializeSessionManager() {
        this.m_sessionManager = new SessionManager(this);
    }

    private void initializeThreadPool() {
        this.m_threadPool = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "TransactionFrameworkThread");
                t.setDaemon(true);
                return t;
            }
        });
    }

    private void initializeStorage() {
        this.m_storage = new StorageImpl();
    }

    private void initializeLockManager() {
        this.m_lockManager = new LockManager();
    }

    private void initializeFromContext(ServiceContext context) {
        this.m_compositionManager = context.getCompositionManager();
        this.m_schema = context.getSchema();
        this.m_xidManager = context.getXidManager();
        this.m_sessionManager = context.getSessionManager();
        this.m_threadPool = context.getThreadPool();
        this.m_localMemberState = LocalMemberState.getMemberState(this.m_sService);
    }
}

