/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.component;

import com.tangosol.coherence.transaction.internal.Endpoint;
import com.tangosol.coherence.transaction.internal.Message;
import com.tangosol.coherence.transaction.internal.Results;
import com.tangosol.coherence.transaction.internal.ServiceContext;
import com.tangosol.coherence.transaction.internal.component.AbstractStorageInvoke;
import com.tangosol.util.BinaryEntry;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class StorageInvoke
extends AbstractStorageInvoke {
    @Override
    protected Set obtainEntrySet(Message msg) {
        Set entries = (Set)msg.getContext();
        HashSet<AbstractStorageInvoke.EntryProxy> setProxyEntries = new HashSet<AbstractStorageInvoke.EntryProxy>();
        ServiceContext context = ServiceContext.getContext(msg.getOperation().getServiceName());
        Endpoint ep = context.getCompositionManager().getEndpoint("storage.fetch");
        for (BinaryEntry entry : entries) {
            Object oNaturalKey = entry.getKey();
            Object oValue = null;
            boolean fPresent = entry.isPresent();
            if (fPresent) {
                Results readResults = this.readFromStorage(msg, entry, ep);
                oValue = readResults.get(oNaturalKey);
                fPresent = readResults.containsKey(oNaturalKey);
            }
            AbstractStorageInvoke.EntryProxy proxyEntry = this.createEntryProxy(entry, null, oValue, entry.getSerializer(), entry.getContext(), fPresent, msg);
            setProxyEntries.add(proxyEntry);
        }
        return setProxyEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Results readFromStorage(Message msg, BinaryEntry entry, Endpoint ep) {
        Results r;
        Results resultsOld = msg.getResults();
        Object ctxOld = msg.getContext();
        try {
            msg.setResults(new Results());
            msg.setContext(Collections.singleton(entry));
            r = ep.dispatch(msg).getResults();
        }
        finally {
            msg.setResults(resultsOld);
            msg.setContext(ctxOld);
        }
        return r;
    }
}

