/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.storage;

import com.tangosol.coherence.transaction.TransactionId;
import com.tangosol.coherence.transaction.internal.SimpleXid;
import com.tangosol.coherence.transaction.internal.storage.SyntheticKey;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class XidSyntheticKey
implements ExternalizableLite,
PortableObject {
    protected long m_lKey;
    protected TransactionId m_xid;

    public XidSyntheticKey() {
    }

    public XidSyntheticKey(SyntheticKey key, TransactionId xid) {
        Base.azzert(xid != null);
        this.m_lKey = key.toLong();
        this.m_xid = xid;
    }

    public void setKey(long lKey) {
        this.m_lKey = lKey;
    }

    public long getKey() {
        return this.m_lKey;
    }

    private void setXid(long lXid) {
        this.setXid(new SimpleXid(lXid));
    }

    public void setXid(TransactionId xid) {
        this.m_xid = xid;
    }

    public TransactionId getXid() {
        return this.m_xid;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof XidSyntheticKey && this.m_lKey == ((XidSyntheticKey)o).m_lKey && this.m_xid.equals(((XidSyntheticKey)o).m_xid);
    }

    public int hashCode() {
        return (int)(this.m_lKey ^ this.m_lKey >>> 32);
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        this.setKey(ExternalizableHelper.readLong(dataInput));
        this.setXid(ExternalizableHelper.readLong(dataInput));
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        ExternalizableHelper.writeLong(dataOutput, this.getKey());
        ExternalizableHelper.writeLong(dataOutput, this.getXid().getId());
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.setKey(in.readLong(1));
        this.setXid(in.readLong(2));
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeLong(1, this.getKey());
        out.writeLong(2, this.getXid().getId());
    }
}

