/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.DoubleConstant;
import com.tangosol.dev.assembler.Op;
import java.io.DataOutput;
import java.io.IOException;

public class Dconst
extends Op
implements Constants {
    private static final String CLASS = "Dconst";
    private DoubleConstant m_constant;

    public Dconst(double dfl) {
        this(new DoubleConstant(dfl));
    }

    public Dconst(DoubleConstant constant) {
        super(232);
        this.m_constant = constant;
        if (constant == null) {
            throw new IllegalArgumentException("Dconst:  Constant must not be null!");
        }
    }

    @Override
    public String toString() {
        return Dconst.format(null, this.getName() + ' ' + this.m_constant.format(), null);
    }

    @Override
    public String toJasm() {
        return this.getName() + ' ' + this.m_constant.format();
    }

    @Override
    protected void preassemble(ConstantPool pool) {
        DoubleConstant constant = this.m_constant;
        double n = constant.getValue();
        if (n != 0.0 && n != 1.0) {
            pool.registerConstant(constant);
        }
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        DoubleConstant constant = this.m_constant;
        double n = constant.getValue();
        if (n == 0.0 || n == 1.0) {
            stream.writeByte(14 + (int)n);
        } else {
            stream.writeByte(20);
            stream.writeShort(pool.findConstant(constant));
        }
    }

    @Override
    protected void calculateSize(ConstantPool pool) {
        double n = this.m_constant.getValue();
        this.setSize(n == 0.0 || n == 1.0 ? 1 : 3);
    }
}

