/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.Block;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.compiler.java.TypeExpression;
import com.tangosol.dev.compiler.java.VariableExpression;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ErrorList;
import java.util.Map;

public class SuperExpression
extends Expression {
    private static final String CLASS = "SuperExpression";
    private boolean m_fSuperAllowed;

    public SuperExpression(Block block, Token tokThis) {
        super(block, tokThis);
    }

    @Override
    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Expression expr = this;
        if (!this.m_fSuperAllowed) {
            this.logError(3, "JC-037", null, errlist);
        } else {
            DataType dtSuper = ctx.getSuperInfo().getTypeInfo().getDataType();
            if (ctx.getMethodInfo().isStatic()) {
                expr = new TypeExpression(this.getBlock(), this.getStartToken(), dtSuper);
            } else {
                Token tokSuper = this.getStartToken();
                Token tokThis = new Token(Token.TOK_THIS, tokSuper.getLine(), tokSuper.getOffset(), tokSuper.getLength());
                expr = new VariableExpression(this.getBlock(), tokThis);
            }
            expr = (Expression)expr.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
            expr.setType(dtSuper);
        }
        return expr;
    }

    @Override
    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        throw new IllegalStateException();
    }

    protected void allowSuper() {
        this.m_fSuperAllowed = true;
    }
}

