/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.cluster;

import com.tangosol.net.ActionPolicy;
import com.tangosol.net.ConfigurableQuorumPolicy;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.run.xml.XmlValue;
import com.tangosol.util.NullImplementation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class LegacyXmlConfigurableQuorumPolicy {
    public ConfigurableQuorumPolicy createPolicy(XmlElement xmlConfig, ClassLoader loader) {
        if (xmlConfig.getElement("instance") != null || xmlConfig.getElement("class-name") != null || xmlConfig.getElement("class-factory-name") != null) {
            return new ConfigurableQuorumPolicy.WrapperQuorumPolicy((ActionPolicy)XmlHelper.createInstance(xmlConfig, loader, null));
        }
        String sConfig = xmlConfig.getName();
        if (!xmlConfig.getElementList().isEmpty()) {
            if (sConfig.equals("partitioned-quorum-policy-scheme")) {
                return ConfigurableQuorumPolicy.instantiatePartitionedCachePolicy(this.getPartitionQuorumRules(xmlConfig));
            }
            if (sConfig.equals("proxy-quorum-policy-scheme")) {
                return ConfigurableQuorumPolicy.instantiateProxyPolicy(this.getProxyQuorumRules(xmlConfig));
            }
            if (sConfig.equals("cluster-quorum-policy")) {
                return ConfigurableQuorumPolicy.instantiateClusterPolicy(this.getQuorumMap(xmlConfig));
            }
        }
        return new ConfigurableQuorumPolicy.WrapperQuorumPolicy(NullImplementation.getActionPolicy());
    }

    private int getQuorumValue(XmlElement xmlConfig, String sElement) {
        int nQuorum = xmlConfig.getSafeElement(sElement).getInt();
        if (nQuorum < 0) {
            throw new IllegalArgumentException("The " + sElement + " must be non-negative");
        }
        return nQuorum;
    }

    private ConfigurableQuorumPolicy.MembershipQuorumPolicy.QuorumRule[] getPartitionQuorumRules(XmlElement xmlConfig) {
        ConfigurableQuorumPolicy.MembershipQuorumPolicy.QuorumRule[] aRule = new ConfigurableQuorumPolicy.MembershipQuorumPolicy.QuorumRule[]{new ConfigurableQuorumPolicy.MembershipQuorumPolicy.QuorumRule(1, this.getQuorumValue(xmlConfig, "distribution-quorum")), new ConfigurableQuorumPolicy.MembershipQuorumPolicy.QuorumRule(2, this.getQuorumValue(xmlConfig, "restore-quorum")), new ConfigurableQuorumPolicy.MembershipQuorumPolicy.QuorumRule(4, this.getQuorumValue(xmlConfig, "read-quorum")), new ConfigurableQuorumPolicy.MembershipQuorumPolicy.QuorumRule(8, this.getQuorumValue(xmlConfig, "write-quorum"))};
        return aRule;
    }

    private ConfigurableQuorumPolicy.MembershipQuorumPolicy.QuorumRule[] getProxyQuorumRules(XmlElement xmlConfig) {
        ConfigurableQuorumPolicy.MembershipQuorumPolicy.QuorumRule[] aRule = new ConfigurableQuorumPolicy.MembershipQuorumPolicy.QuorumRule[]{new ConfigurableQuorumPolicy.MembershipQuorumPolicy.QuorumRule(1, this.getQuorumValue(xmlConfig, "connect-quorum"))};
        return aRule;
    }

    private Map<String, Integer> getQuorumMap(XmlElement xmlConfig) {
        HashMap<String, Integer> mapQuorum = new HashMap<String, Integer>();
        Iterator iter = xmlConfig.getElements("timeout-survivor-quorum");
        while (iter.hasNext()) {
            XmlElement xmlQuorum = (XmlElement)iter.next();
            XmlValue xmlRole = xmlQuorum.getAttribute("role");
            int nQuorum = xmlQuorum.getInt();
            if (nQuorum < 0) {
                throw new IllegalArgumentException("The cluster-quorum must be between non-negative");
            }
            String sRole = xmlRole == null || xmlRole.isEmpty() ? "*role-any*" : xmlRole.getString();
            mapQuorum.put(sRole, nQuorum);
        }
        return mapQuorum;
    }
}

