/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.journal;

import com.tangosol.net.management.annotation.Description;

@Description(value="Provides metrics for a Journal implementation.")
public interface JournalMBean {
    @Description(value="The maximum size of an individual Journal file.")
    public long getMaxFileSize();

    @Description(value="The maximum allowable size, in bytes, for serialized values.")
    public int getMaxValueSize();

    @Description(value="The maximum number of journal files.")
    public int getMaxJournalFilesNumber();

    @Description(value="The number of active BinaryStore objects that are using this Journal")
    public int getBinaryStoreCount();

    @Description(value="The number of Journal files currently in use.")
    public int getFileCount();

    @Description(value="The amount of data currently stored for this Journal in bytes.")
    public long getTotalDataSize();

    @Description(value="The total size of all Journal files for this Journal.")
    public long getTotalFileSize();

    @Description(value="The load factor threshold at which files may be garbage collected. The larger the value, the more aggressive the compaction algorithm is.")
    public double getCollectorLoadFactor();

    @Description(value="The approximate high-water mark of the Journal capacity utilization.")
    public double getHighestLoadFactor();

    @Description(value="The number of serialized values that have yet to be persisted to disk.")
    public int getBacklogCount();

    @Description(value="The total size in bytes of the serialized values that have yet to be synced to disk.")
    public int getBacklogSize();

    @Description(value="When this value, maximum backlog size, is reached, writes are delayed until dropping below this max.")
    public int getMaxBacklogSize();

    @Description(value="The total size, in bytes, of all available buffers in the pool.")
    public int getPoolSize();

    @Description(value="The size of the buffers used to write a chunk of data to the journal")
    public int getBufferSize();

    @Description(value="The maximum size, in bytes, of the buffer pool.")
    public long getMaxPoolSize();

    @Description(value="The total amount of RAM used for this Journal.")
    public long getMaxTotalRam();

    @Description(value="If true, the RAM Journal is using direct buffers (NIO RAM) instead of on heap buffers.")
    public boolean isNioRam();
}

