/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

public class CircularArrayList
extends AbstractList
implements List,
RandomAccess,
Cloneable,
Serializable {
    protected Object[] m_aoData = null;
    protected int m_iFirst = 0;
    protected int m_iLast = 0;
    protected int m_cElements = 0;

    public CircularArrayList() {
        this(16);
    }

    public CircularArrayList(int cInitialElements) {
        if (cInitialElements < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + cInitialElements);
        }
        this.m_aoData = new Object[cInitialElements];
    }

    public CircularArrayList(Collection c) {
        this.m_aoData = new Object[c.size() + 1];
        this.addAll(c);
    }

    public void trimToSize() {
        ++this.modCount;
        int cElements = this.m_cElements;
        if (cElements + 1 < this.m_aoData.length) {
            Object[] aoNewData = new Object[cElements + 1];
            this.toArray(aoNewData);
            this.m_aoData = aoNewData;
            this.m_iFirst = 0;
            this.m_iLast = cElements;
        }
    }

    public boolean ensureCapacity(int cMin) {
        int cOld = this.m_aoData.length;
        if (cMin > cOld) {
            int cNew = Math.max(cMin, cOld * 3 / 2 + 1);
            this.m_aoData = this.toArray(new Object[cNew]);
            this.m_iLast = this.m_cElements;
            this.m_iFirst = 0;
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.m_cElements;
    }

    @Override
    public boolean isEmpty() {
        return this.m_cElements == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public int indexOf(Object o) {
        Object[] aoData = this.m_aoData;
        int cSlots = aoData.length;
        int iFirst = this.m_iFirst;
        int c = this.m_cElements;
        for (int i = 0; i < c; ++i) {
            if (!Base.equals(o, aoData[(iFirst + i) % cSlots])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int cElements = this.m_cElements;
        int iFirst = this.m_iFirst;
        Object[] aoData = this.m_aoData;
        int cSlots = aoData.length;
        for (int i = cElements - 1; i >= 0; --i) {
            if (!Base.equals(o, aoData[(i + iFirst) % cSlots])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.m_cElements]);
    }

    @Override
    public Object[] toArray(Object[] ao) {
        Object[] aoData = this.m_aoData;
        int cSlots = aoData.length;
        int iFirst = this.m_iFirst;
        int iLast = this.m_iLast;
        int co = ao.length;
        int cElements = this.m_cElements;
        if (co < cElements) {
            ao = (Object[])Array.newInstance(ao.getClass().getComponentType(), cElements);
        } else if (co > cElements) {
            ao[cElements] = null;
        }
        if (cElements > 0) {
            if (iFirst < iLast) {
                System.arraycopy(aoData, iFirst, ao, 0, cElements);
            } else {
                System.arraycopy(aoData, iFirst, ao, 0, cSlots - iFirst);
                System.arraycopy(aoData, 0, ao, cSlots - iFirst, iLast);
            }
        }
        return ao;
    }

    public Object get(int index) {
        return this.m_aoData[this.ensureEffectiveIndex(index)];
    }

    public Object set(int index, Object o) {
        Object[] aoData = this.m_aoData;
        int iEff = this.ensureEffectiveIndex(index);
        Object oOldValue = aoData[iEff];
        aoData[iEff] = o;
        return oOldValue;
    }

    @Override
    public boolean add(Object o) {
        this.ensureCapacity(1 + this.m_cElements + 1);
        Object[] aoData = this.m_aoData;
        int iLast = this.m_iLast;
        aoData[iLast] = o;
        this.m_iLast = (iLast + 1) % aoData.length;
        ++this.m_cElements;
        return true;
    }

    public void add(int index, Object o) {
        int cElements = this.m_cElements;
        if (index == cElements) {
            this.add(o);
            return;
        }
        this.rangeCheck(index);
        this.ensureCapacity(1 + cElements + 1);
        Object[] aoData = this.m_aoData;
        int cSlots = aoData.length;
        int iFirst = this.m_iFirst;
        int iLast = this.m_iLast;
        int iEff = this.effectiveIndex(index);
        if (iEff == iFirst) {
            this.m_iFirst = iFirst = (iFirst - 1 + cSlots) % cSlots;
            aoData[iFirst] = o;
        } else if (iFirst > iLast && iEff > iFirst || iLast == cSlots - 1) {
            System.arraycopy(aoData, iFirst, aoData, iFirst - 1, iEff - iFirst);
            --this.m_iFirst;
            aoData[iEff - 1] = o;
            ++this.modCount;
        } else {
            System.arraycopy(aoData, iEff, aoData, iEff + 1, iLast - iEff);
            this.m_iLast = (iLast + 1) % cSlots;
            aoData[iEff] = o;
            ++this.modCount;
        }
        ++this.m_cElements;
    }

    public Object remove(int index) {
        Object[] aoData = this.m_aoData;
        int iEff = this.ensureEffectiveIndex(index);
        int iFirst = this.m_iFirst;
        int iLast = this.m_iLast;
        Object oOldValue = aoData[iEff];
        if (iEff == iFirst) {
            aoData[iEff] = null;
            this.m_iFirst = (iFirst + 1) % aoData.length;
        } else if (iFirst > iLast && iEff > iFirst) {
            System.arraycopy(aoData, iFirst, aoData, iFirst + 1, iEff - iFirst);
            aoData[this.m_iFirst++] = null;
        } else {
            System.arraycopy(aoData, iEff + 1, aoData, iEff, iLast - iEff - 1);
            aoData[--this.m_iLast] = null;
        }
        --this.m_cElements;
        this.ensureCompactness();
        ++this.modCount;
        return oOldValue;
    }

    @Override
    public void clear() {
        Object[] aoData = this.m_aoData;
        int cSlots = aoData.length;
        int iFirst = this.m_iFirst;
        int iLast = this.m_iLast;
        this.m_cElements = 0;
        this.m_iLast = 0;
        this.m_iFirst = 0;
        this.ensureCompactness();
        if (this.m_aoData == aoData) {
            int i = iFirst;
            while (i != iLast) {
                aoData[i] = null;
                i = (i + 1) % cSlots;
            }
        }
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection c) {
        int iNew;
        int cNew = c.size();
        if (cNew == 0) {
            return false;
        }
        this.ensureCapacity(1 + this.m_cElements + cNew);
        Object[] aoData = this.m_aoData;
        int cSlots = aoData.length;
        int iLast = this.m_iLast;
        Iterator iter = c.iterator();
        for (iNew = 0; iNew < cNew && iter.hasNext(); ++iNew) {
            aoData[iLast] = iter.next();
            iLast = (iLast + 1) % cSlots;
        }
        this.m_iLast = iLast;
        this.m_cElements += iNew;
        return true;
    }

    public boolean addAll(int index, Collection c) {
        int cElements = this.m_cElements;
        if (index == cElements) {
            this.addAll(c);
            return true;
        }
        this.rangeCheck(index);
        int cNew = c.size();
        this.ensureCapacity(1 + cElements + cNew);
        Object[] aoData = this.m_aoData;
        int cSlots = aoData.length;
        int iFirst = this.m_iFirst;
        int iLast = this.m_iLast;
        int iEff = this.effectiveIndex(index);
        int iNew = 0;
        Iterator iter = c.iterator();
        if (iEff == iFirst) {
            this.m_iFirst = (iFirst - cNew + cSlots) % cSlots;
        } else if (iFirst > iLast && iEff > iFirst || iFirst < iLast && iFirst - cNew >= 0) {
            System.arraycopy(aoData, iFirst, aoData, iFirst - cNew, iEff - iFirst);
            this.m_iFirst = (iFirst - cNew + cSlots) % cSlots;
        } else if (iLast + cNew <= cSlots) {
            System.arraycopy(aoData, iEff, aoData, iEff + cNew, iLast - iEff);
            this.m_iLast = (iLast + cNew) % cSlots;
        } else {
            System.arraycopy(aoData, iFirst, aoData, 0, iEff - iFirst);
            int cRight = cNew - iFirst;
            System.arraycopy(aoData, iEff, aoData, iEff + cRight, iLast - iEff);
            this.m_iFirst = 0;
            this.m_iLast = iLast + cRight;
        }
        iEff = this.effectiveIndex(index);
        while (iNew < cNew && iter.hasNext()) {
            aoData[iEff] = iter.next();
            iEff = (iEff + 1) % cSlots;
            ++iNew;
        }
        this.m_cElements += cNew;
        ++this.modCount;
        if (iNew != cNew) {
            this.removeRange(index + iNew, index + cNew + 1);
        }
        return true;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        this.rangeCheck(fromIndex);
        this.rangeCheck(toIndex - 1);
        if (fromIndex >= toIndex) {
            return;
        }
        Object[] aoData = this.m_aoData;
        int cSlots = aoData.length;
        int iFrom = this.effectiveIndex(fromIndex);
        int iTo = this.effectiveIndex(toIndex);
        int iFirst = this.m_iFirst;
        int iLast = this.m_iLast;
        int cRemoved = iTo - iFrom;
        if (iFirst < iLast || iFrom < iLast && iTo < iLast) {
            int cMoved = iLast - iTo;
            int iNewLast = iLast - cRemoved;
            System.arraycopy(aoData, iTo, aoData, iFrom, cMoved);
            while (iLast != iNewLast) {
                aoData[--iLast] = null;
            }
            this.m_iLast = iLast;
        } else if (iFrom >= iFirst && iTo > iFirst) {
            int cMoved = iFrom - iFirst;
            int iNewFirst = iTo - cMoved;
            System.arraycopy(aoData, iFirst, aoData, iNewFirst, cMoved);
            while (iFirst != iNewFirst) {
                aoData[iFirst++] = null;
            }
            this.m_iFirst = iFirst;
        } else {
            int cMovedEnd = iFrom - iFirst;
            int iNewFirst = cSlots - cMovedEnd;
            if (cMovedEnd > 0) {
                System.arraycopy(aoData, iFirst, aoData, iNewFirst, cMovedEnd);
            }
            while (iFirst != iNewFirst) {
                aoData[iFirst++] = null;
            }
            this.m_iFirst = iNewFirst % cSlots;
            if (iTo != 0) {
                int iNewLast = iLast - iTo;
                System.arraycopy(aoData, iTo, aoData, 0, iNewLast);
                while (iLast != iNewLast) {
                    aoData[--iLast] = null;
                }
                this.m_iLast = iLast;
            }
        }
        this.m_cElements -= cRemoved;
        this.ensureCompactness();
        ++this.modCount;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int preMod = this.modCount;
        int iFirst = this.m_iFirst;
        int iLast = this.m_iLast;
        Object[] aoData = this.m_aoData;
        int cSlots = aoData.length;
        s.writeInt(this.m_cElements);
        int i = iFirst;
        while (i != iLast) {
            s.writeObject(aoData[i]);
            i = (i + 1) % cSlots;
        }
        if (preMod != this.modCount) {
            throw new ConcurrentModificationException();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int cElements = s.readInt();
        Object[] aoData = new Object[cElements + 1];
        this.m_iFirst = 0;
        this.m_iLast = cElements + 1;
        this.m_cElements = cElements;
        this.m_aoData = aoData;
        for (int i = 0; i < cElements; ++i) {
            aoData[i] = s.readObject();
        }
    }

    public Object clone() {
        try {
            int preMod = this.modCount;
            CircularArrayList cal = (CircularArrayList)super.clone();
            cal.m_aoData = (Object[])this.m_aoData.clone();
            if (preMod != this.modCount) {
                throw new ConcurrentModificationException();
            }
            return cal;
        }
        catch (CloneNotSupportedException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected int effectiveIndex(int index) {
        return (this.m_iFirst + index) % this.m_aoData.length;
    }

    protected void rangeCheck(int index) {
        if (index >= this.m_cElements || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.m_cElements);
        }
    }

    protected int ensureEffectiveIndex(int index) {
        if (index >= this.m_cElements || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.m_cElements);
        }
        return (this.m_iFirst + index) % this.m_aoData.length;
    }

    protected boolean ensureCompactness() {
        return false;
    }

    public void dump() {
        System.out.println("\niFirst = " + this.m_iFirst + " iLast= " + this.m_iLast + " count= " + this.m_cElements);
        for (int i = 0; i < this.m_aoData.length; ++i) {
            System.out.print(this.m_aoData[i]);
            if (i == this.m_aoData.length - 1) continue;
            System.out.print(", ");
        }
        System.out.println();
    }
}

