/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.AbstractStableIterator;
import com.tangosol.util.Base;
import com.tangosol.util.comparator.SafeComparator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class SafeSortedMap
extends AbstractMap
implements SortedMap {
    protected static final int DEFAULT_SPAN = 3;
    protected static final int DEFAULT_MAX_LEVEL = 16;
    protected static final int SEARCH_EQ = 1;
    protected static final int SEARCH_LT = 2;
    protected static final int SEARCH_GT = 4;
    protected static final int SEARCH_LTEQ = 3;
    protected static final int SEARCH_GTEQ = 5;
    protected static final Object NO_VALUE = new Object();
    protected static final Object BASE_VALUE = new Object();
    protected static final AtomicReferenceFieldUpdater m_atomicUpdaterTopNode = AtomicReferenceFieldUpdater.newUpdater(SafeSortedMap.class, IndexNode.class, "m_nodeTop");
    protected final Comparator m_comparator;
    protected final int m_nLevelMax;
    protected final float[] m_aflProbabilityThresholds;
    protected int m_nSpan;
    protected final ViewMap m_mapView;
    protected volatile IndexNode m_nodeTop;
    protected Random m_random = new Random();

    public SafeSortedMap() {
        this(SafeComparator.INSTANCE);
    }

    public SafeSortedMap(Comparator comparator) {
        this(comparator, 3, 16);
    }

    public SafeSortedMap(Comparator comparator, int nSpan, int nLevelMax) {
        Base.azzert(nSpan > 1, "Span must be larger than 1");
        this.m_comparator = comparator == null ? SafeComparator.INSTANCE : comparator;
        this.m_nLevelMax = nLevelMax;
        this.m_nSpan = nSpan;
        this.m_mapView = new ViewMap(null, null);
        this.m_aflProbabilityThresholds = SafeSortedMap.computeProbabilityThresholds(nLevelMax, nSpan);
        this.initialize();
    }

    @Override
    public int size() {
        return this.getBaseNode().getSizeCounter().get();
    }

    @Override
    public boolean containsKey(Object oKey) {
        return this.findNearest(this.getTopNode(), oKey, 1, false) != null;
    }

    @Override
    public Set entrySet() {
        return this.getViewMap().entrySet();
    }

    @Override
    public Object put(Object oKey, Object oValue) {
        EntryNode nodeNew;
        BaseEntryNode nodeBase;
        IndexNode nodeTop;
        Comparator comparator = this.comparator();
        block0: while (true) {
            nodeTop = this.getTopNode();
            nodeBase = (BaseEntryNode)nodeTop.getEntryNode();
            EntryNode nodePrev = this.findPredecessor(nodeTop, oKey);
            EntryNode nodeCur = nodePrev.getNext();
            while (nodeCur != null) {
                EntryNode nodeNext = nodeCur.getNext();
                if (nodeCur != nodePrev.getNext()) continue block0;
                Object oValueOld = nodeCur.getValueInternal();
                if (oValueOld == NO_VALUE) {
                    nodeCur.helpDelete(nodePrev, nodeNext);
                    continue block0;
                }
                if (nodePrev.isDeleted()) continue block0;
                int nCompare = comparator.compare(oKey, nodeCur.getKey());
                if (nCompare == 0) {
                    if (!nodeCur.casValue(oValueOld, oValue)) continue block0;
                    return oValueOld;
                }
                if (nCompare <= 0) break;
                nodePrev = nodeCur;
                nodeCur = nodeNext;
            }
            if (nodePrev.casNext(nodeCur, nodeNew = new EntryNode(oKey, oValue, nodeCur))) break;
        }
        nodeBase.getSizeCounter().incrementAndGet();
        int nLevelThis = this.calculateRandomLevel();
        if (nLevelThis > 0) {
            this.insertIndex(nodeTop, nodeNew, nLevelThis);
        }
        return null;
    }

    @Override
    public Object get(Object oKey) {
        EntryNode node = this.findNearest(this.getTopNode(), oKey, 1, false);
        return node == null ? null : node.getValue();
    }

    public Map.Entry getEntry(Object oKey) {
        EntryNode nodeEntry = this.findNearest(this.getTopNode(), oKey, 1, false);
        if (nodeEntry != null) {
            EntryNode.MapEntry entry = nodeEntry.getMapEntry();
            if (!nodeEntry.isDeleted()) {
                return entry;
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object remove(Object oKey) {
        comparator = this.comparator();
        block0: while (true) {
            nodeTop = this.getTopNode();
            nodeBase = (BaseEntryNode)nodeTop.getEntryNode();
            nodePrev = this.findPredecessor(nodeTop, oKey);
            nodeCur = nodePrev.getNext();
            while (nodeCur != null) {
                nodeNext = nodeCur.getNext();
                if (nodeCur != nodePrev.getNext()) continue block0;
                oValueOld = nodeCur.getValueInternal();
                if (oValueOld == SafeSortedMap.NO_VALUE) {
                    nodeCur.helpDelete(nodePrev, nodeNext);
                    continue block0;
                }
                if (nodePrev.isDeleted()) continue block0;
                nCompare = comparator.compare(oKey, nodeCur.getKey());
                if (nCompare == 0) {
                    if (nodeCur.casValue(oValueOld, SafeSortedMap.NO_VALUE)) ** break;
                    continue block0;
                    nodeBase.getSizeCounter().decrementAndGet();
                    if (!nodeCur.markForDelete(nodeNext) || !nodePrev.casNext(nodeCur, nodeNext)) {
                        this.findNearest(nodeTop, oKey, 1, true);
                    } else {
                        this.findPredecessor(nodeTop, oKey);
                    }
                    return oValueOld;
                }
                if (nCompare <= 0) break block0;
                nodePrev = nodeCur;
                nodeCur = nodeNext;
            }
            break;
        }
        return null;
    }

    @Override
    public void clear() {
        this.initialize();
    }

    public Comparator comparator() {
        return this.m_comparator;
    }

    public SortedMap subMap(Object fromKey, Object toKey) {
        if (this.comparator().compare(fromKey, toKey) > 0) {
            throw new IllegalArgumentException();
        }
        return new ViewMap(fromKey, toKey);
    }

    public SortedMap headMap(Object toKey) {
        return new ViewMap(null, toKey);
    }

    public SortedMap tailMap(Object fromKey) {
        return new ViewMap(fromKey, null);
    }

    public Object firstKey() {
        return this.getViewMap().firstKey();
    }

    public Object lastKey() {
        return this.getViewMap().lastKey();
    }

    protected ViewMap getViewMap() {
        return this.m_mapView;
    }

    protected float[] getProbabilityThresholds() {
        return this.m_aflProbabilityThresholds;
    }

    protected Random getRandom() {
        return this.m_random;
    }

    protected int getMaxLevel() {
        return this.m_nLevelMax;
    }

    protected int getSpan() {
        return this.m_nSpan;
    }

    protected void initialize() {
        BaseEntryNode nodeBase = new BaseEntryNode();
        nodeBase.setNext(null);
        this.setTopNode(new IndexNode(1, null, nodeBase));
    }

    protected IndexNode getTopNode() {
        return this.m_nodeTop;
    }

    protected void setTopNode(IndexNode nodeTop) {
        this.m_nodeTop = nodeTop;
    }

    protected boolean casTopNode(IndexNode nodeTopAssume, IndexNode nodeTopNew) {
        return m_atomicUpdaterTopNode.compareAndSet(this, nodeTopAssume, nodeTopNew);
    }

    protected BaseEntryNode getBaseNode() {
        return (BaseEntryNode)this.getTopNode().getEntryNode();
    }

    protected EntryNode firstNode() {
        BaseEntryNode nodeBase;
        EntryNode nodeNext;
        while ((nodeNext = (nodeBase = this.getBaseNode()).getNext()) != null && nodeNext.isDeleted()) {
            nodeNext.helpDelete(nodeBase, nodeNext.getNext());
        }
        return nodeNext;
    }

    /*
     * Unable to fully structure code
     */
    protected EntryNode lastNode() {
        block0: while (true) {
            nodeTop = this.getTopNode();
            nodeNext = nodeTop;
            do {
                if ((nodeNext = (nodeCur = nodeNext).getNext()) != null) {
                    if (!nodeNext.getEntryNode().isDeleted()) continue;
                    nodeCur.casNext(nodeNext, nodeNext.getNext());
                    continue block0;
                }
                nodeNext = nodeCur.getBelow();
            } while (nodeNext != null);
            nodeEntry = nodeCur.getEntryNode();
            nodeEntryNext = nodeEntry.getNext();
            while (true) {
                if (nodeEntryNext == null) {
                    return nodeEntry == nodeTop.getEntryNode() ? null : nodeEntry;
                }
                nodeEntryAfter = nodeEntryNext.getNext();
                if (nodeEntryNext != nodeEntry.getNext()) continue block0;
                if (nodeEntryNext.isDeleted()) {
                    nodeEntryNext.helpDelete(nodeEntry, nodeEntryAfter);
                    continue block0;
                }
                if (!nodeEntry.isDeleted()) ** break;
                continue block0;
                nodeEntry = nodeEntryNext;
                nodeEntryNext = nodeEntryAfter;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void insertIndex(IndexNode nodeTop, EntryNode nodeNew, int nLevelThis) {
        while (nLevelThis > (nLevelMax = nodeTop.getLevel())) {
            nodeTopOld = nodeTop;
            nodeBase = nodeTop.getEntryNode();
            while (nLevelMax < nLevelThis) {
                nodeTop = new IndexNode(++nLevelMax, nodeTop, nodeBase);
            }
            if (this.casTopNode(nodeTopOld, nodeTop)) continue;
            nLevelThis = nodeTop.getLevel();
            break;
        }
        nodeIndex = null;
        for (i = 1; i <= nLevelThis; ++i) {
            nodeIndex = new SkipNode(nodeIndex, nodeNew);
        }
        comparator = this.comparator();
        nLevelInsert = nLevelThis;
        oKeyNew = nodeNew.getKey();
        block3: while (true) {
            nLevel = nodeTop.getLevel();
            nodeCur = nodeTop;
            nodeNext = nodeCur.getNext();
            nodeIdx = nodeIndex;
            while (true) {
                if (nodeNext != null) {
                    nodeEntry = nodeNext.getEntryNode();
                    nCompare = comparator.compare(oKeyNew, nodeEntry.getKey());
                    if (nodeEntry.isDeleted()) {
                        if (!nodeCur.casNext(nodeNext, nodeNext.getNext())) continue block3;
                        nodeNext = nodeCur.getNext();
                        continue;
                    }
                    if (nCompare > 0) {
                        nodeCur = nodeNext;
                        nodeNext = nodeNext.getNext();
                        continue;
                    }
                }
                if (nLevel == nLevelInsert) {
                    if (nodeNew.isDeleted()) {
                        this.findNearest(nodeTop, oKeyNew, 1, true);
                        return;
                    }
                    nodeIdx.setNext(nodeNext);
                    if (nodeCur.casNext(nodeNext, nodeIdx)) ** break;
                    continue block3;
                    if (--nLevelInsert == 0) {
                        if (nodeNew.isDeleted()) {
                            this.findNearest(nodeTop, oKeyNew, 1, true);
                        }
                        return;
                    }
                }
                if (--nLevel >= nLevelInsert && nLevel < nLevelThis) {
                    nodeIdx = nodeIdx.getBelow();
                }
                nodeCur = nodeCur.getBelow();
                nodeNext = nodeCur.getNext();
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected EntryNode findNearest(IndexNode nodeTop, Object oKey, int nMode, boolean fFixLinks) {
        comparator = this.comparator();
        block0: while (true) {
            if (nMode == 1 && !fFixLinks) {
                nodePrev = this.findNearestIndexedEntry(nodeTop, oKey, 3);
                if (nodePrev != nodeTop.getEntryNode() && comparator.compare(nodePrev.getKey(), oKey) == 0) {
                    return nodePrev;
                }
            } else {
                nodePrev = this.findNearestIndexedEntry(nodeTop, oKey, 2);
            }
            nodeCur = nodePrev.getNext();
            while (true) {
                if (nodeCur == null) {
                    return (nMode & 2) != 0 ? nodePrev : null;
                }
                nodeNext = nodeCur.getNext();
                if (nodeCur != nodePrev.getNext()) continue block0;
                if (nodeCur.isDeleted()) {
                    nodeCur.helpDelete(nodePrev, nodeNext);
                    continue block0;
                }
                if (!nodePrev.isDeleted()) ** break;
                continue block0;
                nCompare = comparator.compare(oKey, nodeCur.getKey());
                if (nCompare < 0) {
                    if (nMode == 1) {
                        return null;
                    }
                    if ((nMode & 2) != 0) {
                        return nodePrev;
                    }
                    return nodeCur;
                }
                if (nCompare == 0) {
                    if ((nMode & 1) != 0) {
                        return nodeCur;
                    }
                    if (nMode == 2) {
                        return nodePrev;
                    }
                }
                nodePrev = nodeCur;
                nodeCur = nodeNext;
            }
            break;
        }
    }

    protected EntryNode findPredecessor(IndexNode nodeTop, Object oKey) {
        return this.findNearestIndexedEntry(nodeTop, oKey, 2);
    }

    protected EntryNode findNearestIndexedEntry(IndexNode nodeTop, Object oKey, int nMode) {
        SkipNode nodeCur;
        boolean fEqualsOk = (nMode & 1) != 0;
        Comparator comparator = this.comparator();
        block0: while (true) {
            nodeCur = nodeTop;
            SkipNode nodeNext = nodeCur.getNext();
            while (true) {
                SkipNode nodeBelow;
                if (nodeNext != null) {
                    EntryNode nodeEntry = nodeNext.getEntryNode();
                    if (nodeEntry.isDeleted()) {
                        if (!nodeCur.casNext(nodeNext, nodeNext.getNext())) continue block0;
                        nodeNext = nodeCur.getNext();
                        continue;
                    }
                    int nCompare = comparator.compare(oKey, nodeEntry.getKey());
                    if (nCompare > 0) {
                        nodeCur = nodeNext;
                        nodeNext = nodeNext.getNext();
                        continue;
                    }
                    if (fEqualsOk && nCompare == 0) {
                        return nodeEntry;
                    }
                }
                if ((nodeBelow = nodeCur.getBelow()) == null) break block0;
                nodeCur = nodeBelow;
                nodeNext = nodeCur.getNext();
            }
            break;
        }
        return nodeCur.getEntryNode();
    }

    protected static float[] computeProbabilityThresholds(int nLevelMax, int nSpan) {
        float flCumulative;
        float[] aflProbability = new float[nLevelMax + 1];
        float flProbability = 1.0f;
        if (nSpan == 2) {
            flProbability = 0.5f;
            flCumulative = 0.5f;
        } else {
            flCumulative = (float)(nSpan - 2) / (float)(nSpan - 1);
        }
        for (int i = 0; i <= nLevelMax; ++i) {
            aflProbability[i] = flCumulative += (flProbability /= (float)nSpan);
        }
        return aflProbability;
    }

    protected int calculateRandomLevel() {
        int nLevel;
        int nLevelMax = this.getMaxLevel();
        float flRandom = this.getRandom().nextFloat();
        float[] aflProbability = this.getProbabilityThresholds();
        for (nLevel = 0; nLevel < nLevelMax && !(flRandom < aflProbability[nLevel]); ++nLevel) {
        }
        return nLevel;
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        IndexNode nodeTop = this.getTopNode();
        int nLevelMax = nodeTop.getLevel();
        SkipNode[] aNodeSkip = new SkipNode[nLevelMax + 1];
        SkipNode nodeSkip = nodeTop;
        for (int i = nLevelMax; i > 0; --i) {
            aNodeSkip[i] = nodeSkip.getNext();
            nodeSkip = nodeSkip.getBelow();
        }
        EntryNode nodeCur = this.firstNode();
        while ((nodeCur = nodeCur.getNext()) != null) {
            Object oKey = nodeCur.getKey();
            Object oValue = nodeCur.getValue();
            int nLevel = 1;
            while (nLevel <= nLevelMax) {
                SkipNode nodeIndex = aNodeSkip[nLevel];
                if (nodeCur == null || nodeIndex == null || nodeCur != nodeIndex.getEntryNode()) break;
                aNodeSkip[nLevel++] = nodeIndex.getNext();
            }
            sb.append(oKey);
            sb.append("=");
            sb.append(oValue);
            sb.append("  indexed to level (");
            sb.append(nLevel - 1);
            sb.append(")\n");
        }
        return sb.toString();
    }

    public Split split(Object oKey) {
        return new Split(oKey);
    }

    public class Split {
        protected SortedMap m_mapHead;
        protected SortedMap m_mapTail;
        protected float m_flHeadWeight = -1.0f;

        protected Split(Object oKey) {
            this.m_mapHead = SafeSortedMap.this.headMap(oKey);
            this.m_mapTail = SafeSortedMap.this.tailMap(oKey);
        }

        protected int quickLog(int n, int nBase) {
            int nLog = 0;
            int i = 1;
            while (i <= n) {
                i *= nBase;
                ++nLog;
            }
            return Math.max(0, nLog - 1);
        }

        protected float calculateHeadWeight() {
            Object oKey = this.getSplitKey();
            int cSampleSize = 100;
            int cEntries = SafeSortedMap.this.size();
            int nLevel = 0;
            int nSpan = SafeSortedMap.this.getSpan();
            if (cEntries > cSampleSize) {
                nLevel = this.quickLog((int)(1.0f / (1.0f - (float)nSpan * (1.0f - ((float)nSpan - 2.0f) / ((float)nSpan - 1.0f) - (float)cSampleSize / (float)cEntries) * (1.0f - 1.0f / (float)nSpan)) - 1.0f), nSpan) - 1;
            }
            Comparator comparator = SafeSortedMap.this.comparator();
            if (nLevel <= 0) {
                int cHead = 0;
                for (EntryNode nodeCur = SafeSortedMap.this.getBaseNode().getNext(); nodeCur != null && comparator.compare(nodeCur.getKey(), oKey) <= 0; nodeCur = nodeCur.getNext()) {
                    ++cHead;
                }
                return (float)cHead / (float)cEntries;
            }
            IndexNode nodeIdx = SafeSortedMap.this.getTopNode();
            while (nodeIdx.getLevel() > nLevel) {
                nodeIdx = (IndexNode)nodeIdx.getBelow();
            }
            int cHead = 0;
            int cTail = 0;
            for (SkipNode nodeCur = nodeIdx.getNext(); nodeCur != null; nodeCur = nodeCur.getNext()) {
                if (cTail == 0 && comparator.compare(nodeCur.getEntryNode().getKey(), oKey) <= 0) {
                    ++cHead;
                    continue;
                }
                ++cTail;
            }
            return (float)cHead / (float)(cHead + cTail);
        }

        public SortedMap getHead() {
            return this.m_mapHead;
        }

        public SortedMap getTail() {
            return this.m_mapTail;
        }

        public float getHeadWeight() {
            if (this.m_flHeadWeight < 0.0f) {
                this.m_flHeadWeight = this.calculateHeadWeight();
            }
            return this.m_flHeadWeight;
        }

        public float getTailWeight() {
            return 1.0f - this.getHeadWeight();
        }

        public boolean isHeadHeavy() {
            return this.getHeadWeight() > 0.5f;
        }

        public Object getSplitKey() {
            return ((ViewMap)this.getHead()).getUpperBound();
        }
    }

    protected class ViewMap
    extends AbstractMap
    implements SortedMap {
        protected final Object m_oKeyLower;
        protected final Object m_oKeyUpper;

        protected ViewMap(Object oKeyLower, Object oKeyUpper) {
            this.m_oKeyLower = oKeyLower;
            this.m_oKeyUpper = oKeyUpper;
        }

        @Override
        public Set entrySet() {
            return new EntrySet();
        }

        @Override
        public Object put(Object oKey, Object oValue) {
            if (!this.inRange(oKey)) {
                throw new IllegalArgumentException();
            }
            return SafeSortedMap.this.put(oKey, oValue);
        }

        @Override
        public Object get(Object oKey) {
            return this.inRange(oKey) ? SafeSortedMap.this.get(oKey) : null;
        }

        @Override
        public boolean containsKey(Object oKey) {
            return this.inRange(oKey) && SafeSortedMap.this.containsKey(oKey);
        }

        @Override
        public Object remove(Object oKey) {
            return this.inRange(oKey) ? SafeSortedMap.this.remove(oKey) : null;
        }

        public Comparator comparator() {
            return SafeSortedMap.this.comparator();
        }

        public SortedMap subMap(Object fromKey, Object toKey) {
            if (this.comparator().compare(fromKey, toKey) > 0 || !this.inRange(fromKey) || !this.inRange(toKey)) {
                throw new IllegalArgumentException();
            }
            return new ViewMap(fromKey, toKey);
        }

        public SortedMap headMap(Object toKey) {
            if (!this.inRange(toKey)) {
                throw new IllegalArgumentException();
            }
            return new ViewMap(this.getLowerBound(), toKey);
        }

        public SortedMap tailMap(Object fromKey) {
            if (!this.inRange(fromKey)) {
                throw new IllegalArgumentException();
            }
            return new ViewMap(fromKey, this.getUpperBound());
        }

        public Object firstKey() {
            EntryNode nodeFirst = this.firstNode();
            return nodeFirst == null ? null : nodeFirst.getKey();
        }

        public Object lastKey() {
            EntryNode nodeLast = this.lastNode();
            return nodeLast == null ? null : nodeLast.getKey();
        }

        protected Object getLowerBound() {
            return this.m_oKeyLower;
        }

        protected Object getUpperBound() {
            return this.m_oKeyUpper;
        }

        protected boolean inRange(Object oKey) {
            Object oKeyLower = this.getLowerBound();
            Object oKeyUpper = this.getUpperBound();
            Comparator comparator = this.comparator();
            return !(oKeyLower != null && comparator.compare(oKeyLower, oKey) > 0 || oKeyUpper != null && comparator.compare(oKey, oKeyUpper) >= 0);
        }

        protected EntryNode firstNode() {
            Object oKeyLower = this.getLowerBound();
            if (oKeyLower == null) {
                return SafeSortedMap.this.firstNode();
            }
            return SafeSortedMap.this.findNearest(SafeSortedMap.this.getTopNode(), oKeyLower, 5, true);
        }

        protected EntryNode lastNode() {
            Object oKeyUpper = this.getUpperBound();
            if (oKeyUpper == null) {
                return SafeSortedMap.this.lastNode();
            }
            return SafeSortedMap.this.findNearest(SafeSortedMap.this.getTopNode(), oKeyUpper, 2, true);
        }

        protected class EntryIterator
        extends AbstractStableIterator {
            protected EntryNode m_nodeNext = null;
            protected boolean m_fInitialized = false;

            protected EntryIterator() {
            }

            @Override
            protected void advance() {
                EntryNode.MapEntry entry = null;
                EntryNode nodeCur = null;
                EntryNode nodeNext = null;
                if (this.m_fInitialized) {
                    nodeNext = this.m_nodeNext;
                } else {
                    nodeNext = ViewMap.this.firstNode();
                    this.m_fInitialized = true;
                }
                do {
                    if ((nodeCur = nodeNext) == null || !ViewMap.this.inRange(nodeCur.getKey())) {
                        return;
                    }
                    entry = nodeCur.getMapEntry();
                    nodeNext = nodeCur.getNext();
                } while (nodeCur.isDeleted());
                this.m_nodeNext = nodeNext;
                this.setNext(entry);
            }

            @Override
            protected void remove(Object o) {
                SafeSortedMap.this.remove(((Map.Entry)o).getKey());
            }
        }

        protected class EntrySet
        extends AbstractSet {
            protected EntrySet() {
            }

            @Override
            public int size() {
                if (ViewMap.this.getLowerBound() == null && ViewMap.this.getUpperBound() == null) {
                    return SafeSortedMap.this.size();
                }
                int cSize = 0;
                Iterator iter = this.iterator();
                while (iter.hasNext()) {
                    ++cSize;
                    iter.next();
                }
                return cSize;
            }

            @Override
            public Iterator iterator() {
                return new EntryIterator();
            }
        }
    }

    protected static class BaseEntryNode
    extends EntryNode {
        protected final AtomicInteger m_atomicSize = new AtomicInteger();

        protected BaseEntryNode() {
            super(BASE_VALUE, BASE_VALUE);
        }

        public AtomicInteger getSizeCounter() {
            return this.m_atomicSize;
        }
    }

    protected static class EntryNode {
        protected static final AtomicReferenceFieldUpdater m_atomicUpdaterNext = AtomicReferenceFieldUpdater.newUpdater(EntryNode.class, EntryNode.class, "m_nodeNext");
        protected static final AtomicReferenceFieldUpdater m_atomicUpdaterValue = AtomicReferenceFieldUpdater.newUpdater(EntryNode.class, Object.class, "m_oValue");
        protected final Object m_oKey;
        protected volatile Object m_oValue;
        protected volatile EntryNode m_nodeNext;

        protected EntryNode(Object oKey, Object oValue) {
            this.m_oKey = oKey;
            this.m_oValue = oValue;
        }

        protected EntryNode(Object oKey, Object oValue, EntryNode nodeNext) {
            this.m_oKey = oKey;
            this.m_oValue = oValue;
            this.m_nodeNext = nodeNext;
        }

        public boolean isDeleted() {
            return this.m_oValue == NO_VALUE;
        }

        public boolean markForDelete(EntryNode nodeNext) {
            return this.casNext(nodeNext, new EntryNode(this.getKey(), NO_VALUE, nodeNext));
        }

        public void helpDelete(EntryNode nodePrev, EntryNode nodeNext) {
            if (nodeNext == this.getNext() && this == nodePrev.getNext()) {
                if (nodeNext == null || !nodeNext.isDeleted()) {
                    this.markForDelete(nodeNext);
                } else {
                    nodePrev.casNext(this, nodeNext.getNext());
                }
            }
        }

        public Object getKey() {
            return this.m_oKey;
        }

        public Object getValue() {
            Object oValue = this.getValueInternal();
            return oValue == NO_VALUE ? null : oValue;
        }

        protected boolean casValue(Object oValueAssume, Object oValueNew) {
            return m_atomicUpdaterValue.compareAndSet(this, oValueAssume, oValueNew);
        }

        protected MapEntry getMapEntry() {
            return new MapEntry();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            sb.append(this.getClass().getName());
            sb.append(" Key=");
            sb.append(this.getKey());
            sb.append(", Value=");
            sb.append(this.getValue());
            sb.append("}");
            return sb.toString();
        }

        protected Object getValueInternal() {
            return this.m_oValue;
        }

        protected EntryNode getNext() {
            return this.m_nodeNext;
        }

        protected void setNext(EntryNode nodeNext) {
            this.m_nodeNext = nodeNext;
        }

        protected boolean casNext(Object nodeAssume, Object nodeNext) {
            return m_atomicUpdaterNext.compareAndSet(this, nodeAssume, nodeNext);
        }

        protected class MapEntry
        implements Map.Entry {
            protected Object m_oValue;

            protected MapEntry() {
                this.m_oValue = EntryNode.this.getValue();
            }

            public Object getKey() {
                return EntryNode.this.getKey();
            }

            public Object getValue() {
                return this.m_oValue;
            }

            public Object setValue(Object oValueNew) {
                Object oValueOld;
                EntryNode nodeEntry = EntryNode.this;
                while ((oValueOld = nodeEntry.getValueInternal()) != NO_VALUE && !nodeEntry.casValue(oValueOld, oValueNew)) {
                }
                if (oValueOld == NO_VALUE) {
                    return null;
                }
                this.m_oValue = oValueNew;
                return oValueOld;
            }

            @Override
            public boolean equals(Object o) {
                return o instanceof Map.Entry && Base.equals(this.getKey(), ((Map.Entry)o).getKey()) && Base.equals(this.getValue(), ((Map.Entry)o).getValue());
            }

            @Override
            public int hashCode() {
                return Base.hashCode(this.getKey()) ^ Base.hashCode(this.getValue());
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("Entry{Key=\"").append(this.getKey()).append("\", Value=\"").append(this.getValue());
                sb.append("\"}");
                return sb.toString();
            }
        }
    }

    protected class IndexNode
    extends SkipNode {
        protected final int m_nLevel;

        protected IndexNode(int nLevel, IndexNode nodeBelow, EntryNode nodeEntry) {
            super(nodeBelow, nodeEntry);
            this.m_nLevel = nLevel;
        }

        public String getDescription() {
            return "IndexLevel=" + this.getLevel();
        }

        protected int getLevel() {
            return this.m_nLevel;
        }
    }

    protected static class SkipNode {
        protected static final AtomicReferenceFieldUpdater m_atomicUpdaterNext = AtomicReferenceFieldUpdater.newUpdater(SkipNode.class, SkipNode.class, "m_nodeNext");
        protected final EntryNode m_nodeEntry;
        protected final SkipNode m_nodeBelow;
        protected volatile SkipNode m_nodeNext;

        protected SkipNode(SkipNode nodeBelow, EntryNode nodeEntry) {
            this.m_nodeBelow = nodeBelow;
            this.m_nodeEntry = nodeEntry;
        }

        protected SkipNode getNext() {
            return this.m_nodeNext;
        }

        protected void setNext(SkipNode nodeNext) {
            this.m_nodeNext = nodeNext;
        }

        protected boolean casNext(SkipNode nodeAssume, SkipNode nodeNext) {
            return m_atomicUpdaterNext.compareAndSet(this, nodeAssume, nodeNext);
        }

        protected SkipNode getBelow() {
            return this.m_nodeBelow;
        }

        protected EntryNode getEntryNode() {
            return this.m_nodeEntry;
        }
    }
}

