/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.io;

import com.oracle.common.io.BufferSequence;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BufferSequenceInputStream
extends InputStream
implements DataInput {
    protected BufferSequence m_bufseq;
    private ByteBuffer m_buffTmp;
    protected long m_cb;
    protected int m_of;
    protected int m_ofMark;
    protected int m_posMark;
    protected long m_cbMark;
    protected ByteBuffer m_buf;

    public BufferSequenceInputStream(BufferSequence bufseq) {
        this.m_bufseq = bufseq;
        this.m_cbMark = this.m_cb = bufseq.getLength();
    }

    @Override
    public void readFully(byte[] ab) throws IOException {
        this.read(ab, 0, ab.length);
    }

    @Override
    public void readFully(byte[] ab, int off, int len) throws IOException {
        this.read(ab, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    @Override
    public short readShort() throws IOException {
        short n;
        int cb = 2;
        ByteBuffer buf = this.getByteBuffer();
        if (buf.remaining() >= cb && buf.order() == ByteOrder.BIG_ENDIAN) {
            n = buf.getShort();
            this.m_cb -= (long)cb;
        } else {
            ByteBuffer buftmp = this.getBufferTemp();
            if (this.read(buftmp.array(), 0, cb) < cb) {
                throw new EOFException();
            }
            n = buftmp.getShort(0);
        }
        return n;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    @Override
    public char readChar() throws IOException {
        char ch;
        int cb = 2;
        ByteBuffer buf = this.getByteBuffer();
        if (buf.remaining() >= cb && buf.order() == ByteOrder.BIG_ENDIAN) {
            ch = buf.getChar();
            this.m_cb -= (long)cb;
        } else {
            ByteBuffer buftmp = this.getBufferTemp();
            if (this.read(buftmp.array(), 0, cb) < cb) {
                throw new EOFException();
            }
            ch = buftmp.getChar(0);
        }
        return ch;
    }

    @Override
    public int readInt() throws IOException {
        int n;
        int cb = 4;
        ByteBuffer buf = this.getByteBuffer();
        if (buf.remaining() >= cb && buf.order() == ByteOrder.BIG_ENDIAN) {
            n = buf.getInt();
            this.m_cb -= (long)cb;
        } else {
            ByteBuffer buftmp = this.getBufferTemp();
            if (this.read(buftmp.array(), 0, cb) < cb) {
                throw new EOFException();
            }
            n = buftmp.getInt(0);
        }
        return n;
    }

    @Override
    public long readLong() throws IOException {
        long n;
        int cb = 8;
        ByteBuffer buf = this.getByteBuffer();
        if (buf.remaining() >= cb && buf.order() == ByteOrder.BIG_ENDIAN) {
            n = buf.getLong();
            this.m_cb -= (long)cb;
        } else {
            ByteBuffer buftmp = this.getBufferTemp();
            if (this.read(buftmp.array(), 0, cb) < cb) {
                throw new EOFException();
            }
            n = buftmp.getLong(0);
        }
        return n;
    }

    @Override
    public float readFloat() throws IOException {
        float fl;
        int cb = 4;
        ByteBuffer buf = this.getByteBuffer();
        if (buf.remaining() >= cb && buf.order() == ByteOrder.BIG_ENDIAN) {
            fl = buf.getFloat();
            this.m_cb -= (long)cb;
        } else {
            ByteBuffer buftmp = this.getBufferTemp();
            if (this.read(buftmp.array(), 0, cb) < cb) {
                throw new EOFException();
            }
            fl = buftmp.getFloat(0);
        }
        return fl;
    }

    @Override
    public double readDouble() throws IOException {
        double dfl;
        int cb = 8;
        ByteBuffer buf = this.getByteBuffer();
        if (buf.remaining() >= cb && buf.order() == ByteOrder.BIG_ENDIAN) {
            dfl = buf.getDouble();
            this.m_cb -= (long)cb;
        } else {
            ByteBuffer buftmp = this.getBufferTemp();
            if (this.read(buftmp.array(), 0, cb) < cb) {
                throw new EOFException();
            }
            dfl = buftmp.getDouble(0);
        }
        return dfl;
    }

    @Override
    @Deprecated
    public String readLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        int c;
        int count;
        int utflen = this.readUnsignedShort();
        byte[] bytearr = new byte[utflen];
        char[] chararr = new char[utflen];
        int chararr_count = 0;
        this.readFully(bytearr, 0, utflen);
        for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararr_count++] = (char)c;
        }
        block6: while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
        return new String(chararr, 0, chararr_count);
    }

    @Override
    public int read() throws IOException {
        ByteBuffer buf = this.getByteBuffer();
        try {
            if (buf.hasRemaining()) {
                --this.m_cb;
                return buf.get() & 0xFF;
            }
            return -1;
        }
        catch (NullPointerException e) {
            throw this.potentialStreamClosedException(e);
        }
    }

    @Override
    public int read(byte[] abDest, int ofDest, int cbDest) throws IOException {
        if (abDest == null || ofDest < 0 || cbDest < 0 || ofDest + cbDest > abDest.length) {
            if (abDest == null) {
                throw new IllegalArgumentException("null byte array");
            }
            throw new IllegalArgumentException("abDest.length=" + abDest.length + ", ofDest=" + ofDest + ", cbDest=" + cbDest);
        }
        int cbResult = 0;
        try {
            while (cbDest > 0) {
                ByteBuffer buf = this.getByteBuffer();
                int posStart = buf.position();
                buf.get(abDest, ofDest, Math.min(cbDest, buf.remaining()));
                int cbRead = buf.position() - posStart;
                cbResult += cbRead;
                ofDest += cbRead;
                cbDest -= cbRead;
            }
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (NullPointerException e) {
            throw this.potentialStreamClosedException(e);
        }
        finally {
            this.m_cb -= (long)cbResult;
        }
        return cbResult == 0 && cbDest != 0 ? -1 : cbResult;
    }

    @Override
    public long skip(long lcb) throws IOException {
        if (this.m_bufseq == null) {
            throw new IOException("stream closed");
        }
        if (lcb < 0L) {
            return 0L;
        }
        int cb = (int)Math.min(Integer.MAX_VALUE, lcb);
        int cbResult = 0;
        try {
            while (cb > 0) {
                ByteBuffer buf = this.getByteBuffer();
                int cbSkip = Math.min(cb, buf.remaining());
                buf.position(buf.position() + cbSkip);
                cb -= cbSkip;
                cbResult += cbSkip;
            }
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (NullPointerException e) {
            throw this.potentialStreamClosedException(e);
        }
        finally {
            this.m_cb -= (long)cbResult;
        }
        return cbResult;
    }

    @Override
    public int available() throws IOException {
        if (this.m_bufseq == null) {
            throw new IOException("stream closed");
        }
        return (int)Math.min(Integer.MAX_VALUE, this.m_cb);
    }

    @Override
    public void mark(int readlimit) {
        try {
            ByteBuffer buff = this.getByteBuffer();
            this.m_cbMark = this.m_cb;
            this.m_ofMark = this.m_of;
            this.m_posMark = buff.position();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void reset() throws IOException {
        try {
            int of = this.m_ofMark;
            ByteBuffer buff = this.m_bufseq.getBuffer(of);
            buff.position(this.m_posMark);
            this.m_of = of;
            this.m_buf = buff;
            this.m_cb = this.m_cbMark;
        }
        catch (NullPointerException e) {
            throw this.potentialStreamClosedException(e);
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() throws IOException {
        this.m_buf = null;
        this.m_bufseq = null;
    }

    protected ByteBuffer getByteBuffer() {
        ByteBuffer buf = this.m_buf;
        while (buf == null || !buf.hasRemaining()) {
            this.m_buf = buf = this.m_bufseq.getBuffer(this.m_of++);
        }
        return buf;
    }

    protected NullPointerException potentialStreamClosedException(NullPointerException e) throws IOException {
        if (this.m_bufseq == null) {
            throw new IOException("stream closed");
        }
        throw e;
    }

    protected final ByteBuffer getBufferTemp() {
        ByteBuffer buffTmp = this.m_buffTmp;
        if (buffTmp == null) {
            this.m_buffTmp = buffTmp = ByteBuffer.allocate(8);
        }
        buffTmp.clear();
        return buffTmp;
    }
}

