/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.net;

import com.oracle.common.base.Hasher;
import com.oracle.common.base.NaturalHasher;
import com.oracle.common.net.InetAddressHasher;
import com.oracle.common.net.InetSocketAddressComparator;
import java.net.InetAddress;
import java.net.SocketAddress;

public class InetSocketAddressHasher
implements Hasher<SocketAddress> {
    public static final InetSocketAddressHasher INSTANCE = new InetSocketAddressHasher();

    @Override
    public int hashCode(SocketAddress addr) {
        if (addr == null) {
            return 0;
        }
        InetAddress ip = InetSocketAddressComparator.getAddress(addr);
        return InetSocketAddressComparator.getPort(addr) + (ip == null ? NaturalHasher.INSTANCE.hashCode(InetSocketAddressComparator.getHostName(addr)) : InetAddressHasher.INSTANCE.hashCode(ip));
    }

    @Override
    public boolean equals(SocketAddress addrA, SocketAddress addrB) {
        try {
            return InetSocketAddressComparator.INSTANCE.compare(addrA, addrB) == 0;
        }
        catch (Exception e) {
            return false;
        }
    }
}

