/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.net.SocketOptions;
import com.tangosol.net.SocketProvider;
import com.tangosol.util.Base;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class TcpRing
extends Net {
    private Map __m_Buddies;
    private transient ByteBuffer __m_Buffer;
    private transient Selector __m_Selector;
    private transient ServerSocketChannel __m_ServerSocketChannel;
    private transient SocketOptions __m_SocketOptions;
    private transient SocketProvider __m_SocketProvider;
    private transient long __m_StatsFailures;
    private transient long __m_StatsPings;

    public TcpRing(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void close() {
        Selector selector = this.getSelector();
        try {
            Iterator iter = selector.keys().iterator();
            while (iter.hasNext()) {
                SelectionKey key = (SelectionKey)iter.next();
                try {
                    if (!(!key.isValid() ? false : key.channel().isOpen())) continue;
                    key.channel().close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        catch (ConcurrentModificationException e) {
            // empty catch block
        }
        ServerSocketChannel server = this.getServerSocketChannel();
        if (server != null) {
            try {
                server.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            selector.close();
        }
        catch (IOException iOException) {}
    }

    protected SelectionKey connect(Member member) {
        SelectionKey key;
        SocketChannel channel;
        try {
            channel = this.getSocketProvider().openSocketChannel();
            channel.configureBlocking(false);
            this.getSocketOptions().apply(channel.socket());
            key = channel.register(this.ensureSelector(channel), SelectionKey.OP_CONNECT, member);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        try {
            if (channel.connect(member.getSocketAddress())) {
                Component._trace(String.valueOf("TcpRing connected to ") + member, 6);
                key.interestOps(SelectionKey.OP_READ);
            } else {
                Component._trace(String.valueOf("TcpRing connecting to ") + member, 6);
            }
            return key;
        }
        catch (ClosedByInterruptException e) {
            this.onClosedByInterrupt(e, key);
            this.disconnect(key);
            return null;
        }
        catch (IOException e) {
            this.onConnectException(e, key);
            this.disconnect(key);
            return null;
        }
    }

    protected void disconnect(SelectionKey key) {
        block3: {
            if (!(key != null)) break block3;
            try {
                if (key.channel().isOpen()) {
                    key.channel().close();
                }
            }
            catch (IOException e) {
                this.onDisconnectException(e, key);
            }
        }
    }

    protected void disconnectAll() {
        Iterator iter = this.getSelector().keys().iterator();
        while (iter.hasNext()) {
            SelectionKey key = (SelectionKey)iter.next();
            if (!key.isValid()) continue;
            this.disconnect(key);
        }
    }

    protected Selector ensureSelector(SelectableChannel channel) throws IOException {
        Selector selector = this.getSelector();
        if (selector == null) {
            selector = channel.provider().openSelector();
            this.setSelector(selector);
        }
        return selector;
    }

    public void ensureTopology(Set setConnect) {
        Map mapBuddies = this.getBuddies();
        Iterator iter = mapBuddies.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            Member member = (Member)entry.getKey();
            SelectionKey key = (SelectionKey)entry.getValue();
            if (!(setConnect.remove(member) ^ true)) continue;
            iter.remove();
            if (!(!(key != null) ? false : key.isValid())) continue;
            this.disconnect(key);
            Component._trace(String.valueOf("TcpRing disconnected from ") + member + " to maintain ring", 6);
        }
        iter = setConnect.iterator();
        while (iter.hasNext()) {
            mapBuddies.put(iter.next(), null);
        }
        iter = setConnect.iterator();
        while (iter.hasNext()) {
            Member member = (Member)iter.next();
            SelectionKey key = this.connect(member);
            if (!(key != null)) continue;
            mapBuddies.put(member, key);
        }
    }

    public String formatStats() {
        return String.valueOf("Pings=") + this.getStatsPings() + ", Failures=" + this.getStatsFailures();
    }

    public Map getBuddies() {
        return this.__m_Buddies;
    }

    public ByteBuffer getBuffer() {
        return this.__m_Buffer;
    }

    public Selector getSelector() {
        return this.__m_Selector;
    }

    public ServerSocketChannel getServerSocketChannel() {
        return this.__m_ServerSocketChannel;
    }

    public SocketOptions getSocketOptions() {
        return this.__m_SocketOptions;
    }

    public SocketProvider getSocketProvider() {
        return this.__m_SocketProvider;
    }

    public long getStatsFailures() {
        return this.__m_StatsFailures;
    }

    public long getStatsPings() {
        return this.__m_StatsPings;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/TcpRing".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private final Component get_Module() {
        return this;
    }

    protected void heartbeat(SelectionKey key) {
        block3: {
            SocketChannel channel;
            if (!(key != null) || !((channel = (SocketChannel)key.channel()).isConnectionPending() ^ true)) break block3;
            ByteBuffer buffer = this.getBuffer();
            ((Buffer)buffer).clear();
            buffer.put((byte)0);
            ((Buffer)buffer).flip();
            try {
                channel.write(buffer);
                this.setStatsPings(this.getStatsPings() + 1L);
            }
            catch (ClosedByInterruptException e) {
                this.onClosedByInterrupt(e, key);
                this.disconnect(key);
            }
            catch (IOException e) {
                Member member = (Member)key.attachment();
                Component._trace(String.valueOf("TcpRing disconnected from ") + member + " due to a peer departure during heartbeat; removing the member.", 5);
                this.onDeadBuddy(member);
            }
        }
    }

    public void heartbeatBuddies() {
        try {
            Iterator iter = this.getBuddies().values().iterator();
            while (iter.hasNext()) {
                this.heartbeat((SelectionKey)iter.next());
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {}
    }

    protected void onAccept(SelectionKey key) {
        block12: {
            SocketChannel channel = null;
            try {
                channel = ((ServerSocketChannel)key.channel()).accept();
                if (channel == null) {
                    return;
                }
            }
            catch (ClosedByInterruptException e) {
                this.onClosedByInterrupt(e, key);
                return;
            }
            catch (IOException e) {
                this.onAcceptException(e);
                return;
            }
            SelectionKey keyClient = null;
            try {
                channel.configureBlocking(false);
                try {
                    channel.socket().setSoLinger(false, 0);
                }
                catch (IOException e) {
                    // empty catch block
                }
                keyClient = channel.register(this.ensureSelector(channel), SelectionKey.OP_READ);
            }
            catch (IOException e) {
                if (channel.socket().isClosed() ^ true) {
                    Component._trace(String.valueOf("error on TcpRing accept: ") + channel.socket() + "\n" + Component.getStackTrace(e), 1);
                }
                if (keyClient == null) {
                    try {
                        channel.socket().close();
                    }
                    catch (IOException e2) {}
                    break block12;
                }
                this.disconnect(keyClient);
            }
        }
    }

    protected void onAcceptException(Exception e) {
        this.onException(e);
    }

    protected void onClosedByInterrupt(ClosedByInterruptException e, SelectionKey key) {
    }

    protected void onConnect(SelectionKey key) {
        SocketChannel channel = (SocketChannel)key.channel();
        Member member = (Member)key.attachment();
        try {
            if (!channel.finishConnect()) {
                throw new IllegalStateException();
            }
            key.interestOps(SelectionKey.OP_READ);
            Component._trace(String.valueOf("TcpRing connected to ") + member, 6);
        }
        catch (ClosedByInterruptException e) {
            this.onClosedByInterrupt(e, key);
            this.disconnect(key);
        }
        catch (IOException e) {
            this.onConnectException(e, key);
            this.disconnect(key);
        }
    }

    protected void onConnectException(Exception e, SelectionKey key) {
        Member member = (Member)key.attachment();
        Component._trace(String.valueOf("TcpRing connection to ") + member + " refused (" + e.getMessage() + "); removing the member.", 5);
        this.onDeadBuddy(member);
    }

    protected void onDeadBuddy(Member member) {
        this.setStatsFailures(this.getStatsFailures() + (long)1);
        this.getBuddies().remove(member);
    }

    protected void onDisconnectException(Exception e, SelectionKey key) {
        Component._trace(String.valueOf("TcpRing disconnect from ") + key.attachment() + " failed: " + e.getMessage(), 5);
    }

    protected void onException(Exception e) {
    }

    public void onInit() {
        this.setBuffer(ByteBuffer.allocate(1));
        super.onInit();
        try {
            SocketOptions options = this.getSocketOptions();
            options.setOption(java.net.SocketOptions.TCP_NODELAY, Boolean.TRUE);
            options.setOption(java.net.SocketOptions.SO_LINGER, 0);
        }
        catch (SocketException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected void onRead(SelectionKey key) {
        SocketChannel channel = (SocketChannel)key.channel();
        ByteBuffer buffer = this.getBuffer();
        ((Buffer)buffer).clear();
        try {
            if (channel.read(buffer) >= 0) {
                return;
            }
        }
        catch (ClosedByInterruptException e) {
            this.onClosedByInterrupt(e, key);
            this.disconnect(key);
            return;
        }
        catch (IOException e) {
            this.onReadException(e);
        }
        Member member = (Member)key.attachment();
        this.disconnect(key);
        if (!(member == null)) {
            Component._trace(String.valueOf("TcpRing disconnected from ") + member + " due to a peer departure; removing the member.", 5);
            this.onDeadBuddy(member);
        }
    }

    protected void onReadException(Exception e) {
    }

    protected void onSelect() {
        Iterator iter = this.getSelector().selectedKeys().iterator();
        while (iter.hasNext()) {
            SelectionKey key = (SelectionKey)iter.next();
            iter.remove();
            if (key.isValid() ^ true) continue;
            int nMaskOps = key.readyOps();
            if (nMaskOps == 0) {
                this.disconnect(key);
            }
            if ((nMaskOps & SelectionKey.OP_ACCEPT) != 0) {
                this.onAccept(key);
            }
            if ((nMaskOps & SelectionKey.OP_CONNECT) != 0) {
                this.onConnect(key);
            }
            if (!((nMaskOps & SelectionKey.OP_READ) != 0)) continue;
            this.onRead(key);
        }
    }

    public void resetStats() {
        this.setStatsFailures(0L);
        this.setStatsPings(0L);
    }

    public void select(long cMillis) {
        try {
            if (cMillis < 0L) {
                this.getSelector().selectNow();
            } else {
                this.getSelector().select(cMillis);
            }
            this.onSelect();
        }
        catch (IOException e) {
            Component._trace(e, String.valueOf("Caught an I/O exception while processing a TcpRing Socket; ") + "the exception has been logged and will be ignored");
        }
    }

    protected void setBuddies(Map mapBuddies) {
        this.__m_Buddies = mapBuddies;
    }

    protected void setBuffer(ByteBuffer buffer) {
        this.__m_Buffer = buffer;
    }

    public void setSelector(Selector selector) {
        this.__m_Selector = selector;
    }

    public void setServerSocketChannel(ServerSocketChannel channel) {
        ServerSocketChannel channelOld = this.getServerSocketChannel();
        if (channelOld != null) {
            try {
                channel.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            channel.register(this.ensureSelector(channel), SelectionKey.OP_ACCEPT);
            this.getSocketOptions().apply(channel.socket());
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
        this.__m_ServerSocketChannel = channel;
    }

    protected void setSocketOptions(SocketOptions options) {
        Component._assert(options != null);
        Component._assert(this.getSocketOptions() == null);
        this.__m_SocketOptions = options;
    }

    public void setSocketProvider(SocketProvider provider) {
        this.__m_SocketProvider = provider;
    }

    protected void setStatsFailures(long cFailures) {
        this.__m_StatsFailures = cFailures;
    }

    protected void setStatsPings(long cPings) {
        this.__m_StatsPings = cPings;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TcpRing{Connections=[");
        Set setBuddies = this.getBuddies().keySet();
        try {
            Iterator iter = setBuddies.iterator();
            while (iter.hasNext()) {
                sb.append(((Member)iter.next()).getId());
                if (!iter.hasNext()) continue;
                sb.append(", ");
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        sb.append("]}");
        return sb.toString();
    }

    public boolean verifyReachable(Member member, long cTimeoutMillis) {
        try {
            Socket socket = this.getSocketProvider().openSocket();
            socket.connect(member.getSocketAddress(), (int)cTimeoutMillis);
            socket.getOutputStream().write(0);
            socket.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void wakeup() {
        this.getSelector().wakeup();
    }
}

