/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.reporter.extractor;

import com.tangosol.coherence.reporter.Constants;
import com.tangosol.coherence.reporter.Reporter;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.MultiExtractor;
import java.util.List;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class JoinExtractor
extends MultiExtractor
implements Constants {
    protected String m_sJoinTemplate;
    protected ValueExtractor m_veSource;

    public JoinExtractor(ValueExtractor[] aExtractors, String sJoinTemplate, ValueExtractor veSource) {
        super(aExtractors);
        this.m_sJoinTemplate = sJoinTemplate;
        this.m_veSource = veSource;
    }

    @Override
    public Object extract(Object oTarget) {
        List listResult = (List)super.extract(oTarget);
        Set set = Reporter.getMacros(this.m_sJoinTemplate);
        String sJoinTarget = this.m_sJoinTemplate;
        int index = 0;
        for (String sId : set) {
            Object oValue = listResult.get(index);
            if (oValue != null) {
                sJoinTarget = sJoinTarget.replaceAll("\\{" + sId + "\\}", oValue.toString().replaceAll("\\$", "\\\\\\$"));
            }
            ++index;
        }
        try {
            ObjectName onameTarget = new ObjectName(sJoinTarget);
            return this.m_veSource.extract(onameTarget);
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }
}

