/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal;

import com.tangosol.coherence.transaction.TransactionId;
import com.tangosol.coherence.transaction.internal.Message;
import com.tangosol.coherence.transaction.internal.ServiceContext;
import com.tangosol.coherence.transaction.internal.Transaction;
import com.tangosol.coherence.transaction.internal.TransactionImpl;
import com.tangosol.coherence.transaction.internal.operation.Operation;
import com.tangosol.coherence.transaction.internal.operation.RollbackOperation;
import com.tangosol.coherence.transaction.internal.operation.UpdateCommitVersionOperation;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.coherence.transaction.internal.storage.XidSyntheticKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SessionManager {
    private Map<TransactionId, Transaction> m_mapSessions = new HashMap<TransactionId, Transaction>();
    List<Transaction> m_listTxIndex = new LinkedList<Transaction>();
    private ServiceContext m_serviceContext;
    Set<Transaction> m_setOldestTx = new HashSet<Transaction>();

    public SessionManager(ServiceContext serviceContext) {
        this.m_serviceContext = serviceContext;
    }

    public synchronized void register(Transaction tx) {
        this.m_mapSessions.put(tx.getXid(), tx);
        this.m_listTxIndex.add(tx);
    }

    public synchronized void unregister(TransactionId xid) {
        Transaction tx = this.m_mapSessions.remove(xid);
        this.m_listTxIndex.remove(tx);
    }

    public synchronized Set<Transaction> getOldestSessions(int c) {
        c = c > this.m_listTxIndex.size() ? this.m_listTxIndex.size() : c;
        HashSet<Transaction> set = new HashSet<Transaction>(c);
        for (int i = 0; i < c; ++i) {
            set.add(this.m_listTxIndex.get(i));
        }
        return set;
    }

    protected void doSessionManagement() {
        Set<Transaction> setOldest = this.getOldestSessions(5);
        this.m_setOldestTx.retainAll(setOldest);
        for (Transaction tx : this.m_setOldestTx) {
            if (this.checkForTimeout(tx)) continue;
            this.updateCommitVersion(tx);
        }
        this.m_setOldestTx = setOldest;
    }

    private boolean checkForTimeout(Transaction tx) {
        if (tx.isTimedOut()) {
            long lMillis = tx.getSession().getActiveMillis();
            boolean fStateChanged = tx.setRollbackOnly("Transaction timed out after " + lMillis + " millis.");
            if (fStateChanged) {
                this.timeoutTx(tx);
                return true;
            }
        }
        return false;
    }

    private void timeoutTx(Transaction tx) {
        Map<String, Set<XidSyntheticKey>> mapSynKeys = tx.getSession().getSyntheticKeyMap();
        for (Map.Entry<String, Set<XidSyntheticKey>> e : mapSynKeys.entrySet()) {
            RollbackOperation op = new RollbackOperation(this.m_serviceContext.getServiceName());
            Message msg = this.createMessage(tx, op, e.getKey(), e.getValue());
            this.m_serviceContext.getCompositionManager().getEndpoint("local-director").dispatch(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCommitVersion(Transaction tx) {
        LocalMemberState lms = this.m_serviceContext.getMemberState();
        long lVersion = lms.getCurrentWriteVersion();
        if (lVersion >= tx.getSession().getCommitVersion()) {
            boolean fUpdated = tx.setCommitVersion(lVersion + 1L);
            SessionManager sessionManager = this;
            synchronized (sessionManager) {
                this.m_listTxIndex.remove(tx);
                if (fUpdated) {
                    this.m_listTxIndex.add(tx);
                    this.updateVersionDependencies(tx, lVersion);
                }
            }
        }
    }

    private void updateVersionDependencies(Transaction tx, long lVersion) {
        Map<String, Set<XidSyntheticKey>> mapSynKeys = tx.getSession().getSyntheticKeyMap();
        for (Map.Entry<String, Set<XidSyntheticKey>> e : mapSynKeys.entrySet()) {
            UpdateCommitVersionOperation op = new UpdateCommitVersionOperation(this.m_serviceContext.getServiceName());
            op.setVersion(lVersion);
            Message msg = this.createMessage(tx, op, e.getKey(), e.getValue());
            this.m_serviceContext.getCompositionManager().getEndpoint("local-director").dispatch(msg);
        }
    }

    private Message createMessage(Transaction tx, Operation op, String sTable, Set setKeys) {
        TransactionId xid = this.m_serviceContext.getXidManager().nextXid();
        TransactionImpl newTx = new TransactionImpl(xid, tx.getSession(), true, false, this.m_serviceContext);
        op.setTableName(sTable);
        op.addKeys(setKeys);
        op.setXid(xid);
        Message msg = new Message(op);
        msg.setContext(newTx);
        return msg;
    }
}

