/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.Filter;
import java.lang.reflect.Method;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class InetAddressHelper
extends Base {
    public static final boolean PreferIPv4Stack = Boolean.getBoolean("java.net.preferIPv4Stack");
    public static final boolean PreferIPv6Addresses = Boolean.getBoolean("java.net.preferIPv6Addresses");
    public static final Method METHOD_GET_MTU;

    public static InetAddress getLocalAddress(Filter filter) throws UnknownHostException {
        InetAddress addrLocal = InetAddress.getLocalHost();
        InetAddress addrBest = null;
        int nMTUBest = 0;
        int nMTULocal = 0;
        Map mapAddr = InetAddressHelper.getAllLocalMTUs();
        for (Map.Entry entry : mapAddr.entrySet()) {
            int nMTU;
            InetAddress addr = (InetAddress)entry.getKey();
            if (!filter.evaluate(addr)) continue;
            Integer oMTU = (Integer)entry.getValue();
            int n = nMTU = oMTU == null ? 0 : oMTU;
            if (addr.equals(addrLocal)) {
                nMTULocal = nMTU;
            }
            if (nMTU <= nMTUBest && (nMTU != nMTUBest || InetAddressHelper.compare(addr, addrBest) >= 0)) continue;
            addrBest = addr;
            nMTUBest = nMTU;
        }
        if (addrBest == null) {
            throw new UnknownHostException("No local address matching " + filter);
        }
        return nMTUBest == nMTULocal && filter.evaluate(addrLocal) ? addrLocal : addrBest;
    }

    public static InetAddress getLocalAddress(String sAddr) throws UnknownHostException {
        if (sAddr == null || sAddr.isEmpty() || sAddr.equals("localhost")) {
            return InetAddressHelper.getLocalHost();
        }
        if (sAddr.indexOf(47) != -1) {
            return InetAddressHelper.getLocalAddress(new SubnetMaskFilter(sAddr));
        }
        InetAddress addr = InetAddress.getByName(sAddr);
        if (InetAddressHelper.isLocalAddress(addr)) {
            return addr;
        }
        throw new UnknownHostException(sAddr + " is not a local address");
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        try {
            return InetAddressHelper.getLocalAddress(RoutableFilter.INSTANCE);
        }
        catch (UnknownHostException e) {
            return InetAddress.getLocalHost();
        }
    }

    public static int compare(InetAddress addrA, InetAddress addrB) {
        int i;
        int ofB;
        int ofA;
        if (addrA == addrB) {
            return 0;
        }
        if (addrA == null) {
            return -1;
        }
        if (addrB == null) {
            return 1;
        }
        if (addrA.isLoopbackAddress() && addrB.isLoopbackAddress()) {
            return 0;
        }
        byte[] abA = addrA.getAddress();
        byte[] abB = addrB.getAddress();
        int cbA = abA.length;
        for (ofA = 0; ofA < cbA && abA[ofA] == 0; ++ofA) {
        }
        int cbsA = cbA - ofA;
        int cbB = abB.length;
        for (ofB = 0; ofB < cbB && abB[ofB] == 0; ++ofB) {
        }
        int cbsB = cbB - ofB;
        if (cbsA < cbsB) {
            return -1;
        }
        if (cbsB < cbsA) {
            return 1;
        }
        int c = cbsA;
        for (i = 0; i < c && abA[ofA + i] == abB[ofB + i]; ++i) {
        }
        return i == c ? 0 : ((0xFF & abA[0]) < (0xFF & abB[0]) ? -1 : 1);
    }

    public static int getLocalMTU(InetAddress addr) {
        if (METHOD_GET_MTU == null) {
            return 0;
        }
        try {
            NetworkInterface ni = NetworkInterface.getByInetAddress(addr);
            if (ni == null) {
                throw new IllegalArgumentException("The specified address \"" + addr + "\" is not a local address.");
            }
            return InetAddressHelper.getLocalMTU(ni);
        }
        catch (SocketException socketException) {
            return 0;
        }
    }

    public static int getLocalMTU(NetworkInterface ni) {
        Method method = METHOD_GET_MTU;
        if (method == null) {
            return 0;
        }
        try {
            int nMTU = (Integer)method.invoke((Object)ni, (Object[])null);
            return nMTU < 0 ? Integer.MAX_VALUE : nMTU;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static List getAllLocalAddresses() {
        ArrayList<InetAddress> listAddr = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> enmrNI = NetworkInterface.getNetworkInterfaces();
            while (enmrNI != null && enmrNI.hasMoreElements()) {
                NetworkInterface ni = enmrNI.nextElement();
                Enumeration<InetAddress> enmrAddr = ni.getInetAddresses();
                while (enmrAddr.hasMoreElements()) {
                    listAddr.add(enmrAddr.nextElement());
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return listAddr;
    }

    public static Map getAllLocalMTUs() {
        HashMap<InetAddress, Integer> mapAddr = new HashMap<InetAddress, Integer>();
        try {
            Enumeration<NetworkInterface> enmrNI = NetworkInterface.getNetworkInterfaces();
            while (enmrNI != null && enmrNI.hasMoreElements()) {
                NetworkInterface ni = enmrNI.nextElement();
                int nMTU = InetAddressHelper.getLocalMTU(ni);
                Integer oMTU = nMTU == 0 ? null : Integer.valueOf(nMTU);
                Enumeration<InetAddress> enmrAddr = ni.getInetAddresses();
                while (enmrAddr.hasMoreElements()) {
                    mapAddr.put(enmrAddr.nextElement(), oMTU);
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return mapAddr;
    }

    private static String unbracketAddressString(String sAddr) {
        if (sAddr.charAt(0) == '[') {
            int ofBracket = sAddr.indexOf(93, 1);
            if (ofBracket < 0) {
                throw new IllegalArgumentException("invalid IPv6 address");
            }
            sAddr = sAddr.substring(1, ofBracket);
        }
        return sAddr;
    }

    public static InetSocketAddress getSocketAddress(String sAddr, int nPort) throws UnknownHostException {
        int ofPort;
        if (sAddr == null) {
            throw new IllegalArgumentException("address cannot be null");
        }
        String sHost = InetAddressHelper.unbracketAddressString(sAddr);
        if (sAddr.equals(sHost)) {
            ofPort = sAddr.lastIndexOf(58);
            int ofEnd = ofPort != -1 ? ofPort : sAddr.length();
            sHost = sAddr.substring(0, ofEnd);
        } else {
            ofPort = sAddr.indexOf(58, sAddr.indexOf(93));
        }
        if (ofPort != -1) {
            nPort = Integer.parseInt(sAddr.substring(ofPort + 1));
        }
        if (sHost.equals("*")) {
            return new InetSocketAddress(nPort);
        }
        if (sHost.equals("localhost") || sAddr.length() == 0) {
            return new InetSocketAddress(InetAddressHelper.getLocalHost(), nPort);
        }
        InetSocketAddress addr = new InetSocketAddress(sHost, nPort);
        if (addr.getAddress() == null) {
            throw new UnknownHostException("could not resolve address \"" + sAddr + "\"");
        }
        return addr;
    }

    public static boolean isLocalAddress(InetAddress addr) {
        List listLocal = InetAddressHelper.getAllLocalAddresses();
        for (InetAddress addrLocal : listLocal) {
            if (InetAddressHelper.compare(addrLocal, addr) != 0) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean isLoopbackAddress(InetAddress addr) {
        InetAddressHelper.azzert(addr != null);
        return addr.isLoopbackAddress();
    }

    @Deprecated
    public static boolean isAnyLocalAddress(InetAddress addr) {
        InetAddressHelper.azzert(addr != null);
        return addr.isAnyLocalAddress();
    }

    @Deprecated
    public static boolean isLinkLocalAddress(InetAddress addr) {
        InetAddressHelper.azzert(addr != null);
        return addr.isLinkLocalAddress();
    }

    @Deprecated
    public static boolean isSiteLocalAddress(InetAddress addr) {
        InetAddressHelper.azzert(addr != null);
        return addr.isSiteLocalAddress();
    }

    public static InetAddress getByAddress(byte[] abAddr) throws UnknownHostException {
        block4: {
            if (abAddr == null) {
                return null;
            }
            if (abAddr.length == 16 && !PreferIPv6Addresses) {
                for (int i = 0; i < 12; ++i) {
                    if (abAddr[i] == 0) {
                        continue;
                    }
                    break block4;
                }
                abAddr = new byte[]{abAddr[12], abAddr[13], abAddr[14], abAddr[15]};
            }
        }
        return InetAddress.getByAddress(abAddr);
    }

    public static boolean virtuallyEqual(byte[] abAddr1, byte[] abAddr2) {
        int cb1 = abAddr1.length;
        int cb2 = abAddr2.length;
        InetAddressHelper.azzert(cb1 == 4 || cb1 == 16);
        int of1 = 0;
        int of2 = 0;
        if (cb1 != cb2) {
            byte[] abIP6;
            InetAddressHelper.azzert(cb2 == 4 || cb2 == 16);
            if (cb1 == 4) {
                abIP6 = abAddr2;
                of2 = 12;
            } else {
                abIP6 = abAddr1;
                of1 = 12;
            }
            for (int of = 0; of < 12; ++of) {
                if (abIP6[of] == 0) continue;
                return false;
            }
        }
        while (of1 < cb1) {
            if (abAddr1[of1++] == abAddr2[of2++]) continue;
            return false;
        }
        return true;
    }

    public static long toLong(InetAddress addr) {
        InetAddressHelper.azzert(addr != null);
        byte[] ab = addr.getAddress();
        int of = ab.length == 4 ? 0 : 12;
        return ((long)ab[of + 0] & 0xFFL) << 24 | ((long)ab[of + 1] & 0xFFL) << 16 | ((long)ab[of + 2] & 0xFFL) << 8 | (long)ab[of + 3] & 0xFFL;
    }

    public static String toString(byte[] ab) {
        int cb = ab.length;
        int of = 0;
        InetAddressHelper.azzert(cb == 4 || cb == 16);
        StringBuffer sb = new StringBuffer(40);
        if (cb == 16) {
            boolean fIPv4 = true;
            int i = 0;
            while (i < 6) {
                int iVal = (ab[of + 0] & 0xFF) << 8 | ab[of + 1] & 0xFF;
                sb.append(InetAddressHelper.toHexString(iVal, InetAddressHelper.getMaxHexDigits(iVal))).append(':');
                fIPv4 &= iVal == 0;
                ++i;
                of += 2;
            }
            if (fIPv4) {
                sb.setLength(0);
                sb.append("::");
            }
        }
        int i = 0;
        while (i < 3) {
            sb.append(ab[of] & 0xFF).append('.');
            ++i;
            ++of;
        }
        sb.append(ab[of] & 0xFF);
        return sb.toString();
    }

    public static String toString(InetAddress addr) {
        if (addr == null) {
            return String.valueOf(addr);
        }
        if (addr instanceof Inet6Address) {
            return InetAddressHelper.toString(addr.getAddress());
        }
        return addr.getHostAddress();
    }

    protected static void setSubnetMask(byte[] ab, int cBits) {
        int i;
        if (ab.length * 8 < cBits) {
            throw new IllegalArgumentException("subnet mask of " + cBits + " exceeds address length of " + ab.length * 8);
        }
        int cBytes = cBits / 8;
        for (i = 0; i < cBytes; ++i) {
            ab[i] = -1;
        }
        int c = cBits % 8;
        for (i = 0; i < c; ++i) {
            int n = cBytes;
            ab[n] = (byte)(ab[n] | 1 << 7 - i);
        }
    }

    static {
        Method method = null;
        try {
            method = ClassHelper.findMethod(NetworkInterface.class, "getMTU", null, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        METHOD_GET_MTU = method;
    }

    public static class SubnetMaskFilter
    implements Filter {
        protected String m_sDescription;
        protected byte[] m_abPattern;
        protected byte[] m_abMask;

        public SubnetMaskFilter(InetAddress addrPattern, InetAddress addrMask) {
            this.m_abPattern = addrPattern.getAddress();
            this.m_abMask = addrMask.getAddress();
            this.m_sDescription = addrPattern + "/" + addrMask;
            if (this.m_abPattern.length != this.m_abMask.length) {
                throw new IllegalArgumentException("pattern and mask must be of the same byte length");
            }
        }

        public SubnetMaskFilter(InetAddress addrPattern, int cMaskBits) {
            this.m_abPattern = addrPattern.getAddress();
            this.m_abMask = new byte[this.m_abPattern.length];
            this.m_sDescription = addrPattern + "/" + cMaskBits;
            InetAddressHelper.setSubnetMask(this.m_abMask, cMaskBits);
        }

        public SubnetMaskFilter(String sAddr) {
            try {
                this.m_sDescription = sAddr;
                int ofSubnetMask = sAddr.indexOf(47);
                InetAddress addr = ofSubnetMask == -1 ? InetAddress.getByName(sAddr) : InetAddress.getByName(sAddr.substring(0, ofSubnetMask));
                this.m_abPattern = addr.getAddress();
                byte[] abPattern = this.m_abPattern;
                if (ofSubnetMask == -1 || sAddr.indexOf(46, ofSubnetMask) == -1) {
                    this.m_abMask = new byte[abPattern.length];
                    byte[] abMask = this.m_abMask;
                    InetAddressHelper.setSubnetMask(abMask, ofSubnetMask == -1 ? abPattern.length * 8 : Integer.valueOf(sAddr.substring(ofSubnetMask + 1)));
                } else {
                    this.m_abMask = InetAddress.getByName(sAddr.substring(ofSubnetMask + 1)).getAddress();
                }
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("dns names are not supported");
            }
        }

        @Override
        public boolean evaluate(Object o) {
            InetAddress addr = (InetAddress)o;
            byte[] ab = addr.getAddress();
            byte[] abPat = this.m_abPattern;
            byte[] abMask = this.m_abMask;
            if (ab.length != abPat.length) {
                return false;
            }
            for (int i = ab.length - 1; i >= 0; --i) {
                byte bMask = abMask[i];
                if ((ab[i] & bMask) == (abPat[i] & bMask)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "SubnetMaskFilter(" + this.m_sDescription + ")";
        }
    }

    public static class RoutableFilter
    implements Filter {
        public static final RoutableFilter INSTANCE = new RoutableFilter();

        @Override
        public boolean evaluate(Object o) {
            InetAddress addr = (InetAddress)o;
            return !addr.isLoopbackAddress() && !addr.isAnyLocalAddress() && !addr.isLinkLocalAddress();
        }

        public String toString() {
            return "RoutableFilter";
        }
    }
}

