/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.AbstractBundler;
import com.tangosol.net.cache.AbstractEntryBundler;
import com.tangosol.net.cache.AbstractKeyBundler;
import com.tangosol.net.cache.WrapperNamedCache;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class BundlingNamedCache
extends WrapperNamedCache {
    private GetBundler m_getBundler;
    private PutBundler m_putBundler;
    private RemoveBundler m_removeBundler;

    public BundlingNamedCache(NamedCache cache) {
        super((Map)cache, null, null);
    }

    public synchronized AbstractBundler ensureGetBundler(int cBundleThreshold) {
        if (cBundleThreshold > 0) {
            GetBundler bundler = this.m_getBundler;
            if (bundler == null) {
                this.m_getBundler = bundler = new GetBundler();
            }
            bundler.setSizeThreshold(cBundleThreshold);
            return bundler;
        }
        this.m_getBundler = null;
        return null;
    }

    public synchronized AbstractBundler ensurePutBundler(int cBundleThreshold) {
        if (cBundleThreshold > 0) {
            PutBundler bundler = this.m_putBundler;
            if (bundler == null) {
                this.m_putBundler = bundler = new PutBundler();
            }
            bundler.setSizeThreshold(cBundleThreshold);
            return bundler;
        }
        this.m_putBundler = null;
        return null;
    }

    public synchronized AbstractBundler ensureRemoveBundler(int cBundleThreshold) {
        if (cBundleThreshold > 0) {
            RemoveBundler bundler = this.m_removeBundler;
            if (bundler == null) {
                this.m_removeBundler = bundler = new RemoveBundler();
            }
            bundler.setSizeThreshold(cBundleThreshold);
            return bundler;
        }
        this.m_removeBundler = null;
        return null;
    }

    public AbstractBundler getGetBundler() {
        return this.m_getBundler;
    }

    public AbstractBundler getPutBundler() {
        return this.m_putBundler;
    }

    public AbstractBundler getRemoveBundler() {
        return this.m_removeBundler;
    }

    @Override
    public Object get(Object oKey) {
        GetBundler bundler = this.m_getBundler;
        return bundler == null ? super.get(oKey) : bundler.process(oKey);
    }

    @Override
    public Map getAll(Collection colKeys) {
        GetBundler bundler = this.m_getBundler;
        return bundler == null ? super.getAll(colKeys) : bundler.processAll(colKeys);
    }

    @Override
    public Object put(Object oKey, Object oValue) {
        PutBundler bundler = this.m_putBundler;
        if (bundler == null) {
            super.putAll(Collections.singletonMap(oKey, oValue));
        } else {
            bundler.process(oKey, oValue);
        }
        return null;
    }

    @Override
    public void putAll(Map map) {
        PutBundler bundler = this.m_putBundler;
        if (bundler == null) {
            super.putAll(map);
        } else {
            bundler.processAll(map);
        }
    }

    @Override
    public Object remove(Object oKey) {
        RemoveBundler bundler = this.m_removeBundler;
        if (bundler == null) {
            super.remove(oKey);
        } else {
            bundler.process(oKey);
        }
        return null;
    }

    protected class RemoveBundler
    extends AbstractKeyBundler {
        protected RemoveBundler() {
        }

        @Override
        protected Map bundle(Collection colKeys) {
            BundlingNamedCache.this.keySet().removeAll(colKeys);
            return null;
        }

        @Override
        protected Object unbundle(Object oKey) {
            BundlingNamedCache.this.keySet().remove(oKey);
            return null;
        }
    }

    protected class PutBundler
    extends AbstractEntryBundler {
        protected PutBundler() {
        }

        @Override
        protected void bundle(Map map) {
            BundlingNamedCache.super.putAll(map);
        }
    }

    protected class GetBundler
    extends AbstractKeyBundler {
        protected GetBundler() {
        }

        @Override
        protected Map bundle(Collection colKeys) {
            return BundlingNamedCache.super.getAll(colKeys);
        }

        @Override
        protected Object unbundle(Object oKey) {
            return BundlingNamedCache.super.get(oKey);
        }
    }
}

