/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.run.jca;

import com.tangosol.net.NamedCache;
import com.tangosol.util.Base;
import com.tangosol.util.TransactionMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.Interaction;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;
import javax.resource.cci.RecordFactory;

public class CacheAdapter
extends Base {
    private int m_nConcur;
    private int m_nIsolation;
    private int m_nTimeout;
    private ConnectionFactory m_factory;
    private Connection m_connection;
    private String m_sServiceName;
    private String m_sServiceType;
    public static final int TRANSACTION_GET_COMMITTED = 1;
    public static final int TRANSACTION_REPEATABLE_GET = 2;
    public static final int TRANSACTION_SERIALIZABLE = 3;
    public static final int CONCUR_PESSIMISTIC = 1;
    public static final int CONCUR_OPTIMISTIC = 2;
    public static final int CONCUR_EXTERNAL = 3;

    public CacheAdapter() {
        this(null, null, 2, 1, 0);
    }

    public CacheAdapter(Context ctx, String sJndiName, int nConcur, int nIsolation, int nTimeout) {
        try {
            if (ctx == null) {
                ctx = new InitialContext();
            }
            if (sJndiName == null) {
                sJndiName = "tangosol.coherenceTx";
            }
            this.m_factory = (ConnectionFactory)ctx.lookup(sJndiName);
            this.m_nConcur = nConcur;
            this.m_nIsolation = nIsolation;
            this.m_nTimeout = nTimeout;
        }
        catch (Exception e) {
            throw CacheAdapter.ensureRuntimeException(e);
        }
        if (this.m_factory == null) {
            throw new IllegalArgumentException("Failed to find a ConnectionFactory: " + sJndiName);
        }
    }

    public NamedCache getReplicatedCache(String sName, ClassLoader loader) {
        if (this.isConnected()) {
            if (!"ReplicatedCache".equals(this.m_sServiceType)) {
                throw new IllegalStateException("Service type mismatch: " + this.m_sServiceType);
            }
        } else {
            this.connect("ReplicatedCache", "ReplicatedCache", null, null);
        }
        return this.getNamedCache(sName, loader, null, false);
    }

    public NamedCache getDistributedCache(String sName, ClassLoader loader) {
        if (this.isConnected()) {
            if (!"DistributedCache".equals(this.m_sServiceType)) {
                throw new IllegalStateException("Service type mismatch: " + this.m_sServiceType);
            }
        } else {
            this.connect("DistributedCache", "DistributedCache", null, null);
        }
        return this.getNamedCache(sName, loader, null, true);
    }

    public void connect(String sServiceName, String sUserName, String sPassword) {
        this.connect(sServiceName, null, sUserName, sPassword);
    }

    public void connect(String sServiceName, String sServiceType, String sUserName, String sPassword) {
        if (this.isConnected()) {
            throw new IllegalStateException("Already connected");
        }
        try {
            CacheConnectionSpec infoCache = new CacheConnectionSpec(sServiceName, sServiceType, sUserName, sPassword, this.m_nConcur, this.m_nIsolation, this.m_nTimeout);
            this.m_connection = this.m_factory.getConnection((ConnectionSpec)infoCache);
            this.m_sServiceName = sServiceName;
            this.m_sServiceType = sServiceType;
        }
        catch (Exception e) {
            throw CacheAdapter.ensureRuntimeException(e);
        }
    }

    public NamedCache getNamedCache(String sName, ClassLoader loader) {
        return this.getNamedCache(sName, loader, null, false);
    }

    public NamedCache getNamedCache(String sName, ClassLoader loader, TransactionMap.Validator validator, boolean fImmutable) {
        if (!this.isConnected()) {
            this.connect(null, null, null, null);
        }
        try {
            Interaction ix = this.m_connection.createInteraction();
            RecordFactory rf = this.m_factory.getRecordFactory();
            MappedRecord mapIn = rf.createMappedRecord("InputRecord");
            mapIn.put((Object)"CacheName", (Object)sName);
            mapIn.put((Object)"ClassLoader", (Object)loader);
            mapIn.put((Object)"Validator", (Object)validator);
            mapIn.put((Object)"Immutable", (Object)(fImmutable ? Boolean.TRUE : Boolean.FALSE));
            return (NamedCache)ix.execute(null, (Record)mapIn);
        }
        catch (Exception e) {
            throw CacheAdapter.ensureRuntimeException(e);
        }
    }

    public void close() {
        try {
            Connection con = this.m_connection;
            if (con != null) {
                con.close();
                this.m_connection = null;
            }
        }
        catch (Exception e) {
            throw CacheAdapter.ensureRuntimeException(e);
        }
    }

    protected boolean isConnected() {
        return this.m_connection != null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CacheAdapter{State=").append(this.isConnected() ? "connected" : "closed");
        if (this.m_sServiceName != null) {
            sb.append(", CacheService=").append(this.m_sServiceName);
        }
        sb.append(", Concurrency=");
        switch (this.m_nConcur) {
            case 1: {
                sb.append("CONCUR_PESSIMISTIC");
                break;
            }
            case 2: {
                sb.append("CONCUR_OPTIMISTIC");
                break;
            }
            case 3: {
                sb.append("CONCUR_EXTERNAL");
                break;
            }
            default: {
                sb.append("invalid");
            }
        }
        sb.append(", Isolation=");
        switch (this.m_nIsolation) {
            case 1: {
                sb.append("TRANSACTION_GET_COMMITTED");
                break;
            }
            case 2: {
                sb.append("TRANSACTION_REPEATABLE_GET");
                break;
            }
            case 3: {
                sb.append("TRANSACTION_SERIALIZABLE");
                break;
            }
            default: {
                sb.append("invalid");
            }
        }
        sb.append(", Timeout=").append(this.m_nTimeout);
        if (this.isConnected()) {
            sb.append(", Connection=(").append(this.m_connection.getClass().getName()).append(") ").append(this.m_connection);
        }
        return sb.toString();
    }

    protected void finalize() {
        this.close();
    }

    public static class CacheConnectionSpec
    implements ConnectionSpec {
        private String m_sServiceName;
        private String m_sServiceType;
        private String m_sUserName;
        private String m_sPassword;
        private int m_nConcur;
        private int m_nIsolation;
        private int m_nTimeout;

        public CacheConnectionSpec(String sServiceName, String sServiceType, String sUserName, String sPassword, int nConcur, int nIsolation, int nTimeout) {
            this.m_sServiceName = sServiceName;
            this.m_sServiceType = sServiceType;
            this.m_sUserName = sUserName;
            this.m_sPassword = sPassword;
            this.m_nConcur = nConcur;
            this.m_nIsolation = nIsolation;
            this.m_nTimeout = nTimeout;
        }

        public String getServiceName() {
            return this.m_sServiceName;
        }

        public String getServiceType() {
            return this.m_sServiceType;
        }

        public String getUserName() {
            return this.m_sUserName;
        }

        public String getPassword() {
            return this.m_sPassword;
        }

        public int getConcurrency() {
            return this.m_nConcur;
        }

        public int getIsolation() {
            return this.m_nIsolation;
        }

        public int getTimeout() {
            return this.m_nTimeout;
        }
    }
}

