/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.processor;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.LiteMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class ConditionalRemove
extends AbstractProcessor
implements ExternalizableLite,
PortableObject {
    protected Filter m_filter;
    protected boolean m_fReturn;

    public ConditionalRemove() {
    }

    public ConditionalRemove(Filter filter) {
        this(filter, false);
    }

    public ConditionalRemove(Filter filter, boolean fReturn) {
        ConditionalRemove.azzert(filter != null, "Filter is null");
        this.m_filter = filter;
        this.m_fReturn = fReturn;
    }

    @Override
    public Object process(InvocableMap.Entry entry) {
        if (entry.isPresent() && InvocableMapHelper.evaluateEntry(this.m_filter, entry)) {
            entry.remove(false);
            return null;
        }
        return this.m_fReturn ? entry.getValue() : null;
    }

    @Override
    public Map processAll(Set setEntries) {
        LiteMap mapResult = new LiteMap();
        Filter filter = this.m_filter;
        boolean fReturn = this.m_fReturn;
        for (InvocableMap.Entry entry : setEntries) {
            if (entry.isPresent() && InvocableMapHelper.evaluateEntry(filter, entry)) {
                entry.remove(false);
                continue;
            }
            if (!fReturn) continue;
            mapResult.put(entry.getKey(), entry.getValue());
        }
        return mapResult;
    }

    public boolean equals(Object o) {
        if (o instanceof ConditionalRemove) {
            ConditionalRemove that = (ConditionalRemove)o;
            return ConditionalRemove.equals(this.m_filter, that.m_filter) && this.m_fReturn == that.m_fReturn;
        }
        return false;
    }

    public int hashCode() {
        return this.m_filter.hashCode() + (this.m_fReturn ? -1 : 1);
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + "{Filter= " + this.m_filter + ", ReturnRequired= " + this.m_fReturn + '}';
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_filter = (Filter)ExternalizableHelper.readObject(in);
        this.m_fReturn = in.readBoolean();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_filter);
        out.writeBoolean(this.m_fReturn);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_filter = (Filter)in.readObject(0);
        this.m_fReturn = in.readBoolean(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_filter);
        out.writeBoolean(1, this.m_fReturn);
    }
}

