package org.gridvise.logical.os

import java.lang.System.getProperty
import org.gridvise.logical.os.support.UnixSupport
import org.gridvise.logical.os.support.WindowsSupport


object OSOperations extends OSSupport{

  var osSupportImpl: OSSupport = new UnixSupport()

  initialize()

  def initialize() {
    if (is("win")) {
      osSupportImpl = new WindowsSupport()
    }
    if (is("nix")) {
      osSupportImpl = new UnixSupport()
    }
    if (is("mac")) {
      osSupportImpl = new UnixSupport()
    }

  }

  def is(osNameFragment: String): Boolean = {
    var os = getProperty("os.name").toLowerCase();
    println("os is " + os)
    os.indexOf(osNameFragment) >= 0
  }

  override def getClasspathSeparator(): String = {
    osSupportImpl.getClasspathSeparator()
  }

  override def getProcessIdentifier(process: scala.sys.process.Process): String = {
    osSupportImpl.getProcessIdentifier(process)
  }

  def stopProcess(processIdentifier: String) = {
    osSupportImpl.stopProcess(processIdentifier)
  }

  def getJavaCommand(): String = {
    osSupportImpl.getJavaCommand()
  }
  
  def setSystemPropery(name: String, value: String) {
    osSupportImpl.setSystemPropery(name, value)
  }

  def threadDump(pid: String) {
    osSupportImpl.threadDump(pid)
  }
  
  override def isValidPid(pid: String) = osSupportImpl.isValidPid(pid)
  
  override def getCPUUsage() = osSupportImpl.getCPUUsage()

  override def getCPUUsageHigherThen(percentage: Int): List[ProcInfo] = osSupportImpl.getCPUUsageHigherThen(percentage)

  
  
}