/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.collections;

import com.oracle.common.collections.ChainedIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class UnmodifiableSetCollection<E>
implements Set<E> {
    protected Set<E>[] m_aSet;

    public UnmodifiableSetCollection(Set<E> ... sets) {
        this.m_aSet = sets;
    }

    @Override
    public int size() {
        int i = 0;
        for (Set<E> set : this.m_aSet) {
            i += set.size();
        }
        return i;
    }

    @Override
    public boolean isEmpty() {
        for (Set<E> set : this.m_aSet) {
            if (set.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object o) {
        for (Set<E> set : this.m_aSet) {
            if (!set.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        Iterator[] aItr = new Iterator[this.m_aSet.length];
        int i = 0;
        for (Set<E> set : this.m_aSet) {
            aItr[i++] = set.iterator();
        }
        return new ChainedIterator(aItr);
    }

    @Override
    public Object[] toArray() {
        ArrayList<E> list = new ArrayList<E>(this.size());
        for (Set<E> set : this.m_aSet) {
            list.addAll(set);
        }
        return list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        ArrayList<E> list = new ArrayList<E>(this.size());
        for (Set<E> set : this.m_aSet) {
            list.addAll(set);
        }
        return list.toArray(a);
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Set) {
            Set set = (Set)o;
            return set.size() == this.size() && this.containsAll(set);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int nHash = 0;
        for (Set<E> set : this.m_aSet) {
            nHash += ((Object)set).hashCode();
        }
        return nHash;
    }
}

