/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.net.exabus.util;

import com.oracle.common.internal.net.socketbus.SocketBusDriver;
import com.oracle.common.net.SSLSocketProvider;
import com.oracle.common.net.SdpSocketProvider;
import com.oracle.common.net.TcpSocketProvider;
import com.oracle.common.net.exabus.Bus;
import com.oracle.common.net.exabus.Depot;
import com.oracle.common.net.exabus.EndPoint;
import com.oracle.common.net.exabus.MemoryBus;
import com.oracle.common.net.exabus.MessageBus;
import com.oracle.common.net.exabus.spi.Driver;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SimpleDepot
implements Depot {
    public static final String TCP_SOCKET_BUS = "TcpSocketBus";
    public static final String TCP_MESSAGE_BUS_PROTOCOL = "tmb";
    public static final String TCP_MEMORY_BUS_PROTOCOL = "trb";
    public static final String TCP_SECURE_SOCKET_BUS = "SecureTcpSocketBus";
    public static final String TCP_SECURE_MESSAGE_BUS_PROTOCOL = "tmbs";
    public static final String TCP_SECURE_MEMORY_BUS_PROTOCOL = "trbs";
    public static final String SDP_SOCKET_BUS = "SdpSocketBus";
    public static final String SDP_MESSAGE_BUS_PROTOCOL = "sdmb";
    public static final String SDP_MEMORY_BUS_PROTOCOL = "sdrb";
    public static final String SDP_SECURE_SOCKET_BUS = "SecureSdpSocketBus";
    public static final String SDP_SECURE_MESSAGE_BUS_PROTOCOL = "sdmbs";
    public static final String SDP_SECURE_MEMORY_BUS_PROTOCOL = "sdrbs";
    public static final String INFINI_BUS = "InfiniBus";
    public static final String IB_MESSAGE_BUS_PROTOCOL = "imb";
    public static final String IB_MEMORY_BUS_PROTOCOL = "irb";
    protected Dependencies m_dependencies;

    public SimpleDepot() {
        this(null);
    }

    public SimpleDepot(Dependencies deps) {
        this.m_dependencies = deps = this.copyDependencies(deps).validate();
        for (Driver driver : deps.getDrivers().values()) {
            driver.setDepot(this);
        }
    }

    @Override
    public EndPoint resolveEndPoint(String sName) {
        for (Driver driver : this.getDependencies().getDrivers().values()) {
            EndPoint ep = driver.resolveEndPoint(sName);
            if (ep == null) continue;
            return ep;
        }
        throw new IllegalArgumentException("unresolvable endpoint " + sName + "; no supporting driver registered");
    }

    @Override
    public MessageBus createMessageBus(EndPoint pointLocal) {
        if (pointLocal == null) {
            pointLocal = this.getDefaultMessageBusEndPoint();
        }
        for (Driver driver : this.getDependencies().getDrivers().values()) {
            if (!driver.isSupported(pointLocal)) continue;
            Bus bus = driver.createBus(pointLocal);
            if (bus instanceof MessageBus) {
                return (MessageBus)bus;
            }
            throw new IllegalArgumentException(pointLocal + " does not describe a MessageBus");
        }
        throw new IllegalArgumentException(pointLocal + " is not creatable; no supporting driver registered");
    }

    @Override
    public MemoryBus createMemoryBus(EndPoint pointLocal) {
        if (pointLocal == null) {
            pointLocal = this.getDefaultMemoryBusEndPoint();
        }
        for (Driver driver : this.getDependencies().getDrivers().values()) {
            if (!driver.isSupported(pointLocal)) continue;
            Bus bus = driver.createBus(pointLocal);
            if (bus instanceof MemoryBus) {
                return (MemoryBus)bus;
            }
            throw new IllegalArgumentException(pointLocal + " does not describe a MessageBus");
        }
        throw new IllegalArgumentException(pointLocal + " is not creatable; no supporting driver registered");
    }

    protected EndPoint getDefaultMessageBusEndPoint() {
        return this.resolveEndPoint(this.getDependencies().getDefaultMessageBusEndPoint());
    }

    protected EndPoint getDefaultMemoryBusEndPoint() {
        return this.resolveEndPoint(this.getDependencies().getDefaultMemoryBusEndPoint());
    }

    protected void registerDriver(Driver driver) {
        if (driver == null) {
            throw new IllegalArgumentException("driver cannot be null");
        }
        driver.setDepot(this);
    }

    public Dependencies getDependencies() {
        return this.m_dependencies;
    }

    protected DefaultDependencies copyDependencies(Dependencies deps) {
        return new DefaultDependencies(deps);
    }

    protected static Driver getInfiniBusDriver() {
        try {
            Class.forName("com.oracle.exalogic.ExaManager");
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            return (Driver)Class.forName("com.oracle.common.net.infinibus.InfiniBusDriver").newInstance();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static class DefaultDependencies
    implements Dependencies {
        protected String m_sDefaultMsgBusEndPoint;
        protected String m_sDefaultMemBusEndPoint;
        protected Map<String, Driver> m_mapDriver;

        public DefaultDependencies() {
        }

        public DefaultDependencies(Dependencies deps) {
            if (deps != null) {
                this.m_sDefaultMsgBusEndPoint = deps.getDefaultMessageBusEndPoint();
                this.m_sDefaultMemBusEndPoint = deps.getDefaultMemoryBusEndPoint();
                this.m_mapDriver = deps.getDrivers();
            }
        }

        @Override
        public String getDefaultMessageBusEndPoint() {
            String sEp = this.m_sDefaultMsgBusEndPoint;
            return sEp == null ? "tmb://0.0.0.0:-1" : sEp;
        }

        @Override
        public DefaultDependencies setDefaultMessageBusEndPoint(String sEp) {
            this.m_sDefaultMsgBusEndPoint = sEp;
            return this;
        }

        @Override
        public String getDefaultMemoryBusEndPoint() {
            String sEp = this.m_sDefaultMemBusEndPoint;
            return sEp == null ? "trb://0.0.0.0:-1" : sEp;
        }

        @Override
        public DefaultDependencies setDefaultMemoryBusEndPoint(String sEp) {
            this.m_sDefaultMemBusEndPoint = sEp;
            return this;
        }

        @Override
        public Map<String, Driver> getDrivers() {
            Map<String, Driver> mapDriver = this.m_mapDriver;
            if (mapDriver == null) {
                mapDriver = new HashMap<String, Driver>();
                mapDriver.put(SimpleDepot.TCP_SOCKET_BUS, new SocketBusDriver(new SocketBusDriver.DefaultDependencies().setMessageBusProtocol(SimpleDepot.TCP_MESSAGE_BUS_PROTOCOL).setMemoryBusProtocol(SimpleDepot.TCP_MEMORY_BUS_PROTOCOL).setSocketProvider(TcpSocketProvider.MULTIPLEXED)));
                mapDriver.put(SimpleDepot.SDP_SOCKET_BUS, new SocketBusDriver(new SocketBusDriver.DefaultDependencies().setMessageBusProtocol(SimpleDepot.SDP_MESSAGE_BUS_PROTOCOL).setMemoryBusProtocol(SimpleDepot.SDP_MEMORY_BUS_PROTOCOL).setSocketProvider(SdpSocketProvider.MULTIPLEXED)));
                mapDriver.put(SimpleDepot.TCP_SECURE_SOCKET_BUS, new SocketBusDriver(new SocketBusDriver.DefaultDependencies().setMessageBusProtocol(SimpleDepot.TCP_SECURE_MESSAGE_BUS_PROTOCOL).setMemoryBusProtocol(SimpleDepot.TCP_SECURE_MEMORY_BUS_PROTOCOL).setSocketProvider(new SSLSocketProvider(new SSLSocketProvider.DefaultDependencies().setDelegate(TcpSocketProvider.MULTIPLEXED)))));
                mapDriver.put(SimpleDepot.SDP_SECURE_SOCKET_BUS, new SocketBusDriver(new SocketBusDriver.DefaultDependencies().setMessageBusProtocol(SimpleDepot.SDP_SECURE_MESSAGE_BUS_PROTOCOL).setMemoryBusProtocol(SimpleDepot.SDP_SECURE_MEMORY_BUS_PROTOCOL).setSocketProvider(new SSLSocketProvider(new SSLSocketProvider.DefaultDependencies().setDelegate(SdpSocketProvider.MULTIPLEXED)))));
                Driver ibDriver = SimpleDepot.getInfiniBusDriver();
                if (ibDriver != null) {
                    mapDriver.put(SimpleDepot.INFINI_BUS, ibDriver);
                }
                this.m_mapDriver = mapDriver = Collections.unmodifiableMap(mapDriver);
            }
            return mapDriver;
        }

        @Override
        public DefaultDependencies setDrivers(Map<String, Driver> mapDriver) {
            this.m_mapDriver = mapDriver;
            return this;
        }

        protected DefaultDependencies validate() {
            DefaultDependencies.ensureArgument(this.getDefaultMemoryBusEndPoint(), "DefaultMemoryBusEndPoint");
            DefaultDependencies.ensureArgument(this.getDefaultMessageBusEndPoint(), "DefaultMessageBusEndPoint");
            DefaultDependencies.ensureArgument(this.getDrivers(), "Drivers");
            for (Driver driver : this.getDrivers().values()) {
                DefaultDependencies.ensureArgument(driver, "driver");
            }
            return this;
        }

        protected static void ensureArgument(Object o, String sName) {
            if (o == null) {
                throw new IllegalArgumentException(sName + " cannot be null");
            }
        }
    }

    public static interface Dependencies {
        public String getDefaultMessageBusEndPoint();

        public Dependencies setDefaultMessageBusEndPoint(String var1);

        public String getDefaultMemoryBusEndPoint();

        public Dependencies setDefaultMemoryBusEndPoint(String var1);

        public Map<String, Driver> getDrivers();

        public Dependencies setDrivers(Map<String, Driver> var1);
    }
}

