/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.extend;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Extend;
import com.tangosol.coherence.component.net.extend.Channel;
import com.tangosol.coherence.component.util.daemon.QueueProcessor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Initiator;
import com.tangosol.io.Serializer;
import com.tangosol.net.Cluster;
import com.tangosol.net.Member;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.ServiceInfo;
import com.tangosol.net.messaging.Connection;
import com.tangosol.net.messaging.ConnectionEvent;
import com.tangosol.net.messaging.ConnectionInitiator;
import com.tangosol.net.messaging.ConnectionListener;
import com.tangosol.net.messaging.ConnectionManager;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Listeners;
import com.tangosol.util.ServiceEvent;
import com.tangosol.util.ServiceListener;
import java.util.Collections;
import java.util.Set;

public abstract class RemoteService
extends Extend
implements com.tangosol.net.Service,
ServiceInfo,
ConnectionListener,
ServiceListener {
    private volatile com.tangosol.net.messaging.Channel __m_Channel;
    private Cluster __m_Cluster;
    private ClassLoader __m_ContextClassLoader;
    private volatile ConnectionInitiator __m_Initiator;
    private Listeners __m_MemberListeners;
    private OperationalContext __m_OperationalContext;
    private Listeners __m_ServiceListeners;
    private String __m_ServiceName;
    private String __m_ServiceVersion;
    private Object __m_UserContext;

    public RemoteService(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void addMemberListener(MemberListener listener) {
        this.getMemberListeners().add(listener);
    }

    public void addServiceListener(ServiceListener listener) {
        this.getServiceListeners().add(listener);
    }

    public synchronized void configure(XmlElement xml) {
        Component._assert(this.isRunning() ^ true);
        this.doConfigure(xml);
    }

    public void connectionClosed(ConnectionEvent evt) {
        this.setChannel(null);
        this.dispatchMemberEvent(MemberEvent.MEMBER_LEAVING);
        this.dispatchMemberEvent(MemberEvent.MEMBER_LEFT);
    }

    public void connectionError(ConnectionEvent evt) {
        this.setChannel(null);
        this.dispatchMemberEvent(MemberEvent.MEMBER_LEAVING);
        this.dispatchMemberEvent(MemberEvent.MEMBER_LEFT);
    }

    public void connectionOpened(ConnectionEvent evt) {
        this.dispatchMemberEvent(MemberEvent.MEMBER_JOINED);
    }

    protected void dispatchMemberEvent(int nId) {
        Listeners listeners = this.getMemberListeners();
        if (listeners.isEmpty() ^ true) {
            new MemberEvent(this, nId, this.getLocalMember()).dispatch(listeners);
        }
    }

    protected void dispatchServiceEvent(int nId) {
        Listeners listeners = this.getServiceListeners();
        if (listeners.isEmpty() ^ true) {
            new ServiceEvent(this, nId).dispatch(listeners);
        }
    }

    protected void doConfigure(XmlElement xml) {
        OperationalContext ctx;
        if (xml == null) {
            throw new IllegalArgumentException("xml configuration must not be null");
        }
        XmlElement xmlInitiator = Initiator.findInitiatorConfig(xml);
        XmlElement xmlHandler = XmlHelper.ensureElement(xmlInitiator, "incoming-message-handler");
        XmlElement xmlSub = XmlHelper.ensureElement(xmlHandler, "thread-count");
        if (xmlSub.getValue() == null) {
            xmlSub.setInt(xml.getSafeElement("thread-count").getInt());
        }
        if ((xmlSub = XmlHelper.ensureElement(xmlHandler, "task-hung-threshold")).getValue() == null) {
            xmlSub.setString(xml.getSafeElement("task-hung-threshold").getString());
        }
        if ((xmlSub = XmlHelper.ensureElement(xmlHandler, "task-timeout")).getValue() == null) {
            xmlSub.setString(xml.getSafeElement("task-timeout").getString());
        }
        if ((xmlSub = XmlHelper.ensureElement(xmlHandler, "request-timeout")).getValue() == null) {
            xmlSub.setString(xml.getSafeElement("request-timeout").getString());
        }
        if ((ctx = this.getOperationalContext()) == null) {
            throw new IllegalStateException("missing required OperationalContext");
        }
        ConnectionInitiator initiator = Initiator.createInitiator(xmlInitiator, ctx);
        if (initiator instanceof Initiator) {
            Initiator initiatorImpl = (Initiator)initiator;
            initiatorImpl.setServiceName(String.valueOf(this.getServiceName()) + ':' + initiatorImpl.getServiceName());
            initiatorImpl.setParentService(this);
        }
        this.setInitiator(initiator);
    }

    protected void doShutdown() {
        ConnectionInitiator initiator = this.getInitiator();
        Component._assert(initiator != null);
        initiator.shutdown();
    }

    protected void doStart() {
        ConnectionInitiator initiator = this.getInitiator();
        Component._assert(initiator != null);
        initiator.addConnectionListener(this);
        initiator.addServiceListener(this);
        initiator.setContextClassLoader(this.getContextClassLoader());
        initiator.start();
        this.setChannel(this.openChannel());
    }

    protected void doStop() {
        ConnectionInitiator initiator = this.getInitiator();
        Component._assert(initiator != null);
        initiator.stop();
    }

    public void drainEvents() {
        ConnectionInitiator initiator = this.getInitiator();
        if (initiator instanceof Initiator) {
            ((Initiator)initiator).drainEvents();
        }
    }

    protected synchronized com.tangosol.net.messaging.Channel ensureChannel() {
        com.tangosol.net.messaging.Channel channel = this.getChannel();
        if (channel == null ? true : channel.isOpen() ^ true) {
            channel = this.openChannel();
            this.setChannel(channel);
        }
        return channel;
    }

    protected QueueProcessor ensureEventDispatcher() {
        Channel channel = (Channel)this.ensureChannel();
        return channel.getConnectionManager().ensureEventDispatcher();
    }

    public com.tangosol.net.messaging.Channel getChannel() {
        return this.__m_Channel;
    }

    public Cluster getCluster() {
        return this.__m_Cluster;
    }

    public ClassLoader getContextClassLoader() {
        return this.__m_ContextClassLoader;
    }

    protected String getDescription() {
        return String.valueOf("Name=") + this.getServiceName();
    }

    public ServiceInfo getInfo() {
        return this;
    }

    public ConnectionInitiator getInitiator() {
        return this.__m_Initiator;
    }

    protected Member getLocalMember() {
        OperationalContext ctx = this.getOperationalContext();
        return ctx == null ? null : ctx.getLocalMember();
    }

    protected Listeners getMemberListeners() {
        return this.__m_MemberListeners;
    }

    public Member getOldestMember() {
        return this.getLocalMember();
    }

    public OperationalContext getOperationalContext() {
        return this.__m_OperationalContext;
    }

    public Serializer getSerializer() {
        ConnectionManager manager;
        Connection connection = this.ensureChannel().getConnection();
        if (connection != null && (manager = connection.getConnectionManager()) instanceof Service) {
            return ((Service)((Object)manager)).getSerializer();
        }
        return null;
    }

    protected Listeners getServiceListeners() {
        return this.__m_ServiceListeners;
    }

    public Member getServiceMember(int nId) {
        Member member = this.getLocalMember();
        if (!(member != null) ? false : member.getId() == nId) {
            return member;
        }
        return null;
    }

    public Set getServiceMembers() {
        Member member = this.getLocalMember();
        return member == null ? Collections.EMPTY_SET : Collections.singleton(member);
    }

    public String getServiceName() {
        return this.__m_ServiceName;
    }

    public String getServiceType() {
        return null;
    }

    public String getServiceVersion() {
        return this.__m_ServiceVersion;
    }

    public String getServiceVersion(Member member) {
        return this.getServiceVersion();
    }

    public Object getUserContext() {
        return this.__m_UserContext;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/extend/RemoteService".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isRunning() {
        ConnectionInitiator initiator = this.getInitiator();
        return initiator == null ? false : initiator.isRunning();
    }

    public boolean isServiceThread(boolean fStrict) {
        ConnectionInitiator initiator = this.getInitiator();
        if (initiator instanceof Initiator) {
            return ((Initiator)initiator).isServiceThread(fStrict);
        }
        return false;
    }

    protected com.tangosol.net.messaging.Channel openChannel() {
        return null;
    }

    public void removeMemberListener(MemberListener listener) {
        this.getMemberListeners().remove(listener);
    }

    public void removeServiceListener(ServiceListener listener) {
        this.getServiceListeners().remove(listener);
    }

    public void serviceStarted(ServiceEvent evt) {
        this.dispatchServiceEvent(evt.getId());
    }

    public void serviceStarting(ServiceEvent evt) {
        this.dispatchServiceEvent(evt.getId());
    }

    public void serviceStopped(ServiceEvent evt) {
        this.dispatchServiceEvent(evt.getId());
        this.setChannel(null);
    }

    public void serviceStopping(ServiceEvent evt) {
        this.dispatchServiceEvent(evt.getId());
    }

    protected void setChannel(com.tangosol.net.messaging.Channel channel) {
        this.__m_Channel = channel;
    }

    public void setCluster(Cluster cluster) {
        this.__m_Cluster = cluster;
    }

    public synchronized void setContextClassLoader(ClassLoader loader) {
        this.__m_ContextClassLoader = loader;
        ConnectionInitiator initiator = this.getInitiator();
        if (initiator != null) {
            initiator.setContextClassLoader(loader);
        }
    }

    protected void setInitiator(ConnectionInitiator initiator) {
        Component._assert(this.getInitiator() == null);
        this.__m_Initiator = initiator;
    }

    protected void setMemberListeners(Listeners listeners) {
        this.__m_MemberListeners = listeners;
    }

    public void setOperationalContext(OperationalContext ctx) {
        Component._assert(this.getOperationalContext() == null);
        this.__m_OperationalContext = ctx;
    }

    protected void setServiceListeners(Listeners listeners) {
        this.__m_ServiceListeners = listeners;
    }

    public void setServiceName(String sName) {
        this.__m_ServiceName = sName;
    }

    protected void setServiceVersion(String sVersion) {
        this.__m_ServiceVersion = sVersion;
    }

    public void setUserContext(Object oCtx) {
        this.__m_UserContext = oCtx;
    }

    public synchronized void shutdown() {
        if (this.isRunning()) {
            this.doShutdown();
        }
    }

    public synchronized void start() {
        if (this.isRunning() ^ true) {
            try {
                this.doStart();
            }
            catch (RuntimeException e) {
                this.doStop();
                throw e;
            }
        }
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            this.doStop();
        }
    }
}

