/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dsltools.base;

import com.tangosol.coherence.dsltools.base.BaseToken;
import com.tangosol.coherence.dsltools.base.BaseTokenScannerException;
import com.tangosol.coherence.dsltools.base.IdentifierBaseToken;
import com.tangosol.coherence.dsltools.base.LiteralBaseToken;
import com.tangosol.coherence.dsltools.base.NestedBaseTokens;
import com.tangosol.coherence.dsltools.base.OperatorBaseToken;
import com.tangosol.coherence.dsltools.base.PunctuationBaseToken;
import com.tangosol.coherence.dsltools.base.SequenceBaseToken;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;

public class BaseTokenScanner {
    protected int m_iPos = 0;
    protected int m_iStartPos = 0;
    protected String m_sPunctuation = ".;,";
    protected String m_sNests = "([{";
    protected String m_sUnnests = ")]}";
    protected StringBuffer m_tokenBuffer = new StringBuffer();
    protected char m_chCurrent;
    protected Reader m_reader;
    protected boolean m_fIsEnd = true;
    protected int m_coffset = 1;
    protected int m_lineNumber = 1;

    public BaseTokenScanner(String s) {
        this(new StringReader(s));
    }

    public BaseTokenScanner(Reader reader) {
        this.m_reader = reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseToken scan() {
        ArrayList<BaseToken> listTokens = new ArrayList<BaseToken>();
        try {
            this.reset();
            while (!this.isEnd()) {
                BaseToken token = this.next();
                if (token == null) continue;
                listTokens.add(token);
            }
            SequenceBaseToken sequenceBaseToken = new SequenceBaseToken(listTokens.toArray(new BaseToken[listTokens.size()]));
            return sequenceBaseToken;
        }
        finally {
            try {
                this.m_reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void reset() {
        this.m_fIsEnd = true;
        this.m_iPos = 0;
        this.m_chCurrent = '\u0000';
        try {
            int ch = this.m_reader.read();
            if (ch != -1) {
                this.m_chCurrent = (char)ch;
                this.m_fIsEnd = false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public BaseToken next() {
        try {
            this.resetTokenString();
            this.skipWhiteSpace();
            if (this.isEnd()) {
                return null;
            }
            this.notePos();
            char ch = this.getCurrentChar();
            if (this.isPunctuation(ch)) {
                this.takeCurrentCharAndAdvance();
                return new PunctuationBaseToken(this.tokenString());
            }
            if (this.isNest(ch)) {
                this.advance();
                return this.scanNest(ch);
            }
            BaseToken oToken = this.scanLiteral();
            if (oToken != null) {
                return oToken;
            }
            oToken = this.scanIdentifier();
            if (oToken != null) {
                return oToken;
            }
            if (this.scanOperator()) {
                return new OperatorBaseToken(this.tokenString());
            }
            throw new BaseTokenScannerException("Unclassifiable char '" + ch + "'" + " : " + Character.getNumericValue(ch) + " at line " + this.m_lineNumber + " offset " + this.m_coffset);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new BaseTokenScannerException("Indexing problem " + ex.getMessage());
        }
    }

    public void skipWhiteSpace() {
        while (!this.isEnd() && Character.isWhitespace(this.getCurrentChar())) {
            this.advance();
        }
    }

    public boolean isEnd() {
        return this.m_fIsEnd;
    }

    public void setPunctuation(String s) {
        this.m_sPunctuation = s;
    }

    public void setNesting(String sNests, String sUnnests) {
        this.m_sNests = sNests;
        this.m_sUnnests = sUnnests;
    }

    protected boolean isPunctuation(char ch) {
        return this.m_sPunctuation.indexOf(ch) >= 0;
    }

    protected boolean isNest(char ch) {
        return this.m_sNests.indexOf(ch) >= 0;
    }

    protected BaseToken scanNest(char ch) {
        ArrayList<BaseToken> otoks = new ArrayList<BaseToken>();
        char unnestChar = this.m_sUnnests.charAt(this.m_sNests.indexOf(ch));
        this.skipWhiteSpace();
        while (this.getCurrentChar() != unnestChar) {
            if (this.isEnd()) {
                throw new BaseTokenScannerException("Unexpected end of stream while looking for a " + unnestChar);
            }
            BaseToken oToken = this.next();
            if (oToken != null) {
                otoks.add(oToken);
            }
            this.skipWhiteSpace();
        }
        this.advance();
        BaseToken[] aoTok = new BaseToken[otoks.size()];
        int c = aoTok.length;
        for (int i = 0; i < c; ++i) {
            aoTok[i] = (BaseToken)otoks.get(i);
        }
        return new NestedBaseTokens(ch, unnestChar, aoTok);
    }

    protected BaseToken scanLiteral() {
        char ch = this.getCurrentChar();
        if (ch == '\"' || ch == '\'') {
            this.advance();
            this.notePos();
            while (this.getCurrentChar() != ch) {
                if (this.isEnd()) {
                    throw new BaseTokenScannerException("Unexpected end of input while processing string literal at line " + this.m_lineNumber + " offset " + this.m_coffset);
                }
                this.takeCurrentCharAndAdvance();
            }
            String st = this.tokenString();
            if (!this.isEnd()) {
                this.advance();
            }
            return LiteralBaseToken.createString(st);
        }
        if (Character.isDigit(ch)) {
            this.notePos();
            if (!this.isEnd()) {
                this.takeCurrentCharAndAdvance();
            }
            while (!this.isEnd() && Character.isDigit(this.getCurrentChar())) {
                this.takeCurrentCharAndAdvance();
            }
            if (this.isEnd()) {
                return LiteralBaseToken.createInteger(this.tokenString());
            }
            if (this.getCurrentChar() == '.') {
                return this.literalFloat();
            }
            String st = this.tokenString();
            if (!this.isEnd()) {
                char cc = this.getCurrentChar();
                if (cc == 'l' || cc == 'L') {
                    this.advance();
                    return LiteralBaseToken.createLong(st);
                }
                if (cc == 's' || cc == 'S') {
                    this.advance();
                    return LiteralBaseToken.createShort(st);
                }
                if (cc == 'd' || cc == 'D') {
                    this.advance();
                    return LiteralBaseToken.createDouble(st + ".0");
                }
                if (cc == 'f' || cc == 'F') {
                    this.advance();
                    return LiteralBaseToken.createFloat(st + ".0");
                }
            }
            return LiteralBaseToken.createInteger(st);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected LiteralBaseToken literalFloat() {
        this.takeCurrentCharAndAdvance();
        if (this.isEnd() || !Character.isDigit(this.getCurrentChar())) throw this.floatingPointFormatError();
        this.takeCurrentCharAndAdvance();
        while (!this.isEnd() && Character.isDigit(this.getCurrentChar())) {
            this.takeCurrentCharAndAdvance();
        }
        char ch = this.getCurrentChar();
        if (ch == 'E' || ch == 'e') {
            this.takeCurrentCharAndAdvance();
            if (!this.isEnd() && this.getCurrentChar() == '-') {
                this.takeCurrentCharAndAdvance();
                if (this.isEnd() || !Character.isDigit(this.getCurrentChar())) throw this.floatingPointFormatError();
                this.takeCurrentCharAndAdvance();
            } else {
                if (this.isEnd() || !Character.isDigit(this.getCurrentChar())) throw this.floatingPointFormatError();
                this.takeCurrentCharAndAdvance();
            }
            while (!this.isEnd() && Character.isDigit(this.getCurrentChar())) {
                this.takeCurrentCharAndAdvance();
            }
        }
        String st = this.tokenString();
        if (this.isEnd()) return LiteralBaseToken.createDouble(st);
        char cc = this.getCurrentChar();
        if (cc == 'd' || cc == 'D') {
            this.advance();
            return LiteralBaseToken.createDouble(st);
        }
        if (cc != 'f' && cc != 'F') return LiteralBaseToken.createDouble(st);
        this.advance();
        return LiteralBaseToken.createFloat(st);
    }

    protected BaseToken scanIdentifier() {
        if (Character.isJavaIdentifierStart(this.getCurrentChar())) {
            this.takeCurrentCharAndAdvance();
            while (!this.isEnd() && Character.isJavaIdentifierPart(this.getCurrentChar())) {
                this.takeCurrentCharAndAdvance();
            }
            return new IdentifierBaseToken(this.tokenString());
        }
        return null;
    }

    protected RuntimeException floatingPointFormatError() {
        return new BaseTokenScannerException("Invalid floating point format " + this.tokenString() + " at line " + this.m_lineNumber + " offset " + this.m_coffset);
    }

    protected boolean scanOperator() {
        char ch = this.getCurrentChar();
        switch (ch) {
            case '+': 
            case '-': 
            case ';': 
            case '?': 
            case '@': {
                this.takeCurrentCharAndAdvance();
                return true;
            }
            case '*': {
                this.takeCurrentCharAndAdvance();
                if (ch == this.getCurrentChar()) {
                    this.takeCurrentCharAndAdvance();
                }
                return true;
            }
            case '/': {
                this.takeCurrentCharAndAdvance();
                return true;
            }
            case '&': 
            case '^': 
            case '|': {
                this.takeCurrentCharAndAdvance();
                if (ch == this.getCurrentChar()) {
                    this.takeCurrentCharAndAdvance();
                }
                return true;
            }
            case '<': {
                this.takeCurrentCharAndAdvance();
                if ('=' == this.getCurrentChar() || '>' == this.getCurrentChar()) {
                    this.takeCurrentCharAndAdvance();
                }
                return true;
            }
            case ':': {
                this.takeCurrentCharAndAdvance();
                if ('=' == this.getCurrentChar()) {
                    this.takeCurrentCharAndAdvance();
                }
                return true;
            }
            case '>': {
                this.takeCurrentCharAndAdvance();
                if ('=' == this.getCurrentChar()) {
                    this.takeCurrentCharAndAdvance();
                }
                return true;
            }
            case '=': {
                this.takeCurrentCharAndAdvance();
                if (ch == this.getCurrentChar()) {
                    this.takeCurrentCharAndAdvance();
                }
                return true;
            }
            case '~': {
                this.takeCurrentCharAndAdvance();
                if (this.getCurrentChar() == '=') {
                    // empty if block
                }
                return true;
            }
            case '!': {
                this.takeCurrentCharAndAdvance();
                if (this.getCurrentChar() == '=') {
                    this.takeCurrentCharAndAdvance();
                }
                return true;
            }
        }
        return false;
    }

    protected char getCurrentChar() {
        return this.m_chCurrent;
    }

    protected void advance() {
        try {
            int nCh = this.m_reader.read();
            if (nCh != -1) {
                ++this.m_iPos;
                this.m_chCurrent = (char)nCh;
                this.m_fIsEnd = false;
                ++this.m_coffset;
                if (this.m_chCurrent == '\n') {
                    ++this.m_lineNumber;
                    this.m_coffset = 1;
                }
            } else {
                this.m_chCurrent = '\u0000';
                this.m_fIsEnd = true;
            }
        }
        catch (IOException e) {
            this.m_fIsEnd = true;
        }
    }

    protected char nextChar() {
        this.advance();
        return this.getCurrentChar();
    }

    protected void notePos() {
        this.m_iStartPos = this.m_iPos;
    }

    protected String tokenString() {
        return this.m_tokenBuffer.toString();
    }

    protected void resetTokenString() {
        this.m_tokenBuffer.setLength(0);
    }

    protected void takeCurrentChar() {
        this.m_tokenBuffer.append(this.getCurrentChar());
    }

    protected void takeCurrentCharAndAdvance() {
        this.m_tokenBuffer.append(this.getCurrentChar());
        this.advance();
    }
}

