/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.mvel.templates.res;

import com.tangosol.coherence.mvel.MVEL;
import com.tangosol.coherence.mvel.integration.VariableResolverFactory;
import com.tangosol.coherence.mvel.templates.TemplateError;
import com.tangosol.coherence.mvel.templates.TemplateRuntime;
import com.tangosol.coherence.mvel.templates.res.Node;
import com.tangosol.coherence.mvel.templates.util.TemplateOutputStream;
import com.tangosol.coherence.mvel.templates.util.TemplateTools;
import com.tangosol.coherence.mvel.util.ExecutionStack;
import com.tangosol.coherence.mvel.util.ParseTools;
import com.tangosol.coherence.mvel.util.StringAppender;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class IncludeNode
extends Node {
    private static final StackThreadLocal<ExecutionStack> relativePathStack = new StackThreadLocal();
    private char[] includeExpression;
    private char[] preExpression;

    public IncludeNode(int begin, String name, char[] template, int start, int end) {
        this.begin = begin;
        this.name = name;
        this.cStart = start;
        this.end = this.cEnd = end;
        this.contents = ParseTools.subset(template, this.cStart, this.cEnd - start - 1);
        int mark = TemplateTools.captureToEOS(this.contents, 0);
        this.includeExpression = ParseTools.subset(this.contents, 0, mark);
        if (mark != this.contents.length) {
            this.preExpression = ParseTools.subset(this.contents, ++mark, this.contents.length - mark);
        }
    }

    public Object eval(TemplateRuntime runtime, TemplateOutputStream appender, Object ctx, VariableResolverFactory factory) {
        String file = MVEL.eval(this.includeExpression, ctx, factory, String.class);
        if (this.preExpression != null) {
            MVEL.eval(this.preExpression, ctx, factory);
        }
        if (this.next != null) {
            return this.next.eval(runtime, appender.append(String.valueOf(TemplateRuntime.eval(IncludeNode.readInFile(file), ctx, factory))), ctx, factory);
        }
        return appender.append(String.valueOf(MVEL.eval(IncludeNode.readInFile(file), ctx, factory)));
    }

    public boolean demarcate(Node terminatingNode, char[] template) {
        return false;
    }

    private static Object peek() {
        return ((ExecutionStack)relativePathStack.get()).peek();
    }

    public static Object pop() {
        return ((ExecutionStack)relativePathStack.get()).pop();
    }

    private static void push(String path) {
        ((ExecutionStack)relativePathStack.get()).push(path);
    }

    public static String readInFile(String fileName) {
        File file = new File(String.valueOf(IncludeNode.peek()) + "/" + fileName);
        try {
            int read;
            FileInputStream instream = new FileInputStream(file);
            BufferedInputStream bufstream = new BufferedInputStream(instream);
            IncludeNode.push(file.getParent());
            byte[] buf = new byte[10];
            StringAppender appender = new StringAppender();
            while ((read = bufstream.read(buf)) != -1) {
                for (int i = 0; i < read; ++i) {
                    appender.append((char)buf[i]);
                }
            }
            bufstream.close();
            instream.close();
            IncludeNode.pop();
            return appender.toString();
        }
        catch (FileNotFoundException e) {
            throw new TemplateError("cannot include template '" + fileName + "': file not found.");
        }
        catch (IOException e) {
            throw new TemplateError("unknown I/O exception while including '" + fileName + "' (stacktrace nested)", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StackThreadLocal<T>
    extends ThreadLocal<T> {
        private StackThreadLocal() {
        }

        @Override
        protected T initialValue() {
            ExecutionStack stk = new ExecutionStack();
            stk.push(".");
            return (T)stk;
        }
    }
}

