/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal;

import com.tangosol.coherence.transaction.internal.ConfigHelper;
import com.tangosol.coherence.transaction.internal.ServiceContext;
import com.tangosol.coherence.transaction.internal.storage.Schema;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.DefaultConfigurableCacheFactory;
import com.tangosol.net.Service;
import com.tangosol.run.xml.XmlElement;
import java.util.HashMap;
import java.util.Map;

public class TxConfigurableCacheFactory
extends DefaultConfigurableCacheFactory {
    protected final Map<String, Map> m_mapCacheAttributes = new HashMap<String, Map>();
    private final DefaultConfigurableCacheFactory m_parent;

    public TxConfigurableCacheFactory(DefaultConfigurableCacheFactory parent, ClassLoader loader) {
        super("internal-txn-cache-config.xml", loader);
        this.m_parent = parent;
    }

    public TxConfigurableCacheFactory(DefaultConfigurableCacheFactory parent, XmlElement xmlConfig, ClassLoader loader) {
        super(xmlConfig, loader);
        this.m_parent = parent;
    }

    protected BackingMapManager instantiateManager() {
        return this.instantiateBackingMapManager(3, null);
    }

    @Override
    protected BackingMapManager instantiateBackingMapManager(int nSchemeType, XmlElement xmlScheme) {
        return new Manager();
    }

    @Override
    public XmlElement resolveScheme(DefaultConfigurableCacheFactory.CacheInfo info) {
        Map mapAttributes;
        String sTxnCache = Schema.extractLogicalTableName(info.getCacheName());
        if (sTxnCache != null && (mapAttributes = this.m_mapCacheAttributes.get(sTxnCache)) != null) {
            info.getAttributes().putAll(mapAttributes);
        }
        return super.resolveScheme(info);
    }

    protected void bootstrapTxService(Service service) {
        ServiceContext.initialize(service);
    }

    class Manager
    extends DefaultConfigurableCacheFactory.Manager {
        public Manager() {
            super(TxConfigurableCacheFactory.this);
        }

        @Override
        public void init(BackingMapManagerContext context) {
            super.init(context);
            TxConfigurableCacheFactory.this.bootstrapTxService(context.getCacheService());
        }

        @Override
        public Map instantiateBackingMap(String sName) {
            String sTxnCache = Schema.extractLogicalTableName(sName);
            if (sTxnCache != null && TxConfigurableCacheFactory.this.m_mapCacheAttributes.get(sTxnCache) == null) {
                DefaultConfigurableCacheFactory.CacheInfo infoCache = TxConfigurableCacheFactory.this.m_parent.findSchemeMapping(sTxnCache);
                XmlElement xmlScheme = TxConfigurableCacheFactory.this.m_parent.resolveScheme(infoCache);
                this.setTxnCacheAttributes(sTxnCache, xmlScheme);
            }
            return super.instantiateBackingMap(sName);
        }

        private void setTxnCacheAttributes(String sCache, XmlElement xmlScheme) {
            HashMap<String, String> mapAttributes = TxConfigurableCacheFactory.this.m_mapCacheAttributes.get(sCache);
            if (mapAttributes == null) {
                mapAttributes = new HashMap<String, String>();
                TxConfigurableCacheFactory.this.m_mapCacheAttributes.put(sCache, mapAttributes);
            }
            for (int i = 0; i < ConfigHelper.TXN_SCHEME_CACHE_ELEMENTS.length; ++i) {
                String element = ConfigHelper.TXN_SCHEME_CACHE_ELEMENTS[i];
                XmlElement xmlElement = xmlScheme.findElement(element);
                if (xmlElement == null) continue;
                mapAttributes.put(element, xmlElement.getString());
            }
        }
    }
}

