/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.xa;

import com.tangosol.coherence.transaction.TransactionId;
import com.tangosol.coherence.transaction.internal.ServiceConnection;
import com.tangosol.coherence.transaction.internal.ServiceContext;
import com.tangosol.coherence.transaction.internal.Transaction;
import com.tangosol.coherence.transaction.internal.storage.Session;
import com.tangosol.coherence.transaction.internal.xa.XABranch;
import com.tangosol.coherence.transaction.internal.xa.XAResourceImpl;
import com.tangosol.net.CacheService;
import javax.transaction.xa.XAResource;

public class XAConnection
extends ServiceConnection {
    private XAResource m_xaResource;

    public XAConnection(CacheService service) {
        super(service);
    }

    public XAConnection(CacheService service, ClassLoader loader) {
        super(service, loader);
    }

    public synchronized XAResource getXAResource() {
        if (this.m_xaResource == null) {
            this.m_xaResource = new XAResourceImpl(this, this.getSchema().getXAPreparedTable());
        }
        return this.m_xaResource;
    }

    public void associateTransaction(Transaction tx) {
        tx.setTimeout(this.m_tx.getTimeout());
        this.m_tx = tx;
        this.registerTxListener();
    }

    public void associateTransaction(boolean fAuto) {
        this.m_fAutoCommit = fAuto;
        Transaction tx = this.newTransaction();
        tx.setIsolation(this.getIsolationLevel());
        this.associateTransaction(tx);
    }

    @Override
    protected Transaction newTransaction() {
        ServiceContext context = this.getContext();
        TransactionId xid = context.getXidManager().nextXid();
        Session session = new Session();
        return new XABranch(xid, session, this.isEager(), this.isAutoCommit(), context);
    }

    public XABranch getXABranch() {
        return (XABranch)super.getTransaction();
    }
}

