/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.AnnotationDefaultAttribute;
import com.tangosol.dev.assembler.ClassFile;
import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.ConstantValueAttribute;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.DeprecatedAttribute;
import com.tangosol.dev.assembler.EnclosingMethodAttribute;
import com.tangosol.dev.assembler.ExceptionsAttribute;
import com.tangosol.dev.assembler.Field;
import com.tangosol.dev.assembler.InnerClassesAttribute;
import com.tangosol.dev.assembler.LineNumberTableAttribute;
import com.tangosol.dev.assembler.LocalVariableTableAttribute;
import com.tangosol.dev.assembler.LocalVariableTypeTableAttribute;
import com.tangosol.dev.assembler.Method;
import com.tangosol.dev.assembler.RuntimeInvisibleAnnotationsAttribute;
import com.tangosol.dev.assembler.RuntimeInvisibleParameterAnnotationsAttribute;
import com.tangosol.dev.assembler.RuntimeVisibleAnnotationsAttribute;
import com.tangosol.dev.assembler.RuntimeVisibleParameterAnnotationsAttribute;
import com.tangosol.dev.assembler.SignatureAttribute;
import com.tangosol.dev.assembler.SourceFileAttribute;
import com.tangosol.dev.assembler.SyntheticAttribute;
import com.tangosol.dev.assembler.UtfConstant;
import com.tangosol.dev.assembler.VMStructure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class Attribute
extends VMStructure
implements Constants,
Comparable {
    private static final String CLASS = "Attribute";
    private static final byte[] NO_BYTES = new byte[0];
    private VMStructure m_context;
    private UtfConstant m_utf;
    private byte[] m_ab;
    private byte[] m_abOrig;

    protected Attribute(VMStructure context, String sAttr) {
        this(context, new UtfConstant(sAttr));
    }

    protected Attribute(VMStructure context, UtfConstant utf) {
        this.m_utf = utf;
        this.m_ab = NO_BYTES;
        this.m_abOrig = NO_BYTES;
        this.m_context = context;
    }

    protected static Attribute loadAttribute(VMStructure context, DataInput stream, ConstantPool pool) throws IOException {
        UtfConstant utf = (UtfConstant)pool.getConstant(stream.readUnsignedShort());
        String sAttr = utf.getValue();
        Attribute attr = null;
        if (context instanceof Method) {
            if (sAttr.equals("Code")) {
                attr = new CodeAttribute(context);
            } else if (sAttr.equals("Exceptions")) {
                attr = new ExceptionsAttribute(context);
            } else if (sAttr.equals("Deprecated")) {
                attr = new DeprecatedAttribute(context);
            } else if (sAttr.equals("Synthetic")) {
                attr = new SyntheticAttribute(context);
            } else if (sAttr.equals("RuntimeVisibleAnnotations")) {
                attr = new RuntimeVisibleAnnotationsAttribute(context);
            } else if (sAttr.equals("RuntimeInvisibleAnnotations")) {
                attr = new RuntimeInvisibleAnnotationsAttribute(context);
            } else if (sAttr.equals("RuntimeVisibleParameterAnnotations")) {
                attr = new RuntimeVisibleParameterAnnotationsAttribute(context);
            } else if (sAttr.equals("RuntimeInvisibleParameterAnnotations")) {
                attr = new RuntimeInvisibleParameterAnnotationsAttribute(context);
            } else if (sAttr.equals("AnnotationDefault")) {
                attr = new AnnotationDefaultAttribute(context);
            } else if (sAttr.equals("Signature")) {
                attr = new SignatureAttribute(context);
            }
        } else if (context instanceof CodeAttribute) {
            if (sAttr.equals("LineNumberTable")) {
                attr = new LineNumberTableAttribute(context);
            } else if (sAttr.equals("LocalVariableTable")) {
                attr = new LocalVariableTableAttribute(context);
            } else if (sAttr.equals("LocalVariableTypeTable")) {
                attr = new LocalVariableTypeTableAttribute(context);
            }
        } else if (context instanceof Field) {
            if (sAttr.equals("ConstantValue")) {
                attr = new ConstantValueAttribute(context);
            } else if (sAttr.equals("Deprecated")) {
                attr = new DeprecatedAttribute(context);
            } else if (sAttr.equals("Synthetic")) {
                attr = new SyntheticAttribute(context);
            } else if (sAttr.equals("RuntimeVisibleAnnotations")) {
                attr = new RuntimeVisibleAnnotationsAttribute(context);
            } else if (sAttr.equals("RuntimeInvisibleAnnotations")) {
                attr = new RuntimeInvisibleAnnotationsAttribute(context);
            } else if (sAttr.equals("Signature")) {
                attr = new SignatureAttribute(context);
            }
        } else if (context instanceof ClassFile) {
            if (sAttr.equals("SourceFile")) {
                attr = new SourceFileAttribute(context);
            } else if (sAttr.equals("Deprecated")) {
                attr = new DeprecatedAttribute(context);
            } else if (sAttr.equals("Synthetic")) {
                attr = new SyntheticAttribute(context);
            } else if (sAttr.equals("InnerClasses")) {
                attr = new InnerClassesAttribute(context);
            } else if (sAttr.equals("EnclosingMethod")) {
                attr = new EnclosingMethodAttribute(context);
            } else if (sAttr.equals("RuntimeVisibleAnnotations")) {
                attr = new RuntimeVisibleAnnotationsAttribute(context);
            } else if (sAttr.equals("RuntimeInvisibleAnnotations")) {
                attr = new RuntimeInvisibleAnnotationsAttribute(context);
            }
        }
        if (attr == null) {
            attr = new Attribute(context, utf);
            pool.setOrderImportant(true);
        }
        ((Attribute)attr).disassemble(stream, pool);
        return attr;
    }

    @Override
    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        int cb = stream.readInt();
        byte[] ab = new byte[cb];
        stream.readFully(ab);
        this.m_ab = ab;
    }

    @Override
    protected void preassemble(ConstantPool pool) {
        pool.registerConstant(this.m_utf);
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        stream.writeShort(pool.findConstant(this.m_utf));
        stream.writeInt(this.m_ab.length);
        stream.write(this.m_ab);
    }

    @Override
    public String getIdentity() {
        return this.m_utf.getValue();
    }

    @Override
    public boolean isModified() {
        return this.m_ab != this.m_abOrig && !Arrays.equals(this.m_ab, this.m_abOrig);
    }

    @Override
    protected void resetModified() {
        this.m_abOrig = this.m_ab;
    }

    public int compareTo(Object obj) {
        Attribute that = (Attribute)obj;
        return this.m_utf.compareTo(that.m_utf);
    }

    public String toString() {
        return this.m_utf.getValue();
    }

    public boolean equals(Object obj) {
        try {
            Attribute that = (Attribute)obj;
            return this == that || this.getClass() == that.getClass() && this.m_utf.equals(that.m_utf) && Arrays.equals(this.getBytes(), that.getBytes());
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    protected VMStructure getContext() {
        return this.m_context;
    }

    public String getName() {
        return this.m_utf.getValue();
    }

    public UtfConstant getNameConstant() {
        return this.m_utf;
    }

    public byte[] getBytes() {
        return this.m_ab;
    }

    public void setBytes(byte[] ab) {
        this.m_ab = ab == null ? NO_BYTES : ab;
    }
}

