/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.ClassConstant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.OpConst;
import java.io.DataOutput;
import java.io.IOException;

public class Multianewarray
extends OpConst
implements Constants {
    private static final String CLASS = "Multianewarray";
    private int m_cDims;

    public Multianewarray(ClassConstant constant, int cDims) {
        super(197, constant);
        this.m_cDims = cDims;
        if (cDims < 1 || cDims > 255) {
            throw new IllegalArgumentException("Multianewarray:  Dimensions must be in the range 0x01..0xFF!");
        }
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        ClassConstant constant = (ClassConstant)super.getConstant();
        stream.writeByte(197);
        stream.writeShort(pool.findConstant(constant));
        stream.writeByte(this.m_cDims);
    }

    @Override
    protected void calculateSize(ConstantPool pool) {
        this.setSize(4);
    }

    @Override
    public int getStackChange() {
        return 1 - this.m_cDims;
    }
}

