/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.compiler.CompilerErrorInfo;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.java.Constants;
import com.tangosol.dev.compiler.java.TokenConstants;
import com.tangosol.util.Base;
import com.tangosol.util.ErrorList;
import java.util.Hashtable;

public class Token
extends Base
implements com.tangosol.dev.compiler.Token,
TokenConstants,
Constants {
    protected static final String[] CATEGORY = new String[]{null, "Identifier", "Keyword", "Literal", "Separator", "Operator", "Comment"};
    protected static final String[] LITERAL_SUBCATEGORY = new String[]{null, "Integer", "Integer", "Float", "Float", "Boolean", "Character", "String", "Null"};
    protected static final String[][] SUBCATEGORY = new String[][]{null, null, null, LITERAL_SUBCATEGORY, null, null};
    protected static final String[] DESC = new String[]{"none", "abstract", "as", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "(", ")", "{", "}", "[", "]", ";", ",", ".", "+", "-", "*", "/", "%", "<<", ">>", ">>>", "&", "|", "^", "~", "=", "+=", "-=", "*=", "/=", "%=", "<<=", ">>=", ">>>=", "&=", "|=", "^=", "==", "!=", ">", ">=", "<", "<=", "&&", "||", "!", "++", "--", "?", ":", "null", "true", "false", "char literal", "int literal", "long literal", "float literal", "double literal", "string literal", "identifier", "single-line", "traditional", "documentation"};
    public static final Token TOK_ABSTRACT = new Token(2, 0, 1, null, DESC[1]);
    public static final Token TOK_AS = new Token(2, 0, 2, null, DESC[2]);
    public static final Token TOK_BOOLEAN = new Token(2, 0, 3, null, DESC[3]);
    public static final Token TOK_BREAK = new Token(2, 0, 4, null, DESC[4]);
    public static final Token TOK_BYTE = new Token(2, 0, 5, null, DESC[5]);
    public static final Token TOK_CASE = new Token(2, 0, 6, null, DESC[6]);
    public static final Token TOK_CATCH = new Token(2, 0, 7, null, DESC[7]);
    public static final Token TOK_CHAR = new Token(2, 0, 8, null, DESC[8]);
    public static final Token TOK_CLASS = new Token(2, 0, 9, null, DESC[9]);
    public static final Token TOK_CONST = new Token(2, 0, 10, null, DESC[10]);
    public static final Token TOK_CONTINUE = new Token(2, 0, 11, null, DESC[11]);
    public static final Token TOK_DEFAULT = new Token(2, 0, 12, null, DESC[12]);
    public static final Token TOK_DO = new Token(2, 0, 13, null, DESC[13]);
    public static final Token TOK_DOUBLE = new Token(2, 0, 14, null, DESC[14]);
    public static final Token TOK_ELSE = new Token(2, 0, 15, null, DESC[15]);
    public static final Token TOK_EXTENDS = new Token(2, 0, 16, null, DESC[16]);
    public static final Token TOK_FINAL = new Token(2, 0, 17, null, DESC[17]);
    public static final Token TOK_FINALLY = new Token(2, 0, 18, null, DESC[18]);
    public static final Token TOK_FLOAT = new Token(2, 0, 19, null, DESC[19]);
    public static final Token TOK_FOR = new Token(2, 0, 20, null, DESC[20]);
    public static final Token TOK_GOTO = new Token(2, 0, 21, null, DESC[21]);
    public static final Token TOK_IF = new Token(2, 0, 22, null, DESC[22]);
    public static final Token TOK_IMPLEMENTS = new Token(2, 0, 23, null, DESC[23]);
    public static final Token TOK_IMPORT = new Token(2, 0, 24, null, DESC[24]);
    public static final Token TOK_INSTANCEOF = new Token(2, 0, 25, null, DESC[25]);
    public static final Token TOK_INT = new Token(2, 0, 26, null, DESC[26]);
    public static final Token TOK_INTERFACE = new Token(2, 0, 27, null, DESC[27]);
    public static final Token TOK_LONG = new Token(2, 0, 28, null, DESC[28]);
    public static final Token TOK_NATIVE = new Token(2, 0, 29, null, DESC[29]);
    public static final Token TOK_NEW = new Token(2, 0, 30, null, DESC[30]);
    public static final Token TOK_PACKAGE = new Token(2, 0, 31, null, DESC[31]);
    public static final Token TOK_PRIVATE = new Token(2, 0, 32, null, DESC[32]);
    public static final Token TOK_PROTECTED = new Token(2, 0, 33, null, DESC[33]);
    public static final Token TOK_PUBLIC = new Token(2, 0, 34, null, DESC[34]);
    public static final Token TOK_RETURN = new Token(2, 0, 35, null, DESC[35]);
    public static final Token TOK_SHORT = new Token(2, 0, 36, null, DESC[36]);
    public static final Token TOK_STATIC = new Token(2, 0, 37, null, DESC[37]);
    public static final Token TOK_STRICTFP = new Token(2, 0, 38, null, DESC[38]);
    public static final Token TOK_SUPER = new Token(2, 0, 39, null, DESC[39]);
    public static final Token TOK_SWITCH = new Token(2, 0, 40, null, DESC[40]);
    public static final Token TOK_SYNCHRONIZED = new Token(2, 0, 41, null, DESC[41]);
    public static final Token TOK_THIS = new Token(2, 0, 42, null, DESC[42]);
    public static final Token TOK_THROW = new Token(2, 0, 43, null, DESC[43]);
    public static final Token TOK_THROWS = new Token(2, 0, 44, null, DESC[44]);
    public static final Token TOK_TRANSIENT = new Token(2, 0, 45, null, DESC[45]);
    public static final Token TOK_TRY = new Token(2, 0, 46, null, DESC[46]);
    public static final Token TOK_VOID = new Token(2, 0, 47, null, DESC[47]);
    public static final Token TOK_VOLATILE = new Token(2, 0, 48, null, DESC[48]);
    public static final Token TOK_WHILE = new Token(2, 0, 49, null, DESC[49]);
    public static final Token TOK_NULL = new Token(3, 8, 96, null, DESC[96]);
    public static final Token TOK_TRUE = new Token(3, 5, 97, Boolean.TRUE, DESC[97]);
    public static final Token TOK_FALSE = new Token(3, 5, 98, Boolean.FALSE, DESC[98]);
    public static final Token TOK_LPARENTHESIS = new Token(4, 0, 50, null, DESC[50]);
    public static final Token TOK_RPARENTHESIS = new Token(4, 0, 51, null, DESC[51]);
    public static final Token TOK_LCURLYBRACE = new Token(4, 0, 52, null, DESC[52]);
    public static final Token TOK_RCURLYBRACE = new Token(4, 0, 53, null, DESC[53]);
    public static final Token TOK_LBRACKET = new Token(4, 0, 54, null, DESC[54]);
    public static final Token TOK_RBRACKET = new Token(4, 0, 55, null, DESC[55]);
    public static final Token TOK_SEMICOLON = new Token(4, 0, 56, null, DESC[56]);
    public static final Token TOK_COMMA = new Token(4, 0, 57, null, DESC[57]);
    public static final Token TOK_DOT = new Token(4, 0, 58, null, DESC[58]);
    public static final Token TOK_ADD = new Token(5, 0, 59, null, DESC[59]);
    public static final Token TOK_SUB = new Token(5, 0, 60, null, DESC[60]);
    public static final Token TOK_MUL = new Token(5, 0, 61, null, DESC[61]);
    public static final Token TOK_DIV = new Token(5, 0, 62, null, DESC[62]);
    public static final Token TOK_REM = new Token(5, 0, 63, null, DESC[63]);
    public static final Token TOK_SHL = new Token(5, 0, 64, null, DESC[64]);
    public static final Token TOK_SHR = new Token(5, 0, 65, null, DESC[65]);
    public static final Token TOK_USHR = new Token(5, 0, 66, null, DESC[66]);
    public static final Token TOK_BITAND = new Token(5, 0, 67, null, DESC[67]);
    public static final Token TOK_BITOR = new Token(5, 0, 68, null, DESC[68]);
    public static final Token TOK_BITXOR = new Token(5, 0, 69, null, DESC[69]);
    public static final Token TOK_BITNOT = new Token(5, 0, 70, null, DESC[70]);
    public static final Token TOK_ASSIGN = new Token(5, 0, 71, null, DESC[71]);
    public static final Token TOK_ASSIGN_ADD = new Token(5, 0, 72, null, DESC[72]);
    public static final Token TOK_ASSIGN_SUB = new Token(5, 0, 73, null, DESC[73]);
    public static final Token TOK_ASSIGN_MUL = new Token(5, 0, 74, null, DESC[74]);
    public static final Token TOK_ASSIGN_DIV = new Token(5, 0, 75, null, DESC[75]);
    public static final Token TOK_ASSIGN_REM = new Token(5, 0, 76, null, DESC[76]);
    public static final Token TOK_ASSIGN_SHL = new Token(5, 0, 77, null, DESC[77]);
    public static final Token TOK_ASSIGN_SHR = new Token(5, 0, 78, null, DESC[78]);
    public static final Token TOK_ASSIGN_USHR = new Token(5, 0, 79, null, DESC[79]);
    public static final Token TOK_ASSIGN_BITAND = new Token(5, 0, 80, null, DESC[80]);
    public static final Token TOK_ASSIGN_BITOR = new Token(5, 0, 81, null, DESC[81]);
    public static final Token TOK_ASSIGN_BITXOR = new Token(5, 0, 82, null, DESC[82]);
    public static final Token TOK_TEST_EQ = new Token(5, 0, 83, null, DESC[83]);
    public static final Token TOK_TEST_NE = new Token(5, 0, 84, null, DESC[84]);
    public static final Token TOK_TEST_GT = new Token(5, 0, 85, null, DESC[85]);
    public static final Token TOK_TEST_GE = new Token(5, 0, 86, null, DESC[86]);
    public static final Token TOK_TEST_LT = new Token(5, 0, 87, null, DESC[87]);
    public static final Token TOK_TEST_LE = new Token(5, 0, 88, null, DESC[88]);
    public static final Token TOK_LOGICAL_AND = new Token(5, 0, 89, null, DESC[89]);
    public static final Token TOK_LOGICAL_OR = new Token(5, 0, 90, null, DESC[90]);
    public static final Token TOK_LOGICAL_NOT = new Token(5, 0, 91, null, DESC[91]);
    public static final Token TOK_INCREMENT = new Token(5, 0, 92, null, DESC[92]);
    public static final Token TOK_DECREMENT = new Token(5, 0, 93, null, DESC[93]);
    public static final Token TOK_CONDITIONAL = new Token(5, 0, 94, null, DESC[94]);
    public static final Token TOK_COLON = new Token(5, 0, 95, null, DESC[95]);
    protected int cat;
    protected int subcat;
    protected int id;
    protected Object value;
    protected String text;
    protected int line;
    protected int offset;
    protected int length;

    public Token(int nCategory, int nSubCategory, int nTokenID, Object oValue, String sText) {
        this(nCategory, nSubCategory, nTokenID, oValue, sText, -1, -1, -1);
    }

    public Token(Token that, int iLine, int ofInLine, int cchToken) {
        this(that.cat, that.subcat, that.id, that.value, that.text, iLine, ofInLine, cchToken);
    }

    public Token(int nCategory, int nSubCategory, int nTokenID, Object oValue, String sText, int iLine, int ofInLine, int cchToken) {
        this.cat = nCategory;
        this.subcat = nSubCategory;
        this.id = nTokenID;
        this.value = oValue;
        this.text = sText;
        this.line = iLine;
        this.offset = ofInLine;
        this.length = cchToken;
    }

    @Override
    public int getCategory() {
        return this.cat;
    }

    @Override
    public int getSubCategory() {
        return this.subcat;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void adjust(int dLine, int dOffset) {
        this.line += dLine;
        if (this.line < 0) {
            this.line = 0;
        }
        this.offset += dOffset;
        if (this.offset < 0) {
            this.offset = 0;
        }
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("(" + this.getLine() + ',' + this.getOffset() + ',' + this.getLength() + ") ");
        if (this.subcat != 0) {
            sb.append(SUBCATEGORY[this.cat][this.subcat]).append(' ');
        }
        sb.append(CATEGORY[this.cat]).append(' ');
        return sb.append(this.getText()).toString();
    }

    protected void logError(int nSeverity, String sCode, String[] asParams, ErrorList errlist) throws CompilerException {
        if (errlist != null) {
            try {
                errlist.add(new CompilerErrorInfo(nSeverity, sCode, RESOURCES, asParams, this.line, this.offset, this.length));
            }
            catch (ErrorList.OverflowException e) {
                throw new CompilerException();
            }
        }
    }

    public static boolean isSimpleNameLegal(String sName) {
        char[] ach = sName.toCharArray();
        int cch = ach.length;
        if (cch < 1 || !Character.isJavaIdentifierStart(ach[0])) {
            return false;
        }
        for (int i = 1; i < cch; ++i) {
            if (Character.isJavaIdentifierPart(ach[i])) continue;
            return false;
        }
        return !RESERVED.containsKey(sName);
    }

    public static boolean isQualifiedNameLegal(String sName) {
        int cch = sName.length();
        if (cch < 1) {
            return false;
        }
        int ofStart = 0;
        while (ofStart < cch) {
            int ofEnd = sName.indexOf(46, ofStart);
            if (ofEnd == cch - 1) {
                return false;
            }
            if (ofEnd < 0) {
                ofEnd = cch;
            }
            if (!Token.isSimpleNameLegal(sName.substring(ofStart, ofEnd))) {
                return false;
            }
            ofStart = ofEnd + 1;
        }
        return true;
    }

    public static Hashtable getReservedWords() {
        return (Hashtable)RESERVED.clone();
    }

    public static String getDescription(int id) {
        return DESC[id];
    }

    static {
        RESERVED.put(TOK_ABSTRACT.getText(), TOK_ABSTRACT);
        RESERVED.put(TOK_AS.getText(), TOK_AS);
        RESERVED.put(TOK_BOOLEAN.getText(), TOK_BOOLEAN);
        RESERVED.put(TOK_BREAK.getText(), TOK_BREAK);
        RESERVED.put(TOK_BYTE.getText(), TOK_BYTE);
        RESERVED.put(TOK_CASE.getText(), TOK_CASE);
        RESERVED.put(TOK_CATCH.getText(), TOK_CATCH);
        RESERVED.put(TOK_CHAR.getText(), TOK_CHAR);
        RESERVED.put(TOK_CLASS.getText(), TOK_CLASS);
        RESERVED.put(TOK_CONST.getText(), TOK_CONST);
        RESERVED.put(TOK_CONTINUE.getText(), TOK_CONTINUE);
        RESERVED.put(TOK_DEFAULT.getText(), TOK_DEFAULT);
        RESERVED.put(TOK_DO.getText(), TOK_DO);
        RESERVED.put(TOK_DOUBLE.getText(), TOK_DOUBLE);
        RESERVED.put(TOK_ELSE.getText(), TOK_ELSE);
        RESERVED.put(TOK_EXTENDS.getText(), TOK_EXTENDS);
        RESERVED.put(TOK_FALSE.getText(), TOK_FALSE);
        RESERVED.put(TOK_FINAL.getText(), TOK_FINAL);
        RESERVED.put(TOK_FINALLY.getText(), TOK_FINALLY);
        RESERVED.put(TOK_FLOAT.getText(), TOK_FLOAT);
        RESERVED.put(TOK_FOR.getText(), TOK_FOR);
        RESERVED.put(TOK_GOTO.getText(), TOK_GOTO);
        RESERVED.put(TOK_IF.getText(), TOK_IF);
        RESERVED.put(TOK_IMPLEMENTS.getText(), TOK_IMPLEMENTS);
        RESERVED.put(TOK_IMPORT.getText(), TOK_IMPORT);
        RESERVED.put(TOK_INSTANCEOF.getText(), TOK_INSTANCEOF);
        RESERVED.put(TOK_INT.getText(), TOK_INT);
        RESERVED.put(TOK_INTERFACE.getText(), TOK_INTERFACE);
        RESERVED.put(TOK_LONG.getText(), TOK_LONG);
        RESERVED.put(TOK_NATIVE.getText(), TOK_NATIVE);
        RESERVED.put(TOK_NEW.getText(), TOK_NEW);
        RESERVED.put(TOK_NULL.getText(), TOK_NULL);
        RESERVED.put(TOK_PACKAGE.getText(), TOK_PACKAGE);
        RESERVED.put(TOK_PRIVATE.getText(), TOK_PRIVATE);
        RESERVED.put(TOK_PROTECTED.getText(), TOK_PROTECTED);
        RESERVED.put(TOK_PUBLIC.getText(), TOK_PUBLIC);
        RESERVED.put(TOK_RETURN.getText(), TOK_RETURN);
        RESERVED.put(TOK_SHORT.getText(), TOK_SHORT);
        RESERVED.put(TOK_STATIC.getText(), TOK_STATIC);
        RESERVED.put(TOK_SUPER.getText(), TOK_SUPER);
        RESERVED.put(TOK_SWITCH.getText(), TOK_SWITCH);
        RESERVED.put(TOK_SYNCHRONIZED.getText(), TOK_SYNCHRONIZED);
        RESERVED.put(TOK_THIS.getText(), TOK_THIS);
        RESERVED.put(TOK_THROW.getText(), TOK_THROW);
        RESERVED.put(TOK_THROWS.getText(), TOK_THROWS);
        RESERVED.put(TOK_TRANSIENT.getText(), TOK_TRANSIENT);
        RESERVED.put(TOK_TRUE.getText(), TOK_TRUE);
        RESERVED.put(TOK_TRY.getText(), TOK_TRY);
        RESERVED.put(TOK_VOID.getText(), TOK_VOID);
        RESERVED.put(TOK_VOLATILE.getText(), TOK_VOLATILE);
        RESERVED.put(TOK_WHILE.getText(), TOK_WHILE);
    }
}

