/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.nio;

import com.tangosol.io.OutputStreaming;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ReadOnlyBufferException;

public class ByteBufferOutputStream
extends OutputStream
implements OutputStreaming {
    private ByteBuffer m_buf;

    public ByteBufferOutputStream(ByteBuffer buffer) {
        this.m_buf = buffer;
    }

    public ByteBuffer getByteBuffer() {
        return this.m_buf;
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.getByteBuffer().put((byte)b);
        }
        catch (NullPointerException e) {
            throw this.potentialStreamClosedException(e);
        }
        catch (BufferOverflowException e) {
            throw new IOException("stream capacity exceeded" + ByteBufferOutputStream.includeMessage(e));
        }
        catch (ReadOnlyBufferException e) {
            throw new IOException("stream is read-only" + ByteBufferOutputStream.includeMessage(e));
        }
    }

    @Override
    public void write(byte[] abSrc, int ofSrc, int cbSrc) throws IOException {
        if (abSrc == null || ofSrc < 0 || cbSrc < 0 || ofSrc + cbSrc > abSrc.length) {
            throw new IllegalArgumentException(abSrc == null ? "null buffer" : "abSrc.length=" + abSrc.length + ", ofSrc=" + ofSrc + ", cbSrc=" + cbSrc);
        }
        try {
            this.getByteBuffer().put(abSrc, ofSrc, cbSrc);
        }
        catch (NullPointerException e) {
            throw this.potentialStreamClosedException(e);
        }
        catch (BufferOverflowException e) {
            throw new IOException("stream capacity exceeded" + ByteBufferOutputStream.includeMessage(e));
        }
        catch (ReadOnlyBufferException e) {
            throw new IOException("stream is read-only" + ByteBufferOutputStream.includeMessage(e));
        }
    }

    @Override
    public void flush() throws IOException {
        ByteBuffer buf = this.getByteBuffer();
        if (buf instanceof MappedByteBuffer) {
            try {
                ((MappedByteBuffer)buf).force();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.m_buf = null;
    }

    protected static String includeMessage(Throwable e) {
        String s = e.getMessage();
        return s == null || s.length() == 0 ? "" : ": \"" + s + '\"';
    }

    protected NullPointerException potentialStreamClosedException(NullPointerException e) throws IOException {
        if (this.getByteBuffer() == null) {
            throw new IOException("stream closed");
        }
        throw e;
    }
}

