/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.net.Guardable;
import com.tangosol.net.Guardian;
import com.tangosol.util.Base;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class GuardSupport
extends Base {
    public static final long GUARDIAN_MAX_CHECK_INTERVAL = 5000L;
    protected static final long GUARDIAN_LATE_THRESHOLD = 10000L;
    protected static final long GUARDIAN_EARLY_THRESHOLD = 500L;
    protected static final long GUARDIAN_LOG_INTERVAL = 3000L;
    protected Context[] m_aGuardContext = new Context[5];
    protected int m_cGuardable;
    protected Guardian m_guardian;
    protected long m_ldtNextCheck;
    protected static ThreadLocal m_tlContext = new ThreadLocal();
    protected static AtomicLong s_atomicLogTime = new AtomicLong();

    public GuardSupport(Guardian guardian) {
        this.m_guardian = guardian;
    }

    protected Context[] getGuardContexts() {
        return this.m_aGuardContext;
    }

    protected void setGuardContexts(Context[] aGuardContext) {
        this.m_aGuardContext = aGuardContext;
    }

    protected Guardian getGuardian() {
        return this.m_guardian;
    }

    public long getNextCheckTime() {
        return this.m_ldtNextCheck;
    }

    protected void setNextCheckTime(long ldtNextCheck) {
        this.m_ldtNextCheck = ldtNextCheck;
    }

    public synchronized Guardian.GuardContext add(Guardable guardable, long cMillis, float flPctRecover) {
        Context context = this.instantiateContext(guardable, cMillis, flPctRecover);
        Context[] aContext = this.getGuardContexts();
        int cGuardable = this.getGuardableCount();
        int cElements = aContext.length;
        int iContext = -1;
        if (cElements == cGuardable) {
            Context[] aContextNew = new Context[cGuardable + 5];
            System.arraycopy(aContext, 0, aContextNew, 0, cGuardable);
            aContext = aContextNew;
            this.setGuardContexts(aContextNew);
            iContext = cGuardable;
        } else {
            for (int i = 0; i < cElements; ++i) {
                if (aContext[i] != null) continue;
                iContext = i;
                break;
            }
        }
        aContext[iContext] = context;
        this.setGuardableCount(cGuardable + 1);
        guardable.setContext(context);
        context.heartbeat();
        return context;
    }

    public synchronized void remove(Guardable guardable) {
        for (Context context : this.getGuardContexts()) {
            if (context == null || !Base.equals(context.getGuardable(), guardable)) continue;
            aContext[i] = null;
            this.setGuardableCount(this.getGuardableCount() - 1);
            return;
        }
    }

    public int getGuardableCount() {
        return this.m_cGuardable;
    }

    protected void setGuardableCount(int cGuardable) {
        this.m_cGuardable = cGuardable;
        if (cGuardable == 0) {
            this.setNextCheckTime(0L);
        }
    }

    public long check() {
        long ldtScheduledCheck;
        long ldtNow = Base.getSafeTimeMillis();
        long cLateMillis = ldtNow - (ldtScheduledCheck = this.getNextCheckTime());
        if (-cLateMillis > 500L) {
            return 0L;
        }
        if (cLateMillis > 10000L && ldtScheduledCheck > 0L) {
            long ldtNextCheck = ldtNow + 5000L;
            this.setNextCheckTime(ldtNextCheck);
            return cLateMillis;
        }
        long ldtTimeoutMin = ldtNow + 1000L;
        for (Context context : this.getGuardContexts()) {
            if (context == null) continue;
            long ldtTimeoutThis = context.getSoftTimeout();
            switch (context.getState()) {
                case 1: {
                    if (!context.isSuspect(ldtNow)) break;
                    context.setState(2);
                    context.onRecovery();
                    long cRecoveryMillis = context.getRecoveryMillis();
                    context.setTimeout(ldtNow + cRecoveryMillis);
                    ldtTimeoutThis = Math.min(context.getTimeout(), ldtNow + 100L);
                    break;
                }
                case 2: {
                    if (!context.isSuspect(ldtNow)) {
                        context.setState(1);
                        context.setMissedSoftTimeout(0L);
                        context.setTimeout(0L);
                        ldtTimeoutThis = Math.max(ldtTimeoutThis, ldtNow);
                        break;
                    }
                    if (context.isTimedOut(ldtNow)) {
                        context.setState(3);
                        context.onTerminate();
                        context.release();
                        ldtTimeoutThis = Long.MAX_VALUE;
                        break;
                    }
                    ldtTimeoutThis = Math.min(context.getTimeout(), ldtNow + 100L);
                    break;
                }
                default: {
                    Base.err("Unexpected GuardContext state " + context);
                }
            }
            ldtTimeoutMin = Math.min(ldtTimeoutMin, ldtTimeoutThis);
        }
        this.setNextCheckTime(Math.max(ldtScheduledCheck, ldtTimeoutMin));
        return 0L;
    }

    public synchronized void release() {
        for (Context context : this.getGuardContexts()) {
            if (context != null) {
                context.release();
            }
            aContext[i] = null;
        }
        this.setGuardableCount(0);
    }

    protected Context instantiateContext(Guardable guardable, long cMillis, float flPctRecover) {
        return new Context(guardable, cMillis, flPctRecover);
    }

    public static Guardian.GuardContext getThreadContext() {
        return (Guardian.GuardContext)m_tlContext.get();
    }

    public static void setThreadContext(Guardian.GuardContext context) {
        m_tlContext.set(context);
    }

    public static void heartbeat() {
        Guardian.GuardContext context = GuardSupport.getThreadContext();
        if (context != null) {
            context.heartbeat();
        }
    }

    public static void heartbeat(long cMillis) {
        Guardian.GuardContext context = GuardSupport.getThreadContext();
        if (context != null) {
            context.heartbeat(cMillis);
        }
    }

    public static void logStackTraces() {
        AtomicLong atomicLogTime = s_atomicLogTime;
        long ldtNow = GuardSupport.getSafeTimeMillis();
        long ldtLast = atomicLogTime.get();
        long ldtNext = ldtNow + 3000L;
        if (ldtNow < ldtLast + 3000L || !atomicLogTime.compareAndSet(ldtLast, ldtNext)) {
            return;
        }
        StringBuffer sBuf = new StringBuffer();
        Map<Thread, StackTraceElement[]> mapTrace = Thread.getAllStackTraces();
        sBuf.append("Full Thread Dump\n");
        for (Map.Entry<Thread, StackTraceElement[]> entry : mapTrace.entrySet()) {
            Thread thread = entry.getKey();
            StackTraceElement[] aStackElement = entry.getValue();
            sBuf.append("\n");
            sBuf.append(thread);
            sBuf.append("\n");
            int cElement = aStackElement.length;
            for (int i = 0; i < cElement; ++i) {
                sBuf.append("\t");
                sBuf.append(aStackElement[i]);
                sBuf.append("\n");
            }
        }
        Base.err(sBuf.toString());
    }

    protected class Context
    implements Guardian.GuardContext {
        protected volatile int m_nState = 1;
        protected boolean m_fHeartbeatDefault;
        protected long m_ldtTimeout;
        protected volatile long m_cRecoveryMillis;
        protected volatile long m_ldtSoftTimeout = Long.MAX_VALUE;
        protected Guardable m_guardable;
        protected long m_cTimeoutMillis;
        protected long m_cSoftTimeoutMillis;
        protected long m_ldtLastMissedSoftTimeout;
        protected float m_flPctRecover;

        protected Context(Guardable guardable, long cTimeoutMillis, float flPctRecover) {
            if (guardable == null || cTimeoutMillis <= 0L || flPctRecover <= 0.0f || flPctRecover > 1.0f) {
                throw new IllegalArgumentException("guardable=" + guardable + ", timeout=" + cTimeoutMillis + ", recover=" + flPctRecover);
            }
            this.m_guardable = guardable;
            this.m_cTimeoutMillis = cTimeoutMillis;
            this.m_cSoftTimeoutMillis = Math.max(1L, (long)((float)cTimeoutMillis * flPctRecover));
            this.m_flPctRecover = flPctRecover;
        }

        protected void setState(int nState) {
            this.m_nState = nState;
        }

        protected long getTimeout() {
            return this.m_ldtTimeout;
        }

        protected void setTimeout(long ldtTimeout) {
            this.m_ldtTimeout = ldtTimeout;
        }

        protected long getSoftTimeout() {
            return this.m_ldtSoftTimeout;
        }

        protected void setSoftTimeout(long ldtSoftTimeout) {
            this.m_ldtSoftTimeout = ldtSoftTimeout;
        }

        protected long getRecoveryMillis() {
            return this.m_cRecoveryMillis;
        }

        protected void setRecoveryMillis(long cRecoveryMillis) {
            this.m_cRecoveryMillis = cRecoveryMillis;
        }

        protected long getMissedSoftTimeout() {
            return this.m_ldtLastMissedSoftTimeout;
        }

        protected void setMissedSoftTimeout(long ldtSoftTimeout) {
            this.m_ldtLastMissedSoftTimeout = ldtSoftTimeout;
        }

        protected boolean isTimedOut(long ldtNow) {
            return ldtNow > this.getTimeout();
        }

        protected boolean isSuspect(long ldtNow) {
            long ldtSoftTimeout = this.getSoftTimeout();
            long ldtMissedSoftTimeout = this.getMissedSoftTimeout();
            return ldtNow > ldtSoftTimeout && (ldtSoftTimeout == ldtMissedSoftTimeout || ldtMissedSoftTimeout == 0L);
        }

        public String toString() {
            String sState;
            int nState = this.getState();
            switch (nState) {
                case 1: {
                    sState = "HEALTHY";
                    break;
                }
                case 2: {
                    sState = "RECOVERY";
                    break;
                }
                case 3: {
                    sState = "TERMINATING";
                    break;
                }
                default: {
                    sState = "{Unknown State: " + nState + "}";
                }
            }
            return "GuardContext {Guardable=" + this.getGuardable() + ", timeout=" + this.getTimeout() + ", state=" + sState + "}";
        }

        @Override
        public Guardian getGuardian() {
            return GuardSupport.this.getGuardian();
        }

        @Override
        public Guardable getGuardable() {
            return this.m_guardable;
        }

        @Override
        public void heartbeat() {
            long ldtNow = Base.getSafeTimeMillis();
            if (!this.m_fHeartbeatDefault) {
                this.setRecoveryMillis(this.m_cTimeoutMillis - this.m_cSoftTimeoutMillis);
                this.m_fHeartbeatDefault = true;
            }
            this.setSoftTimeout(ldtNow + this.m_cSoftTimeoutMillis);
        }

        @Override
        public void heartbeat(long cMillis) {
            long ldtNow = Base.getSafeTimeMillis();
            long cSoftTimeout = (long)((float)cMillis * this.m_flPctRecover);
            Base.azzert(cMillis > 0L, "Invalid heartbeat interval");
            this.setRecoveryMillis(cMillis - cSoftTimeout);
            this.m_fHeartbeatDefault = false;
            this.setSoftTimeout(ldtNow + Math.max(1L, cSoftTimeout));
        }

        @Override
        public int getState() {
            return this.m_nState;
        }

        @Override
        public void release() {
            Guardable guardable = this.getGuardable();
            guardable.setContext(null);
            GuardSupport.this.remove(guardable);
        }

        @Override
        public long getSoftTimeoutMillis() {
            return this.m_cSoftTimeoutMillis;
        }

        protected void onRecovery() {
            final Guardable guardable = this.getGuardable();
            long ldtSoftTimeout = this.getSoftTimeout();
            long cMillisLate = Base.getSafeTimeMillis() - ldtSoftTimeout;
            Base.err("Detected soft timeout" + (cMillisLate > 1000L ? " " + cMillisLate + "ms ago)" : ")") + " of " + guardable);
            this.setMissedSoftTimeout(ldtSoftTimeout);
            Base.makeThread(null, new Runnable(){

                @Override
                public void run() {
                    guardable.recover();
                }
            }, "Recovery Thread").start();
        }

        protected void onTerminate() {
            final Guardable guardable = this.getGuardable();
            long cMillisLate = Base.getSafeTimeMillis() - this.getTimeout();
            Base.err("Detected hard timeout" + (cMillisLate > 1000L ? " " + cMillisLate + "ms ago)" : ")") + " of " + guardable);
            Base.makeThread(null, new Runnable(){

                @Override
                public void run() {
                    guardable.terminate();
                }
            }, "Termination Thread").start();
        }
    }
}

