/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.partition;

import com.tangosol.net.BackingMapManager;
import com.tangosol.net.cache.ConfigurableCacheMap;
import com.tangosol.net.partition.ObservableSplittingBackingMap;
import com.tangosol.util.AbstractKeyBasedMap;
import com.tangosol.util.AbstractKeySetBasedMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ObservableSplittingBackingCache
extends ObservableSplittingBackingMap
implements ConfigurableCacheMap {
    protected static final int PROP_UNITS = 0;
    protected static final int PROP_HIGH_UNITS = 1;
    protected static final int PROP_LOW_UNITS = 2;
    protected int m_cHighUnits = -1;
    protected int m_cLowUnits = -1;
    protected int m_nUnitFactor = -1;
    protected int m_cExpiryDelayMillis = -1;
    protected int m_cFlushDelayMillis = -1;
    protected ConfigurableCacheMap.EvictionPolicy m_policy;
    protected ConfigurableCacheMap.UnitCalculator m_calculator;
    protected ConfigurableCacheMap[] m_acache;

    public ObservableSplittingBackingCache(BackingMapManager bmm, String sName) {
        super(bmm, sName);
    }

    @Override
    public void createPartition(int nPid) {
        super.createPartition(nPid);
        Map map = super.getPartitionMap(nPid);
        if (map instanceof ConfigurableCacheMap) {
            ConfigurableCacheMap.UnitCalculator calculator;
            ConfigurableCacheMap.EvictionPolicy policy;
            int cFlushDelayMillis;
            int cExpiryDelayMillis;
            ConfigurableCacheMap cache = (ConfigurableCacheMap)map;
            int nUnitFactor = this.m_nUnitFactor;
            if (nUnitFactor != -1) {
                cache.setUnitFactor(nUnitFactor);
            }
            if ((cExpiryDelayMillis = this.m_cExpiryDelayMillis) != -1) {
                cache.setExpiryDelay(cExpiryDelayMillis);
            }
            if ((cFlushDelayMillis = this.m_cFlushDelayMillis) != -1) {
                cache.setFlushDelay(cFlushDelayMillis);
            }
            if ((policy = this.m_policy) != null) {
                cache.setEvictionPolicy(policy);
            }
            if ((calculator = this.m_calculator) != null) {
                cache.setUnitCalculator(calculator);
            }
        } else {
            super.destroyPartition(nPid);
            throw new IllegalStateException("Partition backing map " + (map == null ? "is null" : map.getClass().getName() + " does not implement ConfigurableCacheMap"));
        }
        this.repartition();
    }

    @Override
    public void destroyPartition(int nPid) {
        super.destroyPartition(nPid);
        this.repartition();
    }

    @Override
    public int getUnits() {
        return this.calculateUnits(0);
    }

    @Override
    public int getHighUnits() {
        return this.calculateUnits(1);
    }

    @Override
    public void setHighUnits(int cMax) {
        if (cMax != this.m_cHighUnits && cMax >= 0) {
            this.m_cHighUnits = cMax;
            this.partitionUnits(1);
            this.partitionUnits(2);
        }
    }

    @Override
    public int getLowUnits() {
        return this.calculateUnits(2);
    }

    @Override
    public void setLowUnits(int cUnits) {
        if (cUnits != this.m_cLowUnits && cUnits >= 0) {
            this.m_cLowUnits = cUnits;
            this.partitionUnits(2);
        }
    }

    @Override
    public int getUnitFactor() {
        ConfigurableCacheMap map;
        int nFactor = this.m_nUnitFactor;
        if (nFactor < 0 && (map = this.getFirstPartitionCache()) != null) {
            nFactor = map.getUnitFactor();
        }
        return nFactor;
    }

    @Override
    public void setUnitFactor(int nFactor) {
        if (nFactor != this.m_nUnitFactor && nFactor > 0) {
            ConfigurableCacheMap[] amap = this.getPartitionCacheArray();
            int c = amap.length;
            for (int i = 0; i < c; ++i) {
                amap[i].setUnitFactor(nFactor);
            }
            this.m_nUnitFactor = nFactor;
        }
    }

    @Override
    public ConfigurableCacheMap.EvictionPolicy getEvictionPolicy() {
        ConfigurableCacheMap map;
        ConfigurableCacheMap.EvictionPolicy policy = this.m_policy;
        if (policy == null && (map = this.getFirstPartitionCache()) != null) {
            policy = map.getEvictionPolicy();
        }
        return policy;
    }

    @Override
    public void setEvictionPolicy(ConfigurableCacheMap.EvictionPolicy policy) {
        if (policy != this.m_policy) {
            ConfigurableCacheMap[] amap = this.getPartitionCacheArray();
            int c = amap.length;
            for (int i = 0; i < c; ++i) {
                amap[i].setEvictionPolicy(policy);
            }
            this.m_policy = policy;
        }
    }

    @Override
    public void evict(Object oKey) {
        this.getPartitionCache(oKey).evict(oKey);
    }

    @Override
    public void evictAll(Collection colKeys) {
        Iterator iter = colKeys.iterator();
        while (iter.hasNext()) {
            this.evict(iter.next());
        }
    }

    @Override
    public void evict() {
        ConfigurableCacheMap[] amap = this.getPartitionCacheArray();
        int c = amap.length;
        for (int i = 0; i < c; ++i) {
            amap[i].evict();
        }
    }

    @Override
    public int getExpiryDelay() {
        ConfigurableCacheMap map;
        int cMillis = this.m_cExpiryDelayMillis;
        if (cMillis < 0 && (map = this.getFirstPartitionCache()) != null) {
            cMillis = map.getExpiryDelay();
        }
        return cMillis;
    }

    @Override
    public synchronized void setExpiryDelay(int cMillis) {
        if (cMillis != this.m_cExpiryDelayMillis) {
            ConfigurableCacheMap[] amap = this.getPartitionCacheArray();
            int c = amap.length;
            for (int i = 0; i < c; ++i) {
                amap[i].setExpiryDelay(cMillis);
                if (i != 0) continue;
                if (amap[i].getExpiryDelay() != cMillis) break;
                this.m_cExpiryDelayMillis = cMillis;
            }
        }
    }

    @Override
    public int getFlushDelay() {
        ConfigurableCacheMap map;
        int cMillis = this.m_cFlushDelayMillis;
        if (cMillis < 0 && (map = this.getFirstPartitionCache()) != null) {
            cMillis = map.getFlushDelay();
        }
        return cMillis;
    }

    @Override
    public void setFlushDelay(int cMillis) {
        if (cMillis != this.m_cFlushDelayMillis) {
            ConfigurableCacheMap[] amap = this.getPartitionCacheArray();
            int c = amap.length;
            for (int i = 0; i < c; ++i) {
                amap[i].setFlushDelay(cMillis);
                if (i != 0) continue;
                if (amap[i].getFlushDelay() != cMillis) break;
                this.m_cFlushDelayMillis = cMillis;
            }
        }
    }

    @Override
    public ConfigurableCacheMap.Entry getCacheEntry(Object oKey) {
        EntrySet.Entry entry = null;
        ConfigurableCacheMap cache = this.getPartitionCache(oKey);
        ConfigurableCacheMap.Entry entryReal = cache.getCacheEntry(oKey);
        if (entryReal != null) {
            entry = (EntrySet.Entry)((EntrySet)this.entrySet()).instantiateEntry(oKey, null);
            entry.setCacheEntry(entryReal);
        }
        return entry;
    }

    @Override
    public ConfigurableCacheMap.UnitCalculator getUnitCalculator() {
        ConfigurableCacheMap map;
        ConfigurableCacheMap.UnitCalculator calculator = this.m_calculator;
        if (calculator == null && (map = this.getFirstPartitionCache()) != null) {
            calculator = map.getUnitCalculator();
        }
        return calculator;
    }

    @Override
    public synchronized void setUnitCalculator(ConfigurableCacheMap.UnitCalculator calculator) {
        if (calculator != this.m_calculator) {
            ConfigurableCacheMap[] amap = this.getPartitionCacheArray();
            int c = amap.length;
            for (int i = 0; i < c; ++i) {
                amap[i].setUnitCalculator(calculator);
            }
            this.m_calculator = calculator;
        }
    }

    protected ConfigurableCacheMap getPartitionCache(Object oKey) {
        return (ConfigurableCacheMap)this.getPartitionSplittingBackingMap().getBackingMap(oKey);
    }

    protected ConfigurableCacheMap getFirstPartitionCache() {
        Map[] amap = this.getPartitionSplittingBackingMap().getMapArray().getBackingMaps();
        return amap.length == 0 ? null : (ConfigurableCacheMap)amap[0];
    }

    protected ConfigurableCacheMap[] getPartitionCacheArray() {
        ConfigurableCacheMap[] acache = this.m_acache;
        if (acache == null) {
            Map[] amap = this.getPartitionSplittingBackingMap().getMapArray().getBackingMaps();
            int cMaps = amap.length;
            acache = new ConfigurableCacheMap[cMaps];
            for (int i = 0; i < cMaps; ++i) {
                acache[i] = (ConfigurableCacheMap)amap[i];
            }
            this.m_acache = acache;
        }
        return acache;
    }

    protected void repartition() {
        this.m_acache = null;
        this.partitionUnits(2);
        this.partitionUnits(1);
        this.partitionUnits(2);
    }

    protected int calculateUnits(int nProp) {
        int cUnits;
        switch (nProp) {
            case 0: {
                cUnits = -1;
                break;
            }
            case 1: {
                cUnits = this.m_cHighUnits;
                break;
            }
            case 2: {
                cUnits = this.m_cLowUnits;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (cUnits < 0) {
            for (ConfigurableCacheMap cache : this.getPartitionCacheArray()) {
                int cPartitionUnits;
                switch (nProp) {
                    case 0: {
                        cPartitionUnits = cache.getUnits();
                        break;
                    }
                    case 1: {
                        cPartitionUnits = cache.getHighUnits();
                        break;
                    }
                    case 2: {
                        cPartitionUnits = cache.getLowUnits();
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                if (cPartitionUnits < 0) continue;
                cUnits = Math.max(0, cUnits) + cPartitionUnits;
            }
        }
        return cUnits;
    }

    protected void partitionUnits(int nProp) {
        int cUnits;
        switch (nProp) {
            default: {
                throw new IllegalStateException();
            }
            case 1: {
                cUnits = this.m_cHighUnits;
                break;
            }
            case 2: {
                cUnits = this.m_cLowUnits;
            }
        }
        ConfigurableCacheMap[] amap = this.getPartitionCacheArray();
        int cMaps = amap.length;
        if (cUnits >= 0 && cMaps > 0) {
            int cPartitionUnits = (cUnits + cMaps - 1) / cMaps;
            block8: for (int i = 0; i < cMaps; ++i) {
                ConfigurableCacheMap cache = amap[i];
                switch (nProp) {
                    case 1: {
                        cache.setHighUnits(cPartitionUnits);
                        continue block8;
                    }
                    case 2: {
                        cache.setLowUnits(cPartitionUnits);
                    }
                }
            }
        }
    }

    @Override
    protected Set instantiateEntrySet() {
        return new EntrySet();
    }

    public class EntrySet
    extends AbstractKeySetBasedMap.EntrySet {
        public EntrySet() {
            super(ObservableSplittingBackingCache.this);
        }

        @Override
        protected Map.Entry instantiateEntry(Object oKey, Object oValue) {
            return new Entry(oKey, oValue);
        }

        public class Entry
        extends AbstractKeyBasedMap.EntrySet.Entry
        implements ConfigurableCacheMap.Entry {
            ConfigurableCacheMap.Entry m_entryBacking;

            public Entry(Object oKey, Object oValue) {
                super(EntrySet.this, oKey, oValue);
            }

            @Override
            public void touch() {
                this.getCacheEntry().touch();
            }

            @Override
            public int getTouchCount() {
                return this.getCacheEntry().getTouchCount();
            }

            @Override
            public long getLastTouchMillis() {
                return this.getCacheEntry().getLastTouchMillis();
            }

            @Override
            public long getExpiryMillis() {
                return this.getCacheEntry().getExpiryMillis();
            }

            @Override
            public void setExpiryMillis(long lMillis) {
                this.getCacheEntry().setExpiryMillis(lMillis);
            }

            @Override
            public int getUnits() {
                return this.getCacheEntry().getUnits();
            }

            @Override
            public void setUnits(int cUnits) {
                this.getCacheEntry().setUnits(cUnits);
            }

            protected void setCacheEntry(ConfigurableCacheMap.Entry entryBacking) {
                this.m_entryBacking = entryBacking;
            }

            protected ConfigurableCacheMap.Entry getCacheEntry() {
                return this.m_entryBacking;
            }
        }
    }
}

